/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LDAPAttributeSet
extends AbstractSet
implements Cloneable,
Set,
Externalizable {
    private HashMap map = new HashMap();

    public Object clone() {
        try {
            Object newObj = super.clone();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ((LDAPAttributeSet)newObj).add(((LDAPAttribute)i.next()).clone());
            }
            return newObj;
        }
        catch (CloneNotSupportedException ce) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    public LDAPAttribute getAttribute(String attrName) {
        return (LDAPAttribute)this.map.get(attrName.toUpperCase());
    }

    public LDAPAttribute getAttribute(String attrName, String lang) {
        String key = attrName + ";" + lang;
        return (LDAPAttribute)this.map.get(key.toUpperCase());
    }

    public LDAPAttributeSet getSubset(String subtype) {
        LDAPAttributeSet tempAttributeSet = new LDAPAttributeSet();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            LDAPAttribute attr = (LDAPAttribute)i.next();
            if (!attr.hasSubtype(subtype)) continue;
            tempAttributeSet.add(attr.clone());
        }
        return tempAttributeSet;
    }

    public Iterator iterator() {
        return this.map.values().iterator();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean contains(Object attr) {
        LDAPAttribute attribute = (LDAPAttribute)attr;
        return this.map.containsKey(attribute.getName().toUpperCase());
    }

    public boolean add(Object attr) {
        LDAPAttribute attribute = (LDAPAttribute)attr;
        String name = attribute.getName().toUpperCase();
        if (this.map.containsKey(name)) {
            return false;
        }
        this.map.put(name, attribute);
        return true;
    }

    public boolean remove(Object object) {
        String attributeName = object instanceof String ? (String)object : ((LDAPAttribute)object).getName();
        if (attributeName == null) {
            return false;
        }
        return this.map.remove(attributeName.toUpperCase()) != null;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean addAll(Collection c) {
        boolean setChanged = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (!this.add(i.next())) continue;
            setChanged = true;
        }
        return setChanged;
    }

    public String toString() {
        StringBuffer retValue = new StringBuffer("LDAPAttributeSet: ");
        Iterator attrs = this.iterator();
        boolean first = true;
        while (attrs.hasNext()) {
            if (!first) {
                retValue.append(" ");
            }
            first = false;
            LDAPAttribute attr = (LDAPAttribute)attrs.next();
            retValue.append(attr.toString());
        }
        return retValue.toString();
    }

    void newLine(int indentTabs, Writer out) throws IOException {
        String tabString = "    ";
        out.write("\n");
        for (int i = 0; i < indentTabs; ++i) {
            out.write(tabString);
        }
    }

    private void writeAttribute(LDAPAttribute attr, Writer out) throws IOException {
        this.newLine(1, out);
        out.write("<attr name=\"");
        out.write(attr.getName());
        out.write("\">");
        String[] values = attr.getStringValueArray();
        byte[][] bytevalues = attr.getByteValueArray();
        for (int i = 0; i < values.length; ++i) {
            this.newLine(2, out);
            if (Base64.isValidUTF8(bytevalues[i], false)) {
                out.write("<value>");
                out.write(values[i]);
                out.write("</value>");
                continue;
            }
            out.write("<value xsi:type=\"xsd:base64Binary\">");
            out.write(Base64.encode(bytevalues[i]));
            out.write("</value>");
        }
        this.newLine(1, out);
        out.write("</attr>");
    }

    public void writeDSML(OutputStream oout) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(oout, "UTF-8");
        out.write("<LDAPAttributeSet>");
        Iterator i = this.iterator();
        while (i.hasNext()) {
            this.writeAttribute((LDAPAttribute)i.next(), out);
        }
        this.newLine(0, out);
        out.write("</LDAPAttributeSet>");
        ((Writer)out).close();
    }

    public static Object readDSML(InputStream input) throws IOException {
        SAXEventMultiplexer xmlreader = new SAXEventMultiplexer();
        xmlreader.setLDAPXMLHandler(LDAPAttributeSet.getXMLHandler("LDAPAttributeSet", null));
        return (LDAPAttributeSet)xmlreader.parseXML(input);
    }

    static LDAPXMLHandler getXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPAttribute.getXMLHandler("attr", this));
            }

            protected void endElement() {
                LDAPAttributeSet attrset = new LDAPAttributeSet();
                attrset.addAll((Collection)this.valuelist);
                this.setObject(attrset);
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("attr")) {
                    this.valuelist.add(value);
                }
            }
        };
    }

    private void writeAttribute(LDAPAttribute attr, StringBuffer buff) throws IOException {
        buff.append(ValueXMLhandler.newLine(1));
        buff.append("<attr name=\"");
        buff.append(attr.getName());
        buff.append("\">");
        String[] values = attr.getStringValueArray();
        byte[][] bytevalues = attr.getByteValueArray();
        for (int i = 0; i < values.length; ++i) {
            buff.append(ValueXMLhandler.newLine(2));
            if (Base64.isValidUTF8(bytevalues[i], false)) {
                buff.append("<value>");
                buff.append(values[i]);
                buff.append("</value>");
                continue;
            }
            buff.append("<value xsi:type=\"xsd:base64Binary\">");
            buff.append(Base64.encode(bytevalues[i]));
            buff.append("</value>");
        }
        buff.append(ValueXMLhandler.newLine(1));
        buff.append("</attr>");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        StringBuffer buff = new StringBuffer();
        buff.append(ValueXMLhandler.newLine(0));
        buff.append(ValueXMLhandler.newLine(0));
        String header = "";
        header = header + "*************************************************************************\n";
        header = header + "** The encrypted data above and below is the Class definition and  ******\n";
        header = header + "** other data specific to Java Serialization Protocol. The data  ********\n";
        header = header + "** which is of most application specific interest is as follows... ******\n";
        header = header + "*************************************************************************\n";
        header = header + "****************** Start of application data ****************************\n";
        header = header + "*************************************************************************\n";
        buff.append(header);
        buff.append(ValueXMLhandler.newLine(0));
        buff.append("<LDAPAttributeSet>");
        Iterator i = this.iterator();
        while (i.hasNext()) {
            this.writeAttribute((LDAPAttribute)i.next(), buff);
        }
        buff.append(ValueXMLhandler.newLine(0));
        buff.append("</LDAPAttributeSet>");
        buff.append(ValueXMLhandler.newLine(0));
        buff.append(ValueXMLhandler.newLine(0));
        String tail = "";
        tail = tail + "*************************************************************************\n";
        tail = tail + "****************** End of application data ******************************\n";
        tail = tail + "*************************************************************************\n";
        buff.append(tail);
        buff.append(ValueXMLhandler.newLine(0));
        out.writeUTF(buff.toString());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String readData = in.readUTF();
        String readProperties = readData.substring(readData.indexOf(60), readData.lastIndexOf(62) + 1);
        StringBuffer parsedBuff = new StringBuffer();
        ValueXMLhandler.parseInput(readProperties, parsedBuff);
        BufferedInputStream istream = new BufferedInputStream(new ByteArrayInputStream(parsedBuff.toString().getBytes()));
        LDAPAttributeSet readObject = (LDAPAttributeSet)LDAPAttributeSet.readDSML(istream);
        Iterator i = readObject.iterator();
        while (i.hasNext()) {
            this.add(((LDAPAttribute)i.next()).clone());
        }
        readObject = null;
    }
}

