/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.Connection;
import com.novell.ldap.InterThreadException;
import com.novell.ldap.LDAPAddRequest;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAuthHandler;
import com.novell.ldap.LDAPAuthProvider;
import com.novell.ldap.LDAPBindHandler;
import com.novell.ldap.LDAPBindRequest;
import com.novell.ldap.LDAPCompareRequest;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedRequest;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPModifyRequest;
import com.novell.ldap.LDAPReferralException;
import com.novell.ldap.LDAPReferralHandler;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPResponseQueue;
import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchQueue;
import com.novell.ldap.LDAPSearchRequest;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.LDAPUnsolicitedNotificationListener;
import com.novell.ldap.LDAPUrl;
import com.novell.ldap.MessageAgent;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.client.BindProperties;
import com.novell.ldap.client.Debug;
import com.novell.ldap.client.ReferralInfo;
import com.novell.ldap.rfc2251.RfcBindRequest;
import com.novell.ldap.rfc2251.RfcBindResponse;
import com.novell.security.sasl.Sasl;
import com.novell.security.sasl.SaslClient;
import com.novell.security.sasl.SaslException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.auth.callback.CallbackHandler;

public class LDAPConnection
implements Cloneable {
    private LDAPSearchConstraints defSearchCons = new LDAPSearchConstraints();
    private LDAPControl[] responseCtls = null;
    private Object responseCtlSemaphore = new Object();
    private Connection conn = null;
    private static Object nameLock = new Object();
    private static int lConnNum = 0;
    private String name;
    public static final int SCOPE_BASE = 0;
    public static final int SCOPE_ONE = 1;
    public static final int SCOPE_SUB = 2;
    public static final String NO_ATTRS = "1.1";
    public static final String ALL_USER_ATTRS = "*";
    public static final int LDAP_V3 = 3;
    public static final int DEFAULT_PORT = 389;
    public static final int DEFAULT_SSL_PORT = 636;
    public static final String LDAP_PROPERTY_SDK = "version.sdk";
    public static final String LDAP_PROPERTY_PROTOCOL = "version.protocol";
    public static final String LDAP_PROPERTY_SECURITY = "version.security";
    public static final String SERVER_SHUTDOWN_OID = "1.3.6.1.4.1.1466.20036";
    private static final String START_TLS_OID = "1.3.6.1.4.1.1466.20037";

    public LDAPConnection() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConnection(LDAPSocketFactory factory) {
        Object object = nameLock;
        synchronized (object) {
            this.name = "LDAPConnection(" + ++lConnNum + "): ";
        }
        Debug.trace("APIRequests", this.name + "Created");
        this.conn = new Connection(factory);
    }

    public Object clone() {
        Object newObj;
        try {
            newObj = super.clone();
            LDAPConnection newClone = (LDAPConnection)newObj;
        }
        catch (CloneNotSupportedException ce) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
        newClone.conn = this.conn;
        Debug.trace("APIRequests", this.name + "clone()");
        newClone.defSearchCons = this.defSearchCons != null ? (LDAPSearchConstraints)this.defSearchCons.clone() : null;
        if (this.responseCtls != null) {
            newClone.responseCtls = new LDAPControl[this.responseCtls.length];
            for (int i = 0; i < this.responseCtls.length; ++i) {
                newClone.responseCtls[i] = (LDAPControl)this.responseCtls[i].clone();
            }
        } else {
            newClone.responseCtls = null;
        }
        this.conn.incrCloneCount();
        return newObj;
    }

    protected void finalize() throws LDAPException {
        this.disconnect(this.defSearchCons, false);
    }

    public int getProtocolVersion() {
        BindProperties prop = this.conn.getBindProperties();
        if (prop == null) {
            return 3;
        }
        return prop.getProtocolVersion();
    }

    public String getAuthenticationDN() {
        BindProperties prop = this.conn.getBindProperties();
        if (prop == null) {
            return null;
        }
        if (prop.isAnonymous()) {
            return null;
        }
        return prop.getAuthenticationDN();
    }

    public String getAuthenticationMethod() {
        BindProperties prop = this.conn.getBindProperties();
        if (prop == null) {
            return "simple";
        }
        return this.conn.getBindProperties().getAuthenticationMethod();
    }

    public Map getSaslBindProperties() {
        BindProperties prop = this.conn.getBindProperties();
        if (prop == null) {
            return null;
        }
        return this.conn.getBindProperties().getSaslBindProperties();
    }

    public Object getSaslBindCallbackHandler() {
        BindProperties prop = this.conn.getBindProperties();
        if (prop == null) {
            return null;
        }
        return this.conn.getBindProperties().getSaslCallbackHandler();
    }

    public LDAPConstraints getConstraints() {
        return (LDAPConstraints)this.defSearchCons.clone();
    }

    public String getHost() {
        return this.conn.getHost();
    }

    public int getPort() {
        return this.conn.getPort();
    }

    public Object getProperty(String name) {
        if (name.equalsIgnoreCase(LDAP_PROPERTY_SDK)) {
            return Connection.sdk;
        }
        if (name.equalsIgnoreCase(LDAP_PROPERTY_PROTOCOL)) {
            return Connection.protocol;
        }
        if (name.equalsIgnoreCase(LDAP_PROPERTY_SECURITY)) {
            return Connection.security;
        }
        return null;
    }

    public LDAPSearchConstraints getSearchConstraints() {
        return (LDAPSearchConstraints)this.defSearchCons.clone();
    }

    public LDAPSocketFactory getSocketFactory() {
        return this.conn.getSocketFactory();
    }

    public boolean isBound() {
        return this.conn.isBound();
    }

    public boolean isConnected() {
        return this.conn.isConnected();
    }

    public boolean isConnectionAlive() {
        return this.conn.isConnectionAlive();
    }

    public boolean isTLS() {
        return this.conn.isTLS();
    }

    public void setConstraints(LDAPConstraints cons) {
        Hashtable lp;
        if (cons instanceof LDAPSearchConstraints) {
            this.defSearchCons = (LDAPSearchConstraints)cons.clone();
            return;
        }
        LDAPSearchConstraints newCons = (LDAPSearchConstraints)this.defSearchCons.clone();
        newCons.setHopLimit(cons.getHopLimit());
        newCons.setTimeLimit(cons.getTimeLimit());
        newCons.setReferralHandler(cons.getReferralHandler());
        newCons.setReferralFollowing(cons.getReferralFollowing());
        LDAPControl[] lsc = cons.getControls();
        if (lsc != null) {
            newCons.setControls(lsc);
        }
        if ((lp = newCons.getProperties()) != null) {
            newCons.setProperties(lp);
        }
        this.defSearchCons = newCons;
    }

    public static void setSocketFactory(LDAPSocketFactory factory) {
        Connection.setSocketFactory(factory);
    }

    public void addUnsolicitedNotificationListener(LDAPUnsolicitedNotificationListener listener) {
        Debug.trace("APIRequests", this.name + "addUnsolicitedNOtificationListener()");
        if (listener != null) {
            this.conn.addUnsolicitedNotificationListener(listener);
        }
    }

    public void removeUnsolicitedNotificationListener(LDAPUnsolicitedNotificationListener listener) {
        Debug.trace("APIRequests", this.name + "removeUnsolicitedNOtificationListener()");
        if (listener != null) {
            this.conn.removeUnsolicitedNotificationListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTLS() throws LDAPException {
        Debug.trace("APIRequests", this.name + "startTLS()");
        LDAPMessage startTLS = this.makeExtendedOperation(new LDAPExtendedOperation(START_TLS_OID, null), null);
        int tlsID = startTLS.getMessageID();
        this.conn.acquireWriteSemaphore(tlsID);
        try {
            if (!this.conn.areMessagesComplete()) {
                throw new LDAPLocalException("OUTSTANDING_OPERATIONS", 1);
            }
            this.conn.stopReaderOnReply(tlsID);
            LDAPResponseQueue queue = this.sendRequestToServer(startTLS, this.defSearchCons.getTimeLimit(), null, null);
            LDAPExtendedResponse response = (LDAPExtendedResponse)queue.getResponse();
            response.chkResultCode();
            this.conn.startTLS();
        }
        finally {
            this.conn.startReader();
            this.conn.freeWriteSemaphore(tlsID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTLS() throws LDAPException {
        if (!this.isTLS()) {
            throw new LDAPLocalException("NO_STARTTLS", 1);
        }
        int semaphoreID = this.conn.acquireWriteSemaphore();
        try {
            if (!this.conn.areMessagesComplete()) {
                throw new LDAPLocalException("OUTSTANDING_OPERATIONS", 1);
            }
            this.conn.stopTLS();
        }
        finally {
            this.conn.freeWriteSemaphore(semaphoreID);
        }
    }

    public void abandon(LDAPSearchResults results) throws LDAPException {
        this.abandon(results, (LDAPConstraints)this.defSearchCons);
    }

    public void abandon(LDAPSearchResults results, LDAPConstraints cons) throws LDAPException {
        results.abandon();
    }

    public void abandon(int id) throws LDAPException {
        this.abandon(id, (LDAPConstraints)this.defSearchCons);
    }

    public void abandon(int id, LDAPConstraints cons) throws LDAPException {
        try {
            MessageAgent agent = this.conn.getMessageAgent(id);
            Debug.trace("APIRequests", this.name + "abandon(" + id + ")");
            agent.abandon(id, cons);
            return;
        }
        catch (NoSuchFieldException ex) {
            Debug.trace("APIRequests", this.name + "abandon(" + id + "), agent not found");
            return;
        }
    }

    public void abandon(LDAPMessageQueue queue) throws LDAPException {
        this.abandon(queue, (LDAPConstraints)this.defSearchCons);
    }

    public void abandon(LDAPMessageQueue queue, LDAPConstraints cons) throws LDAPException {
        Debug.trace("APIRequests", this.name + "abandon(queue)");
        if (queue != null) {
            MessageAgent agent = queue instanceof LDAPSearchQueue ? queue.getMessageAgent() : queue.getMessageAgent();
            int[] msgIds = agent.getMessageIDs();
            for (int i = 0; i < msgIds.length; ++i) {
                agent.abandon(msgIds[i], cons);
            }
        }
    }

    public void add(LDAPEntry entry) throws LDAPException {
        this.add(entry, this.defSearchCons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LDAPEntry entry, LDAPConstraints cons) throws LDAPException {
        LDAPResponseQueue queue = this.add(entry, null, cons);
        LDAPResponse addResponse = (LDAPResponse)queue.getResponse();
        Object object = this.responseCtlSemaphore;
        synchronized (object) {
            this.responseCtls = addResponse.getControls();
        }
        this.chkResultCode(queue, cons, addResponse);
    }

    public LDAPResponseQueue add(LDAPEntry entry, LDAPResponseQueue queue) throws LDAPException {
        return this.add(entry, queue, this.defSearchCons);
    }

    public LDAPResponseQueue add(LDAPEntry entry, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        Debug.trace("APIRequests", this.name + "add()");
        if (cons == null) {
            cons = this.defSearchCons;
        }
        if (entry == null) {
            throw new IllegalArgumentException("The LDAPEntry parameter cannot be null");
        }
        if (entry.getDN() == null) {
            throw new IllegalArgumentException("The DN value must be present in the LDAPEntry object");
        }
        LDAPAddRequest msg = new LDAPAddRequest(entry, cons.getControls());
        return this.sendRequestToServer(msg, cons.getTimeLimit(), queue, null);
    }

    public void bind(String dn, String passwd) throws LDAPException {
        this.bind(3, dn, passwd, (LDAPConstraints)this.defSearchCons);
    }

    public void bind(int version, String dn, String passwd) throws LDAPException {
        this.bind(version, dn, passwd, (LDAPConstraints)this.defSearchCons);
    }

    public void bind(String dn, String passwd, LDAPConstraints cons) throws LDAPException {
        this.bind(3, dn, passwd, cons);
    }

    public void bind(int version, String dn, String passwd, LDAPConstraints cons) throws LDAPException {
        byte[] pw = null;
        if (passwd != null) {
            try {
                pw = passwd.getBytes("UTF8");
                passwd = null;
            }
            catch (UnsupportedEncodingException ex) {
                passwd = null;
                throw new RuntimeException(ex.toString());
            }
        }
        this.bind(version, dn, pw, cons);
    }

    public void bind(int version, String dn, byte[] passwd) throws LDAPException {
        this.bind(version, dn, passwd, (LDAPConstraints)this.defSearchCons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(int version, String dn, byte[] passwd, LDAPConstraints cons) throws LDAPException {
        LDAPResponseQueue queue = this.bind(version, dn, passwd, null, cons);
        LDAPResponse res = (LDAPResponse)queue.getResponse();
        if (res != null) {
            Object object = this.responseCtlSemaphore;
            synchronized (object) {
                this.responseCtls = res.getControls();
            }
            this.chkResultCode(queue, cons, res);
        }
    }

    public LDAPResponseQueue bind(int version, String dn, byte[] passwd, LDAPResponseQueue queue) throws LDAPException {
        return this.bind(version, dn, passwd, queue, (LDAPConstraints)this.defSearchCons);
    }

    public LDAPResponseQueue bind(int version, String dn, byte[] passwd, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        Debug.trace("APIRequests", this.name + "bind(\"" + dn + "\")");
        if (cons == null) {
            cons = this.defSearchCons;
        }
        dn = dn == null ? "" : dn.trim();
        if (passwd == null) {
            passwd = new byte[]{};
        }
        boolean anonymous = false;
        if (passwd.length == 0) {
            anonymous = true;
            dn = "";
        }
        LDAPBindRequest msg = new LDAPBindRequest(version, dn, passwd, cons.getControls());
        int msgId = msg.getMessageID();
        BindProperties bindProps = new BindProperties(version, dn, "simple", anonymous, null, null);
        if (!this.conn.isConnected()) {
            if (this.conn.getHost() != null) {
                this.conn.connect(this.conn.getHost(), this.conn.getPort());
            } else {
                throw new LDAPException("CONNECTION_IMPOSSIBLE", 91, null);
            }
        }
        this.conn.acquireWriteSemaphore(msgId);
        return this.sendRequestToServer(msg, cons.getTimeLimit(), queue, bindProps);
    }

    public void bind(String dn, String authzId, Map props, Object cbh) throws LDAPException {
        this.bind(dn, authzId, props, cbh, (LDAPConstraints)this.defSearchCons);
    }

    public void bind(String dn, String authzId, Map props, Object cbh, LDAPConstraints cons) throws LDAPException {
        throw new LDAPLocalException("NOT_IMPLEMENTED", new Object[]{"LDAPConnection.bind(with mechanisms)"}, 92);
    }

    public void bind(String dn, String authzId, String[] mechanisms, Map props, Object cbh) throws LDAPException {
        this.bind(dn, authzId, mechanisms, props, cbh, this.defSearchCons);
    }

    public void bind(String dn, String authzId, String[] mechanisms, Map props, Object cbh, LDAPConstraints cons) throws LDAPException {
        Debug.trace("APIRequests", this.name + "saslBind(" + dn + ")");
        if (cons == null) {
            cons = this.defSearchCons;
        }
        if (dn == null) {
            dn = "";
        }
        if (authzId == null) {
            authzId = "";
        }
        try {
            SaslClient saslClient = Sasl.createSaslClient(mechanisms, authzId, "ldap", this.getHost(), props, (CallbackHandler)cbh);
            if (saslClient == null) {
                throw new LDAPException("Unsupported SASL mechanism(s) and/or properties", 7, null);
            }
            Debug.trace("SaslBind", this.name + "saslClient created, mechanism " + saslClient.getMechanismName());
            byte[] clientResponse = null;
            boolean anonymous = false;
            BindProperties bindProps = new BindProperties(3, null, "sasl", anonymous, null, null);
            int id = this.conn.acquireWriteSemaphore();
            this.conn.setBindSemId(id);
            if (saslClient.hasInitialResponse()) {
                clientResponse = saslClient.evaluateChallenge(new byte[0]);
            }
            while (!saslClient.isComplete()) {
                try {
                    byte[] replyBuf = this.LDAPTransport(clientResponse, saslClient.getMechanismName(), bindProps);
                    if (replyBuf != null) {
                        Debug.trace("SaslBind", this.name + "saslClient response " + replyBuf.length + " bytes");
                        clientResponse = saslClient.evaluateChallenge(replyBuf);
                        continue;
                    }
                    Debug.trace("SaslBind", this.name + "saslClient response empty");
                    clientResponse = saslClient.evaluateChallenge(new byte[0]);
                }
                catch (SaslException e) {
                    saslClient.dispose();
                    throw new LDAPException("Unexpected SASL error.", 80, null, e);
                }
                catch (LDAPException lde) {
                    saslClient.dispose();
                    throw lde;
                }
            }
            Debug.trace("SaslBind", this.name + "saslBind Complete");
        }
        catch (SaslException eSasl) {
            throw new LDAPException("SASL Bind Error.", 80, null, eSasl.getCause());
        }
    }

    private byte[] LDAPTransport(byte[] toWrite, String mechanism, BindProperties bindProps) throws LDAPException {
        LDAPSearchConstraints cons = this.defSearchCons;
        LDAPMessage msg = new LDAPMessage(0, new RfcBindRequest(3, "", mechanism, toWrite), cons.getControls());
        LDAPResponseQueue queue = this.sendRequestToServer(msg, cons.getTimeLimit(), null, bindProps);
        LDAPResponse ldapResponse = (LDAPResponse)queue.getResponse();
        RfcBindResponse bindResponse = (RfcBindResponse)ldapResponse.getASN1Object().get(1);
        ASN1OctetString serverCreds = bindResponse.getServerSaslCreds();
        int resultCode = ldapResponse.getResultCode();
        byte[] replyBuf = null;
        if (resultCode == 14 || resultCode == 0) {
            if (serverCreds != null) {
                replyBuf = serverCreds.byteValue();
            }
        } else {
            ldapResponse.chkResultCode();
            throw new LDAPException("SASL Bind Error.", resultCode, null);
        }
        return replyBuf;
    }

    public boolean compare(String dn, LDAPAttribute attr) throws LDAPException {
        return this.compare(dn, attr, this.defSearchCons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compare(String dn, LDAPAttribute attr, LDAPConstraints cons) throws LDAPException {
        boolean ret = false;
        Debug.trace("APIRequests", this.name + "compare(" + dn + ") if value");
        LDAPResponseQueue queue = this.compare(dn, attr, null, cons);
        LDAPResponse res = (LDAPResponse)queue.getResponse();
        Object object = this.responseCtlSemaphore;
        synchronized (object) {
            this.responseCtls = res.getControls();
        }
        if (res.getResultCode() == 6) {
            ret = true;
        } else if (res.getResultCode() == 5) {
            ret = false;
        } else {
            this.chkResultCode(queue, cons, res);
        }
        return ret;
    }

    public LDAPResponseQueue compare(String dn, LDAPAttribute attr, LDAPResponseQueue queue) throws LDAPException {
        return this.compare(dn, attr, queue, this.defSearchCons);
    }

    public LDAPResponseQueue compare(String dn, LDAPAttribute attr, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        Debug.trace("APIRequests", this.name + "compare(" + dn + ") compare value");
        if (attr.size() != 1) {
            throw new IllegalArgumentException("compare: Exactly one value must be present in the LDAPAttribute");
        }
        if (dn == null) {
            throw new IllegalArgumentException("compare: DN cannot be null");
        }
        if (cons == null) {
            cons = this.defSearchCons;
        }
        LDAPCompareRequest msg = new LDAPCompareRequest(dn, attr.getName(), attr.getByteValue(), cons.getControls());
        return this.sendRequestToServer(msg, cons.getTimeLimit(), queue, null);
    }

    public void connect(String host, int port) throws LDAPException {
        Debug.trace("APIRequests", this.name + "connect(" + host + ", " + port + ")");
        StringTokenizer hostList = new StringTokenizer(host, " ");
        String address = null;
        while (hostList.hasMoreTokens()) {
            try {
                int specifiedPort = port;
                address = hostList.nextToken();
                int colonIndex = address.indexOf(58);
                if (colonIndex != -1 && colonIndex + 1 != address.length()) {
                    try {
                        specifiedPort = Integer.parseInt(address.substring(colonIndex + 1));
                        address = address.substring(0, colonIndex);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("INVALID_ADDRESS");
                    }
                }
                this.conn = this.conn.destroyClone(true);
                this.conn.connect(address, specifiedPort);
                break;
            }
            catch (LDAPException LE) {
                if (hostList.hasMoreTokens()) continue;
                throw LE;
            }
        }
    }

    public void delete(String dn) throws LDAPException {
        this.delete(dn, this.defSearchCons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String dn, LDAPConstraints cons) throws LDAPException {
        LDAPResponseQueue queue = this.delete(dn, null, cons);
        LDAPResponse deleteResponse = (LDAPResponse)queue.getResponse();
        Object object = this.responseCtlSemaphore;
        synchronized (object) {
            this.responseCtls = deleteResponse.getControls();
        }
        this.chkResultCode(queue, cons, deleteResponse);
    }

    public LDAPResponseQueue delete(String dn, LDAPResponseQueue queue) throws LDAPException {
        return this.delete(dn, queue, this.defSearchCons);
    }

    public LDAPResponseQueue delete(String dn, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        Debug.trace("APIRequests", this.name + "delete(" + dn + ")");
        if (dn == null) {
            throw new IllegalArgumentException("DN_PARAM_ERROR");
        }
        if (cons == null) {
            cons = this.defSearchCons;
        }
        LDAPDeleteRequest msg = new LDAPDeleteRequest(dn, cons.getControls());
        return this.sendRequestToServer(msg, cons.getTimeLimit(), queue, null);
    }

    public void disconnect() throws LDAPException {
        this.disconnect(this.defSearchCons, true);
    }

    public void disconnect(LDAPConstraints cons) throws LDAPException {
        this.disconnect(cons, true);
    }

    private void disconnect(LDAPConstraints cons, boolean how) throws LDAPException {
        Debug.trace("APIRequests", this.name + (how ? "disconnect()" : "finalize()"));
        this.conn = this.conn.destroyClone(how);
    }

    public LDAPExtendedResponse extendedOperation(LDAPExtendedOperation op) throws LDAPException {
        return this.extendedOperation(op, this.defSearchCons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPExtendedResponse extendedOperation(LDAPExtendedOperation op, LDAPConstraints cons) throws LDAPException {
        LDAPResponseQueue queue = this.extendedOperation(op, cons, null);
        LDAPExtendedResponse response = (LDAPExtendedResponse)queue.getResponse();
        Object object = this.responseCtlSemaphore;
        synchronized (object) {
            this.responseCtls = response.getControls();
        }
        this.chkResultCode(queue, cons, response);
        return response;
    }

    public LDAPResponseQueue extendedOperation(LDAPExtendedOperation op, LDAPResponseQueue queue) throws LDAPException {
        return this.extendedOperation(op, this.defSearchCons, queue);
    }

    public LDAPResponseQueue extendedOperation(LDAPExtendedOperation op, LDAPConstraints cons, LDAPResponseQueue queue) throws LDAPException {
        if (cons == null) {
            cons = this.defSearchCons;
        }
        LDAPMessage msg = this.makeExtendedOperation(op, cons);
        return this.sendRequestToServer(msg, cons.getTimeLimit(), queue, null);
    }

    protected LDAPMessage makeExtendedOperation(LDAPExtendedOperation op, LDAPConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.defSearchCons;
        }
        if (op.getID() == null) {
            throw new IllegalArgumentException("OP_PARAM_ERROR");
        }
        return new LDAPExtendedRequest(op, cons.getControls());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPControl[] getResponseControls() {
        if (this.responseCtls == null) {
            Debug.trace("APIRequests", this.name + "getResponseControls() returns null");
            return null;
        }
        Debug.trace("APIRequests", this.name + "getResponseControls()");
        LDAPControl[] clonedControl = new LDAPControl[this.responseCtls.length];
        Object object = this.responseCtlSemaphore;
        synchronized (object) {
            for (int i = 0; i < this.responseCtls.length; ++i) {
                clonedControl[i] = (LDAPControl)this.responseCtls[i].clone();
            }
        }
        return clonedControl;
    }

    public void modify(String dn, LDAPModification mod) throws LDAPException {
        this.modify(dn, mod, (LDAPConstraints)this.defSearchCons);
    }

    public void modify(String dn, LDAPModification mod, LDAPConstraints cons) throws LDAPException {
        LDAPModification[] mods = new LDAPModification[]{mod};
        this.modify(dn, mods, cons);
    }

    public void modify(String dn, LDAPModification[] mods) throws LDAPException {
        this.modify(dn, mods, (LDAPConstraints)this.defSearchCons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(String dn, LDAPModification[] mods, LDAPConstraints cons) throws LDAPException {
        LDAPResponseQueue queue = this.modify(dn, mods, null, cons);
        LDAPResponse modifyResponse = (LDAPResponse)queue.getResponse();
        Object object = this.responseCtlSemaphore;
        synchronized (object) {
            this.responseCtls = modifyResponse.getControls();
        }
        this.chkResultCode(queue, cons, modifyResponse);
    }

    public LDAPResponseQueue modify(String dn, LDAPModification mod, LDAPResponseQueue queue) throws LDAPException {
        return this.modify(dn, mod, queue, (LDAPConstraints)this.defSearchCons);
    }

    public LDAPResponseQueue modify(String dn, LDAPModification mod, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        LDAPModification[] mods = new LDAPModification[]{mod};
        return this.modify(dn, mods, queue, cons);
    }

    public LDAPResponseQueue modify(String dn, LDAPModification[] mods, LDAPResponseQueue queue) throws LDAPException {
        return this.modify(dn, mods, queue, (LDAPConstraints)this.defSearchCons);
    }

    public LDAPResponseQueue modify(String dn, LDAPModification[] mods, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        Debug.trace("APIRequests", this.name + "modify(" + dn + "), " + mods.length + " modifications");
        if (dn == null) {
            throw new IllegalArgumentException("DN_PARAM_ERROR");
        }
        if (cons == null) {
            cons = this.defSearchCons;
        }
        LDAPModifyRequest msg = new LDAPModifyRequest(dn, mods, cons.getControls());
        return this.sendRequestToServer(msg, cons.getTimeLimit(), queue, null);
    }

    public LDAPEntry read(String dn) throws LDAPException {
        return this.read(dn, this.defSearchCons);
    }

    public LDAPEntry read(String dn, LDAPSearchConstraints cons) throws LDAPException {
        return this.read(dn, null, cons);
    }

    public LDAPEntry read(String dn, String[] attrs) throws LDAPException {
        return this.read(dn, attrs, this.defSearchCons);
    }

    public LDAPEntry read(String dn, String[] attrs, LDAPSearchConstraints cons) throws LDAPException {
        Debug.trace("APIRequests", this.name + "read(" + dn + ")");
        LDAPSearchResults sr = this.search(dn, 0, null, attrs, false, cons);
        LDAPEntry ret = null;
        if (sr.hasMore()) {
            ret = sr.next();
            if (sr.hasMore()) {
                throw new LDAPLocalException("READ_MULTIPLE", 101);
            }
        }
        return ret;
    }

    public static LDAPEntry read(LDAPUrl toGet) throws LDAPException {
        Debug.trace("APIRequests", "read(" + toGet.toString() + ")");
        LDAPConnection lconn = new LDAPConnection();
        lconn.connect(toGet.getHost(), toGet.getPort());
        LDAPEntry toReturn = lconn.read(toGet.getDN(), toGet.getAttributeArray());
        Debug.trace("APIRequests", "read: disconnect()");
        lconn.disconnect();
        return toReturn;
    }

    public static LDAPEntry read(LDAPUrl toGet, LDAPSearchConstraints cons) throws LDAPException {
        Debug.trace("APIRequests", "read(" + toGet.toString() + ")");
        LDAPConnection lconn = new LDAPConnection();
        lconn.connect(toGet.getHost(), toGet.getPort());
        LDAPEntry toReturn = lconn.read(toGet.getDN(), toGet.getAttributeArray(), cons);
        Debug.trace("APIRequests", "read: disconnect()");
        lconn.disconnect();
        return toReturn;
    }

    public void rename(String dn, String newRdn, boolean deleteOldRdn) throws LDAPException {
        this.rename(dn, newRdn, deleteOldRdn, this.defSearchCons);
    }

    public void rename(String dn, String newRdn, boolean deleteOldRdn, LDAPConstraints cons) throws LDAPException {
        this.rename(dn, newRdn, null, deleteOldRdn, cons);
    }

    public void rename(String dn, String newRdn, String newParentdn, boolean deleteOldRdn) throws LDAPException {
        this.rename(dn, newRdn, newParentdn, deleteOldRdn, (LDAPConstraints)this.defSearchCons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String dn, String newRdn, String newParentdn, boolean deleteOldRdn, LDAPConstraints cons) throws LDAPException {
        LDAPResponseQueue queue = this.rename(dn, newRdn, newParentdn, deleteOldRdn, null, cons);
        LDAPResponse renameResponse = (LDAPResponse)queue.getResponse();
        Object object = this.responseCtlSemaphore;
        synchronized (object) {
            this.responseCtls = renameResponse.getControls();
        }
        this.chkResultCode(queue, cons, renameResponse);
    }

    public LDAPResponseQueue rename(String dn, String newRdn, boolean deleteOldRdn, LDAPResponseQueue queue) throws LDAPException {
        return this.rename(dn, newRdn, deleteOldRdn, queue, (LDAPConstraints)this.defSearchCons);
    }

    public LDAPResponseQueue rename(String dn, String newRdn, boolean deleteOldRdn, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        return this.rename(dn, newRdn, null, deleteOldRdn, queue, cons);
    }

    public LDAPResponseQueue rename(String dn, String newRdn, String newParentdn, boolean deleteOldRdn, LDAPResponseQueue queue) throws LDAPException {
        Debug.trace("APIRequests", this.name + "rename(" + dn + "," + newRdn + "," + newParentdn + ")");
        return this.rename(dn, newRdn, newParentdn, deleteOldRdn, queue, this.defSearchCons);
    }

    public LDAPResponseQueue rename(String dn, String newRdn, String newParentdn, boolean deleteOldRdn, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        if (dn == null || newRdn == null) {
            throw new IllegalArgumentException("RDN_PARAM_ERROR");
        }
        Debug.trace("APIRequests", this.name + "rename(" + dn + "," + newRdn + "," + newParentdn + ")");
        if (cons == null) {
            cons = this.defSearchCons;
        }
        LDAPModifyDNRequest msg = new LDAPModifyDNRequest(dn, newRdn, newParentdn, deleteOldRdn, cons.getControls());
        return this.sendRequestToServer(msg, cons.getTimeLimit(), queue, null);
    }

    public LDAPSearchResults search(String base, int scope, String filter, String[] attrs, boolean typesOnly) throws LDAPException {
        return this.search(base, scope, filter, attrs, typesOnly, this.defSearchCons);
    }

    public LDAPSearchResults search(String base, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchConstraints cons) throws LDAPException {
        LDAPSearchQueue queue = this.search(base, scope, filter, attrs, typesOnly, null, cons);
        if (cons == null) {
            cons = this.defSearchCons;
        }
        return new LDAPSearchResults(this, queue, cons);
    }

    public LDAPSearchQueue search(String base, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchQueue queue) throws LDAPException {
        return this.search(base, scope, filter, attrs, typesOnly, queue, this.defSearchCons);
    }

    public LDAPSearchQueue search(String base, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchQueue queue, LDAPSearchConstraints cons) throws LDAPException {
        MessageAgent agent;
        if (filter == null) {
            filter = "objectclass=*";
        }
        Debug.trace("APIRequests", this.name + "search(\"" + base + "\"," + scope + ",\"" + filter + "\")");
        if (cons == null) {
            cons = this.defSearchCons;
        }
        LDAPSearchRequest msg = new LDAPSearchRequest(base, scope, filter, attrs, cons.getDereference(), cons.getMaxResults(), cons.getServerTimeLimit(), typesOnly, cons.getControls());
        LDAPSearchQueue myqueue = queue;
        if (myqueue == null) {
            agent = new MessageAgent();
            myqueue = new LDAPSearchQueue(agent);
        } else {
            agent = queue.getMessageAgent();
        }
        agent.sendMessage(this.conn, msg, cons.getTimeLimit(), myqueue, null);
        return myqueue;
    }

    public static LDAPSearchResults search(LDAPUrl toGet) throws LDAPException {
        return LDAPConnection.search(toGet, null);
    }

    public static LDAPSearchResults search(LDAPUrl toGet, LDAPSearchConstraints cons) throws LDAPException {
        Debug.trace("APIRequests", "LDAPConnection.search(" + toGet.toString() + ")");
        LDAPConnection lconn = new LDAPConnection();
        lconn.connect(toGet.getHost(), toGet.getPort());
        cons = cons == null ? lconn.getSearchConstraints() : (LDAPSearchConstraints)cons.clone();
        cons.setBatchSize(0);
        LDAPSearchResults toReturn = lconn.search(toGet.getDN(), toGet.getScope(), toGet.getFilter(), toGet.getAttributeArray(), false, cons);
        lconn.disconnect();
        return toReturn;
    }

    public LDAPMessageQueue sendRequest(LDAPMessage request, LDAPMessageQueue queue) throws LDAPException {
        return this.sendRequest(request, queue, null);
    }

    public LDAPMessageQueue sendRequest(LDAPMessage request, LDAPMessageQueue queue, LDAPConstraints cons) throws LDAPException {
        MessageAgent agent;
        LDAPMessageQueue myqueue;
        Debug.trace("APIRequests", this.name + "sendRequest(" + request.toString() + ")");
        if (!request.isRequest()) {
            throw new RuntimeException("Object is not a request message");
        }
        if (cons == null) {
            cons = this.defSearchCons;
        }
        if ((myqueue = queue) == null) {
            agent = new MessageAgent();
            myqueue = request.getType() == 3 ? new LDAPSearchQueue(agent) : new LDAPResponseQueue(agent);
        } else {
            agent = request.getType() == 3 ? queue.getMessageAgent() : queue.getMessageAgent();
        }
        agent.sendMessage(this.conn, request, cons.getTimeLimit(), myqueue, null);
        return myqueue;
    }

    private LDAPResponseQueue sendRequestToServer(LDAPMessage msg, int timeout, LDAPResponseQueue queue, BindProperties bindProps) throws LDAPException {
        MessageAgent agent;
        if (queue == null) {
            agent = new MessageAgent();
            queue = new LDAPResponseQueue(agent);
        } else {
            agent = queue.getMessageAgent();
        }
        agent.sendMessage(this.conn, msg, timeout, queue, bindProps);
        return queue;
    }

    Connection getConnection() {
        return this.conn;
    }

    String getConnectionName() {
        return this.name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReferralInfo getReferralConnection(String[] referrals) throws LDAPReferralException {
        ReferralInfo refInfo = null;
        Throwable ex = null;
        LDAPConnection rconn = null;
        LDAPReferralHandler rh = this.defSearchCons.getReferralHandler();
        int i = 0;
        if (rh != null && !(rh instanceof LDAPAuthHandler)) {
            try {
                Debug.trace("Referrals", this.name + "getReferralConnection: " + "Call LDAPBind.bind()");
                rconn = ((LDAPBindHandler)rh).bind(referrals, this);
                if (rconn == null) {
                    LDAPReferralException rex = new LDAPReferralException("REFERRAL_ERROR");
                    rex.setReferrals(referrals);
                    throw rex;
                }
                for (int idx = 0; idx < referrals.length; ++idx) {
                    try {
                        LDAPUrl url = new LDAPUrl(referrals[idx]);
                        Debug.trace("Referrals", this.name + "getReferralConnection: " + "Compare host port " + url.getHost() + "-" + rconn.getHost() + " & " + url.getPort() + "-" + rconn.getPort());
                        if (!url.getHost().equalsIgnoreCase(rconn.getHost()) || url.getPort() != rconn.getPort()) continue;
                        refInfo = new ReferralInfo(rconn, referrals, url);
                        break;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (refInfo == null) {
                    Debug.trace("Referrals", this.name + "getReferralConnection: " + "LDAPBind.bind(): " + " could not match connection with URL" + referrals.toString());
                    ex = new LDAPLocalException("REFERRAL_BIND_MATCH", 91);
                }
            }
            catch (Throwable lex) {
                Debug.trace("Referrals", this.name + "getReferralConnection: " + "Exception from LDAPBind.bind(): " + lex.toString());
                rconn = null;
                ex = lex;
            }
        } else {
            for (i = 0; i < referrals.length; ++i) {
                String dn = null;
                byte[] pw = null;
                try {
                    Debug.trace("Referrals", this.name + "getReferralConnection: " + "url=" + referrals[i]);
                    rconn = new LDAPConnection(this.conn.getSocketFactory());
                    rconn.setConstraints(this.defSearchCons);
                    LDAPUrl url = new LDAPUrl(referrals[i]);
                    rconn.connect(url.getHost(), url.getPort());
                    if (rh != null && rh instanceof LDAPAuthHandler) {
                        LDAPAuthProvider ap = ((LDAPAuthHandler)rh).getAuthProvider(url.getHost(), url.getPort());
                        dn = ap.getDN();
                        pw = ap.getPassword();
                    }
                    rconn.bind(3, dn, pw);
                    ex = null;
                    refInfo = new ReferralInfo(rconn, referrals, url);
                    rconn.getConnection().setActiveReferral(refInfo);
                    break;
                }
                catch (Throwable lex) {
                    if (rconn == null) continue;
                    try {
                        Debug.trace("Referrals", this.name + "getReferralConnection, exception " + "binding for referral" + lex.toString());
                        rconn.disconnect();
                        rconn = null;
                        ex = lex;
                    }
                    catch (LDAPException e) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        if (ex == null) {
            return refInfo;
        }
        if (ex instanceof LDAPReferralException) {
            throw (LDAPReferralException)ex;
        }
        LDAPException ldapex = ex instanceof LDAPException ? (LDAPException)ex : new LDAPLocalException("SERVER_CONNECT_ERROR", new Object[]{this.conn.getHost()}, 91, ex);
        LDAPReferralException rex = new LDAPReferralException("REFERRAL_ERROR", ldapex);
        rex.setReferrals(referrals);
        rex.setFailedReferral(referrals[referrals.length - 1]);
        throw rex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void chkResultCode(LDAPMessageQueue queue, LDAPConstraints cons, LDAPResponse response) throws LDAPException {
        if (response.getResultCode() == 10 && cons.getReferralFollowing()) {
            ArrayList refConn = null;
            try {
                this.chaseReferral(queue, cons, response, response.getReferrals(), 0, false, null);
            }
            finally {
                this.releaseReferralConnections(refConn);
            }
        } else {
            response.chkResultCode();
        }
    }

    ArrayList chaseReferral(LDAPMessageQueue queue, LDAPConstraints cons, LDAPMessage msg, String[] initialReferrals, int hopCount, boolean searchReference, ArrayList connectionList) throws LDAPException {
        LDAPMessage origMsg;
        String[] refs;
        ArrayList connList = connectionList;
        LDAPConnection rconn = null;
        ReferralInfo rinfo = null;
        Debug.trace("Referrals", this.name + "Check for referrals, reference = " + searchReference);
        if (connList == null) {
            connList = new ArrayList(cons.getHopLimit());
        }
        if (initialReferrals != null) {
            refs = initialReferrals;
            origMsg = msg.getRequestingMessage();
        } else {
            LDAPResponse resp = (LDAPResponse)queue.getResponse();
            if (resp.getResultCode() != 10) {
                resp.chkResultCode();
                return connList;
            }
            refs = resp.getReferrals();
            origMsg = resp.getRequestingMessage();
        }
        try {
            if (hopCount++ > cons.getHopLimit()) {
                throw new LDAPLocalException("Max hops exceeded", 97);
            }
            rinfo = this.getReferralConnection(refs);
            rconn = rinfo.getReferralConnection();
            LDAPUrl refUrl = rinfo.getReferralUrl();
            connList.add(rconn);
            Debug.trace("Referrals", this.name + (searchReference ? "Following search reference URL " : "Following referral URL ") + refUrl.toString());
            LDAPMessage newMsg = this.rebuildRequest(origMsg, refUrl, searchReference);
            Debug.trace("Referrals", this.name + "following referral for " + refUrl.toString());
            Debug.trace("Referrals", this.name + "request " + newMsg.toString());
            try {
                MessageAgent agent = queue instanceof LDAPResponseQueue ? queue.getMessageAgent() : queue.getMessageAgent();
                agent.sendMessage(rconn.getConnection(), newMsg, this.defSearchCons.getTimeLimit(), queue, null);
            }
            catch (InterThreadException ex) {
                LDAPReferralException rex = new LDAPReferralException("REFERRAL_SEND", 91, null, ex);
                rex.setReferrals(initialReferrals);
                ReferralInfo ref = rconn.getConnection().getActiveReferral();
                rex.setFailedReferral(ref.getReferralUrl().toString());
                throw rex;
            }
            if (initialReferrals != null) {
                return connList;
            }
            connList = this.chaseReferral(queue, cons, null, null, hopCount, false, connList);
        }
        catch (Exception ex) {
            Debug.trace("Referrals", this.name + "Throw exception " + ex.toString());
            if (ex instanceof LDAPReferralException) {
                throw (LDAPReferralException)ex;
            }
            LDAPReferralException rex = new LDAPReferralException("REFERRAL_ERROR", ex);
            rex.setReferrals(refs);
            if (rinfo != null) {
                rex.setFailedReferral(rinfo.getReferralUrl().toString());
            } else {
                rex.setFailedReferral(refs[refs.length - 1]);
            }
            throw rex;
        }
        return connList;
    }

    private LDAPMessage rebuildRequest(LDAPMessage msg, LDAPUrl url, boolean reference) throws LDAPException {
        Debug.trace("Referrals", this.name + "rebuildRequest: original request = " + "message(" + msg.getMessageID() + "), request type " + msg.getType());
        String dn = url.getDN();
        String filter = null;
        switch (msg.getType()) {
            case 3: {
                if (!reference) break;
                filter = url.getFilter();
                break;
            }
            case 0: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 23: {
                break;
            }
            default: {
                throw new LDAPLocalException("IMPROPER_REFERRAL", new Object[]{new Integer(msg.getType())}, 82);
            }
        }
        return msg.clone(dn, filter, reference);
    }

    void releaseReferralConnections(ArrayList list) {
        if (list == null) {
            return;
        }
        Debug.trace("Referrals", this.name + "Release referal connections");
        for (int i = list.size() - 1; i >= 0; --i) {
            LDAPConnection rconn = null;
            try {
                rconn = (LDAPConnection)list.remove(i);
                Debug.trace("Referrals", "\t" + this.name + "Disconnecting " + rconn.getConnectionName());
                rconn.disconnect();
                continue;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                Debug.trace("Referrals", "\t" + this.name + "Failed to get conn at index " + i);
                continue;
            }
            catch (LDAPException lex) {
                Debug.trace("Referrals", "\t" + this.name + "Disconnect failed for " + rconn.getConnectionName());
            }
        }
    }

    public LDAPSchema fetchSchema(String schemaDN) throws LDAPException {
        LDAPEntry ent = this.read(schemaDN, LDAPSchema.schemaTypeNames);
        return new LDAPSchema(ent);
    }

    public String getSchemaDN() throws LDAPException {
        return this.getSchemaDN("");
    }

    public String getSchemaDN(String dn) throws LDAPException {
        String[] attrSubSchema = new String[]{"subschemaSubentry"};
        LDAPEntry ent = this.read(dn, attrSubSchema);
        LDAPAttribute attr = ent.getAttribute(attrSubSchema[0]);
        String[] values = attr.getStringValueArray();
        if (values == null || values.length < 1) {
            throw new LDAPLocalException("NO_SCHEMA", new Object[]{dn}, 94);
        }
        if (values.length > 1) {
            throw new LDAPLocalException("MULTIPLE_SCHEMA", new Object[]{dn}, 19);
        }
        return values[0];
    }
}

