/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.SchemaParser;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPDITStructureRuleSchema
extends LDAPSchemaElement {
    private int ruleID = 0;
    private String nameForm = "";
    private String[] superiorIDs = new String[]{""};

    public LDAPDITStructureRuleSchema() {
        super(LDAPSchema.schemaTypeNames[5]);
    }

    public LDAPDITStructureRuleSchema(String[] names, int ruleID, String description, boolean obsolete, String nameForm, String[] superiorIDs) {
        super(LDAPSchema.schemaTypeNames[5]);
        this.names = (String[])names.clone();
        this.ruleID = ruleID;
        this.description = description;
        this.obsolete = obsolete;
        this.nameForm = nameForm;
        this.superiorIDs = superiorIDs;
        super.setValue(this.formatString());
    }

    public LDAPDITStructureRuleSchema(String raw) {
        super(LDAPSchema.schemaTypeNames[5]);
        this.obsolete = false;
        try {
            SchemaParser parser = new SchemaParser(raw);
            if (parser.getNames() != null) {
                this.names = (String[])parser.getNames().clone();
            }
            if (parser.getID() != null) {
                this.ruleID = Integer.parseInt(parser.getID());
            }
            if (parser.getDescription() != null) {
                this.description = parser.getDescription();
            }
            if (parser.getSuperiors() != null) {
                this.superiorIDs = (String[])parser.getSuperiors().clone();
            }
            if (parser.getNameForm() != null) {
                this.nameForm = parser.getNameForm();
            }
            this.obsolete = parser.getObsolete();
            Enumeration qualifiers = parser.getQualifiers();
            while (qualifiers.hasMoreElements()) {
                AttributeQualifier attrQualifier = (AttributeQualifier)qualifiers.nextElement();
                this.setQualifier(attrQualifier.getName(), attrQualifier.getValues());
            }
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getRuleID() {
        return this.ruleID;
    }

    public String getNameForm() {
        return this.nameForm;
    }

    public String[] getSuperiors() {
        return this.superiorIDs;
    }

    protected String formatString() {
        Enumeration en;
        int i;
        StringBuffer valueBuffer = new StringBuffer("( ");
        String token = String.valueOf(this.getRuleID());
        valueBuffer.append(token);
        String[] strArray = this.getNames();
        if (strArray != null) {
            valueBuffer.append(" NAME ");
            if (strArray.length == 1) {
                valueBuffer.append("'" + strArray[0] + "'");
            } else {
                valueBuffer.append("( ");
                for (i = 0; i < strArray.length; ++i) {
                    valueBuffer.append(" '" + strArray[i] + "'");
                }
                valueBuffer.append(" )");
            }
        }
        if ((token = this.getDescription()) != null) {
            valueBuffer.append(" DESC ");
            valueBuffer.append("'" + token + "'");
        }
        if (this.isObsolete()) {
            valueBuffer.append(" OBSOLETE");
        }
        if ((token = this.getNameForm()) != null) {
            valueBuffer.append(" FORM ");
            valueBuffer.append("'" + token + "'");
        }
        if ((strArray = this.getSuperiors()) != null) {
            valueBuffer.append(" SUP ");
            if (strArray.length > 1) {
                valueBuffer.append("( ");
            }
            for (i = 0; i < strArray.length; ++i) {
                if (i > 0) {
                    valueBuffer.append(" ");
                }
                valueBuffer.append(strArray[i]);
            }
            if (strArray.length > 1) {
                valueBuffer.append(" )");
            }
        }
        if ((en = this.getQualifierNames()) != null) {
            while (en.hasMoreElements()) {
                String qualName = (String)en.nextElement();
                valueBuffer.append(" " + qualName + " ");
                String[] qualValue = this.getQualifier(qualName);
                if (qualValue == null) continue;
                if (qualValue.length > 1) {
                    valueBuffer.append("( ");
                }
                for (int i2 = 0; i2 < qualValue.length; ++i2) {
                    if (i2 > 0) {
                        valueBuffer.append(" ");
                    }
                    valueBuffer.append("'" + qualValue[i2] + "'");
                }
                if (qualValue.length <= 1) continue;
                valueBuffer.append(" )");
            }
        }
        valueBuffer.append(" )");
        return valueBuffer.toString();
    }

    protected void setDeserializedValues(BufferedInputStream istream) throws IOException {
        LDAPDITStructureRuleSchema readObject = (LDAPDITStructureRuleSchema)LDAPDITStructureRuleSchema.readDSML(istream);
        this.oid = readObject.getID();
        this.names = readObject.getNames();
        this.description = readObject.getDescription();
        this.obsolete = readObject.isObsolete();
        Enumeration enumeration = readObject.getQualifierNames();
        while (enumeration.hasMoreElements()) {
            String xname = (String)enumeration.nextElement();
            String[] qualifierVals = readObject.getQualifier(xname);
            this.setQualifier(xname, qualifierVals);
        }
        super.setValue(this.formatString());
        this.ruleID = readObject.getRuleID();
        this.nameForm = readObject.getName();
        this.superiorIDs = readObject.getSuperiors();
        readObject = null;
    }

    protected void writeValue(Writer out) throws IOException {
        String value = this.formatString();
        out.write(ValueXMLhandler.newLine(2));
        out.write("<value>");
        out.write(value);
        out.write("</value>");
    }

    protected void writeValue(StringBuffer buff) {
        String value = this.formatString();
        buff.append(ValueXMLhandler.newLine(2));
        buff.append("<value>");
        buff.append(value);
        buff.append("</value>");
    }

    public static Object readDSML(InputStream input) throws IOException {
        SAXEventMultiplexer xmlreader = new SAXEventMultiplexer();
        xmlreader.setLDAPXMLHandler(LDAPDITStructureRuleSchema.getTopXMLHandler("LDAPAttribute", null));
        return (LDAPDITStructureRuleSchema)xmlreader.parseXML(input);
    }

    private static LDAPXMLHandler getTopXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPDITStructureRuleSchema.getXMLHandler("attr", this));
            }

            protected void endElement() {
                this.setObject((LDAPDITStructureRuleSchema)this.valuelist.get(0));
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("attr")) {
                    this.valuelist.add(value);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Iterator valueiterator = this.valuelist.iterator();
                LDAPDITStructureRuleSchema attr = new LDAPDITStructureRuleSchema(this.attrName);
                byte[] temp = (byte[])valueiterator.next();
                StringBuffer bf = new StringBuffer(temp.length);
                for (int i = 0; i < temp.length; ++i) {
                    bf.append((char)temp[i]);
                }
                try {
                    SchemaParser parser = new SchemaParser(bf.toString());
                    if (parser.getNames() != null) {
                        attr.names = (String[])parser.getNames().clone();
                    }
                    if (parser.getID() != null) {
                        attr.ruleID = Integer.parseInt(parser.getID());
                    }
                    if (parser.getDescription() != null) {
                        attr.description = parser.getDescription();
                    }
                    if (parser.getSuperiors() != null) {
                        LDAPDITStructureRuleSchema.access$102(attr, (String[])parser.getSuperiors().clone());
                    }
                    if (parser.getNameForm() != null) {
                        attr.nameForm = parser.getNameForm();
                    }
                    attr.obsolete = parser.getObsolete();
                    Enumeration qualifiers = parser.getQualifiers();
                    while (qualifiers.hasMoreElements()) {
                        AttributeQualifier attrQualifier = (AttributeQualifier)qualifiers.nextElement();
                        attr.setQualifier(attrQualifier.getName(), attrQualifier.getValues());
                    }
                    attr.setValue(attr.formatString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e.toString());
                }
                this.setObject(attr);
                this.valuelist.clear();
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("value")) {
                    this.valuelist.add(value);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }

    static /* synthetic */ String[] access$102(LDAPDITStructureRuleSchema x0, String[] x1) {
        x0.superiorIDs = x1;
        return x1;
    }
}

