/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.SchemaParser;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPMatchingRuleUseSchema
extends LDAPSchemaElement {
    private String[] attributes;

    public LDAPMatchingRuleUseSchema() {
        super(LDAPSchema.schemaTypeNames[7]);
    }

    public LDAPMatchingRuleUseSchema(String[] names, String oid, String description, boolean obsolete, String[] attributes) {
        super(LDAPSchema.schemaTypeNames[7]);
        this.names = (String[])names.clone();
        this.oid = oid;
        this.description = description;
        this.obsolete = obsolete;
        this.attributes = (String[])attributes.clone();
        super.setValue(this.formatString());
    }

    public LDAPMatchingRuleUseSchema(String raw) {
        super(LDAPSchema.schemaTypeNames[7]);
        try {
            SchemaParser matchParser = new SchemaParser(raw);
            this.names = (String[])matchParser.getNames().clone();
            this.oid = matchParser.getID();
            this.description = matchParser.getDescription();
            this.obsolete = matchParser.getObsolete();
            this.attributes = matchParser.getApplies();
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    protected String formatString() {
        int i;
        String[] strArray;
        StringBuffer valueBuffer = new StringBuffer("( ");
        String token = this.getID();
        if (token != null) {
            valueBuffer.append(token);
        }
        if ((strArray = this.getNames()) != null) {
            valueBuffer.append(" NAME ");
            if (strArray.length == 1) {
                valueBuffer.append("'" + strArray[0] + "'");
            } else {
                valueBuffer.append("( ");
                for (i = 0; i < strArray.length; ++i) {
                    valueBuffer.append(" '" + strArray[i] + "'");
                }
                valueBuffer.append(" )");
            }
        }
        if ((token = this.getDescription()) != null) {
            valueBuffer.append(" DESC ");
            valueBuffer.append("'" + token + "'");
        }
        if (this.isObsolete()) {
            valueBuffer.append(" OBSOLETE");
        }
        if ((strArray = this.getAttributes()) != null) {
            valueBuffer.append(" APPLIES ");
            if (strArray.length > 1) {
                valueBuffer.append("( ");
            }
            for (i = 0; i < strArray.length; ++i) {
                if (i > 0) {
                    valueBuffer.append(" $ ");
                }
                valueBuffer.append(strArray[i]);
            }
            if (strArray.length > 1) {
                valueBuffer.append(" )");
            }
        }
        valueBuffer.append(" )");
        return valueBuffer.toString();
    }

    protected void setDeserializedValues(BufferedInputStream istream) throws IOException {
        LDAPMatchingRuleUseSchema readObject = (LDAPMatchingRuleUseSchema)LDAPMatchingRuleUseSchema.readDSML(istream);
        this.oid = readObject.getID();
        this.names = readObject.getNames();
        this.description = readObject.getDescription();
        this.obsolete = readObject.isObsolete();
        Enumeration enumeration = readObject.getQualifierNames();
        while (enumeration.hasMoreElements()) {
            String xname = (String)enumeration.nextElement();
            String[] qualifierVals = readObject.getQualifier(xname);
            this.setQualifier(xname, qualifierVals);
        }
        super.setValue(this.formatString());
        this.attributes = readObject.getAttributes();
        readObject = null;
    }

    protected void writeValue(Writer out) throws IOException {
        String value = this.formatString();
        out.write(ValueXMLhandler.newLine(2));
        out.write("<value>");
        out.write(value);
        out.write("</value>");
    }

    protected void writeValue(StringBuffer buff) {
        String value = this.formatString();
        buff.append(ValueXMLhandler.newLine(2));
        buff.append("<value>");
        buff.append(value);
        buff.append("</value>");
    }

    public static Object readDSML(InputStream input) throws IOException {
        SAXEventMultiplexer xmlreader = new SAXEventMultiplexer();
        xmlreader.setLDAPXMLHandler(LDAPMatchingRuleUseSchema.getTopXMLHandler("LDAPAttribute", null));
        return (LDAPMatchingRuleUseSchema)xmlreader.parseXML(input);
    }

    private static LDAPXMLHandler getTopXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPMatchingRuleUseSchema.getXMLHandler("attr", this));
            }

            protected void endElement() {
                this.setObject((LDAPMatchingRuleUseSchema)this.valuelist.get(0));
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("attr")) {
                    this.valuelist.add(value);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Iterator valueiterator = this.valuelist.iterator();
                LDAPMatchingRuleUseSchema attr = new LDAPMatchingRuleUseSchema(this.attrName);
                byte[] temp = (byte[])valueiterator.next();
                StringBuffer bf = new StringBuffer(temp.length);
                for (int i = 0; i < temp.length; ++i) {
                    bf.append((char)temp[i]);
                }
                try {
                    SchemaParser matchParser = new SchemaParser(bf.toString());
                    attr.names = (String[])matchParser.getNames().clone();
                    attr.oid = matchParser.getID();
                    attr.description = matchParser.getDescription();
                    attr.obsolete = matchParser.getObsolete();
                    LDAPMatchingRuleUseSchema.access$002(attr, matchParser.getApplies());
                    attr.setValue(attr.formatString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e.toString());
                }
                this.setObject(attr);
                this.valuelist.clear();
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("value")) {
                    this.valuelist.add(value);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }

    static /* synthetic */ String[] access$002(LDAPMatchingRuleUseSchema x0, String[] x1) {
        x0.attributes = x1;
        return x1;
    }
}

