/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.InterThreadException;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPReferralException;
import com.novell.ldap.LDAPUrl;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.client.Debug;
import com.novell.ldap.client.ReferralInfo;
import com.novell.ldap.rfc2251.RfcAddResponse;
import com.novell.ldap.rfc2251.RfcCompareResponse;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcDelResponse;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcLDAPResult;
import com.novell.ldap.rfc2251.RfcLDAPString;
import com.novell.ldap.rfc2251.RfcModifyDNResponse;
import com.novell.ldap.rfc2251.RfcModifyResponse;
import com.novell.ldap.rfc2251.RfcReferral;
import com.novell.ldap.rfc2251.RfcResponse;
import com.novell.ldap.rfc2251.RfcSearchResultDone;
import java.io.IOException;
import java.net.MalformedURLException;

public class LDAPResponse
extends LDAPMessage {
    private InterThreadException exception = null;
    private ReferralInfo activeReferral;

    public LDAPResponse() {
    }

    public LDAPResponse(InterThreadException ex, ReferralInfo activeReferral) {
        this.exception = ex;
        this.activeReferral = activeReferral;
        Debug.trace("Messages", "new LDAPResponse: referral " + (this.activeReferral != null) + "\n\texception:" + ex.toString());
    }

    LDAPResponse(RfcLDAPMessage message) {
        super(message);
    }

    public LDAPResponse(int type) {
        this(type, 0, null, null, null, null);
    }

    public LDAPResponse(int type, int resultCode, String matchedDN, String serverMessage, String[] referrals, LDAPControl[] controls) {
        super(new RfcLDAPMessage(LDAPResponse.RfcResultFactory(type, resultCode, matchedDN, serverMessage, referrals)));
    }

    private static RfcControls RfcControlFactory(LDAPControl[] controls) {
        RfcControls rfcs = new RfcControls();
        if (controls != null) {
            for (int i = 0; i < controls.length; ++i) {
                rfcs.add(controls[i].getASN1Object());
            }
            return rfcs;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static ASN1Sequence RfcResultFactory(int type, int resultCode, String matchedDN, String serverMessage, String[] referrals) {
        void var5_7;
        RfcReferral rfcreferal = null;
        if (referrals != null) {
            try {
                rfcreferal = new RfcReferral(referrals);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        if (matchedDN == null) {
            matchedDN = "";
        }
        if (serverMessage == null) {
            serverMessage = "";
        }
        switch (type) {
            case 5: {
                RfcLDAPResult ret = new RfcSearchResultDone(new ASN1Enumerated(resultCode), new RfcLDAPDN(matchedDN), new RfcLDAPString(serverMessage), rfcreferal);
                break;
            }
            case 1: {
                RfcLDAPResult ret = null;
                break;
            }
            case 4: {
                RfcLDAPResult ret = null;
                break;
            }
            case 7: {
                RfcLDAPResult ret = new RfcModifyResponse(new ASN1Enumerated(resultCode), new RfcLDAPDN(matchedDN), new RfcLDAPString(serverMessage), rfcreferal);
                break;
            }
            case 9: {
                RfcLDAPResult ret = new RfcAddResponse(new ASN1Enumerated(resultCode), new RfcLDAPDN(matchedDN), new RfcLDAPString(serverMessage), rfcreferal);
                break;
            }
            case 11: {
                RfcLDAPResult ret = new RfcDelResponse(new ASN1Enumerated(resultCode), new RfcLDAPDN(matchedDN), new RfcLDAPString(serverMessage), rfcreferal);
                break;
            }
            case 13: {
                RfcLDAPResult ret = new RfcModifyDNResponse(new ASN1Enumerated(resultCode), new RfcLDAPDN(matchedDN), new RfcLDAPString(serverMessage), rfcreferal);
                break;
            }
            case 15: {
                RfcLDAPResult ret = new RfcCompareResponse(new ASN1Enumerated(resultCode), new RfcLDAPDN(matchedDN), new RfcLDAPString(serverMessage), rfcreferal);
                break;
            }
            case 19: {
                RfcLDAPResult ret = null;
                break;
            }
            case 24: {
                RfcLDAPResult ret = null;
                break;
            }
            default: {
                throw new RuntimeException("Type " + type + " Not Supported");
            }
        }
        return var5_7;
    }

    public String getErrorMessage() {
        if (this.exception != null) {
            return this.exception.getLDAPErrorMessage();
        }
        return ((RfcResponse)((Object)this.message.getResponse())).getErrorMessage().stringValue();
    }

    public String getMatchedDN() {
        if (this.exception != null) {
            return this.exception.getMatchedDN();
        }
        return ((RfcResponse)((Object)this.message.getResponse())).getMatchedDN().stringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getReferrals() {
        String[] referrals = null;
        RfcReferral ref = ((RfcResponse)((Object)this.message.getResponse())).getReferral();
        if (ref == null) {
            referrals = new String[]{};
        } else {
            int size = ref.size();
            referrals = new String[size];
            for (int i = 0; i < size; ++i) {
                String aRef = ((ASN1OctetString)ref.get(i)).stringValue();
                try {
                    RfcLDAPMessage origMsg;
                    String dn;
                    LDAPUrl urlRef = new LDAPUrl(aRef);
                    if (urlRef.getDN() != null || (dn = (origMsg = super.getASN1Object().getRequestingMessage().getASN1Object()).getRequestDN()) == null) continue;
                    urlRef.setDN(dn);
                    aRef = urlRef.toString();
                    continue;
                }
                catch (MalformedURLException mex) {
                    continue;
                }
                finally {
                    referrals[i] = aRef;
                }
            }
        }
        return referrals;
    }

    public int getResultCode() {
        if (this.exception != null) {
            return this.exception.getResultCode();
        }
        return ((RfcResponse)((Object)this.message.getResponse())).getResultCode().intValue();
    }

    public void chkResultCode() throws LDAPException {
        if (this.exception != null) {
            throw this.exception;
        }
        Debug.trace("Messages", "LDAPResponse: message(" + this.getMessageID() + ") result code " + this.getResultCode());
        LDAPException ex = this.getResultException();
        if (ex != null) {
            throw ex;
        }
    }

    LDAPException getResultException() {
        LDAPException ex = null;
        switch (this.getResultCode()) {
            case 0: 
            case 5: 
            case 6: {
                break;
            }
            case 10: {
                String[] refs = this.getReferrals();
                Debug.trace("Messages", "LDAPResponse: Generating RfcReferral Exception");
                for (int i = 0; i < refs.length; ++i) {
                    Debug.trace("Messages", "LDAPResponse: \t" + refs[i]);
                }
                ex = new LDAPReferralException("Automatic referral following not enabled", 10, this.getErrorMessage());
                ((LDAPReferralException)ex).setReferrals(refs);
                break;
            }
            default: {
                ex = new LDAPException(LDAPException.resultCodeToString(this.getResultCode()), this.getResultCode(), this.getErrorMessage(), this.getMatchedDN());
            }
        }
        return ex;
    }

    public LDAPControl[] getControls() {
        if (this.exception != null) {
            return null;
        }
        return super.getControls();
    }

    public int getMessageID() {
        if (this.exception != null) {
            return this.exception.getMessageID();
        }
        return super.getMessageID();
    }

    public int getType() {
        if (this.exception != null) {
            return this.exception.getReplyType();
        }
        return super.getType();
    }

    boolean hasException() {
        return this.exception != null;
    }

    LDAPException getException() {
        return this.exception;
    }

    ReferralInfo getActiveReferral() {
        return this.activeReferral;
    }

    protected void setDeserializedValues(LDAPMessage readObject, RfcControls asn1Ctrls) throws IOException, ClassNotFoundException {
        if (!(readObject instanceof LDAPResponse)) {
            throw new ClassNotFoundException("Error occured while deserializing LDAPResponse object");
        }
        LDAPResponse tmp = (LDAPResponse)readObject;
        int type = tmp.getType();
        int resultCode = tmp.getResultCode();
        String matchedDN = tmp.getMatchedDN();
        String serverMessage = tmp.getErrorMessage();
        String[] referrals = tmp.getReferrals();
        tmp = null;
        this.message = new RfcLDAPMessage(LDAPResponse.RfcResultFactory(type, resultCode, matchedDN, serverMessage, referrals));
        readObject = null;
    }
}

