/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPReferralException;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchQueue;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.LDAPSearchResultReference;
import com.novell.ldap.client.Debug;
import com.novell.ldap.client.ReferralInfo;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Vector;

public class LDAPSearchResults {
    private Vector entries;
    private int entryCount;
    private int entryIndex;
    private Vector references;
    private int referenceCount;
    private int referenceIndex;
    private int batchSize;
    private boolean completed = false;
    private LDAPControl[] controls = null;
    private LDAPSearchQueue queue;
    private static Object nameLock = new Object();
    private static int resultsNum = 0;
    private String name;
    private LDAPConnection conn;
    private LDAPSearchConstraints cons;
    private ArrayList referralConn = null;

    LDAPSearchResults() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LDAPSearchResults(LDAPConnection conn, LDAPSearchQueue queue, LDAPSearchConstraints cons) {
        this.conn = conn;
        this.cons = cons;
        int batchSize = cons.getBatchSize();
        int vectorIncr = batchSize == 0 ? 64 : 0;
        this.entries = new Vector(batchSize == 0 ? 64 : batchSize, vectorIncr);
        this.entryCount = 0;
        this.entryIndex = 0;
        this.references = new Vector(5, 5);
        this.referenceCount = 0;
        this.referenceIndex = 0;
        this.queue = queue;
        this.batchSize = batchSize == 0 ? Integer.MAX_VALUE : batchSize;
        Object object = nameLock;
        synchronized (object) {
            this.name = "LDAPSearchResults(" + ++resultsNum + "): ";
        }
        Debug.trace("Messages", this.name + " Object created, batch size " + this.batchSize + ", hops " + cons.getHopLimit());
    }

    public int getCount() {
        int qCount = this.queue.getMessageAgent().getCount();
        return this.entryCount - this.entryIndex + this.referenceCount - this.referenceIndex + qCount;
    }

    public LDAPControl[] getResponseControls() {
        return this.controls;
    }

    public boolean hasMore() {
        boolean ret = false;
        if (this.entryIndex < this.entryCount || this.referenceIndex < this.referenceCount) {
            ret = true;
        } else if (!this.completed) {
            this.resetVectors();
            ret = this.entryIndex < this.entryCount || this.referenceIndex < this.referenceCount;
        }
        Debug.trace("Messages", this.name + "hasMoreElements: returns " + ret + ", enumeration status " + ", entryIdx=" + this.entryIndex + ", entryCnt=" + this.entryCount + ", referIdx=" + this.referenceIndex + ", referCnt=" + this.referenceCount);
        return ret;
    }

    private void resetVectors() {
        if (this.completed) {
            return;
        }
        if (this.referenceIndex != 0 && this.referenceIndex >= this.referenceCount) {
            this.references.setSize(0);
            this.referenceCount = 0;
            this.referenceIndex = 0;
        }
        if (this.entryIndex != 0 && this.entryIndex >= this.entryCount) {
            this.entries.setSize(0);
            this.entryCount = 0;
            this.entryIndex = 0;
        }
        if (this.referenceIndex == 0 && this.referenceCount == 0 && this.entryIndex == 0 && this.entryCount == 0) {
            this.completed = this.getBatchOfResults();
        }
    }

    public LDAPEntry next() throws LDAPException {
        if (this.completed && this.entryIndex >= this.entryCount && this.referenceIndex >= this.referenceCount) {
            throw new NoSuchElementException("LDAPSearchResults.next() no more results");
        }
        this.resetVectors();
        Object element = null;
        if (this.referenceIndex < this.referenceCount) {
            String[] refs = (String[])this.references.elementAt(this.referenceIndex++);
            Debug.trace("Messages", this.name + "next: throws referral exception");
            for (int i = 0; i < refs.length; ++i) {
                Debug.trace("Messages", this.name + " \t" + refs[i]);
            }
            LDAPReferralException rex = new LDAPReferralException("REFERENCE_NOFOLLOW");
            rex.setReferrals(refs);
            throw rex;
        }
        if (this.entryIndex < this.entryCount) {
            element = this.entries.elementAt(this.entryIndex++);
            Debug.trace("Messages", this.name + "next: returns " + element.getClass().getName() + "@" + Integer.toHexString(element.hashCode()) + ", elements remaining " + this.entries.size());
            if (element instanceof LDAPResponse) {
                if (((LDAPResponse)element).hasException()) {
                    LDAPResponse lr = (LDAPResponse)element;
                    ReferralInfo ri = lr.getActiveReferral();
                    Debug.trace("Messages", this.name + "next: LDAPResponse has embedded exception" + " from following referral - " + (ri != null));
                    if (ri != null) {
                        LDAPReferralException rex = new LDAPReferralException("REFERENCE_ERROR", lr.getException());
                        rex.setReferrals(ri.getReferralList());
                        rex.setFailedReferral(ri.getReferralUrl().toString());
                        throw rex;
                    }
                }
                ((LDAPResponse)element).chkResultCode();
            } else if (element instanceof LDAPException) {
                Debug.trace("Messages", this.name + "next: LDAPException " + element.toString());
                throw (LDAPException)element;
            }
        } else {
            Debug.trace("Messages", this.name + "next: No entry found and request incomplete\n" + "\tentryIdx " + this.entryIndex + ", entryCnt " + this.entryCount + ", referIdx " + this.referenceIndex + ", referCnt " + this.referenceCount);
            throw new LDAPException("REFERRAL_LOCAL", new Object[]{"next"}, 82, (String)null);
        }
        return (LDAPEntry)element;
    }

    private boolean getBatchOfResults() {
        int i = 0;
        while (i < this.batchSize) {
            try {
                LDAPMessage msg = this.queue.getResponse();
                if (msg != null) {
                    LDAPControl[] ctls = msg.getControls();
                    if (ctls != null) {
                        Debug.trace("Controls", this.name + "Saving returned controls in " + "LDAPSearchResults local variable.");
                        this.controls = ctls;
                    }
                    if (msg instanceof LDAPSearchResult) {
                        LDAPEntry entry = ((LDAPSearchResult)msg).getEntry();
                        this.entries.addElement(entry);
                        ++i;
                        ++this.entryCount;
                        Debug.trace("Messages", this.name + "read LDAPEntry@" + Integer.toHexString(entry.hashCode()) + " from LDAPMessage@" + Integer.toHexString(msg.hashCode()));
                        continue;
                    }
                    if (msg instanceof LDAPSearchResultReference) {
                        String[] refs = ((LDAPSearchResultReference)msg).getReferrals();
                        Debug.trace("Messages", this.name + "got " + refs.length + " references in entry ");
                        for (int k = 0; k < refs.length; ++k) {
                            Debug.trace("Messages", this.name + "reference " + k + "\t" + refs[k]);
                        }
                        if (this.cons.getReferralFollowing()) {
                            this.referralConn = this.conn.chaseReferral(this.queue, this.cons, msg, refs, 0, true, this.referralConn);
                            continue;
                        }
                        this.references.addElement(refs);
                        ++this.referenceCount;
                        continue;
                    }
                    LDAPResponse resp = (LDAPResponse)msg;
                    int resultCode = resp.getResultCode();
                    if (resp.hasException()) {
                        resultCode = 91;
                        Debug.trace("Messages", this.name + "LDAPResponse with embeddedException");
                    } else {
                        Debug.trace("Messages", this.name + "read LDAPResponse@" + Integer.toHexString(resp.hashCode()) + ", result " + resultCode);
                    }
                    if (resultCode == 10 && this.cons.getReferralFollowing()) {
                        Debug.trace("Messages", this.name + "following referrals");
                        this.referralConn = this.conn.chaseReferral(this.queue, this.cons, resp, resp.getReferrals(), 0, false, this.referralConn);
                    } else if (resultCode != 0) {
                        this.entries.addElement(resp);
                        ++this.entryCount;
                        Debug.trace("Messages", this.name + "Add LDAPResponse to entry list, count = " + this.entries.size());
                    }
                    Debug.trace("Messages", this.name + "checking for done");
                    int[] msgIDs = this.queue.getMessageIDs();
                    if (msgIDs.length == 0) {
                        Debug.trace("Messages", this.name + "Search completed, all responses processed");
                        this.conn.releaseReferralConnections(this.referralConn);
                        return true;
                    }
                    Debug.trace("Messages", this.name + "Search not done, " + msgIDs.length + " Messages still active");
                    continue;
                }
                Debug.trace("Messages", this.name + "Connection timeout, no results returned");
                LDAPException e = new LDAPException(null, 85, null);
                this.entries.addElement(e);
                break;
            }
            catch (LDAPException e) {
                Debug.trace("Messages", this.name + "Caught exception, add to entry queue: " + e.toString());
                this.entries.addElement(e);
            }
        }
        return false;
    }

    void abandon() {
        Debug.trace("Messages", this.name + "abandon: Entry");
        this.queue.getMessageAgent().abandonAll();
        this.resetVectors();
        this.completed = true;
    }
}

