/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.SchemaParser;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPSyntaxSchema
extends LDAPSchemaElement
implements Externalizable {
    public LDAPSyntaxSchema() {
        super(LDAPSchema.schemaTypeNames[2]);
    }

    public LDAPSyntaxSchema(String raw) {
        super(LDAPSchema.schemaTypeNames[2]);
        try {
            SchemaParser parser = new SchemaParser(raw);
            if (parser.getID() != null) {
                this.oid = parser.getID();
            }
            if (parser.getDescription() != null) {
                this.description = parser.getDescription();
            }
            Enumeration qualifiers = parser.getQualifiers();
            while (qualifiers.hasMoreElements()) {
                AttributeQualifier attrQualifier = (AttributeQualifier)qualifiers.nextElement();
                this.setQualifier(attrQualifier.getName(), attrQualifier.getValues());
            }
            super.setValue(this.formatString());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public LDAPSyntaxSchema(String oid, String description) {
        super(LDAPSchema.schemaTypeNames[2]);
        this.oid = oid;
        this.description = description;
        super.setValue(this.formatString());
    }

    protected String formatString() {
        Enumeration en;
        StringBuffer valueBuffer = new StringBuffer("( ");
        String token = this.getID();
        if (token != null) {
            valueBuffer.append(token);
        }
        if ((token = this.getDescription()) != null) {
            valueBuffer.append(" DESC ");
            valueBuffer.append("'" + token + "'");
        }
        if ((en = this.getQualifierNames()) != null) {
            while (en.hasMoreElements()) {
                String qualName = (String)en.nextElement();
                valueBuffer.append(" " + qualName + " ");
                String[] qualValue = this.getQualifier(qualName);
                if (qualValue == null || qualValue.length <= 1) continue;
                valueBuffer.append("( ");
                for (int i = 0; i < qualValue.length; ++i) {
                    if (i > 0) {
                        valueBuffer.append(" ");
                    }
                    valueBuffer.append("'" + qualValue[i] + "'");
                }
                if (qualValue.length <= 1) continue;
                valueBuffer.append(" )");
            }
        }
        valueBuffer.append(" )");
        return valueBuffer.toString();
    }

    protected void setDeserializedValues(BufferedInputStream istream) throws IOException {
        LDAPSyntaxSchema readObject = (LDAPSyntaxSchema)LDAPSyntaxSchema.readDSML(istream);
        this.oid = readObject.oid;
        this.names = readObject.getNames();
        this.obsolete = readObject.obsolete;
        this.description = readObject.description;
        Enumeration enumeration = readObject.getQualifierNames();
        while (enumeration.hasMoreElements()) {
            String xname = (String)enumeration.nextElement();
            String[] qualifierVals = readObject.getQualifier(xname);
            this.setQualifier(xname, qualifierVals);
        }
        super.setValue(this.formatString());
        readObject = null;
    }

    protected void writeValue(Writer out) throws IOException {
        String oid = this.getID();
        Enumeration enumeration = this.getQualifierNames();
        String xname = (String)enumeration.nextElement();
        String[] qualifierVals = this.getQualifier(xname);
        String value = "( " + oid + " " + xname + " '" + qualifierVals[0] + "' )";
        out.write(ValueXMLhandler.newLine(2));
        out.write("<value>");
        out.write(value);
        out.write("</value>");
    }

    protected void writeValue(StringBuffer buff) {
        String oid = this.getID();
        Enumeration enumeration = this.getQualifierNames();
        String xname = (String)enumeration.nextElement();
        String[] qualifierVals = this.getQualifier(xname);
        String value = "( " + oid + " " + xname + " '" + qualifierVals[0] + "' )";
        buff.append(ValueXMLhandler.newLine(2));
        buff.append("<value>");
        buff.append(value);
        buff.append("</value>");
    }

    public static Object readDSML(InputStream input) throws IOException {
        SAXEventMultiplexer xmlreader = new SAXEventMultiplexer();
        xmlreader.setLDAPXMLHandler(LDAPSyntaxSchema.getTopXMLHandler("LDAPAttribute", null));
        return (LDAPSyntaxSchema)xmlreader.parseXML(input);
    }

    private static LDAPXMLHandler getTopXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPSyntaxSchema.getXMLHandler("attr", this));
            }

            protected void endElement() {
                this.setObject((LDAPSyntaxSchema)this.valuelist.get(0));
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("attr")) {
                    this.valuelist.add(value);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Iterator valueiterator = this.valuelist.iterator();
                LDAPSyntaxSchema attr = new LDAPSyntaxSchema(this.attrName);
                byte[] temp = (byte[])valueiterator.next();
                StringBuffer bf = new StringBuffer(temp.length);
                for (int i = 0; i < temp.length; ++i) {
                    bf.append((char)temp[i]);
                }
                try {
                    SchemaParser parser = new SchemaParser(bf.toString());
                    if (parser.getID() != null) {
                        attr.oid = parser.getID();
                    }
                    if (parser.getDescription() != null) {
                        attr.description = parser.getDescription();
                    }
                    Enumeration qualifiers = parser.getQualifiers();
                    while (qualifiers.hasMoreElements()) {
                        AttributeQualifier attrQualifier = (AttributeQualifier)qualifiers.nextElement();
                        attr.setQualifier(attrQualifier.getName(), attrQualifier.getValues());
                    }
                    attr.setValue(attr.formatString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e.toString());
                }
                this.setObject(attr);
                this.valuelist.clear();
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("value")) {
                    this.valuelist.add(value);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }
}

