/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.client.ArrayEnumeration;
import com.novell.ldap.client.Debug;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Enumeration;

public class LDAPUrl
implements Cloneable,
Externalizable {
    private static final int DEFAULT_SCOPE = 0;
    private boolean secure = false;
    private boolean ipV6 = false;
    private String host = null;
    private int port = 0;
    private String dn = null;
    private String[] attrs = null;
    private String filter = null;
    private int scope = 0;
    private String[] extensions = null;

    public LDAPUrl() {
    }

    public LDAPUrl(String url) throws MalformedURLException {
        this.parseURL(url);
    }

    public LDAPUrl(String host, int port, String dn) {
        this.host = host;
        this.port = port;
        this.dn = dn;
    }

    public LDAPUrl(String host, int port, String dn, String[] attrNames, int scope, String filter, String[] extensions) {
        this.host = host;
        this.port = port;
        this.dn = dn;
        this.attrs = (String[])attrNames.clone();
        this.scope = scope;
        this.filter = filter;
        this.extensions = (String[])extensions.clone();
    }

    public LDAPUrl(String host, int port, String dn, String[] attrNames, int scope, String filter, String[] extensions, boolean secure) {
        this.host = host;
        this.port = port;
        this.dn = dn;
        this.attrs = attrNames;
        this.scope = scope;
        this.filter = filter;
        this.extensions = (String[])extensions.clone();
        this.secure = secure;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ce) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    public static String decode(String URLEncoded) throws MalformedURLException {
        Debug.trace("UrlParse", "decode(" + URLEncoded + ")");
        int searchStart = 0;
        int fieldStart = URLEncoded.indexOf("%", searchStart);
        if (fieldStart < 0) {
            return URLEncoded;
        }
        int fieldEnd = 0;
        int dataLen = URLEncoded.length();
        StringBuffer decoded = new StringBuffer(dataLen);
        while (true) {
            if (fieldStart > dataLen - 3) {
                throw new MalformedURLException("LDAPUrl.decode: must be two hex characters following escape character '%'");
            }
            if (fieldStart < 0) {
                fieldStart = dataLen;
            }
            decoded.append(URLEncoded.substring(fieldEnd, fieldStart));
            if (++fieldStart >= dataLen) break;
            fieldEnd = fieldStart + 2;
            try {
                decoded.append((char)Integer.parseInt(URLEncoded.substring(fieldStart, fieldEnd), 16));
            }
            catch (NumberFormatException ex) {
                throw new MalformedURLException("LDAPUrl.decode: error converting hex characters to integer \"" + ex.getMessage() + "\"");
            }
            searchStart = fieldEnd;
            if (searchStart == dataLen) break;
            fieldStart = URLEncoded.indexOf("%", searchStart);
        }
        Debug.trace("UrlParse", "decode returns(" + decoded + ")");
        return decoded.toString();
    }

    public static String encode(String toEncode) {
        StringBuffer buffer = new StringBuffer(toEncode.length());
        for (int i = 0; i < toEncode.length(); ++i) {
            char currChar = toEncode.charAt(i);
            if (currChar <= '\u001f' || currChar == '\u007f' || currChar >= '\u0080' && currChar <= '\u00ff' || currChar == '<' || currChar == '>' || currChar == '\"' || currChar == '#' || currChar == '%' || currChar == '{' || currChar == '}' || currChar == '|' || currChar == '\\' || currChar == '^' || currChar == '~' || currChar == '[' || currChar == '\'' || currChar == ' ' || currChar == ';' || currChar == '/' || currChar == '?' || currChar == ':' || currChar == '@' || currChar == '=' || currChar == '&') {
                String temp = Integer.toHexString(currChar);
                if (temp.length() == 1) {
                    buffer.append("%0" + temp);
                    continue;
                }
                buffer.append("%" + Integer.toHexString(currChar));
                continue;
            }
            buffer.append(currChar);
        }
        return buffer.toString();
    }

    public String[] getAttributeArray() {
        return this.attrs;
    }

    public Enumeration getAttributes() {
        return new ArrayEnumeration(this.attrs);
    }

    public String getDN() {
        return this.dn;
    }

    void setDN(String dn) {
        this.dn = dn;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        if (this.port == 0) {
            return 389;
        }
        return this.port;
    }

    public int getScope() {
        return this.scope;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        int i;
        StringBuffer url = new StringBuffer(256);
        if (this.secure) {
            url.append("ldaps://");
        } else {
            url.append("ldap://");
        }
        if (this.ipV6) {
            url.append("[" + this.host + "]");
        } else {
            url.append(this.host);
        }
        if (this.port != 0) {
            url.append(":" + this.port);
        }
        if (this.dn == null && this.attrs == null && this.scope == 0 && this.filter == null && this.extensions == null) {
            return url.toString();
        }
        url.append("/");
        if (this.dn != null) {
            url.append(this.dn);
        }
        if (this.attrs == null && this.scope == 0 && this.filter == null && this.extensions == null) {
            return url.toString();
        }
        url.append("?");
        if (this.attrs != null) {
            for (i = 0; i < this.attrs.length; ++i) {
                url.append(this.attrs[i]);
                if (i >= this.attrs.length - 1) continue;
                url.append(",");
            }
        }
        if (this.scope == 0 && this.filter == null && this.extensions == null) {
            return url.toString();
        }
        url.append("?");
        if (this.scope != 0) {
            if (this.scope == 1) {
                url.append("one");
            } else {
                url.append("sub");
            }
        }
        if (this.filter == null && this.extensions == null) {
            return url.toString();
        }
        if (this.filter == null) {
            url.append("?");
        } else {
            url.append("?" + this.getFilter());
        }
        if (this.extensions == null) {
            return url.toString();
        }
        url.append("?");
        if (this.extensions != null) {
            for (i = 0; i < this.extensions.length; ++i) {
                url.append(this.extensions[i]);
                if (i >= this.extensions.length - 1) continue;
                url.append(",");
            }
        }
        return url.toString();
    }

    private String[] parseList(String listStr, char delimiter, int listStart, int listEnd) {
        int itemEnd;
        Debug.trace("UrlParse", "parseList(" + listStr.substring(listStart, listEnd) + ")");
        if (listEnd - listStart < 1) {
            return null;
        }
        int itemStart = listStart;
        int itemCount = 0;
        while (itemStart > 0) {
            ++itemCount;
            itemEnd = listStr.indexOf(delimiter, itemStart);
            if (itemEnd <= 0 || itemEnd >= listEnd) break;
            itemStart = itemEnd + 1;
        }
        itemStart = listStart;
        String[] list = new String[itemCount];
        itemCount = 0;
        while (itemStart > 0) {
            itemEnd = listStr.indexOf(delimiter, itemStart);
            if (itemStart > listEnd) break;
            if (itemEnd < 0) {
                itemEnd = listEnd;
            }
            if (itemEnd > listEnd) {
                itemEnd = listEnd;
            }
            list[itemCount] = listStr.substring(itemStart, itemEnd);
            itemStart = itemEnd + 1;
            ++itemCount;
        }
        return list;
    }

    private void parseURL(String url) throws MalformedURLException {
        int portStart;
        int scanStart = 0;
        int scanEnd = url.length();
        Debug.trace("UrlParse", "parseURL(" + url + ")");
        if (url == null) {
            throw new MalformedURLException("LDAPUrl: URL cannot be null");
        }
        if (url.charAt(scanStart) == '<') {
            if (url.charAt(scanEnd - 1) != '>') {
                throw new MalformedURLException("LDAPUrl: URL bad enclosure");
            }
            ++scanStart;
            --scanEnd;
            Debug.trace("UrlParse", "LDAPUrl: parseURL: Url is enclosed");
        }
        if (url.substring(scanStart, scanStart + 4).equalsIgnoreCase("URL:")) {
            scanStart += 4;
        }
        if (url.substring(scanStart, scanStart + 7).equalsIgnoreCase("ldap://")) {
            scanStart += 7;
            this.port = 389;
        } else if (url.substring(scanStart, scanStart + 8).equalsIgnoreCase("ldaps://")) {
            this.secure = true;
            scanStart += 8;
            this.port = 636;
        } else {
            throw new MalformedURLException("LDAPUrl: URL scheme is not ldap");
        }
        Debug.trace("UrlParse", "parseURL: scheme is " + (this.secure ? "ldaps" : "ldap"));
        int dnStart = url.indexOf("/", scanStart);
        int hostPortEnd = scanEnd;
        boolean novell = false;
        if (dnStart < 0) {
            dnStart = url.indexOf("?", scanStart);
            if (dnStart > 0) {
                if (url.charAt(dnStart + 1) == '?') {
                    hostPortEnd = dnStart++;
                    novell = true;
                    Debug.trace("UrlParse", "parseURL: wierd novell syntax found");
                } else {
                    dnStart = -1;
                }
            }
        } else {
            hostPortEnd = dnStart;
        }
        int hostEnd = hostPortEnd;
        if (url.charAt(scanStart) == '[') {
            hostEnd = url.indexOf(93, scanStart + 1);
            if (hostEnd >= hostPortEnd || hostEnd == -1) {
                throw new MalformedURLException("LDAPUrl: \"]\" is missing on IPV6 host name");
            }
            this.host = url.substring(scanStart + 1, hostEnd);
            portStart = url.indexOf(":", hostEnd);
            if (portStart < hostPortEnd && portStart != -1) {
                this.port = Integer.decode(url.substring(portStart + 1, hostPortEnd));
                Debug.trace("UrlParse", "parseURL: IPV6 host " + this.host + " port " + this.port);
            } else {
                Debug.trace("UrlParse", "parseURL: IPV6 host " + this.host + " default port " + this.port);
            }
        } else {
            portStart = url.indexOf(":", scanStart);
            if (portStart < 0 || portStart > hostPortEnd) {
                this.host = url.substring(scanStart, hostPortEnd);
                Debug.trace("UrlParse", "parseURL: host " + this.host + " default port " + this.port);
            } else {
                this.host = url.substring(scanStart, portStart);
                this.port = Integer.decode(url.substring(portStart + 1, hostPortEnd));
                Debug.trace("UrlParse", "parseURL: host " + this.host + " port " + this.port);
            }
        }
        scanStart = hostPortEnd + 1;
        if (scanStart >= scanEnd || dnStart < 0) {
            return;
        }
        scanStart = dnStart + 1;
        int attrsStart = url.indexOf(63, scanStart);
        this.dn = attrsStart < 0 ? url.substring(scanStart, scanEnd) : url.substring(scanStart, attrsStart);
        Debug.trace("UrlParse", "parseURL: dn " + this.dn);
        scanStart = attrsStart + 1;
        if (scanStart >= scanEnd || attrsStart < 0 || novell) {
            return;
        }
        int scopeStart = url.indexOf(63, scanStart);
        if (scopeStart < 0) {
            scopeStart = scanEnd;
        }
        this.attrs = this.parseList(url, ',', attrsStart + 1, scopeStart);
        if (this.attrs != null) {
            Debug.trace("UrlParse", "parseURL: " + this.attrs.length + " attributes");
            for (int i = 0; i < this.attrs.length; ++i) {
                Debug.trace("UrlParse", "\t" + this.attrs[i]);
            }
        } else {
            Debug.trace("UrlParse", "parseURL: no attributes");
        }
        scanStart = scopeStart + 1;
        if (scanStart >= scanEnd) {
            return;
        }
        int filterStart = url.indexOf(63, scanStart);
        String scopeStr = filterStart < 0 ? url.substring(scanStart, scanEnd) : url.substring(scanStart, filterStart);
        if (scopeStr.equalsIgnoreCase("")) {
            this.scope = 0;
            scopeStr = "sub";
        } else if (scopeStr.equalsIgnoreCase("base")) {
            this.scope = 0;
        } else if (scopeStr.equalsIgnoreCase("one")) {
            this.scope = 1;
        } else if (scopeStr.equalsIgnoreCase("sub")) {
            this.scope = 2;
        } else {
            throw new MalformedURLException("LDAPUrl: URL invalid scope");
        }
        Debug.trace("UrlParse", "parseURL: scope(" + this.scope + ") " + scopeStr);
        scanStart = filterStart + 1;
        if (scanStart >= scanEnd || filterStart < 0) {
            return;
        }
        scanStart = filterStart + 1;
        int extStart = url.indexOf(63, scanStart);
        String filterStr = extStart < 0 ? url.substring(scanStart, scanEnd) : url.substring(scanStart, extStart);
        if (!filterStr.equals("")) {
            this.filter = filterStr;
        }
        Debug.trace("UrlParse", "parseURL: filter " + this.getFilter());
        scanStart = extStart + 1;
        if (scanStart >= scanEnd || extStart < 0) {
            return;
        }
        int end = url.indexOf(63, scanStart);
        if (end > 0) {
            throw new MalformedURLException("LDAPUrl: URL has too many ? fields");
        }
        this.extensions = this.parseList(url, ',', scanStart, scanEnd);
        if (this.extensions != null) {
            Debug.trace("UrlParse", "parseURL: " + this.extensions.length + " extensions");
            for (int i = 0; i < this.extensions.length; ++i) {
                Debug.trace("UrlParse", "\t" + this.extensions[i]);
            }
        } else {
            Debug.trace("UrlParse", "parseURL: no extensions");
        }
    }

    public void writeDSML(OutputStream oout) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(oout, "UTF-8");
        out.write("<LDAPUrl>" + this.toString() + "</LDAPUrl>");
        ((Writer)out).close();
    }

    public static Object readDSML(InputStream input) throws IOException {
        SAXEventMultiplexer xmlreader = new SAXEventMultiplexer();
        xmlreader.setLDAPXMLHandler(LDAPUrl.getXMLHandler("LDAPUrl", null));
        return (LDAPUrl)xmlreader.parseXML(input);
    }

    static LDAPXMLHandler getXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){

            protected void endElement() {
                try {
                    LDAPUrl url = new LDAPUrl(this.getValue());
                    this.setObject(url);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        StringBuffer buff = new StringBuffer();
        buff.append(ValueXMLhandler.newLine(0));
        buff.append(ValueXMLhandler.newLine(0));
        String header = "";
        header = header + "*************************************************************************\n";
        header = header + "** The encrypted data above and below is the Class definition and  ******\n";
        header = header + "** other data specific to Java Serialization Protocol. The data  ********\n";
        header = header + "** which is of most application specific interest is as follows... ******\n";
        header = header + "*************************************************************************\n";
        header = header + "****************** Start of application data ****************************\n";
        header = header + "*************************************************************************\n";
        buff.append(header);
        buff.append(ValueXMLhandler.newLine(0));
        buff.append("<LDAPUrl>");
        buff.append(this.toString());
        buff.append("</LDAPUrl>");
        buff.append(ValueXMLhandler.newLine(0));
        buff.append(ValueXMLhandler.newLine(0));
        String tail = "";
        tail = tail + "*************************************************************************\n";
        tail = tail + "****************** End of application data ******************************\n";
        tail = tail + "*************************************************************************\n";
        buff.append(tail);
        buff.append(ValueXMLhandler.newLine(0));
        out.writeUTF(buff.toString());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String readData = in.readUTF();
        String readProperties = readData.substring(readData.indexOf(60), readData.lastIndexOf(62) + 1);
        StringBuffer parsedBuff = new StringBuffer();
        ValueXMLhandler.parseInput(readProperties, parsedBuff);
        BufferedInputStream istream = new BufferedInputStream(new ByteArrayInputStream(parsedBuff.toString().getBytes()));
        LDAPUrl readObject = (LDAPUrl)LDAPUrl.readDSML(istream);
        this.parseURL(readObject.toString());
        readObject = null;
    }
}

