/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.Connection;
import com.novell.ldap.InterThreadException;
import com.novell.ldap.LDAPAbandonRequest;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.MessageAgent;
import com.novell.ldap.MessageVector;
import com.novell.ldap.client.BindProperties;
import com.novell.ldap.client.Debug;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcResponse;

class Message {
    private LDAPMessage msg;
    private Connection conn;
    private MessageAgent agent;
    private LDAPMessageQueue queue;
    private int mslimit;
    private Thread timer = null;
    private MessageVector replies = new MessageVector(5, 5);
    private int msgId;
    private boolean acceptReplies = true;
    private boolean waitForReply = true;
    private boolean complete = false;
    private String name;
    private BindProperties bindprops;

    Message(LDAPMessage msg, int mslimit, Connection conn, MessageAgent agent, LDAPMessageQueue queue, BindProperties bindprops) {
        this.msg = msg;
        this.conn = conn;
        this.agent = agent;
        this.queue = queue;
        this.mslimit = mslimit;
        this.msgId = msg.getMessageID();
        this.bindprops = bindprops;
        this.name = "Message(" + this.msgId + "): ";
        Debug.trace("Messages", this.name + " Created with mslimit " + this.mslimit);
    }

    final void sendMessage() throws LDAPException {
        Debug.trace("Messages", this.name + "Sending request to " + this.conn.getConnectionName());
        this.conn.writeMessage(this);
        if (this.mslimit != 0) {
            switch (this.msg.getType()) {
                case 2: 
                case 16: {
                    this.mslimit = 0;
                    break;
                }
                default: {
                    this.timer = new Timeout(this.mslimit, this);
                    this.timer.setDaemon(true);
                    this.timer.start();
                }
            }
        }
    }

    boolean hasReplies() {
        if (this.replies == null) {
            return false;
        }
        return this.replies.size() > 0;
    }

    int getCount() {
        int size = this.replies.size();
        if (this.complete) {
            return size > 0 ? size - 1 : size;
        }
        return size;
    }

    boolean acceptsReplies() {
        return this.acceptReplies;
    }

    void refuseReplies() {
        this.acceptReplies = false;
    }

    void setAgent(MessageAgent agent) {
        this.agent = agent;
    }

    void stopTimer() {
        if (this.timer != null) {
            this.timer.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleepersAwake() {
        Debug.trace("Messages", this.name + "Sleepers Awake, " + this.agent.getAgentName());
        MessageVector messageVector = this.replies;
        synchronized (messageVector) {
            this.replies.notify();
        }
        this.agent.sleepersAwake(false);
    }

    boolean isComplete() {
        return this.complete;
    }

    MessageAgent getMessageAgent() {
        return this.agent;
    }

    LDAPMessage getRequest() {
        return this.msg;
    }

    int getMessageID() {
        return this.msgId;
    }

    int getMessageType() {
        if (this.msg == null) {
            return -1;
        }
        return this.msg.getType();
    }

    void putReply(RfcLDAPMessage message) {
        if (!this.acceptReplies) {
            Debug.trace("Messages", this.name + "not accepting replies, discarding reply");
            return;
        }
        this.replies.addElement(message);
        message.setRequestingMessage(this.msg);
        switch (message.getType()) {
            case 4: 
            case 19: 
            case 25: {
                Debug.trace("Messages", this.name + "Reply Queued (" + this.replies.size() + " in queue)");
                break;
            }
            default: {
                int id;
                int res = ((RfcResponse)((Object)message.getResponse())).getResultCode().intValue();
                Debug.trace("Messages", this.name + "Queued LDAPResult (" + this.replies.size() + " in queue), message complete stopping timer, status " + res);
                this.stopTimer();
                this.acceptReplies = false;
                this.complete = true;
                if (this.bindprops == null) break;
                Debug.trace("Messages", this.name + "Bind properties found");
                res = ((RfcResponse)((Object)message.getResponse())).getResultCode().intValue();
                if (res == 14) {
                    Debug.trace("Messages", this.name + "Sasl Bind in-progress status");
                    break;
                }
                if (res == 0) {
                    this.conn.setBindProperties(this.bindprops);
                    Debug.trace("Messages", this.name + "Bind status success");
                } else {
                    Debug.trace("Messages", this.name + "Bind status " + res);
                }
                if (this.conn.isBindSemIdClear()) {
                    id = this.msgId;
                } else {
                    id = this.conn.getBindSemId();
                    this.conn.clearBindSemId();
                }
                this.conn.freeWriteSemaphore(id);
            }
        }
        this.sleepersAwake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object waitForReply() {
        Debug.trace("Messages", this.name + "waitForReply()");
        if (this.replies == null) {
            return null;
        }
        MessageVector messageVector = this.replies;
        synchronized (messageVector) {
            Object msg = null;
            while (this.waitForReply) {
                if (this.replies.isEmpty()) {
                    Debug.trace("Messages", this.name + "No replies queued, waitForReply=" + this.waitForReply);
                    try {
                        Debug.trace("Messages", this.name + "Wait for a reply");
                        this.replies.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.waitForReply) break;
                    continue;
                }
                msg = this.replies.remove(0);
                if ((this.complete || !this.acceptReplies) && this.replies.isEmpty()) {
                    this.conn.removeMessage(this);
                    Debug.trace("Messages", this.name + "Last message removed, remove msg from Connection");
                } else {
                    Debug.trace("Messages", this.name + "Got reply from queue(" + this.replies.size() + " remaining in queue)");
                }
                return msg;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getReply() {
        Object msg;
        if (this.replies == null) {
            return null;
        }
        MessageVector messageVector = this.replies;
        synchronized (messageVector) {
            if (this.replies.isEmpty()) {
                Debug.trace("Messages", this.name + "No replies queued for message");
                return null;
            }
            msg = this.replies.remove(0);
        }
        Debug.trace("Messages", this.name + "Got reply from queue(" + this.replies.size() + " remaining in queue)");
        if (this.conn != null && (this.complete || !this.acceptReplies) && this.replies.isEmpty()) {
            this.conn.removeMessage(this);
        }
        return msg;
    }

    void abandon(LDAPConstraints cons, InterThreadException informUserEx) {
        if (!this.waitForReply) {
            Debug.trace("Messages", this.name + "Abandon request ignored");
            return;
        }
        Debug.trace("Messages", this.name + "Abandon request, complete=" + this.complete + ", bind=" + (this.bindprops != null) + ", informUser=" + (informUserEx != null) + ", waitForReply=" + this.waitForReply);
        this.acceptReplies = false;
        this.waitForReply = false;
        if (!this.complete) {
            try {
                if (this.bindprops != null) {
                    int id;
                    if (this.conn.isBindSemIdClear()) {
                        id = this.msgId;
                    } else {
                        id = this.conn.getBindSemId();
                        this.conn.clearBindSemId();
                    }
                    this.conn.freeWriteSemaphore(id);
                }
                Debug.trace("Messages", this.name + "Sending abandon request");
                LDAPControl[] cont = null;
                if (cons != null) {
                    cont = cons.getControls();
                }
                LDAPAbandonRequest msg = new LDAPAbandonRequest(this.msgId, cont);
                this.conn.writeMessage(msg);
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            if (informUserEx == null) {
                this.agent.abandon(this.msgId, null);
            }
            this.conn.removeMessage(this);
        }
        if (informUserEx != null) {
            this.replies.addElement(new LDAPResponse(informUserEx, this.conn.getActiveReferral()));
            Debug.trace("Messages", this.name + "Queued exception as LDAPResponse (" + this.replies.size() + " in queue):" + " following referral=" + (this.conn.getActiveReferral() != null) + "\n\texception: " + informUserEx.getLDAPErrorMessage());
            this.stopTimer();
            this.sleepersAwake();
        } else {
            this.sleepersAwake();
            this.cleanup();
        }
    }

    private void cleanup() {
        Debug.trace("Messages", this.name + "cleanup");
        this.stopTimer();
        try {
            this.acceptReplies = false;
            if (this.conn != null) {
                this.conn.removeMessage(this);
            }
            if (this.replies != null) {
                if (!this.replies.isEmpty()) {
                    Debug.trace("Messages", this.name + "cleanup: remove " + this.replies.size() + " replies");
                }
                while (!this.replies.isEmpty()) {
                    this.replies.remove(0);
                }
            }
        }
        catch (Throwable ex) {
            Debug.trace("Messages", this.name + "cleanup exception:" + ex.toString());
        }
        this.conn = null;
        this.msg = null;
        this.queue = null;
        this.bindprops = null;
    }

    final boolean isBindRequest() {
        return this.bindprops != null;
    }

    protected final void finalize() throws Throwable {
        Debug.trace("Messages", this.name + "finalize");
        super.finalize();
        this.cleanup();
    }

    private final class Timeout
    extends Thread {
        private int timeToWait = 0;
        private Message message;

        Timeout(int interval, Message msg) {
            this.timeToWait = interval;
            this.message = msg;
        }

        public final void run() {
            try {
                Debug.trace("Messages", this.message.name + "client timer started, " + this.timeToWait + " milliseconds");
                Timeout.sleep(this.timeToWait);
                this.message.acceptReplies = false;
                Debug.trace("Messages", this.message.name + "client timed out");
                this.message.abandon(null, new InterThreadException("Client request timed out", null, 85, null, this.message));
            }
            catch (InterruptedException ie) {
                Debug.trace("Messages", this.message.name + "timer stopped");
            }
        }
    }
}

