/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.asn1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ASN1Identifier
implements Cloneable,
Serializable {
    public static final int UNIVERSAL = 0;
    public static final int APPLICATION = 1;
    public static final int CONTEXT = 2;
    public static final int PRIVATE = 3;
    private int tagClass;
    private boolean constructed;
    private int tag;
    private int encodedLength;

    public ASN1Identifier(int tagClass, boolean constructed, int tag) {
        this.tagClass = tagClass;
        this.constructed = constructed;
        this.tag = tag;
    }

    public ASN1Identifier(InputStream in) throws IOException {
        int r = in.read();
        ++this.encodedLength;
        if (r < 0) {
            throw new EOFException("BERDecoder: decode: EOF in Identifier");
        }
        this.tagClass = r >> 6;
        this.constructed = (r & 0x20) != 0;
        this.tag = r & 0x1F;
        if (this.tag == 31) {
            this.tag = this.decodeTagNumber(in);
        }
    }

    public ASN1Identifier() {
    }

    public final void reset(InputStream in) throws IOException {
        this.encodedLength = 0;
        int r = in.read();
        ++this.encodedLength;
        if (r < 0) {
            throw new EOFException("BERDecoder: decode: EOF in Identifier");
        }
        this.tagClass = r >> 6;
        this.constructed = (r & 0x20) != 0;
        this.tag = r & 0x1F;
        if (this.tag == 31) {
            this.tag = this.decodeTagNumber(in);
        }
    }

    private int decodeTagNumber(InputStream in) throws IOException {
        int r;
        int n = 0;
        do {
            r = in.read();
            ++this.encodedLength;
            if (r < 0) {
                throw new EOFException("BERDecoder: decode: EOF in tag number");
            }
            n = (n << 7) + (r & 0x7F);
        } while ((r & 0x80) != 0);
        return n;
    }

    public final int getASN1Class() {
        return this.tagClass;
    }

    public final boolean getConstructed() {
        return this.constructed;
    }

    public final int getTag() {
        return this.tag;
    }

    public final int getEncodedLength() {
        return this.encodedLength;
    }

    public final boolean isUniversal() {
        return this.tagClass == 0;
    }

    public final boolean isApplication() {
        return this.tagClass == 1;
    }

    public final boolean isContext() {
        return this.tagClass == 2;
    }

    public final boolean isPrivate() {
        return this.tagClass == 3;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ce) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    private void writeObject(ObjectOutputStream objectOStrm) throws IOException {
        objectOStrm.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectIStrm) throws IOException, ClassNotFoundException {
        objectIStrm.defaultReadObject();
    }
}

