/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.connectionpool;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.LDAPTLSSocketFactory;
import com.novell.ldap.connectionpool.Connection;
import com.novell.ldap.connectionpool.ListOfSharedConnections;
import com.novell.ldap.connectionpool.SharedConnections;

public class PoolManager {
    private ListOfSharedConnections inUseListOfSharedConnections = new ListOfSharedConnections();
    private ListOfSharedConnections availableListOfSharedConnections = new ListOfSharedConnections();
    private boolean shuttingDown;

    public PoolManager(String host, int port, int maxConns, int maxSharedConns, LDAPSocketFactory factory) throws LDAPException {
        for (int i = 0; i < maxConns; ++i) {
            SharedConnections sharedConns = new SharedConnections(maxSharedConns);
            Connection conn = new Connection(factory);
            conn.connect(host, port);
            if (factory instanceof LDAPTLSSocketFactory) {
                conn.startTLS();
            }
            sharedConns.add(conn);
            for (int j = 1; j < maxSharedConns; ++j) {
                Connection cloneConn = (Connection)conn.clone();
                sharedConns.add(cloneConn);
            }
            this.availableListOfSharedConnections.add(i, sharedConns);
        }
        this.shuttingDown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConnection getBoundConnection(String DN2, byte[] PW) throws LDAPException, InterruptedException {
        Connection conn = null;
        SharedConnections sharedConns = null;
        boolean needToBind = false;
        ListOfSharedConnections listOfSharedConnections = this.inUseListOfSharedConnections;
        synchronized (listOfSharedConnections) {
            conn = this.inUseListOfSharedConnections.getAvailableConnection(DN2, PW);
            if (null != conn) {
                conn.setInUse();
                return conn;
            }
        }
        listOfSharedConnections = this.availableListOfSharedConnections;
        synchronized (listOfSharedConnections) {
            sharedConns = this.availableListOfSharedConnections.getSharedConns(DN2, PW);
            if (null == sharedConns) {
                if (0 == this.availableListOfSharedConnections.size()) {
                    this.availableListOfSharedConnections.wait();
                    if (this.shuttingDown) {
                        return null;
                    }
                }
                sharedConns = (SharedConnections)this.availableListOfSharedConnections.get(0);
                needToBind = true;
            }
            this.availableListOfSharedConnections.remove(sharedConns);
            conn = (Connection)sharedConns.get(0);
            conn.setInUse();
        }
        if (needToBind) {
            try {
                conn.poolBind(3, DN2, PW);
                sharedConns.setDN(DN2);
                sharedConns.setPW(PW);
            }
            catch (LDAPException e) {
                conn.clearInUse();
                sharedConns.setDN(null);
                sharedConns.setPW(null);
                ListOfSharedConnections listOfSharedConnections2 = this.availableListOfSharedConnections;
                synchronized (listOfSharedConnections2) {
                    this.availableListOfSharedConnections.add(sharedConns);
                }
                throw e;
            }
        }
        listOfSharedConnections = this.inUseListOfSharedConnections;
        synchronized (listOfSharedConnections) {
            this.inUseListOfSharedConnections.add(sharedConns);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeConnectionAvailable(LDAPConnection conn) {
        SharedConnections sharedConns = null;
        ListOfSharedConnections listOfSharedConnections = this.inUseListOfSharedConnections;
        synchronized (listOfSharedConnections) {
            ((Connection)conn).clearInUse();
            sharedConns = this.inUseListOfSharedConnections.getSharedConns((Connection)conn);
            if (sharedConns.allConnectionsAvailable()) {
                this.inUseListOfSharedConnections.remove(sharedConns);
            } else {
                sharedConns = null;
            }
        }
        if (null != sharedConns) {
            listOfSharedConnections = this.availableListOfSharedConnections;
            synchronized (listOfSharedConnections) {
                this.availableListOfSharedConnections.add(sharedConns);
                this.availableListOfSharedConnections.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        ListOfSharedConnections listOfSharedConnections = this.availableListOfSharedConnections;
        synchronized (listOfSharedConnections) {
            this.shuttingDown = true;
            this.availableListOfSharedConnections.notifyAll();
        }
    }
}

