/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.LDAPAddRequest;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPCompareRequest;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedRequest;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPModifyRequest;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchRequest;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.LDAPSearchResultReference;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.DOMWriter;
import com.novell.ldap.util.LDAPWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;

public class DSMLWriter
implements LDAPWriter {
    private static boolean fswitch = true;
    private Writer out = null;
    private int state = 0;
    private static final int NEW_BATCH = 0;
    private static final int REQUEST_BATCH = 1;
    private static final int RESPONSE_BATCH = 2;
    private static final int SEARCH_TAG = 3;
    private boolean indent = false;
    private String tabString = "    ";
    private String version = "2.0";
    private boolean resumeOnError;
    private static final String BATCH_REQUEST_START = "<batchRequest xmlns=\"urn:oasis:names:tc:DSML:2:0:core\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" onError=\"";
    private static final String BATCH_RESPONSE_START = "<batchResponse xmlns=\"urn:oasis:names:tc:DSML:2:0:core\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";

    public void setResumeOnError(boolean resumeOnError) {
        this.resumeOnError = resumeOnError;
    }

    public DSMLWriter(String file) throws FileNotFoundException {
        this(new FileOutputStream(file, true));
    }

    public DSMLWriter(OutputStream stream) {
        try {
            this.out = new OutputStreamWriter(stream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not supported by JVM" + e.toString());
        }
    }

    public DSMLWriter(Writer writer) {
        this.out = writer;
    }

    public void writeError(Exception e) throws IOException {
        try {
            this.checkState(true);
        }
        catch (LDAPLocalException lle) {
            throw new IOException(lle.toString());
        }
        this.newLine(1);
        this.out.write("<errorResponse type=\"");
        if (e instanceof LDAPException) {
            switch (((LDAPException)e).getResultCode()) {
                case 2: 
                case 84: {
                    this.out.write("malformedRequest\">");
                    break;
                }
                case 82: {
                    this.out.write("gatewayInternalError\">");
                    break;
                }
                case 49: {
                    this.out.write("authenticationFailed\">");
                    break;
                }
                default: {
                    this.out.write("other\">");
                    break;
                }
            }
        } else {
            this.out.write("other\">");
        }
        this.newLine(2);
        this.out.write("<message>");
        this.newLine(3);
        if (e instanceof LDAPException) {
            LDAPException le = (LDAPException)e;
            String msg = Integer.toString(le.getResultCode()) + ":" + le.getMessage();
            this.out.write(this.makeXMLSafe(msg));
        } else {
            this.out.write(this.makeXMLSafe(e.getMessage()));
        }
        this.newLine(2);
        this.out.write("</message>");
        this.newLine(1);
        this.out.write("</errorResponse>");
    }

    public void finish() throws IOException {
        this.newLine(0);
        switch (this.state) {
            case 1: {
                this.out.write("</batchRequest>");
                break;
            }
            case 2: {
                this.out.write("</batchResponse>");
                break;
            }
            case 3: {
                if (this.indent) {
                    this.out.write(this.tabString);
                }
                this.out.write("</searchResponse>");
                this.newLine(0);
                this.out.write("</batchResponse>");
                break;
            }
            case 0: {
                this.out.write("<batchResponse>");
                this.newLine(0);
                this.out.write("</batchResponse>");
            }
        }
        this.newLine(0);
        this.out.flush();
    }

    public void writeComments(String lines) throws IOException {
        this.newLine(1);
        this.out.write("<!-- ");
        this.out.write(lines);
        this.out.write(" -->");
    }

    public void writeMessage(LDAPMessage messageToWrite) throws IOException, LDAPLocalException {
        if (messageToWrite instanceof LDAPResponse || messageToWrite instanceof LDAPSearchResult || messageToWrite instanceof LDAPSearchResultReference) {
            this.checkState(true);
        } else {
            this.checkState(false);
        }
        switch (messageToWrite.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 16: {
                throw new UnsupportedOperationException("Writing of this message is not supported");
            }
            case 3: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("searchRequest", messageToWrite);
                    this.state = 1;
                }
                this.writeSearchRequest((LDAPSearchRequest)messageToWrite);
                break;
            }
            case 23: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("extendedRequest", messageToWrite);
                    this.state = 1;
                }
                this.writeExtendedRequest((LDAPExtendedRequest)messageToWrite);
                break;
            }
            case 14: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("compareRequest", messageToWrite);
                    this.state = 1;
                }
                this.writeCompareRequest((LDAPCompareRequest)messageToWrite);
                break;
            }
            case 8: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("addRequest", messageToWrite);
                    this.state = 1;
                }
                this.writeAddRequest((LDAPAddRequest)messageToWrite);
                break;
            }
            case 6: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("modifyRequest", messageToWrite);
                    this.state = 1;
                }
                this.writeModifyRequest((LDAPModifyRequest)messageToWrite);
                break;
            }
            case 12: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("modDNRequest", messageToWrite);
                    this.state = 1;
                }
                this.writeModifyDNRequest((LDAPModifyDNRequest)messageToWrite);
                break;
            }
            case 10: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("delRequest", messageToWrite);
                    this.state = 1;
                }
                this.writeDeleteRequest((LDAPDeleteRequest)messageToWrite);
                break;
            }
            case 4: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("searchResponse", messageToWrite);
                    this.state = 3;
                }
                this.writeSearchResponse((LDAPSearchResult)messageToWrite);
                break;
            }
            case 19: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("searchResponse", messageToWrite);
                    this.state = 3;
                }
                this.writeSearchResultReference((LDAPSearchResultReference)messageToWrite);
                break;
            }
            case 5: {
                if (this.state != 3) {
                    this.newLine(1);
                    this.writeTagWithID("searchResponse", messageToWrite);
                }
                this.newLine(2);
                this.writeTagWithID("searchResultDone", messageToWrite);
                this.writeResult((LDAPResponse)messageToWrite, 3);
                this.newLine(2);
                this.out.write("</searchResultDone>");
                this.newLine(1);
                this.out.write("</searchResponse>");
                this.state = 2;
                break;
            }
            case 7: {
                this.newLine(1);
                this.writeTagWithID("modifyResponse", messageToWrite);
                this.writeResult((LDAPResponse)messageToWrite, 2);
                this.newLine(1);
                this.out.write("</modifyResponse>");
                break;
            }
            case 9: {
                this.newLine(1);
                this.writeTagWithID("addResponse", messageToWrite);
                this.writeResult((LDAPResponse)messageToWrite, 2);
                this.newLine(1);
                this.out.write("</addResponse>");
                break;
            }
            case 11: {
                this.newLine(1);
                this.writeTagWithID("delResponse", messageToWrite);
                this.writeResult((LDAPResponse)messageToWrite, 2);
                this.newLine(1);
                this.out.write("</delResponse>");
                break;
            }
            case 13: {
                this.newLine(1);
                this.writeTagWithID("modDNResponse", messageToWrite);
                this.writeResult((LDAPResponse)messageToWrite, 2);
                this.newLine(1);
                this.out.write("</modDNResponse>");
                break;
            }
            case 15: {
                this.newLine(1);
                this.writeTagWithID("compareResponse", messageToWrite);
                this.writeResult((LDAPResponse)messageToWrite, 2);
                this.newLine(1);
                this.out.write("</compareResponse>");
                break;
            }
            case 24: {
                this.newLine(1);
                LDAPExtendedResponse xResp = (LDAPExtendedResponse)messageToWrite;
                this.writeTagWithID("extendedResponse", messageToWrite);
                this.writeResult((LDAPResponse)messageToWrite, 2);
                this.newLine(2);
                this.out.write("<responseName>");
                this.out.write(xResp.getID());
                this.out.write("</responseName>");
                byte[] value = xResp.getValue();
                if (value != null) {
                    this.newLine(2);
                    this.out.write("<response xsi:type=\"xsd:base64Binary\">");
                    this.out.write(Base64.encode(value));
                    this.out.write("</response>");
                }
                this.newLine(1);
                this.out.write("</extendedResponse>");
            }
        }
    }

    public void writeEntry(LDAPEntry entry) throws IOException, LDAPLocalException {
        this.checkState(true);
        this.writeEntry(entry, null, null);
    }

    public void writeEntry(LDAPEntry entry, LDAPControl[] controls) throws IOException, LDAPLocalException {
        this.checkState(true);
        this.writeEntry(entry, controls, null);
    }

    public void writeEntry(LDAPEntry entry, LDAPControl[] controls, String requestID) throws IOException, LDAPLocalException {
        this.checkState(true);
        this.newLine(2);
        this.out.write("<searchResultEntry dn=\"");
        this.out.write(this.makeAttributeSafe(entry.getDN()));
        if (requestID != null) {
            this.out.write("\" requestID=\"" + requestID);
        }
        this.out.write("\">");
        LDAPAttributeSet set = entry.getAttributeSet();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            this.writeAttribute((LDAPAttribute)i.next());
        }
        if (controls != null && controls.length != 0) {
            this.writeControls(controls, 3);
        }
        this.newLine(2);
        this.out.write("</searchResultEntry>");
    }

    private static String byteString(byte[] value) {
        String toReturn = null;
        if (Base64.isValidUTF8(value, true)) {
            try {
                toReturn = new String(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Default JVM does not support UTF-8 encoding" + e);
            }
        } else {
            StringBuffer binary = new StringBuffer();
            for (int i = 0; i < value.length; ++i) {
                if (value[i] >= 0) {
                    binary.append("\\0");
                    binary.append(Integer.toHexString(value[i]));
                    continue;
                }
                binary.append("\\" + Integer.toHexString(value[i]).substring(6));
            }
            toReturn = binary.toString();
        }
        return toReturn;
    }

    private void writeFilter(Iterator itr) throws IOException, LDAPLocalException {
        int op = -1;
        while (itr.hasNext()) {
            Object filterpart = itr.next();
            if (filterpart instanceof Integer) {
                op = (Integer)filterpart;
                switch (op) {
                    case 0: {
                        this.newLine(3);
                        this.out.write("<and>");
                        break;
                    }
                    case 1: {
                        this.newLine(3);
                        this.out.write("<or>");
                        break;
                    }
                    case 2: {
                        this.newLine(3);
                        this.out.write("<not>");
                        break;
                    }
                    case 3: {
                        this.newLine(4);
                        this.out.write("<equalityMatch name=\"");
                        this.out.write((String)itr.next());
                        this.out.write("\">");
                        byte[] value = (byte[])itr.next();
                        this.newLine(5);
                        this.out.write("<value>");
                        this.out.write(DSMLWriter.byteString(value));
                        this.out.write("</value>");
                        this.newLine(4);
                        this.out.write("</equalityMatch>");
                        break;
                    }
                    case 5: {
                        this.newLine(4);
                        this.out.write("<greaterOrEqual name=\"");
                        this.out.write((String)itr.next());
                        this.out.write("\">");
                        byte[] value = (byte[])itr.next();
                        this.newLine(5);
                        this.out.write("<value>");
                        this.out.write(DSMLWriter.byteString(value));
                        this.out.write("</value>");
                        this.newLine(4);
                        this.out.write("</greaterOrEqual>");
                        break;
                    }
                    case 6: {
                        this.newLine(4);
                        this.out.write("<lessOrEqual name=\"");
                        this.out.write((String)itr.next());
                        this.out.write("\">");
                        byte[] value = (byte[])itr.next();
                        this.newLine(5);
                        this.out.write("<value>");
                        this.out.write(DSMLWriter.byteString(value));
                        this.out.write("</value>");
                        this.newLine(4);
                        this.out.write("</lessOrEqual>");
                        break;
                    }
                    case 7: {
                        this.newLine(4);
                        this.out.write("<present name=\"");
                        this.out.write((String)itr.next());
                        this.out.write("\">");
                        this.newLine(4);
                        this.out.write("</present>");
                        break;
                    }
                    case 8: {
                        this.newLine(4);
                        this.out.write("<approxMatch name=\"");
                        this.out.write((String)itr.next());
                        this.out.write("\">");
                        byte[] value = (byte[])itr.next();
                        this.newLine(5);
                        this.out.write("<value>");
                        this.out.write(DSMLWriter.byteString(value));
                        this.out.write("</value>");
                        this.newLine(4);
                        this.out.write("</approxMatch>");
                        break;
                    }
                    case 4: {
                        this.newLine(4);
                        this.out.write("<substrings name=\"");
                        this.out.write((String)itr.next());
                        this.out.write("\">");
                        boolean noStarLast = false;
                        while (itr.hasNext()) {
                            op = (Integer)itr.next();
                            switch (op) {
                                case 0: {
                                    this.newLine(5);
                                    this.out.write("<initial>");
                                    this.out.write((String)itr.next());
                                    this.out.write("</initial>");
                                    noStarLast = false;
                                    break;
                                }
                                case 1: {
                                    this.newLine(5);
                                    this.out.write("<any>");
                                    this.out.write((String)itr.next());
                                    this.out.write("</any>");
                                    noStarLast = false;
                                    break;
                                }
                                case 2: {
                                    this.newLine(5);
                                    this.out.write("<final>");
                                    this.out.write((String)itr.next());
                                    this.out.write("</final>");
                                }
                            }
                        }
                        this.newLine(4);
                        this.out.write("</substrings>");
                        break;
                    }
                }
                continue;
            }
            if (!(filterpart instanceof Iterator)) continue;
            this.writeFilter((Iterator)filterpart);
            switch (op) {
                case 0: {
                    if (fswitch) {
                        fswitch = false;
                        break;
                    }
                    this.newLine(3);
                    this.out.write("</and>");
                    fswitch = true;
                    break;
                }
                case 1: {
                    if (fswitch) {
                        fswitch = false;
                        break;
                    }
                    this.newLine(3);
                    this.out.write("</or>");
                    fswitch = true;
                    break;
                }
                case 2: {
                    this.newLine(3);
                    this.out.write("</not>");
                    break;
                }
            }
        }
    }

    private void writeModifyDNRequestEntry(LDAPModifyDNRequest request, LDAPControl[] controls, String requestID) throws IOException, LDAPLocalException {
        this.checkState(false);
        if (controls != null && controls.length != 0) {
            this.writeControls(controls, 3);
        }
        this.newLine(1);
        this.out.write("</modDNRequest>");
    }

    private void writeModifyRequestEntry(LDAPModifyRequest request, LDAPControl[] controls, String requestID) throws IOException, LDAPLocalException {
        this.checkState(false);
        LDAPModification[] modList = request.getModifications();
        for (int i = 0; i < modList.length; ++i) {
            LDAPAttribute attr = modList[i].getAttribute();
            this.newLine(2);
            this.out.write("<modification name=\"");
            this.out.write(attr.getName());
            this.out.write("\" operation=\"");
            switch (modList[i].getOp()) {
                case 0: {
                    this.out.write("add");
                    break;
                }
                case 1: {
                    this.out.write("delete");
                    break;
                }
                case 2: {
                    this.out.write("replace");
                }
            }
            this.out.write("\">");
            String[] values = attr.getStringValueArray();
            byte[][] bytevalues = attr.getByteValueArray();
            for (int j = 0; j < values.length; ++j) {
                this.newLine(3);
                if (Base64.isValidUTF8(bytevalues[j], false)) {
                    this.out.write("<value>");
                    this.out.write(values[j]);
                    this.out.write("</value>");
                    continue;
                }
                this.out.write("<value xsi:type=\"xsd:base64Binary\">");
                this.out.write(Base64.encode(bytevalues[j]));
                this.out.write("</value>");
            }
            this.newLine(2);
            this.out.write("</modification>");
        }
        if (controls != null && controls.length != 0) {
            this.writeControls(controls, 3);
        }
        this.newLine(1);
        this.out.write("</modifyRequest>");
    }

    private void writeDeleteRequestEntry(LDAPDeleteRequest request, LDAPControl[] controls, String requestID) throws IOException, LDAPLocalException {
        this.checkState(false);
        if (controls != null && controls.length != 0) {
            this.writeControls(controls, 3);
        }
        this.newLine(1);
        this.out.write("</delRequest>");
    }

    private void writeExtendedRequestEntry(LDAPExtendedRequest request, LDAPControl[] controls, String requestID) throws IOException, LDAPLocalException {
        this.checkState(false);
        this.newLine(2);
        this.out.write("<requestName>");
        this.out.write(request.getExtendedOperation().getID());
        this.out.write("</requestName>");
        byte[] vals = request.getExtendedOperation().getValue();
        if (vals != null) {
            this.newLine(2);
            this.out.write("<requestValue xsi:type=\"xsd:base64Binary\">");
            this.out.write(Base64.encode(vals));
            this.out.write("</requestValue>");
        }
        if (controls != null && controls.length != 0) {
            this.writeControls(controls, 3);
        }
        this.newLine(1);
        this.out.write("</extendedRequest>");
    }

    private void writeCompareRequestEntry(LDAPCompareRequest request, LDAPControl[] controls, String requestID) throws IOException, LDAPLocalException {
        this.checkState(false);
        this.newLine(2);
        this.out.write("<assertion name=\"" + request.getAttributeDescription());
        this.out.write("\">");
        this.newLine(3);
        this.out.write("<value>");
        byte[] vals = request.getAssertionValue();
        if (Base64.isLDIFSafe(vals)) {
            this.out.write(new String(vals, "UTF-8"));
        } else {
            this.out.write(Base64.encode(vals));
        }
        this.out.write("</value>");
        this.newLine(2);
        this.out.write("</assertion>");
        if (controls != null && controls.length != 0) {
            this.writeControls(controls, 3);
        }
        this.newLine(1);
        this.out.write("</compareRequest>");
    }

    private void writeAddRequestEntry(LDAPAddRequest request, LDAPControl[] controls, String requestID) throws IOException, LDAPLocalException {
        this.checkState(false);
        LDAPEntry entry = request.getEntry();
        LDAPAttributeSet set = entry.getAttributeSet();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            this.writeAttribute((LDAPAttribute)i.next());
        }
        if (controls != null && controls.length != 0) {
            this.writeControls(controls, 3);
        }
        this.newLine(1);
        this.out.write("</addRequest>");
    }

    private void writeSearchRequestEntry(LDAPSearchRequest request, LDAPControl[] controls, String requestID) throws IOException, LDAPLocalException {
        this.checkState(false);
        this.newLine(2);
        this.out.write("<attributes>");
        String[] attrs = request.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            this.newLine(3);
            this.out.write("<attribute name=\"");
            this.out.write(attrs[i]);
            this.out.write("\"/>");
        }
        this.newLine(2);
        this.out.write("</attributes>");
        this.newLine(2);
        this.out.write("<filter>");
        Iterator itr = request.getSearchFilter();
        this.writeFilter(itr);
        this.newLine(2);
        this.out.write("</filter>");
        if (controls != null && controls.length != 0) {
            this.writeControls(controls, 3);
        }
        this.newLine(1);
        this.out.write("</searchRequest>");
    }

    private void writeTagWithID(String tag, LDAPMessage message) throws IOException {
        String dn;
        String matchedDN;
        this.out.write("<" + tag + " requestID=\"" + DOMWriter.findRequestID(message) + "\"");
        if (message instanceof LDAPResponse && (matchedDN = ((LDAPResponse)message).getMatchedDN()) != null && !matchedDN.equals("")) {
            this.out.write(" matchedDN=\"" + this.makeAttributeSafe(matchedDN) + "\"");
        }
        if (message instanceof LDAPCompareRequest) {
            dn = ((LDAPCompareRequest)message).getDN();
            this.out.write(" dn=\"" + this.makeAttributeSafe(dn) + "\"");
        }
        if (message instanceof LDAPExtendedRequest) {
            // empty if block
        }
        if (message instanceof LDAPDeleteRequest) {
            dn = ((LDAPDeleteRequest)message).getDN();
            this.out.write(" dn=\"" + this.makeAttributeSafe(dn) + "\"");
        }
        if (message instanceof LDAPAddRequest) {
            dn = ((LDAPAddRequest)message).getEntry().getDN();
            this.out.write(" dn=\"" + this.makeAttributeSafe(dn) + "\"");
        }
        if (message instanceof LDAPModifyRequest) {
            dn = ((LDAPModifyRequest)message).getDN();
            this.out.write(" dn=\"" + this.makeAttributeSafe(dn) + "\"");
        }
        if (message instanceof LDAPModifyDNRequest) {
            dn = ((LDAPModifyDNRequest)message).getDN();
            this.out.write(" dn=\"" + this.makeAttributeSafe(dn) + "\"");
            this.out.write(" newrdn=\"");
            this.out.write(((LDAPModifyDNRequest)message).getNewRDN() + "\" deleteoldrdn=\"");
            this.out.write(((LDAPModifyDNRequest)message).getDeleteOldRDN() + "\" newSuperior=\"");
            this.out.write(((LDAPModifyDNRequest)message).getParentDN() + "\"");
        }
        if (message instanceof LDAPSearchRequest) {
            String searchScope = "";
            String searchDeRef = "";
            String dn2 = ((LDAPSearchRequest)message).getDN();
            int scope = ((LDAPSearchRequest)message).getScope();
            int deref = ((LDAPSearchRequest)message).getDereference();
            int slimit = ((LDAPSearchRequest)message).getMaxResults();
            int tlimit = ((LDAPSearchRequest)message).getServerTimeLimit();
            boolean isTypesonly = ((LDAPSearchRequest)message).isTypesOnly();
            this.out.write(" dn=\"" + this.makeAttributeSafe(dn2) + "\"");
            switch (scope) {
                case 0: {
                    searchScope = "baseObject";
                    break;
                }
                case 1: {
                    searchScope = "singleLevel";
                    break;
                }
                default: {
                    searchScope = "wholeSubtree";
                }
            }
            this.out.write(" scope=\"" + searchScope + "\"");
            switch (deref) {
                case 1: {
                    searchDeRef = "derefInSearching";
                    break;
                }
                case 2: {
                    searchDeRef = "derefFindingBaseObj";
                    break;
                }
                case 3: {
                    searchDeRef = "derefAlways";
                    break;
                }
                default: {
                    searchDeRef = "neverDerefAliases";
                }
            }
            this.out.write(" derefAliases=\"" + searchDeRef + "\"");
            this.out.write(" sizeLimit=\"" + slimit + "\"");
            this.out.write(" timeLimit=\"" + tlimit + "\"");
            this.out.write(" typesOnly=\"" + isTypesonly + "\"");
        }
        this.out.write(">");
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isRequest() {
        return true;
    }

    private void writeResult(LDAPResponse result, int indent) throws IOException {
        String[] referrals;
        LDAPControl[] controls = result.getControls();
        if (controls != null) {
            this.writeControls(controls, indent);
        }
        if ((referrals = result.getReferrals()) != null) {
            for (int i = 0; i < referrals.length; ++i) {
                this.newLine(indent);
                this.out.write("<referral>" + referrals[i] + "</referral>");
            }
        }
        this.newLine(indent);
        this.out.write("<resultCode code=\"");
        this.out.write(new Integer(result.getResultCode()).toString());
        this.out.write("\" descr=\"");
        this.out.write(LDAPException.resultCodeToString(result.getResultCode()));
        this.out.write("\" />");
        String temp = result.getErrorMessage();
        if (temp != null && temp.length() > 0) {
            this.newLine(indent);
            this.out.write("<errorMessage>");
            this.out.write(this.makeXMLSafe(temp));
            this.out.write("</errorMessage>");
        }
    }

    private void writeControls(LDAPControl[] controls, int indent) throws IOException {
        for (int i = 0; i < controls.length; ++i) {
            this.newLine(indent);
            this.out.write("<control type=\"");
            this.out.write(controls[i].getID());
            this.out.write("\" criticality=\"" + controls[i].isCritical() + "\"");
            byte[] value = controls[i].getValue();
            if (value == null) {
                this.out.write(" / >");
                continue;
            }
            this.out.write(">");
            this.newLine(indent + 1);
            this.out.write("<controlValue xsi:type=\"xsd:base64Binary\">");
            this.out.write(Base64.encode(value));
            this.out.write("</controlValue>");
            this.newLine(indent);
            this.out.write("</control>");
        }
    }

    private void writeSearchResultReference(LDAPSearchResultReference ref) throws IOException {
        String[] refs = ref.getReferrals();
        this.newLine(2);
        this.writeTagWithID("searchResultReference", ref);
        for (int i = 0; i < refs.length; ++i) {
            this.newLine(3);
            this.out.write("<ref>");
            this.out.write(refs[i]);
            this.out.write("</ref>");
        }
        this.newLine(2);
        this.out.write("</searchResultReference>");
    }

    private void writeSearchResponse(LDAPSearchResult result) throws IOException, LDAPLocalException {
        this.writeEntry(result.getEntry(), result.getControls(), DOMWriter.findRequestID(result));
    }

    private void writeSearchRequest(LDAPSearchRequest request) throws IOException, LDAPLocalException {
        this.writeSearchRequestEntry(request, request.getControls(), DOMWriter.findRequestID(request));
    }

    private void writeAddRequest(LDAPAddRequest request) throws IOException, LDAPLocalException {
        this.writeAddRequestEntry(request, request.getControls(), DOMWriter.findRequestID(request));
    }

    private void writeCompareRequest(LDAPCompareRequest request) throws IOException, LDAPLocalException {
        this.writeCompareRequestEntry(request, request.getControls(), DOMWriter.findRequestID(request));
    }

    private void writeModifyRequest(LDAPModifyRequest request) throws IOException, LDAPLocalException {
        this.writeModifyRequestEntry(request, request.getControls(), DOMWriter.findRequestID(request));
    }

    private void writeModifyDNRequest(LDAPModifyDNRequest request) throws IOException, LDAPLocalException {
        this.writeModifyDNRequestEntry(request, request.getControls(), DOMWriter.findRequestID(request));
    }

    private void writeDeleteRequest(LDAPDeleteRequest request) throws IOException, LDAPLocalException {
        this.writeDeleteRequestEntry(request, request.getControls(), DOMWriter.findRequestID(request));
    }

    private void writeExtendedRequest(LDAPExtendedRequest request) throws IOException, LDAPLocalException {
        this.writeExtendedRequestEntry(request, request.getControls(), DOMWriter.findRequestID(request));
    }

    private void writeAttribute(LDAPAttribute attr) throws IOException {
        this.newLine(3);
        this.out.write("<attr name=\"");
        this.out.write(attr.getName());
        this.out.write("\">");
        String[] values = attr.getStringValueArray();
        byte[][] bytevalues = attr.getByteValueArray();
        for (int i = 0; i < values.length; ++i) {
            this.newLine(4);
            if (Base64.isValidUTF8(bytevalues[i], true) && this.isXMLSafe(bytevalues[i])) {
                this.out.write("<value>");
                String xmlvalue = values[i];
                xmlvalue = xmlvalue.replaceAll("&", "&amp;");
                xmlvalue = xmlvalue.replaceAll("<", "&lt;");
                xmlvalue = xmlvalue.replaceAll(">", "&gt;");
                xmlvalue = xmlvalue.replaceAll("'", "&apos;");
                xmlvalue = xmlvalue.replaceAll("\"", "&quot;");
                this.out.write(xmlvalue);
                this.out.write("</value>");
                continue;
            }
            this.out.write("<value xsi:type=\"xsd:base64Binary\">");
            this.out.write(Base64.encode(bytevalues[i]));
            this.out.write("</value>");
        }
        this.newLine(3);
        this.out.write("</attr>");
    }

    private void checkState(boolean isResponse) throws IOException, LDAPLocalException {
        if (this.state == 0) {
            if (isResponse) {
                this.out.write(BATCH_RESPONSE_START);
                this.state = 2;
            } else {
                this.out.write(BATCH_REQUEST_START + (this.resumeOnError ? "resume" : "exit") + "\">");
                this.state = 1;
            }
        } else {
            if (this.state == 1 && isResponse) {
                throw new LDAPLocalException("Attempted insertion of a response message in a request batch", 83);
            }
            if (this.state == 2 && !isResponse) {
                throw new LDAPLocalException("Attempted insertion of a request message in a response batch", 83);
            }
        }
    }

    private void newLine(int indentTabs) throws IOException {
        if (!this.indent) {
            return;
        }
        this.out.write("\n");
        for (int i = 0; i < indentTabs; ++i) {
            this.out.write(this.tabString);
        }
    }

    public void useIndent(boolean useIndent) {
        this.indent = useIndent;
    }

    public void setIndent(int spaces) {
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < spaces; ++i) {
            temp.append(' ');
        }
        this.tabString = temp.toString();
    }

    private boolean isXMLSafe(byte[] val) {
        boolean safe = true;
        int m = val.length;
        for (int i = 0; i < m; ++i) {
            if (val[i] < 0 || val[i] > 31) continue;
            safe = false;
            break;
        }
        return safe;
    }

    private String makeXMLSafe(String msg) {
        if (msg == null) {
            return "";
        }
        byte[] val = msg.getBytes();
        boolean safe = true;
        int m = val.length;
        for (int i = 0; i < m; ++i) {
            if (val[i] < 0 || val[i] > 31) continue;
            val[i] = 32;
        }
        return new String(val);
    }

    private String makeAttributeSafe(String attrib) {
        String ret = attrib;
        ret = ret.replaceAll("&", "&amp;");
        ret = ret.replaceAll(">", "&gt;");
        ret = ret.replaceAll("'", "&apos;");
        ret = ret.replaceAll("\"", "&quot;");
        return ret;
    }
}

