/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sasl.client;

import com.novell.security.nmas.client.NMASClient;
import com.novell.security.nmas.transport.MAFTransportException;
import com.novell.security.nmas.transport.NMASTransport;
import com.novell.security.sasl.SaslClient;
import com.novell.security.sasl.SaslException;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;

class NMASSaslClient
implements SaslClient {
    private String m_authorizationId = "";
    private String m_protocol = "";
    private String m_serverName = "";
    private Map m_props;
    private CallbackHandler m_cbh;
    private int m_state;
    private NMASClient nmasClient = null;
    private NmasLdapTransport nmasTransport = null;
    private String loginSequence = null;
    private String dsDn;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_VALID_SERVER_RESPONSE = 1;
    private static final int STATE_INVALID_SERVER_RESPONSE = 2;
    private static final int STATE_DISPOSED = 3;
    private static final int NMAS_INVALID_CLIENT = 4;
    private static final int NMAS_INVALID_TRANSPORT = 5;

    public static SaslClient getClient(String authorizationId, String protocol, String serverName, Map props, CallbackHandler cbh) {
        return new NMASSaslClient(authorizationId, protocol, serverName, props, cbh);
    }

    private NMASSaslClient(String authorizationId, String protocol, String serverName, Map props, CallbackHandler cbh) {
        this.m_authorizationId = authorizationId;
        this.m_protocol = protocol;
        this.m_serverName = serverName;
        this.m_props = props;
        this.m_cbh = cbh;
        this.m_state = 0;
    }

    public String ldapToDSdn(String ldapDN) {
        StringBuffer dnSb = new StringBuffer(ldapDN);
        int index1 = dnSb.indexOf(".");
        while (index1 != -1) {
            dnSb.replace(index1, index1 + 1, "\\.");
            String userDN = dnSb.toString();
            index1 = dnSb.indexOf(".", index1 + 2);
        }
        StringBuffer dnSb2 = new StringBuffer();
        boolean first = true;
        index1 = dnSb.indexOf("=");
        while (index1 != -1) {
            int index2 = dnSb.indexOf(",", index1);
            if (!first) {
                dnSb2.append(".");
            }
            if (index2 != -1) {
                dnSb2.append(dnSb.substring(index1 + 1, index2));
                index1 = dnSb.indexOf("=", index2);
            } else {
                dnSb2.append(dnSb.substring(index1 + 1));
                index1 = -1;
            }
            first = false;
        }
        return dnSb2.toString();
    }

    public boolean hasInitialResponse() {
        CallbackHandler callbackHandler = this.m_cbh;
        this.loginSequence = (String)this.m_props.get("LoginSequence");
        String ldapFdn = this.m_authorizationId.trim();
        this.dsDn = this.ldapToDSdn(ldapFdn.substring(3));
        this.nmasTransport = new NmasLdapTransport();
        if (this.nmasTransport == null) {
            this.m_state = 5;
            return false;
        }
        try {
            this.nmasClient = new NMASClient((NMASTransport)this.nmasTransport, callbackHandler);
        }
        catch (MAFTransportException e) {
            this.m_state = 4;
            return false;
        }
        catch (IOException e) {
            this.m_state = 4;
            return false;
        }
        if (this.nmasClient == null) {
            this.m_state = 4;
            return false;
        }
        return true;
    }

    public void end() {
        this.nmasTransport.end();
    }

    public synchronized byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        System.out.println("");
        switch (this.nmasClient.getState()) {
            case 1: {
                this.nmasClient.startLogin(this.dsDn, this.loginSequence);
                break;
            }
            default: {
                this.nmasTransport.setServerResponse(challenge);
            }
        }
        if (this.nmasTransport.isTransportActive()) {
            return this.nmasTransport.getNmasRequest();
        }
        throw new SaslException();
    }

    public String getMechanismName() {
        return "NMAS_LOGIN";
    }

    public boolean isComplete() {
        return this.nmasClient.getState() == 3 || this.m_state == 4 || this.m_state == 5 || this.m_state == 3;
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new IllegalStateException("unwrap: QOP has neither integrity nor privacy>");
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new IllegalStateException("wrap: QOP has neither integrity nor privacy>");
    }

    public Object getNegotiatedProperty(String propName) {
        if (this.m_state != 1) {
            throw new IllegalStateException("getNegotiatedProperty: authentication exchange not complete.");
        }
        if ("com.novell.security.sasl.qop".equals(propName)) {
            return "auth";
        }
        return null;
    }

    public void dispose() throws SaslException {
        if (this.m_state != 3) {
            this.nmasTransport.kill();
            this.m_state = 3;
        }
    }

    class NmasLdapTransport
    extends NMASTransport {
        private byte[] nmasRequest = null;
        private byte[] serverResponse = null;
        private boolean nmasRequestReady = false;
        private boolean serverResponseReady = false;
        private boolean transportActive = true;
        private boolean transportStopped = false;

        public synchronized byte[] transport(byte[] toWrite, int replyLen) throws MAFTransportException {
            if (this.transportStopped) {
                throw new MAFTransportException(-1502);
            }
            this.setNmasRequest(toWrite);
            return this.getServerResponse();
        }

        public synchronized void setNmasRequest(byte[] request) {
            this.nmasRequest = request;
            this.nmasRequestReady = true;
            ((Object)((Object)this)).notifyAll();
        }

        public synchronized void setServerResponse(byte[] response) {
            this.serverResponse = response;
            this.serverResponseReady = true;
            ((Object)((Object)this)).notifyAll();
        }

        public synchronized byte[] getServerResponse() throws MAFTransportException {
            while (!this.serverResponseReady) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (Exception exception) {}
            }
            this.serverResponseReady = false;
            if (this.transportStopped) {
                throw new MAFTransportException(-1502);
            }
            return this.serverResponse;
        }

        public synchronized byte[] getNmasRequest() {
            while (!this.nmasRequestReady) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (Exception exception) {}
            }
            this.nmasRequestReady = false;
            return this.nmasRequest;
        }

        public synchronized void end() {
            int stopTime = 0;
            while (!this.transportStopped && stopTime < 30) {
                try {
                    ((Object)((Object)this)).wait(10L);
                    stopTime += 10;
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
            this.transportActive = false;
            this.clearAll();
        }

        public synchronized void kill() {
            this.transportStopped = true;
            this.clearAll();
        }

        public synchronized void clearAll() {
            this.nmasRequest = null;
            this.serverResponse = null;
            this.nmasRequestReady = true;
            this.serverResponseReady = true;
            ((Object)((Object)this)).notifyAll();
        }

        public synchronized boolean isTransportActive() {
            return this.transportActive;
        }
    }
}

