/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.ldap;

import org.ietf.ldap.LDAPAuthHandler;
import org.ietf.ldap.LDAPAuthProvider;
import org.ietf.ldap.LDAPBindHandler;
import org.ietf.ldap.LDAPConnection;
import org.ietf.ldap.LDAPControl;
import org.ietf.ldap.LDAPException;
import org.ietf.ldap.LDAPReferralException;
import org.ietf.ldap.LDAPReferralHandler;
import org.ietf.ldap.LDAPSearchConstraints;

public class LDAPConstraints
implements Cloneable {
    private com.novell.ldap.LDAPConstraints cons;
    private com.novell.ldap.LDAPReferralHandler refHandler = null;

    LDAPConstraints(com.novell.ldap.LDAPConstraints cons) {
        this.cons = cons;
    }

    LDAPConstraints(LDAPConstraints cons) {
        this(cons.getTimeLimit(), cons.getReferralFollowing(), null, cons.getHopLimit());
        this.refHandler = cons.getReferralHandler();
        if (cons instanceof LDAPSearchConstraints) {
            LDAPSearchConstraints inCons = (LDAPSearchConstraints)cons;
            com.novell.ldap.LDAPSearchConstraints outCons = (com.novell.ldap.LDAPSearchConstraints)this.cons;
            outCons.setServerTimeLimit(inCons.getServerTimeLimit());
            outCons.setDereference(inCons.getDereference());
            outCons.setMaxResults(inCons.getMaxResults());
            outCons.setBatchSize(inCons.getBatchSize());
        }
    }

    public Object clone() {
        try {
            Object newObj = super.clone();
            ((LDAPConstraints)newObj).cons = (com.novell.ldap.LDAPConstraints)this.cons.clone();
            return newObj;
        }
        catch (CloneNotSupportedException ce) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    public LDAPConstraints() {
        this.cons = new com.novell.ldap.LDAPSearchConstraints();
    }

    public LDAPConstraints(int msLimit, boolean doReferrals, LDAPReferralHandler handler, int hop_limit) {
        this.cons = new com.novell.ldap.LDAPSearchConstraints();
        this.cons.setTimeLimit(msLimit);
        this.cons.setReferralFollowing(doReferrals);
        this.cons.setHopLimit(hop_limit);
        this.setReferralHandler(handler);
    }

    com.novell.ldap.LDAPConstraints getWrappedObject() {
        return this.cons;
    }

    public int getHopLimit() {
        return this.cons.getHopLimit();
    }

    public Object getProperty(String name) {
        return this.cons.getProperty(name);
    }

    public boolean getReferralFollowing() {
        return this.cons.getReferralFollowing();
    }

    public int getTimeLimit() {
        return this.cons.getTimeLimit();
    }

    public void setHopLimit(int hop_limit) {
        this.cons.setHopLimit(hop_limit);
    }

    public void setReferralHandler(LDAPReferralHandler handler) {
        if (handler == null) {
            this.cons.setReferralHandler(null);
            this.refHandler = null;
        } else if (handler instanceof LDAPBindHandler) {
            this.refHandler = new BindHandlerImpl((LDAPBindHandler)handler);
            this.cons.setReferralHandler(this.refHandler);
        } else if (handler instanceof LDAPAuthHandler) {
            this.refHandler = new AuthHandlerImpl((LDAPAuthHandler)handler);
            this.cons.setReferralHandler(this.refHandler);
        } else {
            throw new IllegalArgumentException("LDAPReferralHandler object must be either LDAPAuthHandler or LDAPBindHandler");
        }
    }

    com.novell.ldap.LDAPReferralHandler getReferralHandler() {
        return this.refHandler;
    }

    public void setReferralFollowing(boolean doReferrals) {
        this.cons.setReferralFollowing(doReferrals);
    }

    public void setTimeLimit(int msLimit) {
        this.cons.setTimeLimit(msLimit);
    }

    public LDAPControl[] getControls() {
        com.novell.ldap.LDAPControl[] controls = this.cons.getControls();
        if (controls == null) {
            return null;
        }
        LDAPControl[] ietfControls = new LDAPControl[controls.length];
        for (int i = 0; i < controls.length; ++i) {
            ietfControls[i] = new LDAPControl(controls[i]);
        }
        return ietfControls;
    }

    public void setControls(LDAPControl control) {
        this.cons.setControls(control);
    }

    public void setControls(LDAPControl[] controls) {
        this.cons.setControls(controls);
    }

    public void setProperty(String name, Object value) throws LDAPException {
        try {
            this.cons.setProperty(name, value);
        }
        catch (com.novell.ldap.LDAPException rex) {
            throw new LDAPException(rex);
        }
    }

    private class AuthHandlerImpl
    implements com.novell.ldap.LDAPAuthHandler {
        LDAPAuthHandler ref;

        private AuthHandlerImpl(LDAPAuthHandler ref) {
            this.ref = ref;
        }

        public com.novell.ldap.LDAPAuthProvider getAuthProvider(String host, int port) {
            LDAPAuthProvider auth = this.ref.getAuthProvider(host, port);
            if (auth == null) {
                return null;
            }
            return auth.getWrappedObject();
        }
    }

    private class BindHandlerImpl
    implements com.novell.ldap.LDAPBindHandler {
        LDAPBindHandler ref;

        private BindHandlerImpl(LDAPBindHandler ref) {
            this.ref = ref;
        }

        public com.novell.ldap.LDAPConnection bind(String[] ldapurl, com.novell.ldap.LDAPConnection conn) throws com.novell.ldap.LDAPReferralException {
            try {
                LDAPConnection newconn = this.ref.bind(ldapurl, new LDAPConnection(conn));
                if (newconn == null) {
                    return null;
                }
                return newconn.getWrappedObject();
            }
            catch (LDAPReferralException rex) {
                throw (com.novell.ldap.LDAPReferralException)rex.getWrappedObject();
            }
            catch (Throwable ex) {
                throw new com.novell.ldap.LDAPReferralException(ex.toString(), ex);
            }
        }
    }
}

