/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.ldap.controls;

import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.client.Debug;
import java.io.IOException;
import org.ietf.ldap.LDAPControl;

public class LDAPSortResponse
extends LDAPControl {
    private String failedAttribute;
    private int resultCode;

    public LDAPSortResponse(String oid, boolean critical, byte[] values) throws IOException {
        super(oid, critical, values);
        ASN1Object asn1String;
        LBERDecoder decoder = new LBERDecoder();
        if (decoder == null) {
            throw new IOException("Decoding error");
        }
        ASN1Object asnObj = decoder.decode(values);
        if (asnObj == null || !(asnObj instanceof ASN1Sequence)) {
            throw new IOException("Decoding error");
        }
        Debug.trace("Controls", "LDAPSortResponse controlvalue =" + asnObj.toString());
        ASN1Object asn1Enum = ((ASN1Sequence)asnObj).get(0);
        if (asn1Enum != null && asn1Enum instanceof ASN1Enumerated) {
            this.resultCode = ((ASN1Enumerated)asn1Enum).intValue();
        }
        if (((ASN1Sequence)asnObj).size() > 1 && (asn1String = ((ASN1Sequence)asnObj).get(1)) != null && asn1String instanceof ASN1OctetString) {
            this.failedAttribute = ((ASN1OctetString)asn1String).stringValue();
        }
    }

    public String getFailedAttribute() {
        return this.failedAttribute;
    }

    public int getResultCode() {
        return this.resultCode;
    }
}

