/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.ldap.controls;

import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.asn1.LBEREncoder;
import com.novell.ldap.client.Debug;
import org.ietf.ldap.LDAPControl;

public class LDAPVirtualListControl
extends LDAPControl {
    private static int BYOFFSET = 0;
    private static int GREATERTHANOREQUAL = 1;
    private static String requestOID = "2.16.840.1.113730.3.4.9";
    private static String responseOID = "2.16.840.1.113730.3.4.10";
    private ASN1Sequence m_vlvRequest;
    private int m_beforeCount;
    private int m_afterCount;
    private String m_jumpTo;
    private String m_context = null;
    private int m_startIndex = 0;
    private int m_contentCount = -1;

    public LDAPVirtualListControl(String jumpTo, int beforeCount, int afterCount) {
        this(jumpTo, beforeCount, afterCount, null);
    }

    public LDAPVirtualListControl(String jumpTo, int beforeCount, int afterCount, String context) {
        super(requestOID, true, null);
        this.m_beforeCount = beforeCount;
        this.m_afterCount = afterCount;
        this.m_jumpTo = jumpTo;
        this.m_context = context;
        this.BuildTypedVLVRequest();
        this.setValue(this.m_vlvRequest.getEncoding(new LBEREncoder()));
    }

    private void BuildTypedVLVRequest() {
        this.m_vlvRequest = new ASN1Sequence(4);
        this.m_vlvRequest.add(new ASN1Integer(this.m_beforeCount));
        this.m_vlvRequest.add(new ASN1Integer(this.m_afterCount));
        this.m_vlvRequest.add(new ASN1Tagged(new ASN1Identifier(2, false, GREATERTHANOREQUAL), new ASN1OctetString(this.m_jumpTo), false));
        if (this.m_context != null) {
            this.m_vlvRequest.add(new ASN1OctetString(this.m_context));
        }
    }

    public LDAPVirtualListControl(int startIndex, int beforeCount, int afterCount, int contentCount) {
        this(startIndex, beforeCount, afterCount, contentCount, null);
    }

    public LDAPVirtualListControl(int startIndex, int beforeCount, int afterCount, int contentCount, String context) {
        super(requestOID, true, null);
        this.m_beforeCount = beforeCount;
        this.m_afterCount = afterCount;
        this.m_startIndex = startIndex;
        this.m_contentCount = contentCount;
        this.m_context = context;
        this.BuildIndexedVLVRequest();
        this.setValue(this.m_vlvRequest.getEncoding(new LBEREncoder()));
    }

    private void BuildIndexedVLVRequest() {
        this.m_vlvRequest = new ASN1Sequence(4);
        this.m_vlvRequest.add(new ASN1Integer(this.m_beforeCount));
        this.m_vlvRequest.add(new ASN1Integer(this.m_afterCount));
        ASN1Sequence byoffset = new ASN1Sequence(2);
        byoffset.add(new ASN1Integer(this.m_startIndex));
        byoffset.add(new ASN1Integer(this.m_contentCount));
        this.m_vlvRequest.add(new ASN1Tagged(new ASN1Identifier(2, true, BYOFFSET), byoffset, false));
        if (this.m_context != null) {
            this.m_vlvRequest.add(new ASN1OctetString(this.m_context));
        }
    }

    public int getAfterCount() {
        return this.m_afterCount;
    }

    public int getBeforeCount() {
        return this.m_beforeCount;
    }

    public int getListSize() {
        return this.m_contentCount;
    }

    public void setListSize(int size) {
        this.m_contentCount = size;
        this.BuildIndexedVLVRequest();
        this.setValue(this.m_vlvRequest.getEncoding(new LBEREncoder()));
    }

    public void setRange(int listIndex, int beforeCount, int afterCount) {
        this.m_beforeCount = beforeCount;
        this.m_afterCount = afterCount;
        this.m_startIndex = listIndex;
        this.BuildIndexedVLVRequest();
        this.setValue(this.m_vlvRequest.getEncoding(new LBEREncoder()));
    }

    public void setRange(String jumpTo, int beforeCount, int afterCount) {
        this.m_beforeCount = beforeCount;
        this.m_afterCount = afterCount;
        this.m_jumpTo = jumpTo;
        this.BuildTypedVLVRequest();
        this.setValue(this.m_vlvRequest.getEncoding(new LBEREncoder()));
    }

    public String getContext() {
        return this.m_context;
    }

    public void setContext(String context) {
        int CONTEXTIDINDEX = 3;
        this.m_context = context;
        if (this.m_vlvRequest.size() == 4) {
            this.m_vlvRequest.set(CONTEXTIDINDEX, new ASN1OctetString(this.m_context));
        } else if (this.m_vlvRequest.size() == 3) {
            this.m_vlvRequest.add(new ASN1OctetString(this.m_context));
        }
        this.setValue(this.m_vlvRequest.getEncoding(new LBEREncoder()));
    }

    static {
        try {
            LDAPControl.register(responseOID, Class.forName("org.ietf.ldap.controls.LDAPVirtualListResponse"));
            Debug.trace("Controls", "Registered VLV Control Response Class");
        }
        catch (ClassNotFoundException e) {
            Debug.trace("Controls", "Could not register VLV Control Response - Class not found");
        }
    }
}

