/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.ldap.controls;

import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.client.Debug;
import java.io.IOException;
import org.ietf.ldap.LDAPControl;

public class LDAPVirtualListResponse
extends LDAPControl {
    private int m_firstPosition;
    private int m_ContentCount;
    private int m_resultCode;
    private String m_context = null;

    public LDAPVirtualListResponse(String oid, boolean critical, byte[] values) throws IOException {
        super(oid, critical, values);
        ASN1Object asn1String;
        LBERDecoder decoder = new LBERDecoder();
        if (decoder == null) {
            throw new IOException("Decoding error");
        }
        ASN1Object asnObj = decoder.decode(values);
        if (asnObj == null || !(asnObj instanceof ASN1Sequence)) {
            throw new IOException("Decoding error");
        }
        Debug.trace("Controls", "LDAPVLVResponse Control Value =" + asnObj.toString());
        ASN1Object asn1firstPosition = ((ASN1Sequence)asnObj).get(0);
        if (asn1firstPosition == null || !(asn1firstPosition instanceof ASN1Integer)) {
            throw new IOException("Decoding error");
        }
        this.m_firstPosition = ((ASN1Integer)asn1firstPosition).intValue();
        ASN1Object asn1ContentCount = ((ASN1Sequence)asnObj).get(1);
        if (asn1ContentCount == null || !(asn1ContentCount instanceof ASN1Integer)) {
            throw new IOException("Decoding error");
        }
        this.m_ContentCount = ((ASN1Integer)asn1ContentCount).intValue();
        ASN1Object asn1Enum = ((ASN1Sequence)asnObj).get(2);
        if (asn1Enum == null || !(asn1Enum instanceof ASN1Enumerated)) {
            throw new IOException("Decoding error");
        }
        this.m_resultCode = ((ASN1Enumerated)asn1Enum).intValue();
        if (((ASN1Sequence)asnObj).size() > 3 && (asn1String = ((ASN1Sequence)asnObj).get(3)) != null && asn1String instanceof ASN1OctetString) {
            this.m_context = ((ASN1OctetString)asn1String).stringValue();
        }
    }

    public int getContentCount() {
        return this.m_ContentCount;
    }

    public int getFirstPosition() {
        return this.m_firstPosition;
    }

    public int getResultCode() {
        return this.m_resultCode;
    }

    public String getContext() {
        return this.m_context;
    }
}

