/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver;

import com.novell.xml.dom.DocumentFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DelimitedText {
    public static final char FIELD_DELIMITER_COMMA = ',';
    public static final char FIELD_DELIMITER_TAB = '\t';
    public static final char FIELD_DELIMITER_DEFAULT = ',';
    public static final char FIELD_QUOTE = '\"';
    public static final String ROOT_ELEMENT = "delimited-text";
    public static final String HEADER_ELEMENT = "header";
    public static final String FIELD_NAME_ELEMENT = "field-name";
    public static final String RECORD_ELEMENT = "record";
    public static final String FIELD_ELEMENT = "field";
    public static final String FIELD_NAME_ATTR = "name";
    protected char fieldDelimiter;
    protected String[] columnNames;
    protected boolean hasHeaderRow;

    public DelimitedText() {
        this.fieldDelimiter = (char)44;
        this.columnNames = null;
        this.hasHeaderRow = false;
    }

    public DelimitedText(char c) {
        this.fieldDelimiter = c;
        this.columnNames = null;
        this.hasHeaderRow = false;
    }

    public DelimitedText(char c, boolean bl) {
        this.fieldDelimiter = c;
        this.columnNames = null;
        this.hasHeaderRow = bl;
    }

    public DelimitedText(char c, String[] stringArray) {
        this.fieldDelimiter = c;
        this.columnNames = stringArray;
        this.hasHeaderRow = false;
    }

    public Document convertToXML(String string) throws IOException, DOMException {
        return this.convertToXML(new FileInputStream(string));
    }

    public Document convertToXML(InputStream inputStream) throws IOException, DOMException {
        return this.convertToXML(new InputStreamReader(inputStream));
    }

    public Document convertToXML(Reader reader) throws IOException, DOMException {
        return this.convertToXML(new BufferedReader(reader));
    }

    public Document convertToXML(BufferedReader bufferedReader) throws IOException, DOMException {
        Node node;
        Object object;
        Document document = DocumentFactory.newDocument();
        Element element = document.createElementNS(null, ROOT_ELEMENT);
        document.appendChild(element);
        String[] stringArray = null;
        int n = 0;
        if (this.hasHeaderRow) {
            stringArray = this.readRecord(bufferedReader);
            n = stringArray.length;
            object = document.createElementNS(null, HEADER_ELEMENT);
            element.appendChild((Node)object);
            int n2 = 0;
            while (n2 < stringArray.length) {
                Element element2 = document.createElementNS(null, FIELD_NAME_ELEMENT);
                object.appendChild(element2);
                node = document.createTextNode(stringArray[n2]);
                element2.appendChild(node);
                ++n2;
            }
        } else {
            stringArray = this.columnNames;
            if (stringArray != null) {
                n = stringArray.length;
            }
        }
        while ((object = this.readRecord(bufferedReader)) != null) {
            Element element3 = document.createElementNS(null, RECORD_ELEMENT);
            element.appendChild(element3);
            int n3 = 0;
            while (n3 < ((String[])object).length) {
                node = document.createElementNS(null, FIELD_ELEMENT);
                element3.appendChild(node);
                if (n3 < n) {
                    node.setAttributeNS(null, FIELD_NAME_ATTR, stringArray[n3]);
                }
                Text text = document.createTextNode((String)object[n3]);
                node.appendChild(text);
                ++n3;
            }
        }
        return document;
    }

    protected String[] readRecord(BufferedReader bufferedReader) throws IOException {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        String string = bufferedReader.readLine();
        if (string == null) {
            return null;
        }
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            object = "";
            n2 = n3;
            if (string.charAt(n3) == '\"') {
                int n4;
                n2 = ++n3;
                while (true) {
                    if ((n4 = string.indexOf(34, n3)) == -1) {
                        object = (String)object + string.substring(n2, n);
                        object = (String)object + "\n";
                        string = bufferedReader.readLine();
                        if (string == null) {
                            throw new EOFException();
                        }
                        n = string.length();
                        n2 = 0;
                        n3 = 0;
                        continue;
                    }
                    if (n4 >= n - 1 || string.charAt(n4 + 1) != '\"') break;
                    object = (String)object + string.substring(n2, n4 + 1);
                    n2 = n3 = n4 + 2;
                }
                if (n4 < n - 1 && string.charAt(n4 + 1) != this.fieldDelimiter) {
                    throw new IOException();
                }
                object = (String)object + string.substring(n2, n4);
                n2 = n3 = n4 + 2;
            } else {
                if ((n3 = string.indexOf(this.fieldDelimiter, n3)) == -1) {
                    n3 = n;
                }
                if (n2 != n3) {
                    object = (String)object + string.substring(n2, n3);
                }
                ++n3;
            }
            vector.addElement(object);
        }
        if (n > 0 && string.charAt(n - 1) == this.fieldDelimiter) {
            vector.addElement("");
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public void convertFromXML(Document document, String string) throws IOException, DOMException {
        this.convertFromXML(document, new FileOutputStream(string));
    }

    public void convertFromXML(Document document, OutputStream outputStream) throws IOException, DOMException {
        this.convertFromXML(document, new OutputStreamWriter(outputStream));
    }

    public void convertFromXML(Document document, Writer writer) throws IOException, DOMException {
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        this.convertFromXML(document, bufferedWriter);
        bufferedWriter.flush();
    }

    public void convertFromXML(Document document, BufferedWriter bufferedWriter) throws IOException, DOMException {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        try {
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node instanceof Element) {
                    this.writeRecord((Element)node, bufferedWriter);
                }
                ++n;
            }
        }
        catch (ClassCastException classCastException) {
            throw new IOException();
        }
    }

    protected void writeRecord(Element element, BufferedWriter bufferedWriter) throws IOException, DOMException {
        if (!element.getNodeName().equals(RECORD_ELEMENT) && !element.getNodeName().equals(HEADER_ELEMENT)) {
            throw new IOException();
        }
        NodeList nodeList = element.getChildNodes();
        boolean bl = true;
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                if (!bl) {
                    bufferedWriter.write(this.fieldDelimiter);
                }
                this.writeField((Element)node, bufferedWriter);
                bl = false;
            }
            ++n;
        }
        bufferedWriter.newLine();
    }

    protected void writeField(Element element, BufferedWriter bufferedWriter) throws IOException, DOMException {
        if (!element.getNodeName().equals(FIELD_ELEMENT) && !element.getNodeName().equals(FIELD_NAME_ELEMENT)) {
            throw new IOException();
        }
        NodeList nodeList = element.getChildNodes();
        String string = "";
        int n = 0;
        while (n < nodeList.getLength()) {
            string = string + ((Text)nodeList.item(n)).getData();
            ++n;
        }
        bufferedWriter.write(this.quoteIfNeeded(string));
    }

    protected String quoteIfNeeded(String string) {
        if (string.indexOf(34) != -1 || string.indexOf(this.fieldDelimiter) != -1 || string.indexOf("\n") != -1) {
            int n = 0;
            int n2 = 0;
            String string2 = "\"";
            while ((n2 = string.indexOf(34, n)) != -1) {
                string2 = string2 + string.substring(n, n2 + 1) + '\"';
                n = n2 + 1;
            }
            if (n < string.length()) {
                string2 = string2 + string.substring(n);
            }
            return string2 + '\"';
        }
        return string;
    }
}

