/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.DOMWriter;
import com.novell.xml.dom.DOMtoSAX;
import com.novell.xml.dom.DocumentFactory;
import com.novell.xml.dom.ElementImpl;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.parser.XMLParserFactory;
import com.novell.xml.sax.SAXtoDOM;
import com.novell.xml.util.XmlWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class XmlDocument
implements Externalizable {
    protected Document documentDOM = null;
    protected String documentString = null;
    protected byte[] documentBytes = null;
    protected boolean indent = false;
    protected Parser saxParser = null;
    protected InputSource inputSource = null;
    protected XMLParser xmlDocParser = null;

    public XmlDocument() {
    }

    public XmlDocument(Document document) {
        this.setDocument(document);
    }

    public XmlDocument(String string) {
        this.setDocument(string);
    }

    public XmlDocument(byte[] byArray) {
        this.setDocument(byArray);
    }

    public XmlDocument(Parser parser, InputSource inputSource) {
        this.setDocument(parser, inputSource);
    }

    public void setDocument(Document document) {
        this.documentDOM = document;
        this.documentString = null;
        this.documentBytes = null;
        this.saxParser = null;
        this.inputSource = null;
    }

    public void setDocument(String string) {
        this.documentDOM = null;
        this.documentString = string;
        this.documentBytes = null;
        this.saxParser = null;
        this.inputSource = null;
    }

    public void setDocument(byte[] byArray) {
        this.documentDOM = null;
        this.documentString = null;
        this.documentBytes = byArray;
        this.saxParser = null;
        this.inputSource = null;
    }

    public void setDocument(Parser parser, InputSource inputSource) {
        this.documentDOM = null;
        this.documentString = null;
        this.documentBytes = null;
        this.saxParser = parser;
        this.inputSource = inputSource;
    }

    public void readDocument(InputStream inputStream) {
        this.setDocument(this.getParser().parse(inputStream));
    }

    public void readDocument(InputStream inputStream, String string) throws MalformedURLException {
        this.getParser().setContextURI(string);
        this.setDocument(this.getParser().parse(inputStream));
    }

    public void readDocument(Reader reader) {
        this.setDocument(this.getParser().parse(reader));
    }

    public void readDocument(URL uRL) throws IOException {
        this.setDocument(this.getParser().parse(uRL.toString()));
    }

    public void readDocument(String string) throws IOException {
        this.setDocument(this.getParser().parse(string));
    }

    public void writeDocument(OutputStream outputStream, String string) throws IOException, UnsupportedEncodingException {
        XmlWriter xmlWriter = this.getXmlWriter(outputStream, string);
        xmlWriter.setIndent(this.indent);
        xmlWriter.write();
        outputStream.flush();
    }

    public void writeDocument(Writer writer) throws IOException {
        XmlWriter xmlWriter = this.getXmlWriter(writer);
        xmlWriter.setIndent(this.indent);
        xmlWriter.write();
        writer.flush();
    }

    public Document getDocument() {
        if (this.documentDOM == null) {
            if (this.saxParser != null) {
                this.documentDOM = DocumentFactory.newDocument();
                SAXtoDOM sAXtoDOM = new SAXtoDOM(this.documentDOM);
                this.saxParser.setDocumentHandler((DocumentHandler)sAXtoDOM);
                this.saxParser.setDTDHandler((DTDHandler)sAXtoDOM);
                try {
                    this.saxParser.parse(this.inputSource);
                }
                catch (SAXException sAXException) {
                    this.documentDOM = null;
                }
                catch (IOException iOException) {
                    this.documentDOM = null;
                }
            } else if (this.documentString != null) {
                this.documentDOM = this.getParser().parse((Reader)new StringReader(this.documentString));
            } else if (this.documentBytes != null) {
                this.documentDOM = this.getParser().parse((InputStream)new ByteArrayInputStream(this.documentBytes));
            }
        }
        return this.documentDOM;
    }

    public Document getDocumentNS() {
        if (this.documentDOM == null) {
            return this.getDocument();
        }
        if (this.documentDOM.getImplementation().hasFeature("XML", "2.0")) {
            Element element = this.documentDOM.getDocumentElement();
            if (element != null && element.getLocalName() == null) {
                if (element instanceof ElementImpl) {
                    ((ElementImpl)element).fetchNamespacesFromDecls(true);
                } else {
                    this.documentDOM = DOMUtil.cloneDocument((Document)this.documentDOM);
                }
            }
        } else {
            this.documentDOM = DOMUtil.cloneDocument((Document)this.documentDOM);
        }
        return this.documentDOM;
    }

    public String getDocumentString() {
        if (this.documentString == null) {
            try {
                if (this.documentBytes != null) {
                    this.documentString = new String(this.documentBytes);
                } else if (this.documentDOM == null) {
                    this.getDocument();
                }
                if (this.documentDOM != null) {
                    StringWriter stringWriter = new StringWriter();
                    this.writeDocument(stringWriter);
                    this.documentString = stringWriter.toString();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.documentString;
    }

    public byte[] getDocumentBytes(String string) {
        if (this.documentBytes == null) {
            try {
                if (this.documentString != null) {
                    this.documentBytes = this.documentString.getBytes(string);
                } else if (this.documentDOM == null) {
                    this.getDocument();
                }
                if (this.documentDOM != null) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    this.writeDocument(byteArrayOutputStream, string);
                    this.documentBytes = byteArrayOutputStream.toByteArray();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.documentBytes;
    }

    public Parser getDocumentSAX() {
        if (this.saxParser == null) {
            this.getDocument();
            if (this.documentDOM != null) {
                this.saxParser = new DOMtoSAX(this.getDocument());
            }
        }
        return this.saxParser;
    }

    public InputSource getDocumentInputSource() {
        if (this.inputSource == null) {
            this.inputSource = new InputSource();
        }
        return this.inputSource;
    }

    public XmlWriter getXmlWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        return new DOMWriter((Node)this.getDocument(), outputStream, string);
    }

    public XmlWriter getXmlWriter(Writer writer) {
        return new DOMWriter((Node)this.getDocument(), writer);
    }

    public XMLParser getParser() {
        if (this.xmlDocParser == null) {
            this.xmlDocParser = XMLParserFactory.newParser();
        }
        return this.xmlDocParser;
    }

    public Vector getParserErrorMsgs() {
        if (this.xmlDocParser == null) {
            return new Vector();
        }
        return this.xmlDocParser.getErrorMsgs();
    }

    public String getParserErrorMsgString() {
        if (this.xmlDocParser == null) {
            return "";
        }
        return this.xmlDocParser.getErrorMsgString();
    }

    public void setIndent(boolean bl) {
        this.indent = bl;
    }

    public boolean getIndent() {
        return this.indent;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        byte[] byArray = this.getDocumentBytes("UTF-8");
        if (byArray == null) {
            byArray = new byte[]{};
        }
        objectOutput.writeObject(byArray);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray = (byte[])objectInput.readObject();
        if (byArray.length == 0) {
            byArray = null;
        }
        this.setDocument(byArray);
    }
}

