/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dhutil.DDSServ;
import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.engine.AppSchema;
import com.novell.nds.dirxml.engine.DriverEventMonitor;
import com.novell.nds.dirxml.engine.EmptyStreamAttributeException;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.Entry;
import com.novell.nds.dirxml.engine.LogSettings;
import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.StringUtil;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.XmlInputProcessor;
import com.novell.nds.dirxml.engine.controls.ControlValues;
import com.novell.nds.dirxml.engine.gcv.GCDefinitions;
import com.novell.nds.dirxml.engine.gcv.GCStringValue;
import com.novell.nds.dirxml.engine.gcv.GCVException;
import com.novell.nds.dirxml.engine.gcv.GCValue;
import com.novell.nds.dirxml.engine.gcv.GCValueNotFoundException;
import com.novell.nds.dirxml.engine.gcv.ShimParams;
import com.novell.nds.dirxml.engine.rules.Filter;
import com.novell.nds.dirxml.engine.rules.util.FilterUpgrader;
import com.novell.nds.dirxml.io.SplitterOutputStream;
import com.novell.nds.dirxml.io.TimestampedOutputStream;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.nds.dirxml.util.XdsDN;
import com.novell.nds.io.NDSStreamAttributeInputStream;
import com.novell.nds.io.NDSStreamAttributeOutputStream;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.DOMWriter;
import com.novell.xml.dom.DocumentFactory;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.XmlHook;
import com.novell.xsl.debug.Trace;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.rmi.server.UID;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import novell.jclient.JCCIstringValue;
import novell.jclient.JCContext;
import novell.jclient.JCDistnameValue;
import novell.jclient.JCEntryInfo;
import novell.jclient.JCEntryInfoCB;
import novell.jclient.JCEntryInfoEmptyFieldException;
import novell.jclient.JCException;
import novell.jclient.JCIntegerValue;
import novell.jclient.JCListFilter;
import novell.jclient.JCOctetlistValue;
import novell.jclient.JCOctetstringValue;
import novell.jclient.JCReadFilter;
import novell.jclient.JCTimestamp;
import novell.jclient.JCValue;
import novell.jclient.JClient;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ConfigAbstraction
implements XmlHook {
    private int iDriverType;
    private static final int NATIVE_DRIVER = 1;
    private static final int JAVA_DRIVER = 2;
    private JCContext context = null;
    private Entry driver = null;
    private Entry subscriber = null;
    private Entry publisher = null;
    private Entry driverSet = null;
    private EngineTrace tracer;
    private TraceChange traceChangeHandler = new TraceChange();
    private String driverName = null;
    private static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.ConfigAbstraction");
    private String driverGUID = null;
    private int subPubCount;
    private String tree = null;
    private static String[] initAttr1 = new String[]{"DirXML-ShimAuthID"};
    private static String[] initAttr2 = new String[]{"DirXML-ShimAuthServer"};
    private static String[] jdriverAttrNames = new String[]{"DirXML-JavaModule"};
    private static String[] cdriverAttrNames = new String[]{"DirXML-NativeModule"};
    private static final int MIN_TTL = 30;
    private long driverID = -1L;
    private LogSettings logSettings;
    private static Object settingsGate = new Object();
    private static LogSettings driverSetLogSettings = null;
    private Filter filter = null;
    private GCDefinitions gcvDefs = null;
    private ControlValues ecvDefs = null;
    private Map namedPasswords = null;
    private static PrintStream originalOut = null;
    private static PrintStream originalErr = null;
    private static OutputStream xslOutputStream = null;
    private static Object xslGate = new Object();
    private static XslTraceChange xslTraceChangeHandler = null;
    static final boolean loginAsDriver = true;
    private JCContext remoteContext = null;
    private int[] remoteContextGate = new int[]{0};
    private int remoteContextUseCount = 0;
    protected byte[][] keyPair = null;
    private AppSchema appSchema = null;
    private String driverIdentityName = null;
    private String driverIdentityVersion = null;
    protected static final String FOUND_PUBLISHER = "ct_fndpub";
    protected static final String FOUND_SUBSCRIBER = "ct_fndsub";
    protected static final String READING_DRIVER_INFO = "ct_rddinfo";
    protected static final String READING_XML_ATTR = "ct_rdxmlat";
    protected static final String WRITING_XML_ATTR = "ct_wtxmlat";
    protected static final String WRITING_DRIVER_STATE = "ct_wtdrvst";
    protected static final String LOADED_FILTER = "ct_ldflter";
    protected static final String GCV_REPLACEMENTS_MADE = "ct_gcvrepl";
    protected static final String GCV_TRACE_HEADER = "ct_gcvhdr";
    protected static final String GCV_TRACE_VALUE = "ct_gcvdump";
    protected static final String GCV_ATTR_REPLACEMENT_MADE = "ct_gcvrstr";
    protected static final String READING_NAMED_PASSWORDS = "ct_rkeypwd";
    protected static final String USING_NAMED_PASSWORD = "ct_skeypwd";
    protected static final String GETTING_NAMED_PASSWORD = "ct_gkeypwd";
    protected static final String ERROR_WRITING_DRIVER_ID = "vt_errdrvid";
    protected static final String NO_NAMED_PASSWORD = "ct_errnmpwd";
    private Object stateGate = new Object();

    boolean isNativeDriver() {
        return this.iDriverType == 1;
    }

    void setIsNative() {
        this.iDriverType = 1;
    }

    boolean isJavaDriver() {
        return this.iDriverType == 2;
    }

    void setIsJava() {
        this.iDriverType = 2;
    }

    boolean hasSubscriber() {
        return this.subscriber != null;
    }

    boolean hasPublisher() {
        return this.publisher != null;
    }

    String getSubscriberDN() {
        if (this.subscriber != null) {
            return this.subscriber.getDN();
        }
        return "";
    }

    Entry getSubscriber() {
        return this.subscriber;
    }

    long getSubscriberID() {
        return this.subscriber == null ? -1L : this.subscriber.getEntryID();
    }

    String getPublisherDN() {
        if (this.publisher != null) {
            return this.publisher.getDN();
        }
        return "";
    }

    Entry getPublisher() {
        return this.publisher;
    }

    long getPublisherID() {
        return this.publisher == null ? -1L : this.publisher.getEntryID();
    }

    String getDriverDN() {
        return this.driver.getDN();
    }

    synchronized String getDriverObjectName() {
        if (this.driverName == null) {
            this.driverName = MiscDS.getEntryRDN(this.getDriverID());
        }
        return this.driverName;
    }

    long getDriverID() {
        return this.driverID;
    }

    long getDriverSetID() {
        return this.driverSet.getEntryID();
    }

    String getDriverSetDN() {
        return this.driverSet.getDN();
    }

    Entry getDriver() {
        return this.driver;
    }

    public String getTreeName() {
        return this.tree;
    }

    EngineTrace getTracer() {
        return this.tracer;
    }

    protected void setContext(boolean bl) throws VRDException {
        try {
            if (this.context != null) {
                this.context.free();
            }
            this.context = new JCContext(0, this.tree, "00.\\+=*'");
            if (bl) {
                this.context.setLocal(0);
            }
            this.context.authenticate();
        }
        catch (JCException jCException) {
            throw new VRDException(jCException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigAbstraction(long l) throws VRDException {
        try {
            JCContext jCContext = new JCContext();
            try {
                jCContext.setFlags(4, 128);
                jCContext.setBaseDN("\\", "00.\\+=*'");
                jCContext.setLocal(0);
                jCContext.setEntryID(l);
                JCEntryInfo jCEntryInfo = JClient.getEntryInfo((JCContext)jCContext, (int)10240);
                String string = jCEntryInfo.getEntryDN().toString();
                char[] cArray = "00.\\+=*'".toCharArray();
                XdsDN xdsDN = new XdsDN(string, cArray);
                if (!xdsDN.hasTreeName()) {
                    throw new VRDException(9012, string, (Object)Long.toString(l));
                }
                String string2 = xdsDN.getDNFragment(cArray, 0, 1, false);
                this.commonConstruct(string2, string);
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                jCContext.free();
                throw throwable;
            }
            jCContext.free();
            {
            }
        }
        catch (JCEntryInfoEmptyFieldException jCEntryInfoEmptyFieldException) {
            throw new VRDException(jCEntryInfoEmptyFieldException);
        }
        catch (JCException jCException) {
            throw new VRDException(jCException);
        }
    }

    ConfigAbstraction(String string, String string2) throws VRDException {
        this.commonConstruct(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonConstruct(String string, String string2) throws VRDException {
        try {
            this.tree = string;
            if (this.tree.toUpperCase().startsWith("T=")) {
                this.tree = this.tree.substring(2);
            }
            this.driver = new Entry(string2);
            this.setContext(true);
            JCContext jCContext = this.context.duplicate();
            try {
                this.driver.goTo(jCContext);
                this.driverID = jCContext.getEntryID();
                JCEntryInfo jCEntryInfo = JClient.getEntryInfo((JCContext)jCContext, (int)256);
                this.driverSet = new Entry(jCEntryInfo.getParentID());
                this.driverSet.initDN(jCContext);
                this.driver.goTo(jCContext);
                this.initLog();
                this.initTracer();
                this.initNamedPasswords();
                this.initECVs();
                this.initGCVs();
                JCListFilter jCListFilter = new JCListFilter(false, true, false, false, "DirXML-Subscriber", "", new JCTimestamp());
                this.subPubCount = 0;
                JClient.listToCB((JCContext)jCContext, (JCListFilter)jCListFilter, (int)8194, (JCEntryInfoCB)new JCEntryInfoCB(){

                    public int entryInfoCallback(JCContext jCContext, JCEntryInfo jCEntryInfo) {
                        try {
                            ++ConfigAbstraction.this.subPubCount;
                            ConfigAbstraction.this.subscriber = new Entry(jCEntryInfo.getEntryDN().toString(), jCEntryInfo.getEntryID());
                            ConfigAbstraction.this.tracer.trace(ConfigAbstraction.FOUND_SUBSCRIBER, (MessageSource)messageSource, jCEntryInfo.getEntryDN());
                            return 0;
                        }
                        catch (JCEntryInfoEmptyFieldException jCEntryInfoEmptyFieldException) {
                            return 9004;
                        }
                    }
                });
                if (this.subPubCount > 1) {
                    throw new VRDException(9007);
                }
                jCListFilter = new JCListFilter(false, true, false, false, "DirXML-Publisher", "", new JCTimestamp());
                this.subPubCount = 0;
                JClient.listToCB((JCContext)jCContext, (JCListFilter)jCListFilter, (int)8192, (JCEntryInfoCB)new JCEntryInfoCB(){

                    public int entryInfoCallback(JCContext jCContext, JCEntryInfo jCEntryInfo) {
                        try {
                            ++ConfigAbstraction.this.subPubCount;
                            ConfigAbstraction.this.publisher = new Entry(jCEntryInfo.getEntryDN().toString(), jCEntryInfo.getEntryID());
                            ConfigAbstraction.this.tracer.trace(ConfigAbstraction.FOUND_PUBLISHER, (MessageSource)messageSource, jCEntryInfo.getEntryDN());
                            return 0;
                        }
                        catch (JCEntryInfoEmptyFieldException jCEntryInfoEmptyFieldException) {
                            return 9004;
                        }
                    }
                });
                if (this.subPubCount > 1) {
                    throw new VRDException(9008);
                }
                if (this.subscriber == null && this.publisher == null) {
                    throw new VRDException(9009);
                }
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                jCContext.free();
                throw throwable;
            }
            jCContext.free();
            {
            }
        }
        catch (JCEntryInfoEmptyFieldException jCEntryInfoEmptyFieldException) {
            throw new VRDException(jCEntryInfoEmptyFieldException);
        }
        catch (JCException jCException) {
            throw new VRDException(jCException);
        }
    }

    protected void shutdown() {
        this.cleanupTracer();
        if (this.context != null) {
            this.context.free();
        }
        try {
            this.remoteContextUseCount = 0;
            this.releaseRemoteContext();
        }
        catch (VRDException vRDException) {
            // empty catch block
        }
        this.context = null;
        this.driver = null;
        this.subscriber = null;
        this.publisher = null;
        this.driverSet = null;
        this.tree = null;
        this.driverID = -1L;
        this.filter = null;
    }

    protected void initTracer() {
        this.tracer = new EngineTrace(this.getDriverID(), this.getDriverTraceName());
        this.tracer.setLevel(this.getDriverTraceLevel());
        this.tracer.setTraceFile(this.getDriverTraceFilename());
        this.tracer.setMaxTraceFileSize(this.getDriverTraceSizeLimit());
        try {
            DriverEventMonitor.registerForChange(this.getDriverID(), "DirXML-TraceLevel", this.traceChangeHandler, null);
            DriverEventMonitor.registerForChange(this.getDriverID(), "DirXML-TraceFile", this.traceChangeHandler, null);
            DriverEventMonitor.registerForChange(this.getDriverID(), "DirXML-TraceName", this.traceChangeHandler, null);
            DriverEventMonitor.registerForChange(this.getDriverID(), "DirXML-TraceSizeLimit", this.traceChangeHandler, null);
            DriverEventMonitor.registerForChange(this.getDriverSetID(), "DirXML-DriverTraceLevel", this.traceChangeHandler, null);
            DriverEventMonitor.registerForChange(this.getDriverSetID(), "DirXML-JavaTraceFile", this.traceChangeHandler, null);
            DriverEventMonitor.registerForChange(this.getDriverSetID(), "DirXML-TraceSizeLimit", this.traceChangeHandler, null);
        }
        catch (Throwable throwable) {
            StatusLog.logError(9135, MiscDS.getEntryDN(this.getDriverID()), throwable);
        }
    }

    protected void cleanupTracer() {
        try {
            DriverEventMonitor.unregisterForChange(this.getDriverSetID(), "DirXML-TraceSizeLimit", this.traceChangeHandler, null);
            DriverEventMonitor.unregisterForChange(this.getDriverSetID(), "DirXML-JavaTraceFile", this.traceChangeHandler, null);
            DriverEventMonitor.unregisterForChange(this.getDriverSetID(), "DirXML-DriverTraceLevel", this.traceChangeHandler, null);
            DriverEventMonitor.unregisterForChange(this.getDriverID(), "DirXML-TraceSizeLimit", this.traceChangeHandler, null);
            DriverEventMonitor.unregisterForChange(this.getDriverID(), "DirXML-TraceName", this.traceChangeHandler, null);
            DriverEventMonitor.unregisterForChange(this.getDriverID(), "DirXML-TraceFile", this.traceChangeHandler, null);
            DriverEventMonitor.unregisterForChange(this.getDriverID(), "DirXML-TraceLevel", this.traceChangeHandler, null);
            if (this.tracer != null) {
                this.tracer.close();
                this.tracer = null;
            }
        }
        catch (Throwable throwable) {
            StatusLog.logError(9136, MiscDS.getEntryDN(this.getDriverID()), throwable);
        }
    }

    protected void initECVs() throws VRDException {
        this.ecvDefs = new ControlValues(this.tracer);
        this.ecvDefs.readFromDriver(this.getDriverID());
    }

    public ControlValues getECVs() {
        return this.ecvDefs;
    }

    protected void initGCVs() throws VRDException {
        Object object;
        this.gcvDefs = null;
        GCDefinitions gCDefinitions = null;
        Document document = null;
        Document document2 = null;
        try {
            document2 = this.getAttributeXML(this.driverSet, "DirXML-ConfigValues");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (document2 != null) {
            try {
                gCDefinitions = GCDefinitions.construct((Document)document2);
            }
            catch (GCVException gCVException) {
                throw new VRDException(9029, gCVException.getMessage());
            }
        }
        try {
            document = this.getAttributeXML(this.driver, "DirXML-ConfigValues");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (document == null) {
            this.gcvDefs = gCDefinitions != null ? gCDefinitions : new GCDefinitions();
        } else {
            try {
                this.gcvDefs = GCDefinitions.construct((Document)document);
            }
            catch (GCVException gCVException) {
                throw new VRDException(9030, gCVException.getMessage());
            }
            if (gCDefinitions != null) {
                this.gcvDefs.merge(gCDefinitions);
            }
        }
        try {
            object = new GCStringValue("dirxml.auto.treename");
            object.setValue(this.getTreeName());
            this.gcvDefs.appendValue((GCValue)object);
            object = new GCStringValue("dirxml.auto.driverdn");
            object.setValue(this.getDriverDN());
            this.gcvDefs.appendValue((GCValue)object);
            object = new GCStringValue("dirxml.auto.driverguid");
            object.setValue(this.getDriverGUID());
            this.gcvDefs.appendValue((GCValue)object);
        }
        catch (Exception exception) {
            throw new VRDException(exception);
        }
        if (this.tracer.getLevel() > 0) {
            this.tracer.trace(GCV_TRACE_HEADER, (MessageSource)messageSource);
            this.tracer.pushIndent(1);
            object = this.gcvDefs.iterator();
            while (object.hasNext()) {
                GCValue gCValue = (GCValue)object.next();
                this.tracer.trace(GCV_TRACE_VALUE, (MessageSource)messageSource, gCValue.getName(), (Object)gCValue.getValue());
            }
            this.tracer.popIndent();
        }
    }

    private String replaceGCVRefs(String string, String string2) throws VRDException {
        if (string != null) {
            String[] stringArray = new String[]{string};
            try {
                if (this.gcvDefs.apply(stringArray)) {
                    string = stringArray[0];
                    if (this.tracer.getLevel() > 0) {
                        this.tracer.trace(GCV_ATTR_REPLACEMENT_MADE, (MessageSource)messageSource, string2, (Object)string);
                    }
                }
            }
            catch (GCValueNotFoundException gCValueNotFoundException) {
                throw new VRDException(9032, gCValueNotFoundException.getValueName(), (Object)string2);
            }
        }
        return string;
    }

    GCDefinitions getGCVs() {
        return this.gcvDefs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getDriverName(String[] stringArray) throws VRDException {
        String string;
        JCContext jCContext = null;
        try {
            try {
                this.tracer.trace(READING_DRIVER_INFO, (MessageSource)messageSource, this.driver.getDN());
                jCContext = this.context.duplicate();
                this.driver.goTo(jCContext);
                JCReadFilter jCReadFilter = new JCReadFilter();
                jCReadFilter.attributeNames = stringArray;
                JCValue[] jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                string = ((JCCIstringValue)jCValueArray[0]).getString();
                Object var7_8 = null;
                if (jCContext == null) return string;
            }
            catch (JCException jCException) {
                if (jCException.getErrorCode() != -603) throw new VRDException(jCException);
                String string2 = null;
                Object var7_9 = null;
                if (jCContext == null) return string2;
                jCContext.free();
                return string2;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (jCContext == null) throw throwable;
            jCContext.free();
            throw throwable;
        }
        jCContext.free();
        return string;
    }

    String getCDriverName() throws VRDException {
        return this.getDriverName(cdriverAttrNames);
    }

    String getJavaDriverName() throws VRDException {
        return this.getDriverName(jdriverAttrNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void initLog() {
        JCContext jCContext = null;
        int n = 0;
        int n2 = 50;
        boolean bl = true;
        ConfigAbstraction.getDriverSetLogSettings();
        this.logSettings = new LogSettings();
        if (driverSetLogSettings != null) {
            this.logSettings.setLimit(driverSetLogSettings.getLimit());
            this.logSettings.setLevel(driverSetLogSettings.getLevel());
            this.logSettings.setEventList(driverSetLogSettings.getEventList());
        }
        try {
            try {
                jCContext = this.context.duplicate();
                this.driver.goTo(jCContext);
                JCReadFilter jCReadFilter = new JCReadFilter(false, new JCTimestamp(), new String[]{"DirXML-DriverTraceLevel", "DirXML-LogLimit", "DirXML-LogEvents"});
                JCValue[] jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                int n3 = 0;
                while (n3 < jCValueArray.length) {
                    if (jCValueArray[n3].attributeName.equalsIgnoreCase("DirXML-DriverTraceLevel")) {
                        n = (int)((JCIntegerValue)jCValueArray[n3]).getInteger();
                        this.logSettings.setLevel(n);
                    } else if (jCValueArray[n3].attributeName.equalsIgnoreCase("DirXML-LogLimit")) {
                        n2 = (int)((JCIntegerValue)jCValueArray[n3]).getInteger();
                        n2 = Math.max(n2, 50);
                        n2 = Math.min(n2, 500);
                        this.logSettings.setLimit(n2);
                    } else if (jCValueArray[n3].attributeName.equalsIgnoreCase("DirXML-LogEvents")) {
                        if (bl) {
                            this.logSettings.clearEventList();
                            bl = false;
                        }
                        int n4 = (int)((JCIntegerValue)jCValueArray[n3]).getInteger();
                        this.logSettings.addEvent(n4);
                    }
                    ++n3;
                }
            }
            catch (JCException jCException) {
                Object var10_11 = null;
                if (jCContext == null) return;
                jCContext.free();
                return;
            }
            Object var10_10 = null;
            if (jCContext == null) return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (jCContext == null) throw throwable;
            jCContext.free();
            throw throwable;
        }
        jCContext.free();
    }

    LogSettings getLogSettings() {
        return this.logSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initDriverSetLog() {
        Object object = settingsGate;
        synchronized (object) {
            int n = 50;
            JCContext jCContext = null;
            driverSetLogSettings = new LogSettings();
            driverSetLogSettings.setLevel(0);
            driverSetLogSettings.setLimit(n);
            try {
                jCContext = MiscDS.createLocalContext();
                jCContext.setEntryID(MiscDS.getDriverSetID(jCContext));
                JCReadFilter jCReadFilter = new JCReadFilter(false, new JCTimestamp(), new String[]{"DirXML-LogLimit", "DirXML-LogEvents"});
                JCValue[] jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                int n2 = 0;
                while (n2 < jCValueArray.length) {
                    if (jCValueArray[n2].attributeName.equalsIgnoreCase("DirXML-LogLimit")) {
                        n = (int)((JCIntegerValue)jCValueArray[n2]).getInteger();
                        n = Math.max(n, 50);
                        n = Math.min(n, 500);
                        driverSetLogSettings.setLimit(n);
                    } else if (jCValueArray[n2].attributeName.equalsIgnoreCase("DirXML-LogEvents")) {
                        driverSetLogSettings.setLevel(5);
                        int n3 = (int)((JCIntegerValue)jCValueArray[n2]).getInteger();
                        if (n3 == 0) {
                            driverSetLogSettings.setLevel(3);
                        } else if (n3 == -1) {
                            driverSetLogSettings.setLevel(2);
                        } else {
                            driverSetLogSettings.addEvent(n3);
                        }
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (jCContext != null) {
                    jCContext.free();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LogSettings getDriverSetLogSettings() {
        Object object = settingsGate;
        synchronized (object) {
            if (driverSetLogSettings == null) {
                ConfigAbstraction.initDriverSetLog();
            }
            LogSettings logSettings = driverSetLogSettings;
            return logSettings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetDriverSetLogSettings() {
        Object object = settingsGate;
        synchronized (object) {
            driverSetLogSettings = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static InputStream getAttributeStream(JCContext jCContext, Entry entry, String string) throws IOException {
        NDSStreamAttributeInputStream nDSStreamAttributeInputStream;
        JCContext jCContext2 = null;
        try {
            try {
                jCContext2 = jCContext.duplicate();
                entry.goTo(jCContext2);
                nDSStreamAttributeInputStream = new NDSStreamAttributeInputStream(jCContext2, string);
                Object var6_6 = null;
                if (jCContext2 == null) return nDSStreamAttributeInputStream;
            }
            catch (JCException jCException) {
                throw new IOException(jCException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (jCContext2 == null) throw throwable;
            jCContext2.free();
            throw throwable;
        }
        jCContext2.free();
        return nDSStreamAttributeInputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static OutputStream setAttributeStream(JCContext jCContext, Entry entry, String string) throws IOException {
        NDSStreamAttributeOutputStream nDSStreamAttributeOutputStream;
        JCContext jCContext2 = null;
        try {
            try {
                jCContext2 = jCContext.duplicate();
                entry.goTo(jCContext2);
                nDSStreamAttributeOutputStream = new NDSStreamAttributeOutputStream(jCContext2, string);
                Object var6_6 = null;
                if (jCContext2 == null) return nDSStreamAttributeOutputStream;
            }
            catch (JCException jCException) {
                throw new IOException(jCException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (jCContext2 == null) throw throwable;
            jCContext2.free();
            throw throwable;
        }
        jCContext2.free();
        return nDSStreamAttributeOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAttributeURI(JCContext jCContext, Entry entry, String string) throws JCException {
        JCContext jCContext2;
        String string2 = entry.getDN();
        if (string2 == null) {
            jCContext2 = jCContext.duplicate();
            try {
                entry.initDN(jCContext2);
                string2 = entry.getDN();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                jCContext2.free();
                throw throwable;
            }
            jCContext2.free();
            {
            }
        }
        string2 = jCContext.standardizeDN(entry.getDN(), null);
        jCContext2 = new XdsDN(string2, "00.\\+=*'".toCharArray());
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("vnd.nds.stream:/");
        stringBuffer.append(jCContext2.getDN("00./+=*\\".toCharArray()));
        stringBuffer.append('#');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    Document getAttributeXML(Entry entry, String string) throws VRDException, IOException {
        return ConfigAbstraction.getAttributeXML(this.context, entry, string, this.tracer);
    }

    public static Document getAttributeXML(JCContext jCContext, Entry entry, String string, EngineTrace engineTrace) throws VRDException, IOException {
        XmlDocument xmlDocument = new XmlDocument();
        Document document = null;
        InputStream inputStream = ConfigAbstraction.getAttributeStream(jCContext, entry, string);
        if (((NDSStreamAttributeInputStream)inputStream).available() == 0) {
            inputStream.close();
            throw new EmptyStreamAttributeException();
        }
        try {
            String string2 = ConfigAbstraction.getAttributeURI(jCContext, entry, string);
            engineTrace.trace(READING_XML_ATTR, (MessageSource)messageSource, string2);
            xmlDocument.readDocument(inputStream, string2);
            document = xmlDocument.getDocumentNS();
            inputStream.close();
            if (document == null) {
                throw new VRDException(9013, xmlDocument.getParserErrorMsgString());
            }
            if (document instanceof NodeImpl) {
                ((NodeImpl)document).setBaseURI(string2);
            }
        }
        catch (Exception exception) {
            inputStream.close();
            throw new VRDException(exception);
        }
        return document;
    }

    Document getXMLwithReplacement(Entry entry, String string) throws VRDException, IOException {
        Document document = this.getAttributeXML(entry, string);
        try {
            return this.processDocument(document);
        }
        catch (VRDException vRDException) {
            throw vRDException;
        }
        catch (Exception exception) {
            throw new VRDException(exception);
        }
    }

    void setAttributeXML(Entry entry, String string, Node node) throws VRDException, IOException {
        ConfigAbstraction.setAttributeXML(this.context, entry, string, node, this.tracer);
    }

    public static void setAttributeXML(JCContext jCContext, Entry entry, String string, Node node, EngineTrace engineTrace) throws VRDException, IOException {
        try {
            if (node != null) {
                if (engineTrace.getLevel() > 0) {
                    engineTrace.trace(WRITING_XML_ATTR, (MessageSource)messageSource, ConfigAbstraction.getAttributeURI(jCContext, entry, string));
                }
                OutputStream outputStream = ConfigAbstraction.setAttributeStream(jCContext, entry, string);
                DOMWriter dOMWriter = new DOMWriter(node, outputStream, "UTF-8");
                dOMWriter.setWriteDeclaration(true);
                dOMWriter.setIndent(false);
                dOMWriter.write();
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new VRDException(exception);
        }
    }

    Document getRule(Entry entry, String string, long[] lArray) throws VRDException {
        return this.getReferencedXML(entry, string, "XmlData", lArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Document getReferencedXML(Entry entry, String string, String string2, long[] lArray) throws VRDException {
        JCContext jCContext = null;
        Document document = null;
        try {
            try {
                String string3;
                Object object;
                jCContext = this.context.duplicate();
                entry.goTo(jCContext);
                String[] stringArray = new String[]{string};
                JCReadFilter jCReadFilter = new JCReadFilter(false, null, string);
                try {
                    object = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                    string3 = ((JCDistnameValue)object[0]).getDistname();
                }
                catch (JCException jCException) {
                    if (jCException.getErrorCode() != -603) throw jCException;
                    Document document2 = null;
                    Object var13_15 = null;
                    jCContext.free();
                    return document2;
                }
                object = new Entry(string3);
                if (lArray != null && lArray.length > 0) {
                    ((Entry)object).goTo(jCContext);
                    lArray[0] = ((Entry)object).getEntryID();
                }
                document = this.getXMLwithReplacement((Entry)object, string2);
            }
            catch (Exception exception) {
                VRDException vRDException;
                if (exception instanceof VRDException) throw (VRDException)vRDException;
                vRDException = new VRDException(exception);
                throw (VRDException)vRDException;
            }
            Object var13_16 = null;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            jCContext.free();
            throw throwable;
        }
        jCContext.free();
        return document;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Document getInitParams(String string, String string2) throws VRDException {
        Node node;
        JCContext jCContext = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        try {
            try {
                Node node2;
                Element[] elementArray;
                String string6;
                Object[] objectArray;
                block39: {
                    block38: {
                        JCReadFilter jCReadFilter;
                        block37: {
                            jCContext = this.context.duplicate();
                            this.driver.goTo(jCContext);
                            jCReadFilter = new JCReadFilter();
                            jCReadFilter.attributeNames = initAttr1;
                            try {
                                objectArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                                string4 = ((JCCIstringValue)objectArray[0]).getString();
                            }
                            catch (JCException jCException) {
                                if (jCException.getErrorCode() == -603) break block37;
                                throw jCException;
                            }
                        }
                        string4 = this.replaceGCVRefs(string4, initAttr1[0]);
                        string5 = this.getDriverPassword();
                        jCReadFilter.attributeNames = initAttr2;
                        try {
                            objectArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                            string3 = ((JCCIstringValue)objectArray[0]).getString();
                        }
                        catch (JCException jCException) {
                            if (jCException.getErrorCode() == -603) break block38;
                            throw jCException;
                        }
                    }
                    string3 = this.replaceGCVRefs(string3, initAttr2[0]);
                    objectArray = null;
                    string6 = this.driver.getDN();
                    if (string != null) {
                        try {
                            elementArray = this.getAttributeXML(this.driver, "DirXML-ShimConfigInfo");
                            if (elementArray != null) {
                                objectArray = new Element[string.equals("") ? 3 : 1];
                                if (string.equals("")) {
                                    objectArray[0] = XdsUtil.getFirstElementByTagNameNS((Node)elementArray, null, "driver-options");
                                    objectArray[1] = XdsUtil.getFirstElementByTagNameNS((Node)elementArray, null, "subscriber-options");
                                    objectArray[2] = XdsUtil.getFirstElementByTagNameNS((Node)elementArray, null, "publisher-options");
                                } else {
                                    objectArray[0] = XdsUtil.getFirstElementByTagNameNS((Node)elementArray, null, string);
                                }
                                this.gcvToConfig((Element[])objectArray);
                                this.processDocument((Document)elementArray);
                                this.replaceNamedPasswords((Element[])objectArray);
                            }
                        }
                        catch (IOException iOException) {
                        }
                        catch (Exception exception) {
                            throw new VRDException(exception);
                        }
                        if (string.equals("subscriber-options")) {
                            string6 = this.getSubscriberDN();
                        } else if (string.equals("publisher-options")) {
                            string6 = this.getPublisherDN();
                        }
                    }
                    this.getConfigObjects((Element[])objectArray);
                    elementArray = null;
                    if (string2 != null) {
                        try {
                            node2 = this.getAttributeXML(this.driver, "DirXML-DriverStorage");
                            if (node2 == null) break block39;
                            elementArray = new Element[string2.equals("") ? 3 : 1];
                            if (string2.equals("")) {
                                elementArray[0] = XdsUtil.getFirstElementByTagNameNS(node2, null, "driver-state");
                                elementArray[1] = XdsUtil.getFirstElementByTagNameNS(node2, null, "subscriber-state");
                                elementArray[2] = XdsUtil.getFirstElementByTagNameNS(node2, null, "publisher-state");
                            } else {
                                elementArray[0] = XdsUtil.getFirstElementByTagNameNS(node2, null, string2);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                node2 = NdsDtd.createDoc("input");
                Document document = node2.getOwnerDocument();
                Element element = document.createElementNS(null, "init-params");
                node2.appendChild(element);
                if (string6 != null) {
                    element.setAttributeNS(null, "src-dn", jCContext.standardizeDN(string6, null));
                }
                if (string3 != null || string4 != null || string5 != null) {
                    Element element2;
                    node = document.createElementNS(null, "authentication-info");
                    element.appendChild(node);
                    if (string3 != null) {
                        element2 = document.createElementNS(null, "server");
                        node.appendChild(element2);
                        XdsUtil.setNodeText(element2, string3);
                    }
                    if (string4 != null) {
                        element2 = document.createElementNS(null, "user");
                        node.appendChild(element2);
                        XdsUtil.setNodeText(element2, string4);
                    }
                    if (string5 != null) {
                        element2 = document.createElementNS(null, "password");
                        node.appendChild(element2);
                        XdsUtil.setNodeText(element2, string5);
                    }
                }
                if (string.equals("subscriber-options")) {
                    this.getFilter().toV1FilterXML(element, 0);
                } else if (string.equals("publisher-options")) {
                    this.getFilter().toV1FilterXML(element, 1);
                }
                if (objectArray != null) {
                    int n = 0;
                    while (n < objectArray.length) {
                        if (objectArray[n] != null) {
                            XdsUtil.graftSubtree(element, (Node)objectArray[n]);
                        }
                        ++n;
                    }
                }
                if (elementArray != null) {
                    int n = 0;
                    while (n < elementArray.length) {
                        if (elementArray[n] != null) {
                            XdsUtil.graftSubtree(element, elementArray[n]);
                        }
                        ++n;
                    }
                }
                node = document;
                Object var17_24 = null;
            }
            catch (JCException jCException) {
                throw new VRDException(jCException);
            }
        }
        catch (Throwable throwable) {
            Object var17_25 = null;
            jCContext.free();
            throw throwable;
        }
        jCContext.free();
        return node;
    }

    void replaceNamedPasswords(Element[] elementArray) throws VRDException {
        if (elementArray == null) {
            return;
        }
        int n = 0;
        while (n < elementArray.length) {
            if (elementArray[n] != null) {
                Element[] elementArray2 = XdsUtil.getChildElementsByTagNameWithAttrValueIgnoreCaseNS(elementArray[n], "*", "*", null, "type", "password-ref");
                int n2 = 0;
                while (n2 < elementArray2.length) {
                    String string = XPathUtil.getNodeValue((Node)elementArray2[n2]);
                    if (string == null || string.length() == 0) {
                        throw new VRDException(9149, elementArray2[n2].getAttributeNS(null, "display-name"), (Object)elementArray2[n2].getLocalName());
                    }
                    byte[] byArray = (byte[])this.namedPasswords.get(string);
                    if (byArray == null) {
                        this.tracer.trace(NO_NAMED_PASSWORD, (MessageSource)messageSource, elementArray2[n2].getAttributeNS(null, "display-name"), (Object)elementArray2[n2].getLocalName(), (Object)string);
                    } else {
                        String string2;
                        try {
                            string2 = this.c23(byArray);
                        }
                        catch (DSErr dSErr) {
                            throw new VRDException(9151, string, (Object)dSErr.toString());
                        }
                        this.tracer.trace(USING_NAMED_PASSWORD, (MessageSource)messageSource, string);
                        Text text = elementArray2[n2].getOwnerDocument().createTextNode(string2);
                        XdsUtil.removeAllChildren(elementArray2[n2]);
                        elementArray2[n2].appendChild(text);
                        elementArray2[n2].setAttributeNS(null, "is-sensitive", "true");
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    void gcvToConfig(Element[] elementArray) throws VRDException {
        try {
            int n = 0;
            while (n < elementArray.length) {
                if (elementArray[n] != null) {
                    Node node = elementArray[n].getFirstChild();
                    while (node != null && node.getNodeType() != 1) {
                        node = node.getNextSibling();
                    }
                    if (node != null && node.getNodeName().equals("configuration-values")) {
                        Document document = DocumentFactory.newDocument();
                        Element element = (Element)XdsUtil.cloneSubtree(document, node);
                        document.appendChild(element);
                        DOMUtil.addNamespaceDecls((Node)element);
                        while (elementArray[n].hasChildNodes()) {
                            elementArray[n].removeChild(elementArray[n].getFirstChild());
                        }
                        ShimParams shimParams = ShimParams.constructShimParams((Document)document);
                        Document document2 = elementArray[n].getOwnerDocument();
                        Iterator iterator = shimParams.iterator();
                        while (iterator.hasNext()) {
                            Element element2;
                            GCValue gCValue = (GCValue)iterator.next();
                            if (gCValue.getType() == 7) {
                                String string = gCValue.getName();
                                gCValue = this.getGCVs().getValue(gCValue.getName());
                                if (gCValue == null) {
                                    throw new VRDException(9031, string, ((NodeImpl)elementArray[n]).getBaseURI(), "");
                                }
                            }
                            if (gCValue.getType() == 6) {
                                element2 = document2.createElementNS(null, gCValue.getName());
                                element2.appendChild(document2.createTextNode(gCValue.getValue()));
                                element2.setAttributeNS(null, "display-name", gCValue.getDisplayName());
                                element2.setAttributeNS(null, "type", "password-ref");
                            } else {
                                element2 = document2.createElementNS(null, gCValue.getName());
                                element2.appendChild(document2.createTextNode(gCValue.getValue()));
                                element2.setAttributeNS(null, "display-name", gCValue.getDisplayName());
                            }
                            elementArray[n].appendChild(element2);
                        }
                    }
                }
                ++n;
            }
        }
        catch (DOMException dOMException) {
            throw new VRDException(9175, dOMException.getMessage());
        }
        catch (GCVException gCVException) {
            throw new VRDException(9175, gCVException.getMessage());
        }
    }

    void getConfigObjects(Element[] elementArray) throws VRDException {
        if (elementArray == null) {
            return;
        }
        int n = 0;
        while (n < elementArray.length) {
            Element[] elementArray2;
            if (elementArray[n] != null && (elementArray2 = XdsUtil.getChildElementsByTagNameNS(elementArray[n], null, "config-object")) != null && elementArray2.length > 0) {
                XmlInputProcessor xmlInputProcessor = new XmlInputProcessor(this.getContext(), null, this.tracer);
                xmlInputProcessor.setDriverDN(this.getDriverDN());
                int n2 = 0;
                while (n2 < elementArray2.length) {
                    Element element;
                    int n3;
                    Element element2 = XdsUtil.getFirstChildElementByTagNameNS(elementArray2[n2], null, "query");
                    Element element3 = NdsDtd.createDoc("input");
                    Document document = element3.getOwnerDocument();
                    Element element4 = (Element)XdsUtil.cloneSubtree(document, element2);
                    element3.appendChild(element4);
                    Document document2 = xmlInputProcessor.process(document);
                    Element element5 = XdsUtil.getFirstChildElementByTagNameNS(document2, null, "nds");
                    if (element5 == null) {
                        throw new VRDException(9015);
                    }
                    if ((element5 = XdsUtil.getFirstChildElementByTagNameNS(element5, null, "output")) == null) {
                        throw new VRDException(9015);
                    }
                    Element[] elementArray3 = XdsUtil.getChildElementsByTagNameNS(element5, null, "status");
                    if (elementArray3 != null) {
                        n3 = 0;
                        while (n3 < elementArray3.length) {
                            int n4 = NdsDtd.getStatusLevel(elementArray3[n3]);
                            if (n4 == 3 || n4 == 4) {
                                throw new VRDException(9016, StatusLog.getStatusMessage(elementArray3[n3]));
                            }
                            ++n3;
                        }
                    }
                    NodeList nodeList = document2.getElementsByTagNameNS(null, "instance");
                    n3 = 0;
                    Node node = elementArray2[n2].getParentNode();
                    while ((element = (Element)nodeList.item(n3++)) != null) {
                        Element element6 = (Element)XdsUtil.cloneSubtree(node.getOwnerDocument(), element);
                        node.insertBefore(element6, elementArray2[n2]);
                    }
                    node.removeChild(elementArray2[n2]);
                    ++n2;
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeDriverState(Document document, String string) throws VRDException {
        Object object;
        if (document == null) {
            return;
        }
        Element element = (Element)document.getElementsByTagNameNS(null, string).item(0);
        if (element == null) {
            return;
        }
        Element element2 = XdsUtil.getFirstChildElementByTagNameNS(element, null, "init-params");
        if (element2 == null) {
            return;
        }
        Element[] elementArray = null;
        Node node = element2.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                object = node.getNodeName();
                int n = -1;
                if (((String)object).equals("driver-state")) {
                    n = 0;
                } else if (((String)object).equals("subscriber-state")) {
                    n = 1;
                } else if (((String)object).equals("publisher-state")) {
                    n = 2;
                }
                if (n != -1) {
                    if (elementArray == null) {
                        elementArray = new Element[3];
                        elementArray[2] = null;
                        elementArray[1] = null;
                        elementArray[0] = null;
                    }
                    elementArray[n] = (Element)node;
                }
            }
            node = node.getNextSibling();
        }
        if (elementArray == null) {
            return;
        }
        object = null;
        Object object2 = this.stateGate;
        synchronized (object2) {
            if (elementArray[0] == null || elementArray[1] == null || elementArray[2] == null) {
                try {
                    object = this.getAttributeXML(this.driver, "DirXML-DriverStorage");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (object != null) {
                    element2 = XdsUtil.getFirstChildElementByTagNameNS((Node)object, null, "init-params");
                    if (element2 != null) {
                        int n = 0;
                        while (n < elementArray.length) {
                            if (elementArray[n] != null) {
                                Element element3 = XdsUtil.getFirstChildElementByTagNameNS(element2, null, elementArray[n].getNodeName());
                                XdsUtil.graftSubtree(element2, elementArray[n]);
                                if (element3 != null) {
                                    element2.removeChild(element3);
                                }
                            }
                            ++n;
                        }
                    } else {
                        object = null;
                    }
                }
            }
            if (object == null) {
                object = DocumentFactory.newDocument();
                element2 = object.createElementNS(null, "init-params");
                object.appendChild(element2);
                int n = 0;
                while (n < elementArray.length) {
                    if (elementArray[n] != null) {
                        XdsUtil.graftSubtree(element2, elementArray[n]);
                    }
                    ++n;
                }
            }
            this.tracer.trace(WRITING_DRIVER_STATE, (MessageSource)messageSource);
            try {
                this.setAttributeXML(this.driver, "DirXML-DriverStorage", (Node)object);
            }
            catch (IOException iOException) {
                throw new VRDException(iOException);
            }
        }
    }

    JCContext getContext() throws VRDException {
        JCContext jCContext = new JCContext(0, this.tree, "00.\\+=*'");
        try {
            jCContext.setLocal(0);
            jCContext.nameToID(1, "\\");
            jCContext.authenticate();
        }
        catch (JCException jCException) {
            jCContext.free();
            throw new VRDException(jCException);
        }
        return jCContext;
    }

    JCContext getDriverAuthenticatedContext() throws VRDException {
        JCContext jCContext = new JCContext(0x800000, this.tree, "00.\\+=*'");
        JCContext jCContext2 = this.getContext();
        try {
            try {
                String string = new UID().toString();
                jCContext.connect(0L, jCContext2.getServerReferral());
                this.driver.goTo(jCContext2);
                this.driver.goTo(jCContext);
                while (true) {
                    try {
                        jCContext2.generateKeyPair(string);
                        jCContext.login(string);
                        jCContext.authenticate();
                    }
                    catch (JCException jCException) {
                        if (jCException.getErrorCode() == -684) continue;
                        throw jCException;
                    }
                    break;
                }
                Object var6_6 = null;
            }
            catch (JCException jCException) {
                jCContext.free();
                throw new VRDException(jCException);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            jCContext2.free();
            throw throwable;
        }
        jCContext2.free();
        return jCContext;
    }

    static byte[][] getKeyPair(JCContext jCContext) throws JCException {
        byte[][] byArrayArray;
        block6: {
            byArrayArray = new byte[][]{null, null};
            try {
                JCReadFilter jCReadFilter = new JCReadFilter();
                jCReadFilter.attributeNames = new String[]{"Public Key", "Private Key"};
                JCValue[] jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                int n = 0;
                while (n < jCValueArray.length) {
                    if (jCValueArray[n].attributeName.equalsIgnoreCase("Public Key")) {
                        byArrayArray[0] = ((JCOctetstringValue)jCValueArray[n]).getOctets();
                    } else if (jCValueArray[n].attributeName.equalsIgnoreCase("Private Key")) {
                        byArrayArray[1] = ((JCOctetstringValue)jCValueArray[n]).getOctets();
                    }
                    ++n;
                }
            }
            catch (JCException jCException) {
                int n = jCException.getErrorCode();
                if (n == -602 || n == -603) break block6;
                throw jCException;
            }
        }
        return byArrayArray;
    }

    static void setKeyPair(JCContext jCContext, byte[][] byArray) throws JCException {
        JCValue[] jCValueArray = new JCValue[]{null, null};
        jCValueArray[0] = new JCOctetstringValue("Public Key", 5, 0L, new JCTimestamp(), byArray[0]);
        jCValueArray[1] = new JCOctetstringValue("Private Key", 5, 0L, new JCTimestamp(), byArray[1]);
        if (byArray[0] == null) {
            jCValueArray[0].operation = 6;
        }
        if (byArray[1] == null) {
            jCValueArray[1].operation = 6;
        }
        JClient.modifyEntry((JCContext)jCContext, (JCValue[])jCValueArray);
    }

    JCContext getServerAuthenticatedContext() throws VRDException {
        JCContext jCContext = new JCContext(0x800000, this.tree, "00.\\+=*'");
        try {
            jCContext.loginAsServer();
            jCContext.authenticate();
        }
        catch (JCException jCException) {
            jCContext.free();
            throw new VRDException(jCException);
        }
        return jCContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JCContext getRemoteContext() throws VRDException {
        int[] nArray = this.remoteContextGate;
        synchronized (nArray) {
            while (this.remoteContextGate[0] != 0) {
                try {
                    this.remoteContextGate.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.remoteContext == null) {
                this.remoteContextUseCount = 0;
                JCContext jCContext = null;
                try {
                    try {
                        jCContext = this.context.duplicate();
                        this.getDriver().goTo(jCContext);
                        this.keyPair = ConfigAbstraction.getKeyPair(jCContext);
                        this.remoteContext = this.getDriverAuthenticatedContext();
                    }
                    catch (Throwable throwable) {
                        this.releaseRemoteContext();
                        throw new VRDException(throwable);
                    }
                    Object var5_4 = null;
                    if (jCContext != null) {
                        jCContext.free();
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (jCContext != null) {
                        jCContext.free();
                    }
                    throw throwable;
                }
            }
        }
        ++this.remoteContextUseCount;
        return this.remoteContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void releaseRemoteContext() throws VRDException {
        int[] nArray = this.remoteContextGate;
        synchronized (nArray) {
            if (--this.remoteContextUseCount >= 1) return;
            this.remoteContextUseCount = 0;
            JCContext jCContext = null;
            try {
                try {
                    if (this.keyPair != null) {
                        jCContext = this.context.duplicate();
                        this.getDriver().goTo(jCContext);
                        ConfigAbstraction.setKeyPair(jCContext, this.keyPair);
                        this.keyPair = null;
                        this.remoteContextGate.notifyAll();
                    }
                    if (this.remoteContext != null) {
                        this.remoteContext.free();
                        this.remoteContext = null;
                    }
                }
                catch (JCException jCException) {
                    throw new VRDException(jCException);
                }
                Object var5_3 = null;
                if (jCContext == null) return;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (jCContext == null) throw throwable;
                jCContext.free();
                throw throwable;
            }
            jCContext.free();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockBaseKeyPair() {
        int[] nArray = this.remoteContextGate;
        synchronized (nArray) {
            this.remoteContextGate[0] = this.remoteContextGate[0] + 1;
            while (this.keyPair != null) {
                try {
                    this.remoteContextGate.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockBaseKeyPair() {
        int[] nArray = this.remoteContextGate;
        synchronized (nArray) {
            this.remoteContextGate[0] = this.remoteContextGate[0] - 1;
            this.remoteContextGate.notifyAll();
        }
    }

    protected static void stubbornAuthenticate(JCContext jCContext, int n) throws VRDException {
        int n2 = 0;
        while (true) {
            try {
                jCContext.authenticate();
            }
            catch (JCException jCException) {
                if (++n2 <= n && jCException.getErrorCode() == -632) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw new VRDException(9011, (Throwable)jCException);
            }
            break;
        }
    }

    synchronized Filter getFilter() throws VRDException {
        if (this.filter == null) {
            Document document = this.getFilterDocument();
            this.filter = new Filter(document, this.tracer);
            this.tracer.trace(LOADED_FILTER, (MessageSource)messageSource);
            this.tracer.trace(document);
        }
        return this.filter;
    }

    synchronized void reloadFilter() {
        this.filter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getDriverTraceLevel() {
        int n;
        JCContext jCContext;
        block10: {
            int n2;
            block9: {
                jCContext = null;
                try {
                    try {
                        JCValue[] jCValueArray;
                        JCReadFilter jCReadFilter;
                        block8: {
                            jCContext = this.context.duplicate();
                            this.driver.goTo(jCContext);
                            jCReadFilter = new JCReadFilter(false, null, new String[]{"DirXML-TraceLevel"});
                            jCValueArray = null;
                            try {
                                jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                            }
                            catch (JCException jCException) {
                                if (jCException.getErrorCode() == -603) break block8;
                                throw jCException;
                            }
                        }
                        if (jCValueArray == null || jCValueArray.length == 0) {
                            this.driverSet.goTo(jCContext);
                            jCReadFilter.attributeNames = new String[]{"DirXML-DriverTraceLevel"};
                            jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                        }
                        if (jCValueArray == null || jCValueArray.length == 0) {
                            n2 = 0;
                            Object var6_9 = null;
                            if (jCContext == null) return n2;
                            break block9;
                        }
                        n = (int)((JCIntegerValue)jCValueArray[0]).getInteger();
                        break block10;
                    }
                    catch (Throwable throwable) {
                        int n3 = 0;
                        Object var6_11 = null;
                        if (jCContext == null) return n3;
                        jCContext.free();
                        return n3;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_12 = null;
                    if (jCContext == null) throw throwable;
                    jCContext.free();
                    throw throwable;
                }
            }
            jCContext.free();
            return n2;
        }
        Object var6_10 = null;
        if (jCContext == null) return n;
        jCContext.free();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long getDriverTraceSizeLimit() {
        long l;
        JCContext jCContext;
        block10: {
            long l2;
            block9: {
                jCContext = null;
                try {
                    try {
                        JCValue[] jCValueArray;
                        JCReadFilter jCReadFilter;
                        block8: {
                            jCContext = this.context.duplicate();
                            this.driver.goTo(jCContext);
                            jCReadFilter = new JCReadFilter(false, null, new String[]{"DirXML-TraceSizeLimit"});
                            jCValueArray = null;
                            try {
                                jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                            }
                            catch (JCException jCException) {
                                if (jCException.getErrorCode() == -603) break block8;
                                throw jCException;
                            }
                        }
                        if (jCValueArray == null || jCValueArray.length == 0) {
                            this.driverSet.goTo(jCContext);
                            jCReadFilter.attributeNames = new String[]{"DirXML-TraceSizeLimit"};
                            jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                        }
                        if (jCValueArray == null || jCValueArray.length == 0) {
                            l2 = 0L;
                            Object var7_9 = null;
                            if (jCContext == null) return l2;
                            break block9;
                        }
                        l = (((JCIntegerValue)jCValueArray[0]).getInteger() & 0xFFFFFFFFL) * 1024L;
                        break block10;
                    }
                    catch (Throwable throwable) {
                        long l3 = 0L;
                        Object var7_11 = null;
                        if (jCContext == null) return l3;
                        jCContext.free();
                        return l3;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_12 = null;
                    if (jCContext == null) throw throwable;
                    jCContext.free();
                    throw throwable;
                }
            }
            jCContext.free();
            return l2;
        }
        Object var7_10 = null;
        if (jCContext == null) return l;
        jCContext.free();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getDriverTraceFilename() {
        String string;
        JCContext jCContext;
        block10: {
            String string2;
            block9: {
                jCContext = null;
                try {
                    try {
                        JCValue[] jCValueArray;
                        JCReadFilter jCReadFilter;
                        block8: {
                            jCContext = this.context.duplicate();
                            this.driver.goTo(jCContext);
                            jCReadFilter = new JCReadFilter(false, null, new String[]{"DirXML-TraceFile"});
                            jCValueArray = null;
                            try {
                                jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                            }
                            catch (JCException jCException) {
                                if (jCException.getErrorCode() == -603) break block8;
                                throw jCException;
                            }
                        }
                        if (jCValueArray == null || jCValueArray.length == 0) {
                            this.driverSet.goTo(jCContext);
                            jCReadFilter.attributeNames = new String[]{"DirXML-JavaTraceFile"};
                            jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                        }
                        if (jCValueArray == null || jCValueArray.length == 0) {
                            string2 = null;
                            Object var6_9 = null;
                            if (jCContext == null) return string2;
                            break block9;
                        }
                        string = ((JCCIstringValue)jCValueArray[0]).getString();
                        break block10;
                    }
                    catch (Throwable throwable) {
                        String string3 = null;
                        Object var6_11 = null;
                        if (jCContext == null) return string3;
                        jCContext.free();
                        return string3;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_12 = null;
                    if (jCContext == null) throw throwable;
                    jCContext.free();
                    throw throwable;
                }
            }
            jCContext.free();
            return string2;
        }
        Object var6_10 = null;
        if (jCContext == null) return string;
        jCContext.free();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getDriverTraceName() {
        String string;
        JCContext jCContext = null;
        try {
            try {
                jCContext = this.context.duplicate();
                this.driver.goTo(jCContext);
                JCReadFilter jCReadFilter = new JCReadFilter(false, null, new String[]{"DirXML-TraceName"});
                JCValue[] jCValueArray = null;
                jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                if (jCValueArray == null) throw new Exception();
                if (jCValueArray.length == 0) {
                    throw new Exception();
                }
                string = ((JCCIstringValue)jCValueArray[0]).getString();
                Object var6_9 = null;
                if (jCContext == null) return string;
            }
            catch (Throwable throwable) {
                String string2;
                try {
                    string2 = MiscDS.getEntryRDN(this.getDriverID());
                    Object var6_10 = null;
                    if (jCContext == null) return string2;
                }
                catch (Throwable throwable2) {
                    String string3 = null;
                    Object var6_11 = null;
                    if (jCContext == null) return string3;
                    jCContext.free();
                    return string3;
                }
                jCContext.free();
                return string2;
            }
        }
        catch (Throwable throwable3) {
            Object var6_12 = null;
            if (jCContext == null) throw throwable3;
            jCContext.free();
            throw throwable3;
        }
        jCContext.free();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getGlobalTraceLevel() {
        int n;
        JCContext jCContext;
        block6: {
            int n2;
            block5: {
                jCContext = null;
                try {
                    try {
                        jCContext = MiscDS.createLocalContext();
                        JCReadFilter jCReadFilter = new JCReadFilter(false, null, new String[]{"DirXML-DriverTraceLevel"});
                        JCValue[] jCValueArray = null;
                        jCContext.setEntryID(MiscDS.getDriverSetID(jCContext));
                        jCReadFilter.attributeNames = new String[]{"DirXML-DriverTraceLevel"};
                        jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                        if (jCValueArray == null || jCValueArray.length == 0) {
                            n2 = 0;
                            Object var5_7 = null;
                            if (jCContext == null) return n2;
                            break block5;
                        }
                        n = (int)((JCIntegerValue)jCValueArray[0]).getInteger();
                        break block6;
                    }
                    catch (Throwable throwable) {
                        int n3 = 0;
                        Object var5_9 = null;
                        if (jCContext == null) return n3;
                        jCContext.free();
                        return n3;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    if (jCContext == null) throw throwable;
                    jCContext.free();
                    throw throwable;
                }
            }
            jCContext.free();
            return n2;
        }
        Object var5_8 = null;
        if (jCContext == null) return n;
        jCContext.free();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long getGlobalTraceSizeLimit() {
        long l;
        JCContext jCContext;
        block6: {
            long l2;
            block5: {
                jCContext = null;
                try {
                    try {
                        jCContext = MiscDS.createLocalContext();
                        JCReadFilter jCReadFilter = new JCReadFilter(false, null, new String[]{"DirXML-TraceSizeLimit"});
                        JCValue[] jCValueArray = null;
                        jCContext.setEntryID(MiscDS.getDriverSetID(jCContext));
                        jCReadFilter.attributeNames = new String[]{"DirXML-TraceSizeLimit"};
                        jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                        if (jCValueArray == null || jCValueArray.length == 0) {
                            l2 = 0L;
                            Object var6_7 = null;
                            if (jCContext == null) return l2;
                            break block5;
                        }
                        l = (((JCIntegerValue)jCValueArray[0]).getInteger() & 0xFFFFFFFFL) * 1024L;
                        break block6;
                    }
                    catch (Throwable throwable) {
                        long l3 = 0L;
                        Object var6_9 = null;
                        if (jCContext == null) return l3;
                        jCContext.free();
                        return l3;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    if (jCContext == null) throw throwable;
                    jCContext.free();
                    throw throwable;
                }
            }
            jCContext.free();
            return l2;
        }
        Object var6_8 = null;
        if (jCContext == null) return l;
        jCContext.free();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getGlobalTraceFilename() {
        String string;
        JCContext jCContext;
        block6: {
            String string2;
            block5: {
                jCContext = null;
                try {
                    try {
                        jCContext = MiscDS.createLocalContext();
                        JCReadFilter jCReadFilter = new JCReadFilter(false, null, new String[]{"DirXML-JavaTraceFile"});
                        JCValue[] jCValueArray = null;
                        jCContext.setEntryID(MiscDS.getDriverSetID(jCContext));
                        jCReadFilter.attributeNames = new String[]{"DirXML-DriverTraceLevel"};
                        jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                        if (jCValueArray == null || jCValueArray.length == 0) {
                            string2 = null;
                            Object var5_7 = null;
                            if (jCContext == null) return string2;
                            break block5;
                        }
                        string = ((JCCIstringValue)jCValueArray[0]).getString();
                        break block6;
                    }
                    catch (Throwable throwable) {
                        String string3 = null;
                        Object var5_9 = null;
                        if (jCContext == null) return string3;
                        jCContext.free();
                        return string3;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    if (jCContext == null) throw throwable;
                    jCContext.free();
                    throw throwable;
                }
            }
            jCContext.free();
            return string2;
        }
        Object var5_8 = null;
        if (jCContext == null) return string;
        jCContext.free();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void initializeXSLTrace() {
        Object object = xslGate;
        synchronized (object) {
            ConfigAbstraction.cleanupXSLTrace();
            try {
                ConfigAbstraction.updateXSLTrace();
                JCContext jCContext = null;
                try {
                    jCContext = MiscDS.createLocalContext();
                    xslTraceChangeHandler = new XslTraceChange();
                    long l = MiscDS.getDriverSetID(jCContext);
                    DriverEventMonitor.registerForChange(l, "DirXML-XSLTraceLevel", xslTraceChangeHandler, null);
                    DriverEventMonitor.registerForChange(l, "DirXML-JavaTraceFile", xslTraceChangeHandler, null);
                    Object var5_4 = null;
                    if (jCContext == null) return;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (jCContext == null) throw throwable;
                    jCContext.free();
                    throw throwable;
                }
                jCContext.free();
                {
                }
            }
            catch (Throwable throwable) {
                ConfigAbstraction.cleanupXSLTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanupXSLTrace() {
        Object object = xslGate;
        synchronized (object) {
            ConfigAbstraction.resetXSLTrace();
            JCContext jCContext = null;
            try {
                jCContext = MiscDS.createLocalContext();
                long l = MiscDS.getDriverSetID(jCContext);
                DriverEventMonitor.unregisterForChange(l, "DirXML-JavaTraceFile", xslTraceChangeHandler, null);
                DriverEventMonitor.unregisterForChange(l, "DirXML-XSLTraceLevel", xslTraceChangeHandler, null);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (jCContext != null) {
                    jCContext.free();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetXSLTrace() {
        Object object = xslGate;
        synchronized (object) {
            if (xslOutputStream != null) {
                try {
                    xslOutputStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                xslOutputStream = null;
            }
            if (originalOut != null) {
                System.setOut(originalOut);
                Trace.setPrintWriter((PrintWriter)new PrintWriter(originalOut, true));
                try {
                    Trace.setTraceLevel((int)0);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                originalOut = null;
            }
            if (originalErr != null) {
                System.setErr(originalErr);
                originalErr = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateXSLTrace() {
        Object object = xslGate;
        synchronized (object) {
            block14: {
                JCContext jCContext;
                block13: {
                    block12: {
                        if (originalOut == null) {
                            originalOut = System.out;
                            originalErr = System.err;
                        }
                        PrintStream printStream = originalOut;
                        PrintStream printStream2 = originalErr;
                        jCContext = null;
                        try {
                            try {
                                JCValue[] jCValueArray;
                                block16: {
                                    block15: {
                                        jCContext = MiscDS.createLocalContext();
                                        JCReadFilter jCReadFilter = new JCReadFilter(false, null, new String[]{"DirXML-XSLTraceLevel"});
                                        jCValueArray = null;
                                        jCContext.setEntryID(MiscDS.getDriverSetID(jCContext));
                                        jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                                        if (jCValueArray == null) break block15;
                                        if (jCValueArray.length != 0) break block16;
                                    }
                                    Object var11_7 = null;
                                    if (jCContext == null) return;
                                    break block12;
                                }
                                int n = (int)((JCIntegerValue)jCValueArray[0]).getInteger();
                                String string = ConfigAbstraction.getGlobalTraceFilename();
                                if (string != null) {
                                    try {
                                        xslOutputStream = new FileOutputStream(string);
                                    }
                                    catch (Throwable throwable) {
                                        StatusLog.logError(9066, string, throwable);
                                    }
                                }
                                if (xslOutputStream != null) {
                                    xslOutputStream = new TimestampedOutputStream(xslOutputStream);
                                    SplitterOutputStream splitterOutputStream = new SplitterOutputStream(originalOut, xslOutputStream);
                                    SplitterOutputStream splitterOutputStream2 = new SplitterOutputStream(originalErr, xslOutputStream);
                                    printStream = new PrintStream(splitterOutputStream, true);
                                    printStream2 = new PrintStream(splitterOutputStream2, true);
                                    System.setErr(printStream2);
                                    System.setOut(printStream);
                                }
                                Trace.setPrintWriter((PrintWriter)new PrintWriter(printStream, true));
                                Trace.setTraceLevel((int)n);
                                break block13;
                            }
                            catch (Throwable throwable) {
                                ConfigAbstraction.resetXSLTrace();
                                Object var11_9 = null;
                                if (jCContext == null) return;
                                jCContext.free();
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_10 = null;
                            if (jCContext == null) throw throwable;
                            jCContext.free();
                            throw throwable;
                        }
                    }
                    jCContext.free();
                    return;
                }
                Object var11_8 = null;
                if (jCContext == null) return;
                jCContext.free();
            }
            return;
        }
    }

    Element loadAppSchemaDef() throws VRDException {
        Element element = null;
        try {
            Document document = this.getAttributeXML(this.driver, "DirXML-ApplicationSchema");
            element = XdsUtil.getFirstElementByTagNameNS(document, null, "schema-def");
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            VRDException vRDException;
            if (!(exception instanceof VRDException)) {
                vRDException = new VRDException(exception);
            }
            throw (VRDException)vRDException;
        }
        return element;
    }

    void setAppSchema(AppSchema appSchema) {
        this.appSchema = appSchema;
    }

    AppSchema getAppSchema() {
        return this.appSchema;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getDriverGUID() throws VRDException {
        String string;
        if (this.driverGUID != null) {
            return this.driverGUID;
        }
        JCContext jCContext = null;
        try {
            try {
                String[] stringArray = new String[]{"GUID"};
                jCContext = this.context.duplicate();
                this.driver.goTo(jCContext);
                JCReadFilter jCReadFilter = new JCReadFilter();
                jCReadFilter.attributeNames = stringArray;
                JCValue[] jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                string = StringUtil.GUIDToString(((JCOctetstringValue)jCValueArray[0]).getOctets());
                Object var7_7 = null;
                if (jCContext == null) return string;
            }
            catch (Exception exception) {
                throw new VRDException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (jCContext != null) {
                jCContext.free();
            }
            throw throwable;
        }
        jCContext.free();
        return string;
    }

    native void setDriverThreadID(long var1, boolean var3);

    static native void setThreadEventID(String var0) throws DSErr;

    protected String getDriverPassword() {
        return this.getDriverPassword(this.getDriverID());
    }

    private native String getDriverPassword(long var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initNamedPasswords() throws VRDException {
        this.namedPasswords = new HashMap();
        JCContext jCContext = null;
        try {
            try {
                this.tracer.trace(READING_NAMED_PASSWORDS, (MessageSource)messageSource);
                jCContext = this.context.duplicate();
                this.driver.goTo(jCContext);
                JCReadFilter jCReadFilter = new JCReadFilter();
                jCReadFilter.attributeNames = new String[]{"DirXML-NamedPasswords"};
                JCValue[] jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                int n = 0;
                while (n < jCValueArray.length) {
                    JCOctetlistValue jCOctetlistValue = (JCOctetlistValue)jCValueArray[n];
                    byte[][] byArray = jCOctetlistValue.getOctetstrings();
                    if (byArray.length >= 2) {
                        String string = new String(byArray[0], "UTF-8");
                        this.namedPasswords.put(string, byArray[1]);
                    }
                    ++n;
                }
            }
            catch (JCException jCException) {
                if (jCException.getErrorCode() != -603 && jCException.getErrorCode() != -602) {
                    throw new VRDException(9148, (Throwable)jCException);
                }
                Object var9_11 = null;
                if (jCContext == null) return;
                jCContext.free();
                return;
            }
            catch (Throwable throwable) {
                throw new VRDException(9148, throwable);
            }
            Object var9_10 = null;
            if (jCContext == null) return;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (jCContext == null) throw throwable;
            jCContext.free();
            throw throwable;
        }
        jCContext.free();
    }

    public String getNamedPassword(String string) throws VRDException {
        byte[] byArray = (byte[])this.namedPasswords.get(string);
        if (byArray == null) {
            throw new VRDException(9153, string);
        }
        try {
            this.tracer.trace(GETTING_NAMED_PASSWORD, (MessageSource)messageSource, string);
            return this.c23(byArray);
        }
        catch (DSErr dSErr) {
            throw new VRDException(9151, string, (Object)dSErr.toString());
        }
    }

    private native String c23(byte[] var1) throws DSErr;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document getFilterDocument() throws VRDException {
        block21: {
            var1_1 = null;
            try {
                try {
                    try {
                        var2_2 = this.getXMLwithReplacement(this.driver, "DirXML-DriverFilter");
                        var14_6 = null;
                        if (var1_1 == null) return var2_2;
                        break block21;
                    }
                    catch (IOException var2_3) {
                        var2_4 = new Entry[]{this.subscriber, this.publisher};
                        var3_9 = new byte[][]{null, null};
                        var1_1 = this.context.duplicate();
                        var4_11 = 0;
                    }
                    while (true) {
                        block22: {
                            if (var4_11 >= var2_4.length) break;
                            if (var2_4[var4_11] != null) {
                                var2_4[var4_11].goTo(var1_1);
                                var5_12 = false;
                                try {
                                    try {
                                        var6_14 = JClient.openStream((JCContext)var1_1, (String)"DirXML-DriverFilter", (int)1);
                                        var5_12 = true;
                                        var3_9[var4_11] = new byte[(int)var6_14];
                                        var8_16 = JClient.readStream((JCContext)var1_1, (long)0L, (long)var6_14, (byte[])var3_9[var4_11]);
                                    }
                                    catch (JCException var6_15) {
                                        switch (var6_15.getErrorCode()) {
                                            case -603: 
                                            case -602: 
                                            case -601: {
                                                var11_17 = null;
                                                if (var5_12) {
                                                    try {
                                                        JClient.closeStream((JCContext)var1_1);
                                                    }
                                                    catch (JCException var12_18) {}
                                                }
                                                break block22;
                                            }
                                            default: {
                                                throw new VRDException(9028, (Throwable)var6_15, (Object)var2_4[var4_11].getDN());
                                            }
                                        }
                                    }
                                    var11_17 = null;
                                    if (!var5_12) break block22;
                                }
                                catch (Throwable var10_19) {
                                    var11_17 = null;
                                    if (var5_12 == false) throw var10_19;
                                    ** try [egrp 5[TRYBLOCK] [5 : 201->208)] { 
lbl48:
                                    // 1 sources

                                    JClient.closeStream((JCContext)var1_1);
                                    throw var10_19;
lbl50:
                                    // 1 sources

                                    catch (JCException var12_18) {
                                        // empty catch block
                                    }
                                    throw var10_19;
                                }
                                try {}
                                catch (JCException var12_18) {}
                                JClient.closeStream((JCContext)var1_1);
                            }
                        }
                        ++var4_11;
                    }
                    var5_13 = new FilterUpgrader().upgradeFilters((Object)var3_9[0], (Object)var3_9[1]);
                    var14_7 = null;
                    if (var1_1 == null) return var5_13;
                    var1_1.free();
                    return var5_13;
                }
                catch (VRDException var2_5) {
                    throw var2_5;
                }
                catch (Exception var3_10) {
                    throw new VRDException(9028, (Throwable)var3_10, (Object)this.driver.getDN());
                }
            }
            catch (Throwable var13_20) {
                var14_8 = null;
                if (var1_1 == null) throw var13_20;
                var1_1.free();
                throw var13_20;
            }
        }
        var1_1.free();
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setDriverIdentity(String string, String string2) throws VRDException {
        this.driverIdentityName = string;
        this.driverIdentityVersion = string2;
        JCContext jCContext = null;
        try {
            try {
                jCContext = this.context.duplicate();
                Entry entry = this.getDriver();
                entry.goTo(jCContext);
                JCTimestamp jCTimestamp = new JCTimestamp();
                JClient.modifyEntry((JCContext)jCContext, (JCValue[])new JCValue[]{new JCCIstringValue("DirXML-DriverId", 5, 0L, jCTimestamp, string), new JCCIstringValue("DirXML-DriverVersion", 5, 0L, jCTimestamp, string2)});
            }
            catch (Exception exception) {
                VRDException vRDException = new VRDException(exception);
                if (vRDException.isRetry()) {
                    throw vRDException;
                }
                this.tracer.trace(ERROR_WRITING_DRIVER_ID, (MessageSource)messageSource);
                Object var7_9 = null;
                if (jCContext == null) return;
                jCContext.free();
                return;
            }
            Object var7_8 = null;
            if (jCContext == null) return;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (jCContext == null) throw throwable;
            jCContext.free();
            throw throwable;
        }
        jCContext.free();
    }

    String getDriverIdentityName() {
        if (this.driverIdentityName == null) {
            this.loadDriverIdentity();
        }
        return this.driverIdentityName;
    }

    String getDriverIdentityVersion() {
        if (this.driverIdentityVersion == null) {
            this.loadDriverIdentity();
        }
        return this.driverIdentityVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadDriverIdentity() {
        JCContext jCContext;
        block11: {
            block10: {
                jCContext = null;
                try {
                    try {
                        JCValue[] jCValueArray;
                        block13: {
                            block12: {
                                jCContext = this.context.duplicate();
                                Entry entry = this.getDriver();
                                entry.goTo(jCContext);
                                JCReadFilter jCReadFilter = new JCReadFilter();
                                jCReadFilter.attributeNames = new String[]{"DirXML-DriverId", "DirXML-DriverVersion"};
                                jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                                if (jCValueArray == null) break block12;
                                if (jCValueArray.length != 0) break block13;
                            }
                            Object var7_6 = null;
                            if (jCContext == null) return;
                            break block10;
                        }
                        int n = 0;
                        while (n < jCValueArray.length) {
                            if (jCValueArray[n].attributeName.equalsIgnoreCase("DirXML-DriverId")) {
                                this.driverIdentityName = ((JCCIstringValue)jCValueArray[n]).getString();
                            } else if (jCValueArray[n].attributeName.equalsIgnoreCase("DirXML-DriverVersion")) {
                                this.driverIdentityVersion = ((JCCIstringValue)jCValueArray[n]).getString();
                            }
                            ++n;
                        }
                        break block11;
                    }
                    catch (Exception exception) {
                        Object var7_8 = null;
                        if (jCContext == null) return;
                        jCContext.free();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (jCContext == null) throw throwable;
                    jCContext.free();
                    throw throwable;
                }
            }
            jCContext.free();
            return;
        }
        Object var7_7 = null;
        if (jCContext == null) return;
        jCContext.free();
    }

    public Document processDocument(Document document) throws Exception {
        if (document != null && this.gcvDefs != null) {
            try {
                if (this.gcvDefs.apply((Node)document) && this.tracer.getLevel() > 0) {
                    if (document instanceof NodeImpl) {
                        this.tracer.trace(GCV_REPLACEMENTS_MADE, (MessageSource)messageSource, ((NodeImpl)document).getBaseURI());
                    } else {
                        this.tracer.trace(GCV_REPLACEMENTS_MADE, (MessageSource)messageSource, "");
                    }
                    if (this.tracer.getLevel() > 3) {
                        this.tracer.trace(document);
                    }
                }
            }
            catch (GCValueNotFoundException gCValueNotFoundException) {
                throw new VRDException(9031, gCValueNotFoundException.getValueName(), gCValueNotFoundException.getDocumentURI(), Integer.toString(gCValueNotFoundException.getLineNumber()));
            }
        }
        return document;
    }

    private static class XslTraceChange
    implements DriverEventMonitor.ChangeHandler {
        private XslTraceChange() {
        }

        public void reportChange(long l, long l2, Object object) {
            try {
                ConfigAbstraction.resetXSLTrace();
                ConfigAbstraction.updateXSLTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class TraceChange
    implements DriverEventMonitor.ChangeHandler {
        private TraceChange() {
        }

        public void reportChange(long l, long l2, Object object) {
            try {
                String string = DDSServ.getLocalSchemaName((long)l2);
                if (string.equals("DirXML-TraceLevel") || string.equals("DirXML-DriverTraceLevel")) {
                    ConfigAbstraction.this.tracer.setLevel(ConfigAbstraction.this.getDriverTraceLevel());
                } else if (string.equals("DirXML-TraceFile") || string.equals("DirXML-JavaTraceFile")) {
                    ConfigAbstraction.this.tracer.setTraceFile(ConfigAbstraction.this.getDriverTraceFilename());
                } else if (string.equals("DirXML-TraceName")) {
                    ConfigAbstraction.this.tracer.setShortName(ConfigAbstraction.this.getDriverTraceName());
                } else if (string.equals("DirXML-TraceSizeLimit")) {
                    ConfigAbstraction.this.tracer.setMaxTraceFileSize(ConfigAbstraction.this.getDriverTraceSizeLimit());
                }
            }
            catch (Throwable throwable) {
                StatusLog.logError(9134, MiscDS.getEntryDN(l), throwable);
            }
        }
    }
}

