/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dhutil.DHUtil;
import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.driver.Trace;
import com.novell.nds.dirxml.engine.DriverEventMonitor;
import com.novell.nds.dirxml.engine.DriverList;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.NdsConstants;
import com.novell.nds.dirxml.engine.PersistentLog;
import com.novell.nds.dirxml.engine.SchemaCache;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.act.DirXMLAct;
import com.novell.nds.dirxml.engine.command.DirXMLCommands;
import com.novell.nds.dirxml.engine.controls.ControlValues;
import com.novell.nds.dirxml.engine.url.NDSURLConnection;
import com.novell.nds.dirxml.engine.verb.DirXMLVerbs;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.nds.dstrace.DDSTrace;
import com.novell.nds.dstrace.RedirectStdStream;
import com.novell.nds.events.EventNotification;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import novell.jclient.JCContext;
import novell.jclient.JCEntryInfo;
import novell.jclient.JCEntryInfoCB;
import novell.jclient.JCEntryInfoEmptyFieldException;
import novell.jclient.JCListFilter;
import novell.jclient.JCTimestamp;
import novell.jclient.JClient;

public class DirXML
implements Runnable {
    private static final long SHUTDOWN_MAX_TOTAL_WAIT = 45000L;
    private static final long SHUTDOWN_WAIT_INTERVAL = 250L;
    private static final long SHUTDOWN_MSG_INTERVAL = 5000L;
    private static double ENGINE_TRACE_PRIORITY = 10.0;
    private static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.DirXML");
    private static DirXML engineInstance = null;
    private boolean shuttingDown = false;
    private static boolean runningExternal = true;
    protected static final String ENGINE_THREAD_STARTING = "dxt_etstrt";
    protected static final String ERROR_INITIALIZING = "dxt_erinit";
    protected static final String SHUTTING_DOWN = "dxt_shutdn";
    protected static final String ERROR_SHUTTING_DOWN = "dxt_eshutd";
    protected static final String ENGINE_THREAD_EXITING = "dxt_etexit";
    protected static final String DRIVER_NOT_STARTED = "dxt_dnstrt";
    protected static final String DRIVERS_INITIALIZED = "dxt_dsinit";
    protected static final String WAIT_FOR_DRIVER_STOP = "dxt_wdrvst";
    private long nativeObject = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        block6: {
            block5: {
                DHUtil.initialize();
                try {
                    long l;
                    if (stringArray.length != 1) {
                        String string = "Error starting DirXML: missing address of native object";
                        DDSTrace.trace((int)217, (int)12, (String)string);
                        System.out.println(string);
                        Object var6_3 = null;
                        break block5;
                    }
                    try {
                        l = Long.parseLong(stringArray[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string = "Error starting DirXML: bad address of native object: " + stringArray[0];
                        DDSTrace.trace((int)217, (int)12, (String)string);
                        System.out.println(string);
                        Object var6_4 = null;
                        DHUtil.cleanup();
                        return;
                    }
                    new DirXML(l);
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    DHUtil.cleanup();
                    throw throwable;
                }
            }
            DHUtil.cleanup();
            return;
        }
        Object var6_5 = null;
        DHUtil.cleanup();
    }

    public DirXML(long l) {
        this.nativeObject = l;
        runningExternal = false;
        new Thread((Runnable)this, "DirXML").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block55: {
            Throwable throwable7;
            Throwable throwable22;
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            boolean bl7;
            boolean bl8;
            boolean bl9;
            boolean bl10;
            boolean bl11;
            block56: {
                block54: {
                    bl11 = false;
                    bl10 = false;
                    bl9 = false;
                    bl8 = false;
                    bl7 = false;
                    bl6 = false;
                    bl5 = false;
                    bl4 = false;
                    bl3 = false;
                    bl2 = false;
                    bl = false;
                    DirXML.registerClassExitCallback();
                    try {
                        Throwable throwable32;
                        try {
                            try {
                                engineInstance = this;
                                RedirectStdStream.initialize();
                                bl11 = true;
                                DHUtil.initialize();
                                bl10 = true;
                                DDSTrace.trace((int)217, (int)11, (String)messageSource.getMessageString(ENGINE_THREAD_STARTING));
                                JClient.initialize();
                                bl7 = true;
                                EventNotification.initialize();
                                bl8 = true;
                                DirXMLVerbs.initialize();
                                bl2 = true;
                                DriverEventMonitor.initialize();
                                bl6 = true;
                                EngineTrace.initialize();
                                bl9 = true;
                                DirXMLCommands.initialize();
                                bl5 = true;
                                DirXMLAct.initialize();
                                bl4 = true;
                                PersistentLog.initialize();
                                bl3 = true;
                                NDSURLConnection.enableURLHandlers();
                                this.setUpTrace();
                                SchemaCache.init(null);
                                bl = true;
                                this.initDrivers();
                                DirXMLCommands.processCommands();
                            }
                            catch (Throwable throwable4) {
                                if (bl10) {
                                    String string = messageSource.getMessage(ERROR_INITIALIZING, (Object[])new String[]{DDSTrace.getStackTrace((Throwable)throwable4)});
                                    DDSTrace.trace((int)217, (int)12, (String)string);
                                    string = messageSource.getMessage(SHUTTING_DOWN, null);
                                    DDSTrace.trace((int)217, (int)12, (String)string);
                                }
                                throw throwable4;
                            }
                            try {
                                DirXML.waitToExit(this.nativeObject);
                                this.shuttingDown = true;
                                DriverEventMonitor.shutdown();
                                this.shutdownDrivers();
                            }
                            catch (Throwable throwable5) {
                                String string = messageSource.getMessage(ERROR_SHUTTING_DOWN, (Object[])new String[]{DDSTrace.getStackTrace((Throwable)throwable5)});
                                DDSTrace.trace((int)217, (int)12, (String)string);
                            }
                            Object var15_17 = null;
                            break block54;
                        }
                        catch (Throwable throwable6) {
                            Object var15_18 = null;
                            try {
                                if (bl10) {
                                    DDSTrace.trace((int)217, (int)11, (String)messageSource.getMessageString(ENGINE_THREAD_EXITING));
                                }
                            }
                            catch (Throwable throwable32) {}
                        }
                        while (bl3 || bl4 || bl5 || bl6 || bl8 || bl9 || bl7 || bl10 || bl11 || bl2) {
                            try {
                                if (bl) {
                                    bl = false;
                                    SchemaCache.cleanup();
                                }
                                if (bl3) {
                                    bl3 = false;
                                    PersistentLog.cleanup();
                                }
                                if (bl4) {
                                    bl4 = false;
                                    DirXMLAct.cleanup();
                                }
                                if (bl5) {
                                    bl5 = false;
                                    DirXMLCommands.cleanup();
                                }
                                if (bl9) {
                                    bl9 = false;
                                    EngineTrace.cleanup();
                                }
                                if (bl6) {
                                    bl6 = false;
                                    DriverEventMonitor.cleanup();
                                }
                                if (bl2) {
                                    bl2 = false;
                                    DirXMLVerbs.cleanup();
                                }
                                if (bl8) {
                                    bl8 = false;
                                    EventNotification.shutdown();
                                }
                                if (bl7) {
                                    bl7 = false;
                                    JClient.cleanup();
                                }
                                if (bl10) {
                                    bl10 = false;
                                    DHUtil.cleanup();
                                }
                                if (!bl11) continue;
                                bl11 = false;
                                RedirectStdStream.cleanup();
                            }
                            catch (Throwable throwable32) {
                                // empty catch block
                            }
                        }
                        break block55;
                    }
                    catch (Throwable throwable22) {
                        Object var15_19 = null;
                        try {}
                        catch (Throwable throwable7) {}
                        if (bl10) {
                            DDSTrace.trace((int)217, (int)11, (String)messageSource.getMessageString(ENGINE_THREAD_EXITING));
                        }
                        break block56;
                    }
                }
                try {}
                catch (Throwable throwable8) {}
                if (bl10) {
                    DDSTrace.trace((int)217, (int)11, (String)messageSource.getMessageString(ENGINE_THREAD_EXITING));
                }
                while (bl3 || bl4 || bl5 || bl6 || bl8 || bl9 || bl7 || bl10 || bl11 || bl2) {
                    try {}
                    catch (Throwable throwable8) {
                        // empty catch block
                        continue;
                    }
                    if (bl) {
                        bl = false;
                        SchemaCache.cleanup();
                    }
                    if (bl3) {
                        bl3 = false;
                        PersistentLog.cleanup();
                    }
                    if (bl4) {
                        bl4 = false;
                        DirXMLAct.cleanup();
                    }
                    if (bl5) {
                        bl5 = false;
                        DirXMLCommands.cleanup();
                    }
                    if (bl9) {
                        bl9 = false;
                        EngineTrace.cleanup();
                    }
                    if (bl6) {
                        bl6 = false;
                        DriverEventMonitor.cleanup();
                    }
                    if (bl2) {
                        bl2 = false;
                        DirXMLVerbs.cleanup();
                    }
                    if (bl8) {
                        bl8 = false;
                        EventNotification.shutdown();
                    }
                    if (bl7) {
                        bl7 = false;
                        JClient.cleanup();
                    }
                    if (bl10) {
                        bl10 = false;
                        DHUtil.cleanup();
                    }
                    if (!bl11) continue;
                    bl11 = false;
                    RedirectStdStream.cleanup();
                }
                break block55;
            }
            while (true) {
                if (!(bl3 || bl4 || bl5 || bl6 || bl8 || bl9 || bl7 || bl10 || bl11 || bl2)) {
                    throw throwable22;
                }
                try {}
                catch (Throwable throwable7) {
                    // empty catch block
                    continue;
                }
                if (bl) {
                    bl = false;
                    SchemaCache.cleanup();
                }
                if (bl3) {
                    bl3 = false;
                    PersistentLog.cleanup();
                }
                if (bl4) {
                    bl4 = false;
                    DirXMLAct.cleanup();
                }
                if (bl5) {
                    bl5 = false;
                    DirXMLCommands.cleanup();
                }
                if (bl9) {
                    bl9 = false;
                    EngineTrace.cleanup();
                }
                if (bl6) {
                    bl6 = false;
                    DriverEventMonitor.cleanup();
                }
                if (bl2) {
                    bl2 = false;
                    DirXMLVerbs.cleanup();
                }
                if (bl8) {
                    bl8 = false;
                    EventNotification.shutdown();
                }
                if (bl7) {
                    bl7 = false;
                    JClient.cleanup();
                }
                if (bl10) {
                    bl10 = false;
                    DHUtil.cleanup();
                }
                if (!bl11) continue;
                bl11 = false;
                RedirectStdStream.cleanup();
                continue;
                break;
            }
        }
        engineInstance = null;
        DirXML.finished(this.nativeObject);
    }

    public static boolean isShuttingDown() {
        if (engineInstance != null) {
            return DirXML.engineInstance.shuttingDown;
        }
        return true;
    }

    public static boolean isExternal() {
        return runningExternal;
    }

    private void setUpTrace() throws ClassNotFoundException {
        Trace.registerImpl(Class.forName("com.novell.nds.dirxml.engine.TraceImpl"), ENGINE_TRACE_PRIORITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDrivers() throws DSErr {
        try {
            JCContext jCContext = MiscDS.createLocalContext();
            try {
                long l = MiscDS.getDriverSetID(jCContext);
                jCContext.setEntryID(l);
                JCListFilter jCListFilter = new JCListFilter(false, true, false, false, "DirXML-Driver", "", new JCTimestamp());
                final ArrayList arrayList = new ArrayList();
                JClient.listToCB((JCContext)jCContext, (JCListFilter)jCListFilter, (int)2, (JCEntryInfoCB)new JCEntryInfoCB(){

                    public int entryInfoCallback(JCContext jCContext, JCEntryInfo jCEntryInfo) {
                        try {
                            arrayList.add(new Long(jCEntryInfo.getEntryID()));
                            return 0;
                        }
                        catch (JCEntryInfoEmptyFieldException jCEntryInfoEmptyFieldException) {
                            return 0;
                        }
                    }
                });
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    long l2 = (Long)iterator.next();
                    try {
                        ControlValues controlValues = new ControlValues(EngineTrace.staticTracer);
                        controlValues.readFromDriver(l2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    int n = MiscDS.getDriverStartOption(jCContext, l2);
                    if (n != 2) {
                        if (EngineTrace.staticTracer.getLevel() < 1) continue;
                        EngineTrace.staticTracer.trace(DRIVER_NOT_STARTED, (MessageSource)messageSource, MiscDS.getEntryRDN(l2), (Object)NdsConstants.getDriverStartOptionString(n, 14));
                        continue;
                    }
                    MiscDS.setDriverState(jCContext, l2, 1);
                }
                EngineTrace.staticTracer.trace(DRIVERS_INITIALIZED, (MessageSource)messageSource);
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                jCContext.free();
                throw throwable;
            }
            jCContext.free();
            {
            }
        }
        catch (Throwable throwable) {
            StatusLog.logError(9067, throwable);
            throw MiscDS.translateException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownDrivers() {
        boolean bl = false;
        while (!DriverList.isEmpty() && !bl) {
            try {
                Object var4_7;
                JCContext jCContext = MiscDS.createLocalContext();
                try {
                    DriverList.stopAllDrivers(jCContext);
                    var4_7 = null;
                }
                catch (Throwable throwable) {
                    var4_7 = null;
                    jCContext.free();
                    throw throwable;
                }
                jCContext.free();
                long l = new Date().getTime();
                long l2 = l + 45000L;
                long l3 = l + 5000L;
                long l4 = l;
                while (!DriverList.isEmpty() && (l = new Date().getTime()) < l2) {
                    if (l - l3 > 5000L) {
                        DDSTrace.trace((int)217, (int)14, (String)messageSource.getMessage(WAIT_FOR_DRIVER_STOP, new Object[]{new Integer((int)((l - l4) / 1000L))}));
                        l3 = l;
                    }
                    Thread.sleep(250L);
                }
                if (DriverList.isEmpty()) continue;
                StatusLog.logError(9068, new Integer((int)((l - l4) / 1000L)));
                bl = true;
            }
            catch (DSErr dSErr) {
                DDSTrace.trace((int)214, (int)4, (String)("DSErr shutting down drivers: " + dSErr.getMessage()));
                StatusLog.logError(9069, dSErr);
                bl = true;
            }
            catch (Throwable throwable) {
                DDSTrace.trace((int)214, (int)4, (String)"Throwable shutdown drivers - gave up");
                StatusLog.logError(9069, throwable);
                bl = true;
            }
        }
    }

    private static native void waitToExit(long var0);

    private static native void finished(long var0);

    private static native void registerClassExitCallback();
}

