/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.driver.ThreadGroupLocal;
import com.novell.nds.dirxml.engine.ConfigAbstraction;
import com.novell.nds.dirxml.engine.Driver;
import com.novell.nds.dirxml.engine.DriverList;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.Events;
import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.NdsConstants;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.PersistentLog;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.ThreadGroupVars;
import com.novell.nds.dirxml.engine.ThreadVars;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.act.DirXMLAct;
import com.novell.nds.dirxml.engine.cache.CheckAbort;
import com.novell.nds.dirxml.engine.cache.DriverCache;
import com.novell.nds.dirxml.engine.cache.Transaction;
import com.novell.nds.dirxml.engine.event.DSEEventInfo;
import com.novell.nds.dirxml.util.DxConst;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import novell.jclient.JCContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DriverEntry
implements Runnable,
CheckAbort {
    protected static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.DriverEntry");
    protected static final String REQUEST_RETRY = "det_reqret";
    protected static final String REQUEST_SHUTDOWN = "det_reqtrm";
    protected static final String CREATE_SUBSCRIBER_THREAD = "det_crtst";
    protected static final String SUBSCRIBER_THREAD_STARTING = "det_ststrt";
    protected static final String STARTING_EVENT_LOOP = "det_stevl";
    protected static final String LEAVING_EVENT_LOOP = "det_endevl";
    protected static final String DRIVER_TERMINATED = "det_drtrm";
    protected static final String RECEIVED_STATE_CHANGE_EVENT = "det_stcev";
    protected static final String PROCESSED_STATE_CHANGE_EVENT = "det_stprc";
    protected static final String PROCESSED_FILTER_CHANGE_EVENT = "det_pfprc";
    protected static final String PROCESSED_DRIVER_RESYNC_EVENT = "det_drprc";
    protected static final String STATE_TRANSITION = "det_sttrs";
    protected static final String REQUEST_RESYNC = "det_ccherr";
    protected static final String WAITING_FOR_CACHE = "det_waitch";
    protected static final String STATUS_STATE_CHANGE = "det_stchg";
    protected static final int MAX_CACHE_WAIT_TIME = 20000;
    protected static final int CACHE_WAIT_MESSAGE_INTERVAL = 5000;
    Thread workerThread = null;
    List stateQueue = new ArrayList();
    List eventQueue = new LinkedList();
    List actionQueue = new LinkedList();
    int driverState;
    Date retryExpirationTime = null;
    boolean shuttingDown = false;
    boolean activationInitialized = false;
    Date expiration = null;
    int idVersion = -1;
    String idString = null;
    ConfigAbstraction registry = null;
    Driver driver = null;
    JCContext context = null;
    ThreadGroup driverGroup;
    EngineTrace tracer;

    static void startDriver(long l) {
        try {
            new DriverEntry(l);
        }
        catch (Throwable throwable) {
            StatusLog.logError(9070, MiscDS.getEntryDN(l), throwable);
            new Thread(new ResetDriverState(l)).start();
        }
    }

    private DriverEntry(long l) throws Throwable {
        try {
            this.registry = new ConfigAbstraction(l);
        }
        catch (VRDException vRDException) {
            StatusLog.logError(9071, vRDException);
            throw vRDException;
        }
        ConfigAbstraction.resetDriverSetLogSettings();
        this.tracer = this.registry.getTracer();
        this.context = this.registry.getContext();
        DriverList.addEntry(this);
        try {
            this.startDriverThread();
        }
        catch (Throwable throwable) {
            DriverList.removeEntry(this);
            throw throwable;
        }
    }

    long getEntryID() {
        return this.registry != null ? this.registry.getDriverID() : -1L;
    }

    long getSubEntryID() {
        return this.registry != null ? this.registry.getSubscriberID() : -1L;
    }

    long getPubEntryID() {
        return this.registry != null ? this.registry.getPublisherID() : -1L;
    }

    String getDN() {
        return this.registry != null ? this.registry.getDriverDN() : null;
    }

    String getName() {
        return this.registry != null ? this.registry.getDriverObjectName() : null;
    }

    int getIDVersion() {
        return this.idVersion;
    }

    String getIDString() {
        return this.idString;
    }

    ConfigAbstraction getRegistry() {
        return this.registry;
    }

    EngineTrace getTracer() {
        return this.tracer;
    }

    void writeDriverID(int n, String string) {
        this.idVersion = n;
        this.idString = string;
        DirXMLAct.ActivationState activationState = DirXMLAct.checkDriverActivation(this.getEntryID(), this.getIDString(), this.getIDVersion());
        if (activationState.getState() == 0) {
            this.setRequestShutdown();
            StatusLog.logError(9072);
        }
        this.expiration = activationState.getExpiration();
        if (this.expiration == null) {
            this.expiration = DirXMLAct.getMaxEvaluationExpiration();
        }
    }

    void setRetryDelay(int n) {
        if (this.tracer.getLevel() > 0) {
            this.tracer.trace(REQUEST_RETRY, (MessageSource)messageSource, new Integer(n));
        }
        this.retryExpirationTime = new Date(new Date().getTime() + (long)n * 1000L);
    }

    boolean inRetryDelay() {
        if (this.retryExpirationTime != null) {
            if (this.retryExpirationTime.compareTo(new Date()) > 0) {
                return true;
            }
            this.retryExpirationTime = null;
        }
        return false;
    }

    void setRegistry(ConfigAbstraction configAbstraction) {
        this.registry = configAbstraction;
    }

    void setRequestShutdown() {
        this.tracer.trace(REQUEST_SHUTDOWN, (MessageSource)messageSource);
        try {
            int n = MiscDS.getDriverState(this.context, this.getEntryID());
            if (n == 1) {
                MiscDS.setDriverState(this.context, this.getEntryID(), 2);
                n = MiscDS.getDriverState(this.context, this.getEntryID());
            }
            if (n == 2) {
                MiscDS.setDriverState(this.context, this.getEntryID(), 3);
            }
        }
        catch (DSErr dSErr) {
            StatusLog.logError(9073, dSErr);
        }
        this.shuttingDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueStateChange() {
        List list = this.stateQueue;
        synchronized (list) {
            this.stateQueue.add(Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkStateChange() {
        Boolean bl = null;
        List list = this.stateQueue;
        synchronized (list) {
            if (!this.stateQueue.isEmpty()) {
                bl = (Boolean)this.stateQueue.remove(0);
            }
        }
        return bl != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document submitAction(Document document) throws DSErr {
        ActionEntry actionEntry = new ActionEntry(document);
        List list = this.actionQueue;
        synchronized (list) {
            this.actionQueue.add(actionEntry);
        }
        Document document2 = actionEntry.getResult();
        if (document2 == null) {
            throw new DSErr(-255);
        }
        return document2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEvent(DSEEventInfo dSEEventInfo) {
        List list = this.eventQueue;
        synchronized (list) {
            this.eventQueue.add(dSEEventInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DSEEventInfo removeEvent() {
        DSEEventInfo dSEEventInfo = null;
        List list = this.eventQueue;
        synchronized (list) {
            if (!this.eventQueue.isEmpty()) {
                dSEEventInfo = (DSEEventInfo)this.eventQueue.remove(0);
            }
        }
        return dSEEventInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void shutdown() {
        block9: {
            block8: {
                if (this.driver == null) break block8;
                this.driver.shutdown();
            }
            Object var3_1 = null;
            this.driver = null;
            try {
                DriverList.removeEntry(this.getEntryID());
            }
            catch (Throwable throwable) {
                StatusLog.logError(9073, throwable);
            }
            break block9;
            {
                catch (VRDException vRDException) {
                    StatusLog.logError(9073, vRDException);
                    Object var3_2 = null;
                    this.driver = null;
                    try {
                        DriverList.removeEntry(this.getEntryID());
                    }
                    catch (Throwable throwable) {
                        StatusLog.logError(9073, throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.driver = null;
                try {
                    DriverList.removeEntry(this.getEntryID());
                }
                catch (Throwable throwable2) {
                    StatusLog.logError(9073, throwable2);
                }
                throw throwable;
            }
        }
    }

    protected void startDriverThread() throws VRDException {
        this.tracer.trace(CREATE_SUBSCRIBER_THREAD, (MessageSource)messageSource);
        String string = MiscDS.getEntryRDN(this.getEntryID());
        this.driverGroup = new ThreadGroup(this.getDN());
        this.driverGroup.setDaemon(true);
        ThreadGroupVars.put(this.driverGroup, "vrDriverDN", this.getDN());
        ThreadGroupVars.put(this.driverGroup, "vrDriverRDN", string);
        ThreadGroupVars.put(this.driverGroup, "registry", this.registry);
        ThreadGroup threadGroup = ThreadGroupLocal.setThreadProxyGroup(this.driverGroup);
        ThreadGroupLocal.put("driverDN", this.getDN());
        ThreadGroupLocal.put("driverRDN", string);
        ThreadGroupLocal.setThreadProxyGroup(threadGroup);
        this.workerThread = new Thread(this.driverGroup, this, this.getDN());
        this.workerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block56: {
            block55: {
                block54: {
                    block40: {
                        block53: {
                            block52: {
                                block51: {
                                    block39: {
                                        try {
                                            try {
                                                block44: {
                                                    this.tracer.setSubscriberThread();
                                                    this.tracer.trace("det_ststrt", (MessageSource)DriverEntry.messageSource);
                                                    if (!this.getCacheLock()) break block44;
                                                    try {
                                                        var1_1 = MiscDS.getDriverState(this.context, this.getEntryID());
                                                        var2_3 = var1_1 == 11;
                                                        this.driver = new Driver(this, var2_3);
                                                        if (var2_3) {
                                                            this.driver = null;
                                                            var4_5 = null;
                                                        }
                                                        ** GOTO lbl-1000
                                                    }
                                                    catch (Throwable var3_43) {
                                                        var4_7 = null;
                                                        DriverCache.unlock(this.getEntryID());
                                                        throw var3_43;
                                                    }
                                                    DriverCache.unlock(this.getEntryID());
                                                    var6_8 = null;
                                                    v0 = this.registry != null ? this.getEntryID() : -1L;
                                                    break block39;
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        MiscDS.setDriverState(this.context, this.getEntryID(), 1);
                                                        this.eventLoop();
                                                        var4_6 = null;
                                                        DriverCache.unlock(this.getEntryID());
                                                        break block40;
                                                    }
                                                }
                                                StatusLog.logError(9171);
                                                break block40;
                                            }
                                            catch (VRDException var1_2) {
                                                var6_10 = null;
                                                var7_15 = this.registry != null ? this.getEntryID() : -1L;
                                                var9_20 = null;
                                                try {
                                                    var9_20 = this.context != null ? this.context.duplicate() : MiscDS.createLocalContext();
                                                }
                                                catch (Throwable var10_25) {
                                                    // empty catch block
                                                }
                                                try {
                                                    this.shutdown();
                                                    this.logDriverState(0);
                                                    ThreadVars.removeAll();
                                                    ThreadGroupVars.removeAll();
                                                    ThreadGroupLocal.cleanup();
                                                    DriverList.removeEntry(this.getEntryID());
                                                    ThreadGroupVars.removeAll(this.driverGroup);
                                                    var10_25 = ThreadGroupLocal.setThreadProxyGroup(this.driverGroup);
                                                    ThreadGroupLocal.cleanup();
                                                    ThreadGroupLocal.setThreadProxyGroup((ThreadGroup)var10_25);
                                                    this.tracer.trace("det_drtrm", (MessageSource)DriverEntry.messageSource);
                                                    if (this.registry != null) {
                                                        this.registry.shutdown();
                                                    }
                                                    try {
                                                        if (var9_20 != null && var7_15 != -1L) {
                                                            MiscDS.setDriverState(var9_20, var7_15, 0);
                                                            this.updateState(var9_20, var7_15);
                                                        }
                                                    }
                                                    catch (Throwable var11_30) {
                                                        StatusLog.logError(9073, var11_30);
                                                    }
                                                    v1 = null;
                                                }
                                                catch (Throwable var12_35) {
                                                    v1 = null;
                                                }
                                                var13_40 = v1;
                                                if (var9_20 == null) return;
                                                var9_20.free();
                                                return;
                                            }
                                            catch (Throwable var2_4) {
                                                block47: {
                                                    block46: {
                                                        block45: {
                                                            StatusLog.logError(9074, var2_4);
                                                            var6_11 = null;
                                                            var7_16 = this.registry != null ? this.getEntryID() : -1L;
                                                            var9_21 = null;
                                                            ** try [egrp 4[TRYBLOCK] [10 : 183->210)] { 
lbl86:
                                                            // 1 sources

                                                            var9_21 = this.context != null ? this.context.duplicate() : MiscDS.createLocalContext();
                                                            break block45;
lbl88:
                                                            // 1 sources

                                                            catch (Throwable var10_26) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        ** try [egrp 5[TRYBLOCK] [12 : 212->338)] { 
lbl92:
                                                        // 1 sources

                                                        this.shutdown();
                                                        this.logDriverState(0);
                                                        ThreadVars.removeAll();
                                                        ThreadGroupVars.removeAll();
                                                        ThreadGroupLocal.cleanup();
                                                        DriverList.removeEntry(this.getEntryID());
                                                        ThreadGroupVars.removeAll(this.driverGroup);
                                                        var10_26 = ThreadGroupLocal.setThreadProxyGroup(this.driverGroup);
                                                        ThreadGroupLocal.cleanup();
                                                        ThreadGroupLocal.setThreadProxyGroup((ThreadGroup)var10_26);
                                                        this.tracer.trace("det_drtrm", (MessageSource)DriverEntry.messageSource);
                                                        if (this.registry != null) {
                                                            this.registry.shutdown();
                                                        }
                                                        ** try [egrp 6[TRYBLOCK] [11 : 288->322)] { 
lbl107:
                                                        // 1 sources

                                                        if (var9_21 != null && var7_16 != -1L) {
                                                            MiscDS.setDriverState(var9_21, var7_16, 0);
                                                            this.updateState(var9_21, var7_16);
                                                        }
                                                        break block46;
lbl112:
                                                        // 1 sources

                                                        catch (Throwable var11_31) {
                                                            StatusLog.logError(9073, var11_31);
                                                        }
                                                    }
                                                    v2 = null;
                                                    break block47;
lbl117:
                                                    // 1 sources

                                                    catch (Throwable var12_36) {
                                                        v2 = null;
                                                    }
                                                }
                                                var13_41 = v2;
                                                if (var9_21 == null) return;
                                                var9_21.free();
                                                return;
                                            }
                                        }
                                        catch (Throwable var5_44) {
                                            block50: {
                                                block49: {
                                                    block48: {
                                                        var6_12 = null;
                                                        var7_17 = this.registry != null ? this.getEntryID() : -1L;
                                                        var9_22 = null;
                                                        ** try [egrp 4[TRYBLOCK] [10 : 183->210)] { 
lbl130:
                                                        // 1 sources

                                                        var9_22 = this.context != null ? this.context.duplicate() : MiscDS.createLocalContext();
                                                        break block48;
lbl132:
                                                        // 1 sources

                                                        catch (Throwable var10_27) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    ** try [egrp 5[TRYBLOCK] [12 : 212->338)] { 
lbl136:
                                                    // 1 sources

                                                    this.shutdown();
                                                    this.logDriverState(0);
                                                    ThreadVars.removeAll();
                                                    ThreadGroupVars.removeAll();
                                                    ThreadGroupLocal.cleanup();
                                                    DriverList.removeEntry(this.getEntryID());
                                                    ThreadGroupVars.removeAll(this.driverGroup);
                                                    var10_27 = ThreadGroupLocal.setThreadProxyGroup(this.driverGroup);
                                                    ThreadGroupLocal.cleanup();
                                                    ThreadGroupLocal.setThreadProxyGroup((ThreadGroup)var10_27);
                                                    this.tracer.trace("det_drtrm", (MessageSource)DriverEntry.messageSource);
                                                    if (this.registry != null) {
                                                        this.registry.shutdown();
                                                    }
                                                    ** try [egrp 6[TRYBLOCK] [11 : 288->322)] { 
lbl151:
                                                    // 1 sources

                                                    if (var9_22 != null && var7_17 != -1L) {
                                                        MiscDS.setDriverState(var9_22, var7_17, 0);
                                                        this.updateState(var9_22, var7_17);
                                                    }
                                                    break block49;
lbl156:
                                                    // 1 sources

                                                    catch (Throwable var11_32) {
                                                        StatusLog.logError(9073, var11_32);
                                                    }
                                                }
                                                v3 = null;
                                                break block50;
lbl161:
                                                // 1 sources

                                                catch (Throwable var12_37) {
                                                    v3 = null;
                                                }
                                            }
                                            var13_42 = v3;
                                            if (var9_22 == null) throw var5_44;
                                            var9_22.free();
                                            throw var5_44;
                                        }
                                    }
                                    var7_13 = v0;
                                    var9_18 = null;
                                    ** try [egrp 4[TRYBLOCK] [10 : 183->210)] { 
lbl172:
                                    // 1 sources

                                    var9_18 = this.context != null ? this.context.duplicate() : MiscDS.createLocalContext();
                                    break block51;
lbl174:
                                    // 1 sources

                                    catch (Throwable var10_23) {
                                        // empty catch block
                                    }
                                }
                                ** try [egrp 5[TRYBLOCK] [12 : 212->338)] { 
lbl178:
                                // 1 sources

                                this.shutdown();
                                this.logDriverState(0);
                                ThreadVars.removeAll();
                                ThreadGroupVars.removeAll();
                                ThreadGroupLocal.cleanup();
                                DriverList.removeEntry(this.getEntryID());
                                ThreadGroupVars.removeAll(this.driverGroup);
                                var10_23 = ThreadGroupLocal.setThreadProxyGroup(this.driverGroup);
                                ThreadGroupLocal.cleanup();
                                ThreadGroupLocal.setThreadProxyGroup((ThreadGroup)var10_23);
                                this.tracer.trace("det_drtrm", (MessageSource)DriverEntry.messageSource);
                                if (this.registry != null) {
                                    this.registry.shutdown();
                                }
                                ** try [egrp 6[TRYBLOCK] [11 : 288->322)] { 
lbl193:
                                // 1 sources

                                if (var9_18 != null && var7_13 != -1L) {
                                    MiscDS.setDriverState(var9_18, var7_13, 0);
                                    this.updateState(var9_18, var7_13);
                                }
                                break block52;
lbl198:
                                // 1 sources

                                catch (Throwable var11_28) {
                                    StatusLog.logError(9073, var11_28);
                                }
                            }
                            v4 = null;
                            break block53;
lbl203:
                            // 1 sources

                            catch (Throwable var12_33) {
                                v4 = null;
                            }
                        }
                        var13_38 = v4;
                        if (var9_18 == null) return;
                        var9_18.free();
                        return;
                    }
                    var6_9 = null;
                    var7_14 = this.registry != null ? this.getEntryID() : -1L;
                    var9_19 = null;
                    ** try [egrp 4[TRYBLOCK] [10 : 183->210)] { 
lbl215:
                    // 1 sources

                    var9_19 = this.context != null ? this.context.duplicate() : MiscDS.createLocalContext();
                    break block54;
lbl217:
                    // 1 sources

                    catch (Throwable var10_24) {
                        // empty catch block
                    }
                }
                ** try [egrp 5[TRYBLOCK] [12 : 212->338)] { 
lbl221:
                // 1 sources

                this.shutdown();
                this.logDriverState(0);
                ThreadVars.removeAll();
                ThreadGroupVars.removeAll();
                ThreadGroupLocal.cleanup();
                DriverList.removeEntry(this.getEntryID());
                ThreadGroupVars.removeAll(this.driverGroup);
                var10_24 = ThreadGroupLocal.setThreadProxyGroup(this.driverGroup);
                ThreadGroupLocal.cleanup();
                ThreadGroupLocal.setThreadProxyGroup((ThreadGroup)var10_24);
                this.tracer.trace("det_drtrm", (MessageSource)DriverEntry.messageSource);
                if (this.registry != null) {
                    this.registry.shutdown();
                }
                ** try [egrp 6[TRYBLOCK] [11 : 288->322)] { 
lbl236:
                // 1 sources

                if (var9_19 != null && var7_14 != -1L) {
                    MiscDS.setDriverState(var9_19, var7_14, 0);
                    this.updateState(var9_19, var7_14);
                }
                break block55;
lbl241:
                // 1 sources

                catch (Throwable var11_29) {
                    StatusLog.logError(9073, var11_29);
                }
            }
            v5 = null;
            break block56;
lbl246:
            // 1 sources

            catch (Throwable var12_34) {
                v5 = null;
            }
        }
        var13_39 = v5;
        if (var9_19 == null) return;
        var9_19.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getCacheLock() {
        if (!DriverCache.lock(this.getEntryID())) {
            block5: {
                long l = new Date().getTime();
                this.tracer.pushColor(14);
                try {
                    long l2 = l;
                    long l3 = l;
                    while (!DriverCache.lock(this.getEntryID()) && l2 - l < 20000L) {
                        this.sleep(100L);
                        l2 = new Date().getTime();
                        if (l2 - l3 < 5000L) continue;
                        this.tracer.trace(WAITING_FOR_CACHE, (MessageSource)messageSource, Integer.toString((int)(l2 - l) / 1000));
                        l3 = l2;
                    }
                    if (DriverCache.lock(this.getEntryID())) break block5;
                    boolean bl = false;
                    Object var9_5 = null;
                    this.tracer.popColor();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var9_7 = null;
                    this.tracer.popColor();
                    throw throwable;
                }
            }
            Object var9_6 = null;
            this.tracer.popColor();
        }
        return true;
    }

    private void eventLoop() {
        this.tracer.trace(STARTING_EVENT_LOOP, (MessageSource)messageSource);
        DriverCache driverCache = new DriverCache(this.getEntryID(), this.tracer);
        driverCache.setCheckAbort(this);
        while (!this.abort()) {
            try {
                if (DirXMLAct.checkEngineActivation().getState() == 0) {
                    this.setRequestShutdown();
                    StatusLog.logError(9075);
                    break;
                }
                this.processWork();
                this.processStateChange();
                this.processQueuedEvent();
                boolean bl = this.processAction();
                if (this.expiration != null && this.expiration.compareTo(new Date()) <= 0) {
                    DirXMLAct.ActivationState activationState = DirXMLAct.checkDriverActivation(this.getEntryID(), this.getIDString(), this.getIDVersion());
                    if (activationState.getState() == 0) {
                        this.setRequestShutdown();
                        StatusLog.logError(9072);
                    }
                    this.expiration = activationState.getExpiration();
                    if (this.expiration == null) {
                        this.expiration = DirXMLAct.getMaxEvaluationExpiration();
                    }
                }
                if (this.abort() || bl || this.processCachedTransaction(driverCache)) continue;
                this.sleep(100L);
            }
            catch (Throwable throwable) {
                StatusLog.logError(9076, throwable);
                driverCache = new DriverCache(this.getEntryID(), this.tracer);
                driverCache.setCheckAbort(this);
            }
        }
        this.abortActions();
        this.tracer.trace(LEAVING_EVENT_LOOP, (MessageSource)messageSource);
    }

    private void processStateChange() {
        if (this.checkStateChange()) {
            try {
                this.tracer.trace(RECEIVED_STATE_CHANGE_EVENT, (MessageSource)messageSource);
                int n = this.updateState();
                if (n == 1) {
                    MiscDS.setDriverState(this.context, this.getEntryID(), 2);
                    this.logDriverState(2);
                } else if (n == 3) {
                    this.shuttingDown = true;
                }
                this.tracer.trace(PROCESSED_STATE_CHANGE_EVENT, (MessageSource)messageSource);
                this.retryExpirationTime = null;
            }
            catch (Throwable throwable) {
                StatusLog.logError(9077, throwable);
            }
        }
    }

    private void processQueuedEvent() {
        DSEEventInfo dSEEventInfo = this.removeEvent();
        if (dSEEventInfo == null) {
            return;
        }
        try {
            ArrayList<DSEEventInfo> arrayList = new ArrayList<DSEEventInfo>(1);
            arrayList.add(dSEEventInfo);
            Transaction transaction = new Transaction(this.getEntryID(), arrayList);
            this.submitTransaction(transaction);
            this.tracer.trace(PROCESSED_DRIVER_RESYNC_EVENT, (MessageSource)messageSource);
        }
        catch (Throwable throwable) {
            StatusLog.logError(9078, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processAction() {
        ActionEntry actionEntry = null;
        List list = this.actionQueue;
        synchronized (list) {
            if (!this.actionQueue.isEmpty()) {
                actionEntry = (ActionEntry)this.actionQueue.remove(0);
            }
        }
        if (actionEntry != null) {
            actionEntry.setResult(this.driver.submitAction(actionEntry.getAction()));
        }
        List list2 = this.actionQueue;
        synchronized (list2) {
            boolean bl = !this.actionQueue.isEmpty();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortActions() {
        List list = this.actionQueue;
        synchronized (list) {
            while (!this.actionQueue.isEmpty()) {
                ActionEntry actionEntry = (ActionEntry)this.actionQueue.remove(0);
                actionEntry.releaseWaiting();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean processCachedTransaction(DriverCache var1_1) {
        if (this.inRetryDelay()) {
            return false;
        }
        var2_2 = var1_1.getTransaction();
        try {
            this.initActivation();
            if (!var2_2.isDataAvailable()) {
                return false;
            }
            var3_3 = null;
            ** GOTO lbl19
            {
                if (this.abort()) {
                    throw new DriverFatalException("Aborting processing cached transaction.");
                }
                this.sleep(100L);
                this.processWork();
                this.processStateChange();
                do {
                    if (!var2_2.getEvent()) continue block6;
                    this.processWork();
                    this.processStateChange();
lbl19:
                    // 2 sources

                } while (!this.abort() && !var2_2.isEndTransaction());
            }
            if (var2_2.isEndTransaction()) {
                this.submitTransaction(var2_2);
                var2_2.commit();
                if (var3_3 != null) {
                    throw var3_3;
                }
            } else {
                var2_2.abort();
            }
        }
        catch (DriverRetryException var3_4) {
        }
        catch (DriverFatalException var4_6) {
            this.setRequestShutdown();
        }
        catch (Throwable var5_7) {
            StatusLog.logError(9080, var5_7);
        }
        if (!var2_2.isCommitted()) {
            try {
                var2_2.abort();
            }
            catch (IOException var3_5) {
                StatusLog.logError(9081, var3_5);
            }
        }
        return var2_2.isDataAvailable();
    }

    private void processWork() throws VRDException {
        if (this.driver != null) {
            this.driver.processWork();
        }
    }

    private int updateState() throws DSErr {
        return this.updateState(this.context, this.getEntryID());
    }

    private int updateState(JCContext jCContext, long l) throws DSErr {
        int n = this.driverState;
        int n2 = MiscDS.getDriverState(jCContext, l);
        if (this.tracer.getLevel() > 0) {
            this.tracer.trace(STATE_TRANSITION, (MessageSource)messageSource, NdsConstants.getDriverStateString(n, 14), (Object)NdsConstants.getDriverStateString(n2, 14));
        }
        this.driverState = n2;
        return n2;
    }

    private void submitTransaction(Transaction transaction) throws DriverRetryException, DriverFatalException {
        try {
            DSEEventInfo dSEEventInfo = transaction.getEndTransaction();
            if (dSEEventInfo == null) {
                return;
            }
            if (dSEEventInfo.getType() == 10) {
                this.tracer.trace(REQUEST_RESYNC, (MessageSource)messageSource);
                try {
                    MiscDS.resyncDriver(this.context, this.getEntryID(), dSEEventInfo.getSeconds());
                }
                catch (DSErr dSErr) {
                    StatusLog.logError(9082, dSErr);
                }
            } else {
                this.driver.submitTransaction(transaction);
            }
        }
        catch (VRDException vRDException) {
            StatusLog.log(vRDException);
            if (vRDException.isRetry()) {
                if (this.retryExpirationTime == null) {
                    this.driver.setDriverRetryDelay();
                }
                throw new DriverRetryException();
            }
            if (vRDException.isFatal()) {
                throw new DriverFatalException(vRDException.getMessage());
            }
            StatusLog.logError(9083, vRDException);
        }
        catch (Throwable throwable) {
            StatusLog.logError(9083, throwable);
        }
    }

    private void initActivation() throws DriverRetryException, DriverFatalException {
        if (this.activationInitialized) {
            return;
        }
        try {
            this.driver.initActivation();
            this.activationInitialized = true;
        }
        catch (VRDException vRDException) {
            StatusLog.log(vRDException);
            if (vRDException.isRetry()) {
                throw new DriverRetryException();
            }
            if (vRDException.isFatal()) {
                throw new DriverFatalException(vRDException.getMessage());
            }
            StatusLog.logError(9083, vRDException);
        }
        catch (Throwable throwable) {
            StatusLog.logError(9083, throwable);
        }
    }

    public boolean abort() {
        return this.shuttingDown;
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void logDriverState(int n) {
        String string = messageSource.getMessage(STATUS_STATE_CHANGE, new Object[]{DxConst.getDriverStateString((int)n)});
        int n2 = 0;
        if (n == 0) {
            n2 = 2;
        }
        Document document = NdsDtd.createStatusDocument(n2, null, string);
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "status");
        element.setAttributeNS(null, "type", "driver-status");
        StatusLog.addLogDataElements(element);
        PersistentLog.logEvent(n == 2 ? 34 : 35, Events.convertLevel(n2), this.getDN(), 1L, "DirXML-State", null, null, string, (long)n, 0L, element);
    }

    private static class ActionEntry {
        Document action;
        Document result;

        ActionEntry(Document document) {
            this.action = document;
            this.result = null;
        }

        Document getAction() {
            return this.action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Document getResult() {
            ActionEntry actionEntry = this;
            synchronized (actionEntry) {
                if (this.result == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Document document = this.result;
                return document;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setResult(Document document) {
            ActionEntry actionEntry = this;
            synchronized (actionEntry) {
                this.result = document;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseWaiting() {
            ActionEntry actionEntry = this;
            synchronized (actionEntry) {
                this.notifyAll();
            }
        }
    }

    private static class ResetDriverState
    implements Runnable {
        private long entryID;

        ResetDriverState(long l) {
            this.entryID = l;
        }

        public void run() {
            try {
                MiscDS.setDriverState(MiscDS.createLocalContext(), this.entryID, 0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static class DriverRetryException
    extends Exception {
        DriverRetryException() {
        }
    }

    static class DriverFatalException
    extends Exception {
        DriverFatalException(String string) {
            super(string);
        }
    }
}

