/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dhutil.DDSServ;
import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dhutil.Lock;
import com.novell.nds.dirxml.engine.DriverEntry;
import com.novell.nds.dirxml.engine.DriverList;
import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.events.EntryEventHandler;
import com.novell.nds.events.EventException;
import com.novell.nds.events.EventNotification;
import com.novell.nds.events.SyncArrayList;
import com.novell.nds.events.ValueEventHandler;
import com.novell.nds.events.entries.DSEEntryInfo;
import com.novell.nds.events.values.DSEValueInfo;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import novell.jclient.JCContext;
import novell.jclient.JCEntryInfo;
import novell.jclient.JCEntryInfoEmptyFieldException;
import novell.jclient.JCException;
import novell.jclient.JClient;

class DriverEventMonitor {
    private static DriverEventMonitor eventHandler = null;
    private JCContext context;
    private DriverStateHandler stateHandler;
    private DriverConfigHandler changeHandler;
    private boolean shuttingDown = false;
    protected static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.DriverEventMonitor");

    static void initialize() throws DSErr {
        if (eventHandler != null) {
            return;
        }
        eventHandler = new DriverEventMonitor();
        try {
            EventNotification.registerForEntryEvent((int)0, (int)215, (int)0, (EntryEventHandler)DriverEventMonitor.eventHandler.stateHandler, (String)"DirXML-Driver");
        }
        catch (DSErr dSErr) {
            eventHandler = null;
            StatusLog.logError(9086, dSErr);
            throw dSErr;
        }
        catch (EventException eventException) {
            eventHandler = null;
            StatusLog.logError(9086, eventException);
            throw new DSErr(eventException.getCode());
        }
    }

    static void shutdown() {
        if (eventHandler != null) {
            DriverEventMonitor.eventHandler.shuttingDown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void cleanup() {
        if (eventHandler == null) return;
        try {
            try {
                EventNotification.unregisterForEntryEvent((int)0, (int)215, (EntryEventHandler)DriverEventMonitor.eventHandler.stateHandler, (String)"DirXML-Driver");
            }
            catch (DSErr dSErr) {
                Object var3_1 = null;
                DriverEventMonitor.eventHandler.context.free();
                eventHandler = null;
                return;
            }
            catch (EventException eventException) {
                Object var3_2 = null;
                DriverEventMonitor.eventHandler.context.free();
                eventHandler = null;
                return;
            }
            Object var3 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            DriverEventMonitor.eventHandler.context.free();
            eventHandler = null;
            throw throwable;
        }
        DriverEventMonitor.eventHandler.context.free();
        eventHandler = null;
    }

    public static void registerForChange(long l, String string, ChangeHandler changeHandler, Object object) throws DSErr {
        try {
            if (eventHandler != null) {
                long l2 = eventHandler.getClassID(l);
                long l3 = DDSServ.getLocalAttributeID((String)string);
                DriverEventMonitor.eventHandler.changeHandler.registerForChange(l, l2, l3, changeHandler, object);
            }
        }
        catch (JCException jCException) {
            throw new DSErr(jCException.getErrorCode());
        }
        catch (EventException eventException) {
            StatusLog.logError(9133, eventException);
            throw new DSErr(-319);
        }
    }

    public static void unregisterForChange(long l, String string, ChangeHandler changeHandler, Object object) throws DSErr {
        try {
            if (eventHandler != null) {
                long l2 = eventHandler.getClassID(l);
                long l3 = DDSServ.getLocalAttributeID((String)string);
                DriverEventMonitor.eventHandler.changeHandler.unregisterForChange(l, l2, l3, changeHandler, object);
            }
        }
        catch (JCException jCException) {
            throw new DSErr(jCException.getErrorCode());
        }
        catch (EventException eventException) {
            StatusLog.logError(9133, eventException);
            throw new DSErr(-319);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getClassID(long l) throws JCException, DSErr {
        long l2;
        JCContext jCContext = this.context.duplicate();
        try {
            try {
                jCContext.setEntryID(l);
                JCEntryInfo jCEntryInfo = JClient.getEntryInfo((JCContext)jCContext, (int)2048);
                l2 = DDSServ.getLocalClassID((String)jCEntryInfo.getBaseClass());
                Object var8_6 = null;
            }
            catch (JCEntryInfoEmptyFieldException jCEntryInfoEmptyFieldException) {
                StatusLog.logError(9133, jCEntryInfoEmptyFieldException);
                throw new JCException("getClassID", -319);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            jCContext.free();
            throw throwable;
        }
        jCContext.free();
        return l2;
    }

    private DriverEventMonitor() throws DSErr {
        try {
            this.context = MiscDS.createLocalContext();
            this.stateHandler = new DriverStateHandler();
            this.changeHandler = new DriverConfigHandler();
        }
        catch (JCException jCException) {
            throw new DSErr(jCException.getErrorCode());
        }
    }

    private static class RegistrationRecord {
        private int useCount = 0;

        private RegistrationRecord() {
        }

        int incUseCount() {
            return ++this.useCount;
        }

        int decUseCount() {
            return --this.useCount;
        }
    }

    private static class EntryKey
    implements Comparable {
        private long entryID;
        private long attrID;

        EntryKey(long l, long l2) {
            this.entryID = l;
            this.attrID = l2;
        }

        public int hashCode() {
            return (int)(this.entryID ^ this.entryID >>> 32) ^ (int)(this.attrID ^ this.attrID >>> 32);
        }

        public boolean equals(Object object) {
            if (object instanceof EntryKey) {
                EntryKey entryKey = (EntryKey)object;
                return this.entryID == entryKey.entryID && this.attrID == entryKey.attrID;
            }
            return false;
        }

        public int compareTo(Object object) {
            if (object instanceof EntryKey) {
                EntryKey entryKey = (EntryKey)object;
                long l = this.entryID - entryKey.entryID;
                if (l == 0L) {
                    l = this.attrID - entryKey.attrID;
                }
                return (int)l;
            }
            return -1;
        }
    }

    private static class HandlerEntry {
        private Object data;
        private ChangeHandler handler;

        HandlerEntry(ChangeHandler changeHandler, Object object) {
            this.handler = changeHandler;
            this.data = object;
        }

        public boolean equals(Object object) {
            if (object instanceof HandlerEntry) {
                HandlerEntry handlerEntry = (HandlerEntry)object;
                return this.handler == handlerEntry.handler && this.data == handlerEntry.data;
            }
            return false;
        }
    }

    public static interface ChangeHandler {
        public void reportChange(long var1, long var3, Object var5);
    }

    private class DriverConfigHandler
    implements ValueEventHandler {
        private Map handlers = new TreeMap();
        private Map registration = new TreeMap();
        private Lock lock = new Lock();

        private DriverConfigHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int handleEvent(int n, DSEValueInfo dSEValueInfo, int n2) {
            try {
                EntryKey entryKey = new EntryKey(dSEValueInfo.getEntryID(), dSEValueInfo.getAttrID());
                this.lock.lockForRead();
                try {
                    SyncArrayList syncArrayList = (SyncArrayList)this.handlers.get(entryKey);
                    if (syncArrayList != null) {
                        syncArrayList.lockForRead();
                        try {
                            Iterator iterator = syncArrayList.iterator();
                            while (iterator.hasNext()) {
                                HandlerEntry handlerEntry = (HandlerEntry)iterator.next();
                                handlerEntry.handler.reportChange(dSEValueInfo.getEntryID(), dSEValueInfo.getAttrID(), handlerEntry.data);
                            }
                            Object var9_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_10 = null;
                            syncArrayList.unlockForRead();
                            throw throwable;
                        }
                        syncArrayList.unlockForRead();
                        {
                        }
                    }
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    this.lock.unlockForRead();
                    throw throwable;
                }
                this.lock.unlockForRead();
                {
                }
            }
            catch (Throwable throwable) {
                StatusLog.logError(9133, throwable);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void registerForChange(long var1_2, long var3_3, long var5_4, ChangeHandler var7_5, Object var8_1) throws EventException, DSErr {
            var9_6 = new EntryKey(var1_2, var5_4);
            this.lock.lockForWrite();
            try {
                var10_7 = (SyncArrayList)this.handlers.get(var9_6);
                if (var10_7 == null) {
                    var10_7 = new SyncArrayList();
                    this.handlers.put(var9_6, var10_7);
                }
                var11_8 = new HandlerEntry(var7_5, var8_1);
                var10_7.lockForWrite();
                try {
                    var12_9 = var10_7.iterator();
                    ** GOTO lbl-1000
                }
                catch (Throwable var13_16) {
                    var14_12 = null;
                    var10_7.unlockForWrite();
                    throw var13_16;
                }
lbl19:
                // 1 sources

                while (true) {
                    var10_7.unlockForWrite();
                    var16_13 = null;
                    this.lock.unlockForWrite();
                    return;
                }
lbl-1000:
                // 1 sources

                {
                    block10: {
                        do {
                            if (!var12_9.hasNext()) break block10;
                        } while (!((HandlerEntry)var12_9.next()).equals(var11_8));
                        var14_10 = null;
                        ** continue;
                    }
                    var10_7.add((Object)var11_8);
                    var14_11 = null;
                    var10_7.unlockForWrite();
                }
                var12_9 = new EntryKey(var3_3, var5_4);
                var13_17 = (RegistrationRecord)this.registration.get(var12_9);
                if (var13_17 == null) {
                    var13_17 = new RegistrationRecord();
                    this.registration.put(var12_9, var13_17);
                }
                if (var13_17.incUseCount() == 1) {
                    EventNotification.registerForValueEvent((int)2, (int)5, (int)0, (ValueEventHandler)this, (long)var3_3, (long)var5_4);
                    EventNotification.registerForValueEvent((int)2, (int)6, (int)0, (ValueEventHandler)this, (long)var3_3, (long)var5_4);
                }
                var16_14 = null;
                this.lock.unlockForWrite();
                return;
            }
            catch (Throwable var15_18) {
                var16_15 = null;
                this.lock.unlockForWrite();
                throw var15_18;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterForChange(long l, long l2, long l3, ChangeHandler changeHandler, Object object) throws EventException, DSErr {
            EntryKey entryKey = new EntryKey(l, l3);
            this.lock.lockForWrite();
            try {
                Object object2;
                SyncArrayList syncArrayList = (SyncArrayList)this.handlers.get(entryKey);
                if (syncArrayList == null) {
                    syncArrayList = new SyncArrayList();
                }
                HandlerEntry handlerEntry = new HandlerEntry(changeHandler, object);
                syncArrayList.lockForWrite();
                try {
                    object2 = syncArrayList.listIterator();
                    while (object2.hasNext()) {
                        if (!((HandlerEntry)object2.next()).equals(handlerEntry)) continue;
                        object2.remove();
                        break;
                    }
                    if (syncArrayList.isEmpty()) {
                        this.handlers.remove(entryKey);
                    }
                    Object var14_10 = null;
                }
                catch (Throwable throwable) {
                    Object var14_11 = null;
                    syncArrayList.unlockForWrite();
                    throw throwable;
                }
                syncArrayList.unlockForWrite();
                object2 = new EntryKey(l2, l3);
                RegistrationRecord registrationRecord = (RegistrationRecord)this.registration.get(object2);
                if (registrationRecord != null && registrationRecord.decUseCount() == 0) {
                    this.registration.remove(object2);
                    EventNotification.unregisterForValueEvent((int)2, (int)5, (ValueEventHandler)this, (long)l2, (long)l3);
                    EventNotification.unregisterForValueEvent((int)2, (int)6, (ValueEventHandler)this, (long)l2, (long)l3);
                }
                Object var16_14 = null;
            }
            catch (Throwable throwable) {
                Object var16_15 = null;
                this.lock.unlockForWrite();
                throw throwable;
            }
            this.lock.unlockForWrite();
        }
    }

    private class DriverStateHandler
    implements EntryEventHandler {
        private DriverStateHandler() {
        }

        public int handleEvent(int n, DSEEntryInfo dSEEntryInfo, int n2) {
            try {
                int n3 = MiscDS.getDriverState(DriverEventMonitor.this.context, dSEEntryInfo.getEntryID());
                DriverEntry driverEntry = DriverList.findEntry(dSEEntryInfo.getEntryID());
                if (driverEntry == null) {
                    if (n3 != 0 && !DriverEventMonitor.this.shuttingDown) {
                        DriverEntry.startDriver(dSEEntryInfo.getEntryID());
                    }
                } else if (n3 != 0) {
                    driverEntry.queueStateChange();
                }
            }
            catch (Throwable throwable) {
                StatusLog.logError(9084, throwable);
            }
            return 0;
        }
    }
}

