/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dhutil.Lock;
import com.novell.nds.dirxml.engine.DriverEntry;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import novell.jclient.JCContext;

public abstract class DriverList {
    private static Lock lock = new Lock();
    private static Map driverMap = new HashMap();
    protected static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.DriverList");
    protected static final String STOPPING_DRIVER = "dlt_stpdrv";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEmpty() {
        boolean bl;
        lock.lockForRead();
        try {
            bl = driverMap.isEmpty();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            lock.unlockForRead();
            throw throwable;
        }
        lock.unlockForRead();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DriverEntry findEntry(long l) {
        DriverEntry driverEntry;
        lock.lockForRead();
        try {
            driverEntry = (DriverEntry)driverMap.get(new Long(l));
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            lock.unlockForRead();
            throw throwable;
        }
        lock.unlockForRead();
        return driverEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopAllDrivers(JCContext jCContext) {
        lock.lockForRead();
        try {
            Iterator iterator = driverMap.values().iterator();
            while (iterator.hasNext()) {
                DriverEntry driverEntry = (DriverEntry)iterator.next();
                try {
                    if (MiscDS.getDriverState(jCContext, driverEntry.getEntryID()) != 2) continue;
                    EngineTrace.staticTracer.trace(STOPPING_DRIVER, (MessageSource)messageSource, driverEntry.getName());
                    MiscDS.setDriverState(jCContext, driverEntry.getEntryID(), 3);
                }
                catch (Throwable throwable) {
                    StatusLog.logError(9087, driverEntry.getDN(), throwable);
                }
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlockForRead();
            throw throwable;
        }
        lock.unlockForRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addEntry(DriverEntry driverEntry) {
        lock.lockForWrite();
        try {
            DriverList.addEntryID(driverEntry.getEntryID(), driverEntry);
            DriverList.addEntryID(driverEntry.getSubEntryID(), driverEntry);
            DriverList.addEntryID(driverEntry.getPubEntryID(), driverEntry);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            lock.unlockForWrite();
            throw throwable;
        }
        lock.unlockForWrite();
    }

    static void removeEntry(DriverEntry driverEntry) {
        DriverList.removeEntry(driverEntry.getEntryID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeEntry(long l) {
        lock.lockForWrite();
        try {
            DriverEntry driverEntry = (DriverEntry)driverMap.get(new Long(l));
            if (driverEntry != null) {
                DriverList.removeEntryID(driverEntry.getEntryID());
                DriverList.removeEntryID(driverEntry.getSubEntryID());
                DriverList.removeEntryID(driverEntry.getPubEntryID());
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            lock.unlockForWrite();
            throw throwable;
        }
        lock.unlockForWrite();
    }

    private static void addEntryID(long l, DriverEntry driverEntry) {
        if (l != -1L) {
            driverMap.put(new Long(l), driverEntry);
        }
    }

    private static void removeEntryID(long l) {
        if (l != -1L) {
            driverMap.remove(new Long(l));
        }
    }
}

