/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dhutil.NMASSimplePwd;
import com.novell.nds.dhutil.SPMAgent;
import com.novell.nds.dirxml.engine.Driver;
import com.novell.nds.dirxml.engine.Entry;
import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.OperationData;
import com.novell.nds.dirxml.engine.SchemaCache;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.ThreadGroupVars;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEAttributeValueFactory;
import com.novell.nds.dirxml.engine.event.DSEAttributeValueXml;
import com.novell.nds.dirxml.engine.event.DSECaseExactString;
import com.novell.nds.dirxml.engine.event.DSEStream;
import com.novell.xml.dom.DOMUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import novell.jclient.JCAttributeDef;
import novell.jclient.JCCEstringValue;
import novell.jclient.JCClassDef;
import novell.jclient.JCClassnameValue;
import novell.jclient.JCContext;
import novell.jclient.JCCounterValue;
import novell.jclient.JCEntryData;
import novell.jclient.JCEntryInfo;
import novell.jclient.JCEntryInfoEmptyFieldException;
import novell.jclient.JCEntryIterator;
import novell.jclient.JCException;
import novell.jclient.JCPathValue;
import novell.jclient.JCReadFilter;
import novell.jclient.JCSearchExp;
import novell.jclient.JCSearchFilter;
import novell.jclient.JCSearchSubExp;
import novell.jclient.JCTimestamp;
import novell.jclient.JCValue;
import novell.jclient.JClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NDSReader {
    public static final int TYPE_DEFAULT = 0;
    public static final int TYPE_XML = 1;

    public static void readObjects(JCContext jCContext, String string, JCValue[] jCValueArray, String[] stringArray, int n, Node node, OperationData operationData, Map map, Driver driver) throws VRDException {
        try {
            boolean[] blArray = new boolean[]{false};
            JCSearchFilter jCSearchFilter = NDSReader.createSimpleFilter(jCValueArray, stringArray, n, blArray);
            NDSReader.readObjects(jCContext, string, jCSearchFilter, node, operationData, map, driver, blArray[0]);
        }
        catch (JCException jCException) {
            throw new VRDException(jCException);
        }
    }

    public static void readObjects(JCContext jCContext, String string, JCSearchFilter jCSearchFilter, Node node, OperationData operationData, Map map, Driver driver, boolean bl) throws VRDException {
        Entry entry = null;
        if (string != null && string.length() != 0) {
            entry = new Entry(string);
        }
        NDSReader.readObjects(jCContext, entry, jCSearchFilter, node, operationData, map, driver, bl);
    }

    public static void readObjects(JCContext jCContext, Entry entry, JCValue[] jCValueArray, String[] stringArray, int n, Node node, OperationData operationData, Map map, Driver driver) throws VRDException {
        try {
            boolean[] blArray = new boolean[]{false};
            JCSearchFilter jCSearchFilter = NDSReader.createSimpleFilter(jCValueArray, stringArray, n, blArray);
            NDSReader.readObjects(jCContext, entry, jCSearchFilter, node, operationData, map, driver, blArray[0]);
        }
        catch (JCException jCException) {
            throw new VRDException(jCException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readObjects(JCContext jCContext, Entry entry, JCSearchFilter jCSearchFilter, Node node, OperationData operationData, Map map, Driver driver, boolean bl) throws VRDException {
        JCContext jCContext2;
        block18: {
            JCContext jCContext3 = null;
            jCContext2 = null;
            try {
                try {
                    jCContext3 = jCContext.duplicate();
                    if (entry != null) {
                        entry.goTo(jCContext3);
                    }
                    jCContext3.setBaseDN(null, "10.\\+=*'");
                    jCContext2 = jCContext3.duplicate();
                    if (jCSearchFilter.scope == 0L) {
                        JCEntryInfo jCEntryInfo = JClient.getEntryInfo((JCContext)jCContext3, (int)((int)jCSearchFilter.entryFlags));
                        JCValue[] jCValueArray = null;
                        try {
                            jCValueArray = JClient.readEntry((JCContext)jCContext3, (long)jCSearchFilter.valueInfoType, (JCReadFilter)jCSearchFilter.rfilter);
                        }
                        catch (JCException jCException) {
                            // empty catch block
                        }
                        NDSReader.addInstance(jCContext2, jCEntryInfo, jCValueArray, node, operationData, map, driver, bl);
                    } else {
                        JCEntryIterator jCEntryIterator = jCContext3.createIterator(jCSearchFilter);
                        try {
                            JCEntryData jCEntryData = jCEntryIterator.current();
                            while (true) {
                                if (jCEntryData == null) {
                                    Object var14_16 = null;
                                    break;
                                }
                                NDSReader.addInstance(jCContext2, jCEntryData.entryInfo, jCEntryData.attributeValues, node, operationData, map, driver, bl);
                                jCEntryData = jCEntryIterator.next(0);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var14_17 = null;
                            jCEntryIterator.close();
                            throw throwable;
                        }
                        jCEntryIterator.close();
                    }
                    Object var16_19 = null;
                    if (jCContext3 == null) break block18;
                }
                catch (JCException jCException) {
                    if (jCException.getErrorCode() != -601) throw new VRDException(jCException);
                    if (jCSearchFilter.scope != 0L) {
                        throw new VRDException(jCException);
                    }
                    Object var16_20 = null;
                    if (jCContext3 != null) {
                        jCContext3.free();
                    }
                    if (jCContext2 == null) return;
                    jCContext2.free();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                if (jCContext3 != null) {
                    jCContext3.free();
                }
                if (jCContext2 == null) throw throwable;
                jCContext2.free();
                throw throwable;
            }
            jCContext3.free();
        }
        if (jCContext2 == null) return;
        jCContext2.free();
    }

    public static JCSearchFilter createSimpleFilter(JCValue[] jCValueArray, String[] stringArray, int n, boolean[] blArray) throws JCException {
        String[] stringArray2 = stringArray;
        blArray[0] = stringArray2 == (stringArray = NDSReader.forceAssociationAttribute(stringArray));
        JCReadFilter jCReadFilter = stringArray == null || stringArray.length == 0 ? JCReadFilter.allAttributes() : new JCReadFilter(false, null, stringArray);
        JCSearchExp jCSearchExp = null;
        if (jCValueArray == null || jCValueArray.length == 0) {
            jCSearchExp = new JCSearchExp((JCValue)new JCClassnameValue("Object Class", 17, 0L, new JCTimestamp(), "*"));
        } else {
            ArrayList<JCSearchExp> arrayList = new ArrayList<JCSearchExp>();
            ArrayList<JCSearchExp> arrayList2 = new ArrayList<JCSearchExp>();
            int n2 = 0;
            while (n2 < jCValueArray.length) {
                if (jCValueArray[n2].operation == 17) {
                    arrayList2.add(new JCSearchExp(jCValueArray[n2]));
                } else {
                    arrayList.add(new JCSearchExp(jCValueArray[n2]));
                }
                ++n2;
            }
            JCSearchExp[] jCSearchExpArray = new JCSearchExp[]{null, null};
            JCSearchExp[] jCSearchExpArray2 = arrayList.toArray(new JCSearchExp[arrayList.size()]);
            JCSearchExp[] jCSearchExpArray3 = arrayList2.toArray(new JCSearchExp[arrayList2.size()]);
            if (jCSearchExpArray2.length == 1) {
                jCSearchExpArray[0] = jCSearchExpArray2[0];
            } else if (jCSearchExpArray2.length > 1) {
                jCSearchExpArray[0] = new JCSearchExp(2, new JCSearchSubExp(jCSearchExpArray2));
            }
            if (jCSearchExpArray3.length == 1) {
                jCSearchExpArray[1] = jCSearchExpArray3[0];
            } else if (jCSearchExpArray3.length > 1) {
                jCSearchExpArray[1] = new JCSearchExp(1, new JCSearchSubExp(jCSearchExpArray3));
            }
            jCSearchExp = jCSearchExpArray[0] == null ? jCSearchExpArray[1] : (jCSearchExpArray[1] == null ? jCSearchExpArray[0] : new JCSearchExp(2, new JCSearchSubExp(jCSearchExpArray)));
        }
        return new JCSearchFilter((long)n, 6L, 1L, -1L, 10246L, 3L, jCReadFilter, jCSearchExp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void addInstance(JCContext jCContext, JCEntryInfo jCEntryInfo, JCValue[] jCValueArray, Node node, OperationData operationData, Map map, Driver driver, boolean bl) throws VRDException {
        JCContext jCContext2 = null;
        try {
            block25: {
                try {
                    Object object;
                    Document document = node.getOwnerDocument();
                    Element element = document.createElementNS(null, "instance");
                    String string = jCContext.standardizeDN(jCEntryInfo.getEntryDN().toString(), null);
                    long l = jCEntryInfo.getEntryID();
                    long l2 = 0L;
                    String[] stringArray = XdsUtil.getDNForms(string);
                    element.setAttributeNS(null, "src-dn", stringArray[0]);
                    element.setAttributeNS(null, "qualified-src-dn", stringArray[1]);
                    element.setAttributeNS(null, "class-name", NDSReader.getBaseClass(jCEntryInfo));
                    element.setAttributeNS(null, "src-entry-id", String.valueOf(l));
                    if (operationData != null && operationData.getOperationID() != null) {
                        element.setAttributeNS(null, "event-id", operationData.getOperationID());
                    }
                    if (operationData != null && operationData.getOpData() != null) {
                        object = (Element)XdsUtil.cloneSubtree(document, operationData.getOpData());
                        element.appendChild((Node)object);
                        DOMUtil.addNamespaceDecls((Node)object);
                    }
                    node.appendChild(element);
                    object = (String)ThreadGroupVars.get("vrDriverDN");
                    String string2 = null;
                    if (object != null) {
                        int n = ((String)object).indexOf(((String)object).charAt(0), 1) + 1;
                        string2 = ((String)object).substring(n);
                    }
                    if (jCValueArray == null) break block25;
                    String string3 = null;
                    Element element2 = null;
                    Node node2 = null;
                    int n = 0;
                    while (n < jCValueArray.length) {
                        block26: {
                            Object object2;
                            String string4;
                            DSEAttributeValue dSEAttributeValue;
                            block31: {
                                JCCEstringValue jCCEstringValue;
                                JCValue jCValue;
                                SPMAgent.PasswordInfo passwordInfo;
                                Element element3;
                                block30: {
                                    long l3;
                                    block29: {
                                        block28: {
                                            dSEAttributeValue = DSEAttributeValueFactory.createValue(jCValueArray[n]);
                                            string4 = ((JCValue)dSEAttributeValue).attributeName;
                                            if (!Driver.isSensitiveData(string4) || driver != null && driver.isTrustedDriver()) break block28;
                                            StatusLog.logWarning(8000, string4);
                                            break block26;
                                        }
                                        if (map != null && (object2 = (Integer)map.get(string4)) != null && (Integer)object2 == 1 && dSEAttributeValue instanceof DSEAttributeValueXml) {
                                            ((DSEAttributeValueXml)dSEAttributeValue).setInterpretAsXml(true);
                                        }
                                        if (!string4.equals("DirXML-Associations")) break block29;
                                        if (object != null && ((object2 = (JCPathValue)dSEAttributeValue).getVolumeDN().equalsIgnoreCase((String)object) || object2.getVolumeDN().equalsIgnoreCase(string2))) {
                                            element3 = NdsDtd.createAssociationElement(document, object2.getVolumePath(), object2.getNameSpace());
                                            if (node2 == null) {
                                                element.insertBefore(element3, element.getFirstChild());
                                            } else {
                                                element.insertBefore(element3, node2.getNextSibling());
                                            }
                                        }
                                        if (!bl) break block26;
                                    }
                                    if (dSEAttributeValue instanceof DSEStream) {
                                        try {
                                            ((DSEStream)dSEAttributeValue).readValue(jCContext, string);
                                        }
                                        catch (JCException jCException) {
                                            if (jCException.getErrorCode() != -602) throw jCException;
                                            break block26;
                                        }
                                    }
                                    if (!string4.equals("nspmDistributionPassword")) break block30;
                                    if (object == null || (passwordInfo = SPMAgent.getSPMDistPassword((String)"Agent Dirxml", (String)object, (String)(object2 = MiscDS.getTreeName()), (String)string, (long)(l3 = 0L))) == null) break block26;
                                    jCValue = (JCValue)dSEAttributeValue;
                                    jCCEstringValue = new JCCEstringValue("nspmDistributionPassword", jCValue.operation, jCValue.flags, jCValue.timestamp, passwordInfo.getPassword());
                                    DSECaseExactString dSECaseExactString = new DSECaseExactString(jCCEstringValue);
                                    dSEAttributeValue = dSECaseExactString;
                                }
                                if (!string4.equals("SAS:Login Configuration")) break block31;
                                if (object == null) break block26;
                                object2 = MiscDS.getTreeName();
                                element3 = null;
                                jCContext2 = new JCContext(0x800000, (String)object2, "00.\\+=*'");
                                int n2 = SPMAgent.extractDClientContext((JCContext)jCContext2);
                                element3 = SPMAgent.getSimplePassword((int)n2, (String)string, (int[])NMASSimplePwd.METHOD_ID, (String)"Password Hash");
                                jCContext2.free();
                                jCContext2 = null;
                                if (element3 == null) break block26;
                                passwordInfo = (JCValue)dSEAttributeValue;
                                jCValue = new JCCEstringValue("SAS:Login Configuration", passwordInfo.operation, passwordInfo.flags, passwordInfo.timestamp, element3.getPassword());
                                jCCEstringValue = new DSECaseExactString((JCCEstringValue)jCValue);
                                dSEAttributeValue = jCCEstringValue;
                            }
                            if (element2 == null || !((JCValue)dSEAttributeValue).attributeName.equals(string3)) {
                                element2 = document.createElementNS(null, "attr");
                                element2.setAttributeNS(null, "attr-name", ((JCValue)dSEAttributeValue).attributeName);
                                element.appendChild(element2);
                                string3 = ((JCValue)dSEAttributeValue).attributeName;
                                l2 = 0L;
                            }
                            if (Driver.isSensitiveData(string4)) {
                                dSEAttributeValue.encrypt(driver.getOutKey());
                            }
                            if (dSEAttributeValue instanceof JCCounterValue) {
                                object2 = (Element)element2.getLastChild();
                                l2 += (long)((JCCounterValue)dSEAttributeValue).getCounter();
                                if (object2 != null) {
                                    XdsUtil.setNodeText((Node)object2, String.valueOf(l2));
                                } else {
                                    dSEAttributeValue.toXML(element2);
                                }
                            } else {
                                dSEAttributeValue.toXML(element2);
                            }
                            object2 = (Element)element2.getLastChild();
                            if (((JCValue)dSEAttributeValue).timestamp != null) {
                                object2.setAttributeNS(null, "timestamp", String.valueOf(((JCValue)dSEAttributeValue).timestamp.seconds.getTime() / 1000L) + "#" + String.valueOf(((JCValue)dSEAttributeValue).timestamp.event));
                            }
                            if ((((JCValue)dSEAttributeValue).flags & 1L) != 0L) {
                                object2.setAttributeNS(null, "naming", "true");
                            }
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    throw new VRDException(exception);
                }
            }
            Object var33_34 = null;
            if (jCContext2 == null) return;
            jCContext2.free();
            return;
        }
        catch (Throwable throwable) {
            Object var33_35 = null;
            if (jCContext2 == null) throw throwable;
            jCContext2.free();
            throw throwable;
        }
    }

    protected static String[] forceAssociationAttribute(String[] stringArray) {
        if (stringArray != null) {
            if (stringArray.length == 1 && stringArray[0].equals("")) {
                stringArray = new String[]{"DirXML-Associations"};
            } else {
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].equalsIgnoreCase("DirXML-Associations")) break;
                    ++n;
                }
                if (n == stringArray.length) {
                    String[] stringArray2 = new String[stringArray.length + 1];
                    stringArray2[0] = "DirXML-Associations";
                    System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
                    stringArray = stringArray2;
                }
            }
        }
        return stringArray;
    }

    public static void readSchema(JCContext jCContext, Node node) throws VRDException {
        try {
            Document document = node.getOwnerDocument();
            Element element = document.createElementNS(null, "schema-def");
            element.setAttributeNS(null, "hierarchical", "true");
            element.setAttributeNS(null, "dn-format", "slash");
            JCClassDef[] jCClassDefArray = SchemaCache.getClassDefs();
            int n = 0;
            while (n < jCClassDefArray.length) {
                long l = jCClassDefArray[n].getCharacteristics();
                if ((l & 2L) != 0L) {
                    Element element2 = document.createElementNS(null, "class-def");
                    element.appendChild(element2);
                    element2.setAttributeNS(null, "class-name", jCClassDefArray[n].getName());
                    if ((l & 1L) != 0L) {
                        element2.setAttributeNS(null, "container", "true");
                    }
                    String[] stringArray = jCClassDefArray[n].getNamingAttributes();
                    HashSet<String> hashSet = new HashSet<String>();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        hashSet.add(stringArray[n2]);
                        ++n2;
                    }
                    String[][] stringArrayArray = new String[][]{jCClassDefArray[n].getMandatoryAttributes(), jCClassDefArray[n].getOptionalAttributes()};
                    int n3 = 0;
                    while (n3 < stringArrayArray.length) {
                        int n4 = 0;
                        while (n4 < stringArrayArray[n3].length) {
                            JCAttributeDef jCAttributeDef = SchemaCache.getAttributeDef(stringArrayArray[n3][n4]);
                            long l2 = jCAttributeDef.getConstraints();
                            Element element3 = document.createElementNS(null, "attr-def");
                            element2.appendChild(element3);
                            element3.setAttributeNS(null, "attr-name", jCAttributeDef.getName());
                            String string = DSEAttributeValueFactory.getTypeName(jCAttributeDef.getSyntax());
                            if (string != "string") {
                                element3.setAttributeNS(null, "type", string);
                            }
                            if (jCAttributeDef.getSyntax() == 2) {
                                element3.setAttributeNS(null, "case-sensitive", "true");
                            }
                            if (n3 == 0) {
                                element3.setAttributeNS(null, "required", "true");
                            }
                            if (hashSet.contains(jCAttributeDef.getName())) {
                                element3.setAttributeNS(null, "naming", "true");
                            }
                            if ((l2 & 1L) != 0L) {
                                element3.setAttributeNS(null, "multi-valued", "false");
                            }
                            if ((l2 & 8L) != 0L) {
                                element3.setAttributeNS(null, "read-only", "true");
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                }
                ++n;
            }
            node.appendChild(element);
        }
        catch (Exception exception) {
            throw new VRDException(exception);
        }
    }

    public static String getBaseClass(JCEntryInfo jCEntryInfo) throws JCEntryInfoEmptyFieldException {
        if ((jCEntryInfo.getEntryFlags() & 1) != 0) {
            return "Alias";
        }
        return jCEntryInfo.getBaseClass();
    }
}

