/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.driver.DriverShim;
import com.novell.nds.dirxml.driver.PublicationShim;
import com.novell.nds.dirxml.driver.SubscriptionShim;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.NativePublicationShim;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import org.w3c.dom.Element;

class NativeDriverShim
implements DriverShim {
    NativePublicationShim publicationShim = null;
    boolean nativeInit = false;
    long nativeShim = 0L;
    long hLibrary = 0L;
    EngineTrace tracer;
    protected static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.NativeDriverShim");
    protected static final String CALLING_NATIVE_DESTROY_1 = "nt_cnsdsty1";
    protected static final String CALLING_NATIVE_DESTROY_2 = "nt_cnsdsty2";
    protected static final String CALLING_NATIVE_DESTROY_3 = "nt_cnsdsty3";

    NativeDriverShim(String string, EngineTrace engineTrace) throws VRDException {
        this.tracer = engineTrace;
        try {
            long[] lArray = new long[1];
            this.nativeShim = this.nativeConstructor(string, lArray);
            this.hLibrary = lArray[0];
        }
        catch (VRDException vRDException) {
            throw vRDException;
        }
        catch (Throwable throwable) {
            throw new VRDException(throwable);
        }
        if (this.nativeShim == 0L) {
            throw new VRDException(9020, string);
        }
    }

    public EngineTrace getTracer() {
        return this.tracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDocument init(XmlDocument xmlDocument) {
        XmlDocument xmlDocument2;
        block7: {
            xmlDocument2 = this.init(this.nativeShim, xmlDocument);
            try {
                Object object;
                boolean bl = false;
                if (xmlDocument2 != null) {
                    Element element;
                    object = xmlDocument2.getDocumentNS().getElementsByTagNameNS(null, "status");
                    int n = 0;
                    while ((element = (Element)object.item(n++)) != null) {
                        if (NdsDtd.getStatusLevel(element) != 4) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) break block7;
                object = this;
                synchronized (object) {
                    this.nativeInit = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return xmlDocument2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDocument shutdown(XmlDocument xmlDocument) {
        NativeDriverShim nativeDriverShim;
        XmlDocument xmlDocument2;
        try {
            xmlDocument2 = this.shutdown(this.nativeShim, xmlDocument);
            Object var4_3 = null;
            nativeDriverShim = this;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            NativeDriverShim nativeDriverShim2 = this;
            synchronized (nativeDriverShim2) {
                this.nativeInit = false;
            }
            this.tracer.trace(CALLING_NATIVE_DESTROY_1, (MessageSource)messageSource);
            this.destroy();
            throw throwable;
        }
        synchronized (nativeDriverShim) {
            this.nativeInit = false;
        }
        this.tracer.trace(CALLING_NATIVE_DESTROY_1, (MessageSource)messageSource);
        this.destroy();
        return xmlDocument2;
    }

    public SubscriptionShim getSubscriptionShim() {
        return this.getSubscriptionShim(this.nativeShim);
    }

    public PublicationShim getPublicationShim() {
        this.publicationShim = (NativePublicationShim)this.getPublicationShim(this.nativeShim);
        return this.publicationShim;
    }

    public XmlDocument getSchema(XmlDocument xmlDocument) {
        XmlDocument xmlDocument2 = this.getSchema(this.nativeShim, xmlDocument);
        this.tracer.trace(CALLING_NATIVE_DESTROY_2, (MessageSource)messageSource);
        this.destroy();
        return xmlDocument2;
    }

    public synchronized void destroy() {
        if (!(this.nativeShim == 0L || this.nativeInit || this.publicationShim != null && this.publicationShim.inStart())) {
            this.tracer.trace(CALLING_NATIVE_DESTROY_3, (MessageSource)messageSource);
            this.destroy(this.nativeShim, this.hLibrary);
            this.nativeShim = 0L;
        }
    }

    protected void finalize() {
        this.nativeInit = false;
        this.destroy();
    }

    protected native long nativeConstructor(String var1, long[] var2) throws VRDException;

    protected native XmlDocument init(long var1, XmlDocument var3);

    protected native XmlDocument shutdown(long var1, XmlDocument var3);

    protected native SubscriptionShim getSubscriptionShim(long var1);

    protected native PublicationShim getPublicationShim(long var1);

    protected native XmlDocument getSchema(long var1, XmlDocument var3);

    protected native void destroy(long var1, long var3);
}

