/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.engine.OperationData;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.DocumentFactory;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class NdsDtd {
    protected static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.NdsDtd");
    protected static final String LOC_SUCCESS = "ndt_suc";
    protected static final String LOC_RETRY = "ndt_ret";
    protected static final String LOC_WARNING = "ndt_war";
    protected static final String LOC_ERROR = "ndt_err";
    protected static final String LOC_FATAL = "ndt_fat";
    protected static final String LOC_UNKNOWN = "ndt_ukn";
    public static final String CURRENT_CONTACT = "Novell, Inc.";
    public static final String VRDRIVER_PROD_NAME = "DirXML";
    public static final String VRDRIVER_PROD_VER = NdsDtd.getVersionFromManifest();
    public static final String ACTUAL_DTD_VERSION = "nds.dtd";
    public static final String NOT_ASSOCIATED = "not-associated";
    public static final String ASSOCIATED = "associated";
    public static final String DISABLED = "disabled";
    public static final String MIGRATE = "migrate";
    public static final String PENDING = "pending";
    public static final String MANUAL = "manual";
    public static final String ENTRY = "entry";
    public static final String SUBORDINATES = "subordinates";
    public static final String SUBTREE = "subtree";
    public static final String SUCCESS = "success";
    public static final String RETRY = "retry";
    public static final String WARNING = "warning";
    public static final String ERROR = "error";
    public static final String FATAL = "fatal";
    public static final int SL_SUCCESS = 0;
    public static final int SL_RETRY = 1;
    public static final int SL_WARNING = 2;
    public static final int SL_ERROR = 3;
    public static final int SL_FATAL = 4;
    public static final String UNKNOWN = "unknown";
    public static final int SL_UNKNOWN = Integer.MAX_VALUE;
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String DEFAULT = "default";
    public static final String XML = "xml";
    public static final String ROOT = "nds";
    public static final String NDS = "nds";
    public static final String ROOT_NDS_VER = "ndsversion";
    public static final String ROOT_DTD_VER = "dtdversion";
    public static final String CURRENT_NDS_VER = "8.x";
    public static final String CURRENT_DTD_VER = "2.0";
    public static final String SOURCE = "source";
    public static final String PRODUCT = "product";
    public static final String PRODUCT_VER = "version";
    public static final String PRODUCT_ASN1 = "asn1id";
    public static final String CONTACT = "contact";
    public static final String INPUT = "input";
    public static final String OUTPUT = "output";
    public static final String VALUE = "value";
    public static final String TYPE = "type";
    public static final String ASSOCIATION_REF = "association-ref";
    public static final String COMPONENT = "component";
    public static final String NAME = "name";
    public static final String TIMESTAMP = "timestamp";
    public static final String ASSOCIATION = "association";
    public static final String STATE = "state";
    public static final String PARENT = "parent";
    public static final String QUERY = "query";
    public static final String DEST_DN = "dest-dn";
    public static final String DEST_ENTRY_ID = "dest-entry-id";
    public static final String SCOPE = "scope";
    public static final String EVENT_ID = "event-id";
    public static final String QUERY_SCHEMA = "query-schema";
    public static final String SEARCH_CLASS = "search-class";
    public static final String CLASS_NAME = "class-name";
    public static final String SEARCH_ATTR = "search-attr";
    public static final String ATTR_NAME = "attr-name";
    public static final String READ_ATTR = "read-attr";
    public static final String READ_PARENT = "read-parent";
    public static final String ADD = "add";
    public static final String SRC_DN = "src-dn";
    public static final String QUALIFIED_SRC_DN = "qualified-src-dn";
    public static final String SRC_ENTRY_ID = "src-entry-id";
    public static final String TEMPLATE_DN = "template-dn";
    public static final String ADD_ATTR = "add-attr";
    public static final String DELETE = "delete";
    public static final String MODIFY = "modify";
    public static final String FROM_MERGE = "from-merge";
    public static final String MODIFY_ATTR = "modify-attr";
    public static final String REMOVE_ALL_VALUES = "remove-all-values";
    public static final String REMOVE_VALUE = "remove-value";
    public static final String ADD_VALUE = "add-value";
    public static final String MODIFY_PASSWORD = "modify-password";
    public static final String OLD_PASSWORD = "old-password";
    public static final String RENAME = "rename";
    public static final String NEW_NAME = "new-name";
    public static final String OLD_SRC_DN = "old-src-dn";
    public static final String QUALIFIED_OLD_SRC_DN = "qualified-old-src-dn";
    public static final String REMOVE_OLD_NAME = "remove-old-name";
    public static final String MOVE = "move";
    public static final String INSTANCE = "instance";
    public static final String ATTR = "attr";
    public static final String REQUEST_RESYNC = "request-resync";
    public static final String STARTING_TIME = "starting-time";
    public static final String STATUS = "status";
    public static final String LEVEL = "level";
    public static final String CODE = "code";
    public static final String DESCRIPTION = "description";
    public static final String ENCODED_DATA = "encoded-data";
    public static final String MODULE = "module";
    public static final String OBJECT_DN = "object-dn";
    public static final String APPLICATION = "application";
    public static final String REMOTELOADER = "remoteloader";
    public static final String APP_GENERAL = "app-general";
    public static final String APP_AUTHENTICATION = "app-authentication";
    public static final String APP_CONNECTION = "app-connection";
    public static final String DRIVER_GENERAL = "driver-general";
    public static final String DRIVER_STATUS = "driver-status";
    public static final String PASSWORD_SET_OPERATION = "password-set-operation";
    public static final String ADD_ASSOCIATION = "add-association";
    public static final String MODIFY_ASSOCIATION = "modify-association";
    public static final String REMOVE_ASSOCIATION = "remove-association";
    public static final String INIT_PARAMS = "init-params";
    public static final String CHECK_PASSWORD = "check-password";
    public static final String CHECK_OBJECT_PASSWORD = "check-object-password";
    public static final String GET_NAMED_PASSWORD = "get-named-password";
    public static final String AUTHENTICATION_INFO = "authentication-info";
    public static final String SERVER = "server";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String DRIVER_FILTER = "driver-filter";
    public static final String ALLOW_CLASS = "allow-class";
    public static final String ALLOW_ATTR = "allow-attr";
    public static final String PUBLISHER = "publisher";
    public static final String SUBSCRIBER = "subscriber";
    public static final String DRIVER = "driver";
    public static final String SCHEMA_DEF = "schema-def";
    public static final String HIERARCHICAL = "hierarchical";
    public static final String APPLICATION_NAME = "application-name";
    public static final String CLASS_DEF = "class-def";
    public static final String CONTAINER = "container";
    public static final String ATTR_DEF = "attr-def";
    public static final String REQUIRED = "required";
    public static final String NAMING = "naming";
    public static final String MULTI_VALUED = "multi-valued";
    public static final String CASE_SENSITIVE = "case-sensitive";
    public static final String READ_ONLY = "read-only";
    public static final String DN_FORMAT = "dn-format";
    public static final String DN_DELIMS = "dn-delims";
    public static final String SYNC = "sync";
    public static final String CLASS_ID = "class-id";
    public static final String SLASH = "slash";
    public static final String DOT = "dot";
    public static final String LDAP = "ldap";
    public static final String QSLASH = "qualified-slash";
    public static final String QDOT = "qualified-dot";
    public static final String MATCHING_RULES = "matching-rules";
    public static final String MATCHING_RULE = "matching-rule";
    public static final String PLACEMENT_RULES = "placement-rules";
    public static final String PLACEMENT_RULE = "placement-rule";
    public static final String MATCH_CLASS = "match-class";
    public static final String MATCH_ATTR = "match-attr";
    public static final String MATCH_PATH = "match-path";
    public static final String COPY_NAME = "copy-name";
    public static final String COPY_PATH = "copy-path";
    public static final String COPY_PATH_SUFFIX = "copy-path-suffix";
    public static final String COPY_ATTR = "copy-attr";
    public static final String PLACEMENT = "placement";
    public static final String PREFIX = "prefix";
    public static final String SRC_DN_FORMAT = "src-dn-format";
    public static final String DEST_DN_FORMAT = "dest-dn-format";
    public static final String SRC_DN_DELIMS = "src-dn-delims";
    public static final String DEST_DN_DELIMS = "dest-dn-delims";
    public static final String ATTR_NAME_MAP = "attr-name-map";
    public static final String NDS_NAME = "nds-name";
    public static final String APP_NAME = "app-name";
    public static final String CREATE_RULES = "create-rules";
    public static final String CREATE_RULE = "create-rule";
    public static final String REQUIRED_ATTR = "required-attr";
    public static final String WRITE_BACK = "write-back";
    public static final String TEMPLATE = "template";
    public static final String DRIVER_CONFIG = "driver-config";
    public static final String DRIVER_OPTIONS = "driver-options";
    public static final String SUBSCRIBER_OPTIONS = "subscriber-options";
    public static final String PUBLISHER_OPTIONS = "publisher-options";
    public static final String DRIVER_STATE = "driver-state";
    public static final String SUBSCRIBER_STATE = "subscriber-state";
    public static final String PUBLISHER_STATE = "publisher-state";
    public static final String CONFIG_OBJECT = "config-object";
    public static final String DISPLAY_NAME = "display-name";
    public static final String PASSWORD_REF = "password-ref";
    public static final String VALIDATE_PASSWORD = "enforce-password-policy";
    public static final String FAILED_SYNC = "failed-sync";
    public static final String OPERATION_DATA = "operation-data";
    public static final String STRUCTURED = "structured";
    public static final String SERVERDN = "serverDn";
    public static final String REMOTEID = "remoteId";
    public static final String STRING = "string";
    public static final String CLASSNAME = "className";
    public static final String COUNTER = "counter";
    public static final String DN = "dn";
    public static final String EMAILTYPE = "eMailType";
    public static final String EMAILADDR = "eMailAddr";
    public static final String FAXNBR = "faxNumber";
    public static final String FAXBITCNT = "faxBitCount";
    public static final String FAXPARM = "faxParameters";
    public static final String HOLDOBJ = "holdEntryDn";
    public static final String HOLDAMT = "holdAmount";
    public static final String INT = "int";
    public static final String INTERVAL = "interval";
    public static final String NETTYPE = "netAddrType";
    public static final String NETADDR = "netAddr";
    public static final String PROTECTEDNAME = "protectedName";
    public static final String TRUSTEE = "trustee";
    public static final String PRIVILEGES = "privileges";
    public static final String OCTET = "octet";
    public static final String PATHNAMESPACE = "nameSpace";
    public static final String VOLUME = "volume";
    public static final String PATH = "path";
    public static final String REPLICATYPE = "replicaType";
    public static final String REPLICANUMBER = "replicaNumber";
    public static final String COUNT = "count";
    public static final String STREAM = "stream";
    public static final String TELEPHONENUMBER = "teleNumber";
    public static final String TIME = "time";
    public static final String TSSECONDS = "seconds";
    public static final String TSREPLICNR = "replicaNumber";
    public static final String TSEVENTID = "eventId";
    public static final String DRIVER_IDENT_CLASS = "__driver_identification_class__";
    public static final String DRIVER_ID = "driver-id";
    public static final String DRIVER_VERSION = "driver-version";
    public static final String MIN_ACTIVATION_VERSION = "min-activation-version";
    public static final String IS_SENSITIVE = "is-sensitive";
    protected static final String[] LEVEL_MAP = new String[]{"success", "retry", "warning", "error", "fatal"};
    protected static final String[] LOC_LEVEL_MAP = new String[]{"ndt_suc", "ndt_ret", "ndt_war", "ndt_err", "ndt_fat"};

    public static Element createDoc(String string) {
        Document document = DocumentFactory.newDocument();
        Element element = document.createElementNS(null, "nds");
        element.setAttributeNS(null, ROOT_NDS_VER, CURRENT_NDS_VER);
        element.setAttributeNS(null, ROOT_DTD_VER, CURRENT_DTD_VER);
        document.appendChild(element);
        Element element2 = document.createElementNS(null, SOURCE);
        element.appendChild(element2);
        Element element3 = document.createElementNS(null, PRODUCT);
        element3.setAttributeNS(null, PRODUCT_VER, VRDRIVER_PROD_VER);
        element2.appendChild(element3);
        element3.appendChild(document.createTextNode(VRDRIVER_PROD_NAME));
        Element element4 = document.createElementNS(null, CONTACT);
        element2.appendChild(element4);
        element4.appendChild(document.createTextNode(CURRENT_CONTACT));
        Element element5 = document.createElementNS(null, string);
        element.appendChild(element5);
        return element5;
    }

    public static Element createAssociationElement(Document document, String string, int n) {
        Element element = document.createElementNS(null, ASSOCIATION);
        String string2 = null;
        switch (n) {
            case 1: {
                string2 = ASSOCIATED;
                break;
            }
            case 0: {
                string2 = DISABLED;
                break;
            }
            case 4: {
                string2 = MIGRATE;
                break;
            }
            case 2: {
                string2 = PENDING;
                break;
            }
            case 3: {
                string2 = MANUAL;
                break;
            }
        }
        if (string2 != null) {
            element.setAttributeNS(null, STATE, string2);
        }
        if (string != null) {
            element.appendChild(document.createTextNode(string));
        }
        return element;
    }

    public static Document createStatusDocument(Throwable throwable, OperationData operationData) {
        Element element = NdsDtd.createDoc(OUTPUT);
        NdsDtd.addStatusElement(element, throwable, operationData);
        return element.getOwnerDocument();
    }

    public static Document createStatusDocument(int n, OperationData operationData, String string) {
        Element element = NdsDtd.createDoc(OUTPUT);
        NdsDtd.addStatusElement(element, n, operationData, string);
        return element.getOwnerDocument();
    }

    public static void addStatusElement(Element element, Throwable throwable, OperationData operationData) {
        String string;
        if (!(throwable instanceof VRDException)) {
            throwable = new VRDException(throwable);
        }
        if ((string = throwable.getLocalizedMessage()) == null || string.length() == 0) {
            string = throwable.toString();
        }
        NdsDtd.addStatusElement(element, ((VRDException)throwable).getSeverity(), operationData, string);
    }

    public static void addStatusElement(Element element, int n, OperationData operationData, String string) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(null, STATUS);
        element.appendChild(element2);
        element2.setAttributeNS(null, LEVEL, NdsDtd.getLevelString(n));
        if (operationData != null && operationData.getOperationID() != null) {
            element2.setAttributeNS(null, EVENT_ID, operationData.getOperationID());
        }
        element2.appendChild(document.createTextNode(string));
        if (operationData != null && operationData.getOpData() != null) {
            Element element3 = (Element)XdsUtil.cloneSubtree(document, operationData.getOpData());
            element2.appendChild(element3);
            DOMUtil.addNamespaceDecls((Node)element3);
        }
    }

    public static int getStatusLevel(Element element) {
        return NdsDtd.getLevelInt(element.getAttributeNS(null, LEVEL));
    }

    public static String getLevelString(int n) {
        try {
            return LEVEL_MAP[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return UNKNOWN;
        }
    }

    public static String getLocalizedLevelString(int n) {
        String string;
        try {
            string = LOC_LEVEL_MAP[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = LOC_UNKNOWN;
        }
        return messageSource.getMessageString(string);
    }

    public static int getLevelInt(String string) {
        int n = 0;
        while (n < LEVEL_MAP.length) {
            if (LEVEL_MAP[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return Integer.MAX_VALUE;
    }

    private static String getVersionFromManifest() {
        String string = "?.?.?.?";
        try {
            URL uRL = Class.forName("com.novell.nds.dirxml.engine.NdsDtd").getResource("NdsDtd.class");
            uRL = new URL(uRL, "../../../../../META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(uRL.openStream());
            Attributes attributes = manifest.getMainAttributes();
            String string2 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            if (string2 != null && string2.length() != 0) {
                string = string2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }
}

