/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dhutil.DDSServ;
import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.ConfigAbstraction;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.Errors;
import com.novell.nds.dirxml.engine.Events;
import com.novell.nds.dirxml.engine.LogSettings;
import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.ThreadGroupVars;
import com.novell.nds.dirxml.engine.ThreadVars;
import com.novell.nds.dirxml.engine.Transformer;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dstrace.DDSTrace;
import com.novell.xml.xpath.XPathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import novell.jclient.JCCIlistValue;
import novell.jclient.JCContext;
import novell.jclient.JCException;
import novell.jclient.JCReadFilter;
import novell.jclient.JCTimeValue;
import novell.jclient.JCTimestamp;
import novell.jclient.JCValue;
import novell.jclient.JClient;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class PersistentLog {
    private static int initCount = 0;
    private static long driverSetID = -1L;
    private static long driverClassID = -1L;
    private static JCContext context = null;
    private static boolean ontarioAvailable = false;
    private static EngineTrace tracer;
    protected static final String NO_ERROR_DESCRIPTION = "elm_nodesc";
    protected static final String NO_OBJECT_NAME = "elm_noobjn";
    protected static final String CONFIG_CHANGE = "elm_cfgchg";
    protected static LocalizedMessageSource messageSource;

    static void initialize() throws DSErr {
        if (++initCount == 1) {
            try {
                context = MiscDS.createLocalContext();
                driverSetID = MiscDS.getDriverSetID(context);
                driverClassID = DDSServ.getLocalClassID((String)"DirXML-Driver");
                ontarioAvailable = PersistentLog.isOntarioAvailable();
            }
            catch (DSErr dSErr) {
                StatusLog.logError(9088, dSErr);
                PersistentLog.cleanup();
                throw dSErr;
            }
            catch (JCException jCException) {
                StatusLog.logError(9088, jCException);
                PersistentLog.cleanup();
                throw new DSErr(jCException.getErrorCode());
            }
            tracer = EngineTrace.staticTracer;
        }
    }

    static void cleanup() {
        if (--initCount == 0) {
            try {
                if (context != null) {
                    context.free();
                }
            }
            catch (Throwable throwable) {
                StatusLog.logError(9089, throwable);
            }
            context = null;
            driverSetID = -1L;
            driverClassID = -1L;
            tracer = null;
        }
        if (initCount < 0) {
            initCount = 0;
        }
    }

    public static void logEvent(int n, int n2, Element element) {
        String string = null;
        if (element != null) {
            string = Events.getElementContent(null, element, true);
        }
        PersistentLog.logEvent(n, n2, null, 0L, null, null, null, null, 0L, 0L, 3L, string);
    }

    public static void logEvent(int n, int n2, String string) {
        PersistentLog.logEvent(n, n2, null, 0L, null, null, null, string, 0L, 0L, 0L, null);
    }

    public static void logEvent(int n, int n2, String string, long l, String string2, String string3, String string4, String string5, long l2, long l3, String string6) {
        PersistentLog.logEvent(n, n2, string, l, string2, string3, string4, string5, l2, l3, 1L, string6);
    }

    public static void logEvent(int n, int n2, String string, long l, String string2, String string3, String string4, String string5, long l2, long l3) {
        PersistentLog.logEvent(n, n2, string, l, string2, string3, string4, string5, l2, l3, 0L, null);
    }

    public static void logEvent(int n, int n2, String string, long l, String string2, String string3, String string4, String string5, long l2, long l3, Element element) {
        String string6 = null;
        if (element != null) {
            string6 = Events.getElementContent(null, element, true);
        }
        PersistentLog.logEvent(n, n2, string, l, string2, string3, string4, string5, l2, l3, 3L, string6);
    }

    public static void logEvent(int n, int n2, String string, long l, String string2, String string3, String string4, String string5, long l2, long l3, long l4, String string6) {
        int n3 = PersistentLog.getChannelID();
        LogSettings logSettings = PersistentLog.getChannelSettings(n3);
        if (logSettings.getLevel() == 3) {
            return;
        }
        if (!logSettings.filter(n)) {
            return;
        }
        if (n >= 1 && n <= 6) {
            boolean bl = false;
            if (string3 != null && string3.equals("app-connection")) {
                bl = true;
            }
            PersistentLog.logInternal(n3, n2, string6, string, bl);
        } else if (n == 38 || n == 39) {
            PersistentLog.logInternal(n3, n2, string4, string3, false);
        } else if (n == 34 || n == 35) {
            PersistentLog.logInternal(0, n2, string5, string, true);
        }
        PersistentLog.logToServices(n, n3, n2, string, l, string2, string3, string4, string5, l2, l3, l4, string6);
    }

    public static void logEvents(ArrayList arrayList, int n, int n2) {
        String string = null;
        long l = 0L;
        String string2 = null;
        long l2 = 0L;
        Object var9_7 = null;
        Object var10_8 = null;
        String string3 = null;
        if (arrayList == null) {
            return;
        }
        int n3 = 0;
        while (n3 < arrayList.size()) {
            Object var16_13 = null;
            Events.LogEvent logEvent = (Events.LogEvent)arrayList.get(n3);
            long l3 = 0L;
            if (logEvent != null) {
                Element element;
                int n4 = logEvent.getLevel();
                if (n4 == -1) {
                    n4 = n;
                }
                if (n3 == 0) {
                    string = string2 = logEvent.getTarget();
                    l = l2 = logEvent.getTargetType();
                } else {
                    string = logEvent.getTarget();
                    l = logEvent.getTargetType();
                    if (string == null) {
                        string = string2;
                        l = l2;
                    }
                }
                if (logEvent.getData() instanceof String) {
                    string3 = (String)logEvent.getData();
                    l3 = 1L;
                } else if (logEvent.getData() instanceof Element && (element = (Element)logEvent.getData()) != null) {
                    string3 = Events.getElementContent(null, element, true);
                    l3 = 3L;
                }
                PersistentLog.logEvent(logEvent.getEventID(), n4, string, l, logEvent.getSubTarget(), logEvent.getText1(), logEvent.getText2(), logEvent.getText3(), n2, 0L, l3, string3);
            }
            ++n3;
        }
    }

    public static void logUserEvent(int n, int n2, String string, long l, String string2, String string3, String string4, String string5, long l2, long l3, long l4, String string6) {
        int n3 = PersistentLog.getChannelID();
        PersistentLog.logToServices(n, n3, n2, string, l, string2, string3, string4, string5, l2, l3, l4, string6);
    }

    protected static void logInternal(int n, int n2, String string, String string2, boolean bl) {
        if (!(bl || n2 != 0 && n2 != 1)) {
            return;
        }
        LogSettings logSettings = PersistentLog.getChannelSettings(n);
        long l = -1L;
        if (n == 0) {
            l = driverSetID;
        } else {
            ConfigAbstraction configAbstraction = (ConfigAbstraction)ThreadGroupVars.get("registry");
            if (configAbstraction != null) {
                if (n == 1) {
                    l = configAbstraction.getSubscriberID();
                } else if (n == 2) {
                    l = configAbstraction.getPublisherID();
                }
            }
        }
        if (l == -1L) {
            l = driverSetID;
        }
        if (logSettings.getLevel() == 2) {
            PersistentLog.writeLogTime(l);
            return;
        }
        if (string == null || string.length() == 0) {
            string = messageSource.getMessage(NO_ERROR_DESCRIPTION, null);
        }
        if (string2 == null || string2.length() == 0) {
            string2 = messageSource.getMessage(NO_OBJECT_NAME, null);
        }
        PersistentLog.writeStatus(l, n2, string, string2, logSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static long writeLogTime(long l) {
        JCContext jCContext;
        long l2;
        block9: {
            long l3;
            block8: {
                l2 = System.currentTimeMillis() / 1000L;
                jCContext = null;
                try {
                    try {
                        if (context == null) {
                            l3 = l2;
                            Object var10_5 = null;
                            if (jCContext == null) return l3;
                            break block8;
                        }
                        jCContext = context.duplicate();
                        jCContext.setEntryID(l);
                        JCTimeValue jCTimeValue = new JCTimeValue();
                        jCTimeValue.setTime(l2);
                        jCTimeValue.attributeName = "DirXML-LastLogTime";
                        jCTimeValue.operation = 5;
                        JCValue[] jCValueArray = new JCValue[]{jCTimeValue};
                        JClient.modifyEntry((JCContext)jCContext, (JCValue[])jCValueArray);
                        break block9;
                    }
                    catch (Throwable throwable) {
                        if (tracer.getLevel() > 10) {
                            DDSTrace.trace((int)217, (int)12, (String)Errors.getMessage(9092, throwable));
                        } else {
                            DDSTrace.trace((int)217, (int)14, (String)Errors.getMessage(9092));
                        }
                        Object var10_7 = null;
                        if (jCContext == null) return l2;
                        jCContext.free();
                        return l2;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_8 = null;
                    if (jCContext == null) throw throwable;
                    jCContext.free();
                    throw throwable;
                }
            }
            jCContext.free();
            return l3;
        }
        Object var10_6 = null;
        if (jCContext == null) return l2;
        jCContext.free();
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void writeStatus(long l, int n, String string, String string2, LogSettings logSettings) {
        JCContext jCContext;
        block19: {
            block17: {
                long l2 = PersistentLog.writeLogTime(l);
                if (logSettings.getLevel() == 2) {
                    return;
                }
                jCContext = null;
                try {
                    try {
                        if (context == null) {
                            Object var14_7 = null;
                            if (jCContext == null) return;
                            break block17;
                        }
                        jCContext = context.duplicate();
                        jCContext.setEntryID(l);
                    }
                    catch (Throwable throwable) {
                        String string3 = MiscDS.getEntryDN(l);
                        if (tracer.getLevel() > 10) {
                            DDSTrace.trace((int)217, (int)12, (String)Errors.getMessage(9090, string3, throwable));
                        } else {
                            DDSTrace.trace((int)217, (int)14, (String)Errors.getMessage(9090, string3));
                        }
                        Object var14_8 = null;
                        if (jCContext == null) return;
                        jCContext.free();
                        return;
                    }
                    try {
                        JCValue[] jCValueArray;
                        block18: {
                            JCReadFilter jCReadFilter = new JCReadFilter(false, new JCTimestamp(), new String[]{"DirXML-StatusLog"});
                            jCValueArray = null;
                            try {
                                jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                            }
                            catch (JCException jCException) {
                                if (jCException.getErrorCode() == -602 || jCException.getErrorCode() == -603) break block18;
                                String string4 = MiscDS.getEntryDN(l);
                                if (tracer.getLevel() > 10) {
                                    DDSTrace.trace((int)217, (int)12, (String)Errors.getMessage(9091, string4, (Object)jCException));
                                    throw jCException;
                                }
                                DDSTrace.trace((int)217, (int)14, (String)Errors.getMessage(9091, string4));
                                throw jCException;
                            }
                        }
                        if (jCValueArray != null && jCValueArray.length > logSettings.getLimit()) {
                            PersistentLog.removeOldValues(jCContext, jCValueArray, logSettings.getLimit());
                        }
                        JCCIlistValue jCCIlistValue = new JCCIlistValue();
                        jCCIlistValue.attributeName = "DirXML-StatusLog";
                        int n2 = Events.convertToIDMLevel(n);
                        jCCIlistValue.addString(Long.toString(l2));
                        jCCIlistValue.addString("\r\n" + NdsDtd.getLocalizedLevelString(n2) + "\r\n");
                        jCCIlistValue.addString(string + "\r\n");
                        jCCIlistValue.addString(string2 + "\r\n");
                        jCCIlistValue.operation = 5;
                        JClient.modifyEntry((JCContext)jCContext, (JCValue[])new JCValue[]{jCCIlistValue});
                    }
                    catch (JCException jCException) {
                        if (jCException.getErrorCode() == -614) break block19;
                        if (tracer.getLevel() > 10) {
                            DDSTrace.trace((int)217, (int)12, (String)Errors.getMessage(9092, (Object)jCException));
                            break block19;
                        }
                        DDSTrace.trace((int)217, (int)14, (String)Errors.getMessage(9092));
                    }
                    catch (Throwable throwable) {
                        if (tracer.getLevel() > 10) {
                            DDSTrace.trace((int)217, (int)12, (String)Errors.getMessage(9092, throwable));
                            break block19;
                        }
                        DDSTrace.trace((int)217, (int)14, (String)Errors.getMessage(9092));
                    }
                    break block19;
                }
                catch (Throwable throwable) {
                    Object var14_10 = null;
                    if (jCContext == null) throw throwable;
                    jCContext.free();
                    throw throwable;
                }
            }
            jCContext.free();
            return;
        }
        Object var14_9 = null;
        if (jCContext == null) return;
        jCContext.free();
    }

    protected static void logToServices(int n, int n2, int n3, String string, long l, String string2, String string3, String string4, String string5, long l2, long l3, long l4, String string6) {
        byte[] byArray;
        LogSettings.LogTimestamp logTimestamp;
        long l5;
        String string7;
        block11: {
            string7 = null;
            l5 = 1L;
            if (!ontarioAvailable) {
                return;
            }
            ConfigAbstraction configAbstraction = (ConfigAbstraction)ThreadGroupVars.get("registry");
            if (configAbstraction != null) {
                l5 = 1L;
                if (n2 == 1) {
                    string7 = configAbstraction.getSubscriberDN();
                } else if (n2 == 2) {
                    string7 = configAbstraction.getPublisherDN();
                }
                if (string7 == null || string7.length() == 0) {
                    string7 = configAbstraction.getDriverDN();
                }
                if (n == 34 || n == 35 || string7 == null || string7.equals(string)) {
                    string7 = configAbstraction.getDriverSetDN();
                }
            }
            if ((logTimestamp = (LogSettings.LogTimestamp)ThreadVars.get("logEventTS")) == null) {
                logTimestamp = new LogSettings.LogTimestamp();
            }
            byArray = null;
            try {
                if (string6 != null) {
                    byArray = string6.getBytes("UTF-8");
                }
            }
            catch (Throwable throwable) {
                if (string6 == null) break block11;
                byArray = string6.getBytes();
            }
        }
        PersistentLog.writeToLogService(Events.Component(n2), Events.ontarioEvent(n), n3, string7, l5, string, l, string2, string3, string4, string5, l2, logTimestamp.getTickCount(), l3, logTimestamp.getSeconds(), l4, byArray);
    }

    protected static void removeOldValues(JCContext jCContext, JCValue[] jCValueArray, int n) throws JCException {
        block4: {
            JCTimeStampComparator jCTimeStampComparator = new JCTimeStampComparator();
            Arrays.sort(jCValueArray, jCTimeStampComparator);
            try {
                int n2 = jCValueArray.length - n + n / 2;
                if (n2 <= 0) {
                    return;
                }
                JCValue[] jCValueArray2 = new JCValue[n2];
                int n3 = 0;
                do {
                    JCCIlistValue jCCIlistValue = (JCCIlistValue)jCValueArray[n3];
                    jCCIlistValue.operation = 3;
                    jCValueArray2[n3] = jCCIlistValue;
                    ++n3;
                } while (--n2 > 0);
                JClient.modifyEntry((JCContext)jCContext, (JCValue[])jCValueArray2);
            }
            catch (JCException jCException) {
                if (jCException.getErrorCode() == -602) break block4;
                throw jCException;
            }
        }
    }

    protected static String getMessage(Element element) {
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 3) {
                return XPathUtil.getNodeValue((Node)node);
            }
            node = node.getNextSibling();
        }
        Element element2 = (Element)element.getElementsByTagNameNS(null, "description").item(0);
        return element2 == null ? null : XPathUtil.getNodeValue((Node)element2);
    }

    protected static String getObjectDN(Element element) {
        Element element2 = (Element)element.getElementsByTagNameNS(null, "object-dn").item(0);
        return element2 == null ? null : XPathUtil.getNodeValue((Node)element2);
    }

    protected static int getChannelID() {
        Transformer transformer = (Transformer)ThreadVars.get("channel");
        int n = transformer != null ? transformer.getChannelID() : 0;
        return n;
    }

    protected static LogSettings getChannelSettings(int n) {
        ConfigAbstraction configAbstraction;
        LogSettings logSettings = null;
        logSettings = n == 0 ? ConfigAbstraction.getDriverSetLogSettings() : ((configAbstraction = (ConfigAbstraction)ThreadGroupVars.get("registry")) != null ? configAbstraction.getLogSettings() : ConfigAbstraction.getDriverSetLogSettings());
        return logSettings;
    }

    protected static native boolean isOntarioAvailable();

    protected static native void writeToLogService(String var0, long var1, long var3, String var5, long var6, String var8, long var9, String var11, String var12, String var13, String var14, long var15, long var17, long var19, long var21, long var23, byte[] var25);

    static {
        messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.PersistentLog");
    }

    static class JCTimeStampComparator
    implements Comparator {
        JCTimeStampComparator() {
        }

        public int compare(Object object, Object object2) {
            JCValue jCValue = (JCValue)object;
            JCValue jCValue2 = (JCValue)object2;
            JCTimestamp jCTimestamp = jCValue.timestamp;
            JCTimestamp jCTimestamp2 = jCValue2.timestamp;
            int n = jCTimestamp.seconds.compareTo(jCTimestamp2.seconds);
            if (n == 0) {
                n = jCTimestamp.event - jCTimestamp2.event;
            }
            return n;
        }

        public boolean equals(Object object) {
            return object == this;
        }
    }
}

