/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.driver.PublicationShim;
import com.novell.nds.dirxml.driver.XmlCommandProcessor;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.nds.dirxml.engine.Association;
import com.novell.nds.dirxml.engine.ConfigAbstraction;
import com.novell.nds.dirxml.engine.Driver;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.Entry;
import com.novell.nds.dirxml.engine.Errors;
import com.novell.nds.dirxml.engine.KeyAccepter;
import com.novell.nds.dirxml.engine.KeyDeliverer;
import com.novell.nds.dirxml.engine.LogSettings;
import com.novell.nds.dirxml.engine.NDSReader;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.OperationData;
import com.novell.nds.dirxml.engine.PersistentLog;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.ThreadGroupVars;
import com.novell.nds.dirxml.engine.ThreadVars;
import com.novell.nds.dirxml.engine.Transformer;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.Warnings;
import com.novell.nds.dirxml.engine.XdsCommandProcessor;
import com.novell.nds.dirxml.engine.XdsQueryProcessor;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.XmlInputProcessor;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.url.NDSURLConnection;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.xml.dom.DOMUtil;
import novell.jclient.JCContext;
import novell.jclient.JCEntryInfo;
import novell.jclient.JClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Publisher
extends Transformer
implements XmlCommandProcessor,
XdsQueryProcessor,
Runnable,
KeyAccepter {
    protected XmlInputProcessor processor;
    protected PublicationShim shim;
    protected Object executeGate = new Object();
    protected boolean shutdown = false;
    protected XdsCommandProcessor srcCommandProcessor = new SrcCommandProcessor();
    protected XdsCommandProcessor destCommandProcessor = new DestCommandProcessor();
    protected RuleDynamicContext nullDynamicContext = new RuleDynamicContext(null, null, null, null, this.context);
    protected static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.Publisher", Transformer.messageSource);
    protected static final String CREATING_PUBLISHER = "pt_crtpub";
    protected static final String CREATING_PUBLISHER_THREAD = "pt_crtpthd";
    protected static final String PUBLISHER_THREAD_CREATED = "pt_crdpthd";
    protected static final String RECEIVING_DOC_FROM_APP = "pt_rcvdom";
    protected static final String IN_PUBLISHER_THREAD = "pt_inpubth";
    protected static final String INIT_PUBLISHER_SHIM = "pt_ipubshm";
    protected static final String INIT_PUBLISHER_RET = "pt_ipubret";
    protected static final String START_PUBLISHER_RET = "pt_spubret";
    protected static final String KILL_FROM_PUBLISHER = "pt_killpub";
    protected static final String ENDING_PUBLISHER_THREAD = "pt_endpub";
    protected static final String APPLYING_PUBLISHER_FILTER = "pt_apubfil";
    protected static final String SKIPPING_PUBLISHER_FILTER = "pt_spubfil";
    protected static final String PUBLISHER_PROCESSING_OP = "pt_pubproc";
    protected static final String FOUND_ASSOCIATED_OBJECT = "pt_fndassob";
    protected static final String MERGE_SCHEDULING_UPDATE = "pt_mrgschup";
    protected static final String MERGE_MISSING_ASSOCIATION = "pt_mrgnoass";
    protected static final String MERGE_NO_OBJECTS = "pt_mrgnoobj";
    protected static final String CONVERTING_MODIFY_TO_ADD = "pt_cnvmadd";
    protected static final String OPTIMIZE_MODIFY_RET = "pt_omodret";
    protected static final String OPTIMIZE_MODIFY_VETO = "pt_omveto";
    protected static final String QUERYING_PUBLISHER_SHIM = "pt_qpubshm";
    protected static final String PUBLISHER_SHIM_RET = "pt_qpubret";
    protected static final String KILL_FROM_PUBLISHER_QUERY = "pt_qkillpub";
    protected static final String SYNC_MERGE = "pt_syncmerge";
    protected static final String SYNC_ADD = "pt_syncadd";
    protected static final String QUEUED_WRITEBACK = "pt_queuedwb";
    Thread publisherThread;

    public Publisher(Driver driver, ConfigAbstraction configAbstraction, PublicationShim publicationShim, EngineTrace engineTrace) throws VRDException {
        super(driver, configAbstraction, 2, engineTrace);
        this.tracer.trace(CREATING_PUBLISHER, (MessageSource)messageSource);
        this.shim = publicationShim;
        this.init();
    }

    protected void init() throws VRDException {
        this.loadDriverRules();
        Entry entry = this.registry.getPublisher();
        if (entry != null) {
            this.loadChannelRules(entry, false);
        }
        this.processor = new XmlInputProcessor(this.registry.getContext(), this.driver, this.tracer);
        this.processor.setDriverDN(this.registry.getDriverDN());
    }

    protected void start() {
        this.tracer.trace(CREATING_PUBLISHER_THREAD, (MessageSource)messageSource);
        String string = (String)ThreadGroupVars.get("vrDriverDN");
        this.publisherThread = new Thread(Thread.currentThread().getThreadGroup(), this, string + " - Publisher");
        this.publisherThread.start();
        this.tracer.trace(PUBLISHER_THREAD_CREATED, (MessageSource)messageSource);
    }

    protected boolean waitForThreadEnd(long l) {
        if (this.publisherThread != null) {
            try {
                this.publisherThread.join(l);
                return !this.publisherThread.isAlive();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDocument execute(XmlDocument xmlDocument, XmlQueryProcessor xmlQueryProcessor) {
        Object object = this.executeGate;
        synchronized (object) {
            Object object2;
            Object object3;
            this.tracer.trace(RECEIVING_DOC_FROM_APP, (MessageSource)messageSource);
            this.tracer.trace(xmlDocument);
            LogSettings logSettings = this.registry.getLogSettings();
            LogSettings.LogTimestamp logTimestamp = LogSettings.getLogTimestamp();
            ThreadVars.put("logEventTS", logTimestamp);
            Document document = null;
            try {
                PersistentLog.logEvent(20, 7, xmlDocument.getDocumentNS().getDocumentElement());
                object3 = new RawAppProcessor(xmlQueryProcessor);
                document = this.applyInputTransformation(xmlDocument.getDocumentNS(), new RuleDynamicContext((XdsQueryProcessor)object3, this, (XdsCommandProcessor)object3, this.destCommandProcessor, this.context));
                this.registry.writeDriverState(document, "input");
                object2 = new RuleDynamicContext(new PublisherAppQueryProcessor(xmlQueryProcessor), this, this.srcCommandProcessor, this.destCommandProcessor, this.context);
                document = this.processEvents(document, (RuleDynamicContext)object2);
                document = this.applyOutputTransformation(document, new RuleDynamicContext(this, (XdsQueryProcessor)object3, this.destCommandProcessor, (XdsCommandProcessor)object3, this.context));
            }
            catch (VRDException vRDException) {
                document = NdsDtd.createStatusDocument(vRDException, null);
                StatusLog.log(document);
                if (vRDException.isFatal()) {
                    this.driver.killDriver();
                }
            }
            catch (Throwable throwable) {
                document = NdsDtd.createStatusDocument(throwable, null);
                StatusLog.log(document);
            }
            object3 = new XmlDocument(document);
            this.tracer.trace((XmlDocument)object3);
            ThreadVars.remove("logEventTS");
            object2 = object3;
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document execute(Document document, RuleDynamicContext ruleDynamicContext) {
        Object object = this.executeGate;
        synchronized (object) {
            LogSettings logSettings = this.registry.getLogSettings();
            LogSettings.LogTimestamp logTimestamp = LogSettings.getLogTimestamp();
            ThreadVars.put("logEventTS", logTimestamp);
            Document document2 = null;
            try {
                PersistentLog.logEvent(20, 7, document.getDocumentElement());
                document2 = this.processEvents(document, ruleDynamicContext);
            }
            catch (VRDException vRDException) {
                document2 = NdsDtd.createStatusDocument(vRDException, null);
                StatusLog.log(document2);
                if (vRDException.isFatal()) {
                    this.driver.killDriver();
                }
            }
            catch (Throwable throwable) {
                document2 = NdsDtd.createStatusDocument(throwable, null);
                StatusLog.log(document2);
            }
            ThreadVars.remove("logEventTS");
            Document document3 = document2;
            return document3;
        }
    }

    protected void shutdown() {
        if (this.processor != null) {
            this.processor.shutdown();
        }
        this.driver = null;
        this.processor = null;
        this.shim = null;
        this.executeGate = null;
        super.shutdown();
    }

    public synchronized void run() {
        boolean bl = false;
        this.tracer.setPublisherThread();
        ThreadVars.put("channel", this);
        ThreadVars.put("default-tracer", this.tracer);
        this.tracer.trace(IN_PUBLISHER_THREAD, (MessageSource)messageSource);
        try {
            this.registry.setDriverThreadID(this.registry.getDriverID(), true);
            NDSURLConnection.setThreadBaseContext(this.context);
            Document document = this.registry.getInitParams("publisher-options", "publisher-state");
            if (this.outputMapper != null) {
                document = this.outputMapper.applyRules(document, this.nullDynamicContext);
            }
            XmlDocument xmlDocument = new XmlDocument(document);
            this.tracer.trace(INIT_PUBLISHER_SHIM, (MessageSource)messageSource);
            this.tracer.trace(xmlDocument);
            XmlDocument xmlDocument2 = this.shim.init(xmlDocument);
            if (this.tracer.getLevel() > 1) {
                this.tracer.trace(INIT_PUBLISHER_RET, (MessageSource)messageSource);
                this.tracer.trace(xmlDocument2);
            }
            document = null;
            xmlDocument = null;
            if (xmlDocument2 != null) {
                xmlDocument2.setDocument(this.applyInputTransformation(xmlDocument2.getDocumentNS(), this.nullDynamicContext));
                this.registry.writeDriverState(xmlDocument2.getDocumentNS(), "output");
            }
            Driver.checkShimError(xmlDocument2, true);
            this.driver.setInitState(4);
            xmlDocument2 = null;
            if (this.driver.isTrustedDriver() && this.shim instanceof KeyDeliverer) {
                ((KeyDeliverer)((Object)this.shim)).setAccepter(this);
            }
            this.driver.setInitState(8);
            xmlDocument2 = this.shim.start(this);
            if (this.tracer.getLevel() > 1) {
                this.tracer.trace(START_PUBLISHER_RET, (MessageSource)messageSource);
                this.tracer.trace(xmlDocument2);
            }
            if (xmlDocument2 != null) {
                xmlDocument2.setDocument(this.applyInputTransformation(xmlDocument2.getDocumentNS(), this.nullDynamicContext));
                this.registry.writeDriverState(xmlDocument2.getDocumentNS(), "output");
            }
            Driver.checkShimError(xmlDocument2, true);
            if (!this.driver.isShuttingDown()) {
                throw new VRDException(9021);
            }
        }
        catch (Throwable throwable) {
            if (!this.driver.isUp()) {
                this.driver.setInitState(16);
            }
            StatusLog.log(throwable);
            bl = true;
        }
        ThreadVars.removeAll();
        if (bl) {
            this.tracer.trace(KILL_FROM_PUBLISHER, (MessageSource)messageSource);
            this.driver.killDriver();
        }
        NDSURLConnection.setThreadBaseContext(null);
        this.tracer.trace(ENDING_PUBLISHER_THREAD, (MessageSource)messageSource);
    }

    public void acceptKey(byte[] byArray) {
        this.driver.setInKey(byArray);
    }

    protected Document processEvents(Document document, RuleDynamicContext ruleDynamicContext) throws VRDException {
        Element element;
        document = XdsUtil.cloneDocument(document);
        if (this.eventTransformationRule != null) {
            this.tracer.trace("tt_aexform", (MessageSource)messageSource);
            document = this.eventTransformationRule.applyRules(document, ruleDynamicContext);
            PersistentLog.logEvent(23, 7, document.getDocumentElement());
        } else {
            this.tracer.trace("tt_nexform", (MessageSource)messageSource);
            PersistentLog.logEvent(23, 7, messageSource.getMessageString("tt_nexform"));
        }
        Element element2 = XdsUtil.getFirstElementByTagNameNS(document, null, "input");
        if (element2 == null) {
            return NdsDtd.createStatusDocument(3, null, Errors.getMessage(9042, "nds", "input"));
        }
        Element element3 = document.createElementNS(null, "input");
        element2.getParentNode().replaceChild(element3, element2);
        Element element4 = NdsDtd.createDoc("output");
        while ((element = XdsUtil.getFirstChildElement(element2)) != null) {
            Object object;
            Object object2;
            String string = element.getNodeName();
            if ((string.equals("add") || string.equals("modify") || string.equals("delete") || string.equals("rename") || string.equals("move") || string.equals("modify-password") || string.equals("check-object-password") || string.equals("sync")) && (object2 = this.resolveAssociation(element)) != null) {
                if (object2[0].getAssociationState() == 0) {
                    object = new OperationData(element);
                    NdsDtd.addStatusElement(element4, 2, (OperationData)object, Warnings.getMessage(8002, string));
                    ThreadVars.put("currentObject", element.getAttributeNS(null, "src-dn"));
                    StatusLog.log((Element)element4.getLastChild());
                    ThreadVars.remove("currentObject");
                    element2.removeChild(element);
                    continue;
                }
                this.resolveClassName(element, object2[0]);
            }
            element3.appendChild(element);
            object2 = this.processEvent(document, ruleDynamicContext);
            object = XdsUtil.getFirstElementByTagNameNS((Node)object2, null, "output");
            if (object != null) {
                Node node = object.getFirstChild();
                while (node != null) {
                    XdsUtil.graftSubtree(element4, node);
                    node = node.getNextSibling();
                }
            }
            XdsUtil.removeAllChildren(element3);
        }
        return element4.getOwnerDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Document processEvent(Document document, RuleDynamicContext ruleDynamicContext) {
        String string;
        Document document2;
        block21: {
            Document document3;
            block20: {
                Document document4;
                block18: {
                    block19: {
                        document2 = null;
                        string = null;
                        OperationData operationData = null;
                        try {
                            try {
                                Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "input");
                                Element element2 = XdsUtil.getFirstChildElement(element);
                                string = element2.getNodeName();
                                operationData = new OperationData(element2);
                                String string2 = element2.getAttributeNS(null, "src-dn");
                                ThreadVars.put("currentObject", string2);
                                if (!(string.equals("query") || string.equals("check-object-password") || string.equals("get-named-password"))) {
                                    this.tracer.trace(APPLYING_PUBLISHER_FILTER, (MessageSource)messageSource);
                                    document = this.filter.filterDocument(document, 1, 2, false);
                                    PersistentLog.logEvent(30, 7, document.getDocumentElement());
                                    element = XdsUtil.getFirstElementByTagNameNS(document, null, "input");
                                    if (element == null) {
                                        document4 = NdsDtd.createStatusDocument(2, operationData, Warnings.getMessage(8015));
                                        Object var11_14 = null;
                                        if (string != null && (string.equals("query") || string.equals("check-password") || string.equals("check-object-password") || string.equals("status"))) break block18;
                                        break block19;
                                    }
                                    element2 = XdsUtil.getFirstChildElement(element);
                                    if (element2 == null) {
                                        document3 = NdsDtd.createStatusDocument(2, operationData, Warnings.getMessage(8015));
                                        break block20;
                                    }
                                    string = element2.getNodeName();
                                    string2 = element2.getAttributeNS(null, "src-dn");
                                } else {
                                    this.tracer.trace(SKIPPING_PUBLISHER_FILTER, (MessageSource)messageSource, string);
                                }
                                this.tracer.trace(PUBLISHER_PROCESSING_OP, (MessageSource)messageSource, string, (Object)string2);
                                String string3 = element2.getAttributeNS(null, "dest-dn");
                                if (string3.length() == 0) {
                                    ThreadVars.put("currentObject", string2);
                                } else {
                                    ThreadVars.put("currentObject", string2 + " (" + string3 + ")");
                                }
                                document2 = string.equals("add") ? this.processAdd(document, ruleDynamicContext) : (string.equals("modify") ? this.processModify(document, ruleDynamicContext) : (string.equals("delete") ? this.processDelete(document, ruleDynamicContext) : (string.equals("rename") ? this.processRename(document, ruleDynamicContext) : (string.equals("move") ? this.processMove(document, ruleDynamicContext) : (string.equals("sync") ? this.processSync(document, ruleDynamicContext) : (string.equals("modify-password") ? this.processModifyPassword(document, ruleDynamicContext) : this.processCommand(document, ruleDynamicContext, true)))))));
                                break block21;
                            }
                            catch (VRDException vRDException) {
                                document2 = NdsDtd.createStatusDocument(vRDException, null);
                                if (vRDException.isFatal()) {
                                    this.driver.killDriver();
                                }
                                Object var11_17 = null;
                                if (string == null || !string.equals("query") && !string.equals("check-password") && !string.equals("check-object-password") && !string.equals("status")) {
                                    StatusLog.log(document2);
                                }
                                ThreadVars.remove("currentObject");
                                return document2;
                            }
                            catch (Throwable throwable) {
                                document2 = NdsDtd.createStatusDocument(throwable, operationData);
                                Object var11_18 = null;
                                if (string == null || !string.equals("query") && !string.equals("check-password") && !string.equals("check-object-password") && !string.equals("status")) {
                                    StatusLog.log(document2);
                                }
                                ThreadVars.remove("currentObject");
                                return document2;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_19 = null;
                            if (string == null || !string.equals("query") && !string.equals("check-password") && !string.equals("check-object-password") && !string.equals("status")) {
                                StatusLog.log(document2);
                            }
                            ThreadVars.remove("currentObject");
                            throw throwable;
                        }
                    }
                    StatusLog.log(document2);
                }
                ThreadVars.remove("currentObject");
                return document4;
            }
            Object var11_15 = null;
            if (string == null || !string.equals("query") && !string.equals("check-password") && !string.equals("check-object-password") && !string.equals("status")) {
                StatusLog.log(document2);
            }
            ThreadVars.remove("currentObject");
            return document3;
        }
        Object var11_16 = null;
        if (string == null || !string.equals("query") && !string.equals("check-password") && !string.equals("check-object-password") && !string.equals("status")) {
            StatusLog.log(document2);
        }
        ThreadVars.remove("currentObject");
        return document2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Document processAdd(Document document, RuleDynamicContext ruleDynamicContext) throws VRDException {
        String string;
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "add");
        OperationData operationData = new OperationData(element);
        String string2 = element.getAttributeNS(null, "src-dn");
        String string3 = XdsUtil.getAssociationValue(element);
        String string4 = element.getAttributeNS(null, "class-name");
        Entry entry = XdsUtil.getDestEntry(element);
        if (entry != null && entry.getEntryID() != -1L) {
            this.tracer.trace(FOUND_ASSOCIATED_OBJECT, (MessageSource)messageSource);
            return this.processMerge(entry, string3, string4, operationData, ruleDynamicContext, document);
        }
        if (this.matchingRule != null) {
            this.tracer.trace("tt_amrule", (MessageSource)messageSource);
            document = this.matchingRule.applyRules(document, ruleDynamicContext);
            PersistentLog.logEvent(28, 7, document.getDocumentElement());
            element = XdsUtil.getFirstElementByTagNameNS(document, null, "add");
            if (element == null) {
                return NdsDtd.createStatusDocument(2, operationData, Warnings.getMessage(8016));
            }
            entry = XdsUtil.getDestEntry(element);
            if (entry != null && (string = entry.getDN()).length() != 0) {
                if (string.equals("\ufffd")) {
                    return NdsDtd.createStatusDocument(3, operationData, Errors.getMessage(9062));
                }
                if (string.equals("\ufffc")) {
                    return NdsDtd.createStatusDocument(3, operationData, Errors.getMessage(9063));
                }
                ThreadVars.put("currentObject", string2 + " (" + string + ")");
                this.tracer.trace("tt_mchfnd", (MessageSource)messageSource, string);
                Association.addAssociation(this.context, this.registry.getDriverDN(), XdsUtil.getDestEntry(element), string3, 1);
                return this.processMerge(entry, string3, string4, operationData, ruleDynamicContext, document);
            }
            this.tracer.trace("tt_nmchfnd", (MessageSource)messageSource);
            PersistentLog.logEvent(28, 6, messageSource.getMessageString("tt_nmchfnd"));
        } else {
            this.tracer.trace("tt_nmrule", (MessageSource)messageSource);
            PersistentLog.logEvent(28, 7, messageSource.getMessageString("tt_nmrule"));
        }
        if (this.createRule != null) {
            this.tracer.trace("tt_acrule", (MessageSource)messageSource);
            document = this.createRule.applyRules(document, ruleDynamicContext);
            PersistentLog.logEvent(25, 7, document.getDocumentElement());
            element = XdsUtil.getFirstElementByTagNameNS(document, null, "add");
            if (element == null) {
                return NdsDtd.createStatusDocument(2, operationData, Warnings.getMessage(8017));
            }
        } else {
            this.tracer.trace("tt_ncrule", (MessageSource)messageSource);
            PersistentLog.logEvent(25, 7, messageSource.getMessageString("tt_ncrule"));
        }
        if (this.placementRule != null) {
            this.tracer.trace("tt_aprule", (MessageSource)messageSource);
            document = this.placementRule.applyRules(document, ruleDynamicContext);
            PersistentLog.logEvent(24, 7, document.getDocumentElement());
            element = XdsUtil.getFirstElementByTagNameNS(document, null, "add");
            if (element == null) {
                return NdsDtd.createStatusDocument(2, operationData, Warnings.getMessage(8018));
            }
            element = XdsUtil.getFirstElementByTagNameNS(document, null, "add");
            string = element.getAttributeNS(null, "dest-dn");
            if (string.length() == 0) return NdsDtd.createStatusDocument(3, operationData, Errors.getMessage(9064));
            ThreadVars.put("currentObject", string2 + " (" + string + ")");
        } else {
            this.tracer.trace("tt_nprule", (MessageSource)messageSource);
            PersistentLog.logEvent(24, 7, messageSource.getMessageString("tt_nprule"));
        }
        this.addAuxClassesToAdd(document);
        return this.processCommand(document, ruleDynamicContext, true);
    }

    protected Document processMerge(Entry entry, String string, String string2, OperationData operationData, RuleDynamicContext ruleDynamicContext, Document document) throws VRDException {
        this.tracer.trace("tt_merge", (MessageSource)messageSource);
        Document document2 = document;
        if (document2 != null) {
            document2 = this.convertAddToInstance(document2);
            document2 = this.filter.filterDocument(document2, 1, 0, true);
        }
        Document[] documentArray = this.createMergeDocuments(entry, this, null, string, ruleDynamicContext.srcQueryProcessor0, document2, string2, operationData);
        Document document3 = null;
        if (documentArray[0] != null) {
            this.tracer.trace("tt_updnds", (MessageSource)messageSource);
            this.tracer.trace(documentArray[0]);
            PersistentLog.logEvent(44, 6, entry.getDN(), 1L, "Object Class", string2, "publisher", string, 0L, 0L, documentArray[0].getDocumentElement());
            document3 = this.processCommand(documentArray[0], ruleDynamicContext, true);
        } else {
            document3 = NdsDtd.createStatusDocument(0, operationData, "");
        }
        if (documentArray[1] != null) {
            this.tracer.trace(MERGE_SCHEDULING_UPDATE, (MessageSource)messageSource);
            this.tracer.trace(documentArray[1]);
            PersistentLog.logEvent(44, 6, entry.getDN(), 1L, "Object Class", string2, "subscriber", string, 0L, 0L, documentArray[1].getDocumentElement());
            this.driver.addWork(1, documentArray[1]);
        }
        return document3;
    }

    protected void processReset(Document document, Entry entry, RuleDynamicContext ruleDynamicContext) {
        this.tracer.trace("tt_rstapp", (MessageSource)messageSource);
        this.tracer.trace(document);
        PersistentLog.logEvent(46, 6, entry.getDN(), 1L, "subscriber", null, null, null, 0L, 0L, document.getDocumentElement());
        this.driver.addWork(1, document);
    }

    protected Entry[] resolveAssociation(Element element) throws VRDException {
        String string = XdsUtil.getAssociationValue(element);
        Entry entry = XdsUtil.getDestEntry(element);
        if (entry != null && entry.getEntryID() != -1L) {
            return new Entry[]{entry};
        }
        if (string.length() == 0) {
            if (entry != null) {
                return new Entry[]{entry};
            }
            this.tracer.trace(MERGE_MISSING_ASSOCIATION, (MessageSource)messageSource);
            return null;
        }
        Entry[] entryArray = Association.lookupEntry(this.context, this.registry.getDriverDN(), string);
        if (entryArray == null) {
            this.tracer.trace(MERGE_NO_OBJECTS, (MessageSource)messageSource);
            return entryArray;
        }
        Node node = element.getParentNode();
        element.setAttributeNS(null, "dest-dn", entryArray[0].getDN());
        element.setAttributeNS(null, "dest-entry-id", String.valueOf(entryArray[0].getEntryID()));
        int n = 1;
        while (n < entryArray.length) {
            if (entryArray[n].getAssociationState() != 0) {
                Element element2 = (Element)element.cloneNode(true);
                element2.setAttributeNS(null, "dest-dn", entryArray[n].getDN());
                element2.setAttributeNS(null, "dest-entry-id", String.valueOf(entryArray[n].getEntryID()));
                node.insertBefore(element2, element.getNextSibling());
                DOMUtil.addNamespaceDecls((Node)element2);
                element = element2;
            }
            ++n;
        }
        return entryArray;
    }

    protected Document processModify(Document document, RuleDynamicContext ruleDynamicContext) throws VRDException {
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "modify");
        OperationData operationData = new OperationData(element);
        if (XdsUtil.getDestEntry(element) == null) {
            this.tracer.trace(CONVERTING_MODIFY_TO_ADD, (MessageSource)messageSource);
            document = this.convertModifyToAdd(document, ruleDynamicContext.srcQueryProcessor0, true, operationData);
            return this.processAdd(document, ruleDynamicContext);
        }
        if ((document = this.optimizeModify(document, this, true)) != null) {
            if (this.tracer.getLevel() > 2) {
                this.tracer.trace(OPTIMIZE_MODIFY_RET, (MessageSource)messageSource);
                this.tracer.trace(document);
            }
            return this.processCommand(document, ruleDynamicContext, true);
        }
        this.tracer.trace(OPTIMIZE_MODIFY_VETO, (MessageSource)messageSource);
        return NdsDtd.createStatusDocument(0, operationData, "");
    }

    protected Document processDelete(Document document, RuleDynamicContext ruleDynamicContext) throws VRDException {
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "delete");
        OperationData operationData = new OperationData(element);
        if (XdsUtil.getDestEntry(element) == null) {
            return NdsDtd.createStatusDocument(2, operationData, Warnings.getMessage(8019));
        }
        return this.processCommand(document, ruleDynamicContext, true);
    }

    protected Document processRename(Document document, RuleDynamicContext ruleDynamicContext) throws VRDException {
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "rename");
        OperationData operationData = new OperationData(element);
        if (XdsUtil.getDestEntry(element) == null) {
            return NdsDtd.createStatusDocument(2, operationData, Warnings.getMessage(8019));
        }
        return this.processCommand(document, ruleDynamicContext, true);
    }

    protected Document processMove(Document document, RuleDynamicContext ruleDynamicContext) throws VRDException {
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "move");
        OperationData operationData = new OperationData(element);
        if (XdsUtil.getDestEntry(element) == null) {
            return NdsDtd.createStatusDocument(2, operationData, Warnings.getMessage(8019));
        }
        return this.processCommand(document, ruleDynamicContext, true);
    }

    protected Document processModifyPassword(Document document, RuleDynamicContext ruleDynamicContext) throws VRDException {
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "modify-password");
        OperationData operationData = new OperationData(element);
        if (XdsUtil.getDestEntry(element) == null) {
            return NdsDtd.createStatusDocument(2, operationData, Warnings.getMessage(8019));
        }
        return this.processCommand(document, ruleDynamicContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resolveClassName(Element element, Entry entry) {
        JCContext jCContext = null;
        try {
            try {
                jCContext = this.context.duplicate();
                entry.goTo(jCContext);
                JCEntryInfo jCEntryInfo = JClient.getEntryInfo((JCContext)jCContext, (int)2052);
                element.setAttributeNS(null, "class-name", NDSReader.getBaseClass(jCEntryInfo));
            }
            catch (Exception exception) {
                Object var6_7 = null;
                if (jCContext == null) return;
                jCContext.free();
                return;
            }
            Object var6_6 = null;
            if (jCContext == null) return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (jCContext == null) throw throwable;
            jCContext.free();
            throw throwable;
        }
        jCContext.free();
    }

    protected Document processSync(Document document, RuleDynamicContext ruleDynamicContext) throws VRDException {
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "sync");
        OperationData operationData = new OperationData(element);
        String string = element.getAttributeNS(null, "class-name");
        String string2 = XdsUtil.getAssociationValue(element);
        Entry entry = XdsUtil.getDestEntry(element);
        if (entry != null) {
            PersistentLog.logEvent(19, 6, entry.getDN(), 1L, "Object Class", string, string2, messageSource.getMessageString(SYNC_MERGE), 0L, 0L, element);
            this.tracer.trace(FOUND_ASSOCIATED_OBJECT, (MessageSource)messageSource);
            return this.processMerge(entry, string2, string, operationData, ruleDynamicContext, null);
        }
        PersistentLog.logEvent(19, 6, string2, 4L, "Object Class", string, string2, messageSource.getMessageString(SYNC_ADD), 0L, 0L, element);
        Document document2 = this.readObject(null, string2, string, this.filter.getClassAttrs(string, 1, 2, false), ruleDynamicContext.srcQueryProcessor0, false);
        document2 = this.convertInstanceToAdd(document2, null, operationData);
        Element element2 = XdsUtil.getFirstElementByTagNameNS(document2, null, "add");
        if (element2 != null) {
            element2 = (Element)XdsUtil.cloneSubtree(document, element2);
            element.getParentNode().replaceChild(element2, element);
            DOMUtil.addNamespaceDecls((Node)element2);
            return this.processAdd(document, ruleDynamicContext);
        }
        return null;
    }

    public Document query(Document document) {
        try {
            return this.processCommand(document, this.nullDynamicContext, false);
        }
        catch (VRDException vRDException) {
            return NdsDtd.createStatusDocument(vRDException, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Document processCommand(Document document, RuleDynamicContext ruleDynamicContext, boolean bl) throws VRDException {
        if (this.processor == null) {
            throw new VRDException(9022);
        }
        XmlInputProcessor xmlInputProcessor = this.processor;
        synchronized (xmlInputProcessor) {
            if (bl) {
                if (this.commandTransformationRule != null) {
                    this.tracer.trace("tt_acxform", (MessageSource)messageSource);
                    document = this.commandTransformationRule.applyRules(document, ruleDynamicContext);
                    PersistentLog.logEvent(29, 7, document.getDocumentElement());
                } else {
                    this.tracer.trace("tt_ncxform", (MessageSource)messageSource);
                    PersistentLog.logEvent(29, 7, messageSource.getMessageString("tt_ncxform"));
                }
                document = this.applyNotifyAndResetFilters(document, ruleDynamicContext);
            }
            this.addOperationIDs(document);
            Document document2 = this.processor.process(document);
            Document document3 = (Document)ThreadVars.get("pwdWriteBack");
            if (document3 != null) {
                this.driver.addWork(1, document3);
                ThreadVars.remove("pwdWriteBack");
            }
            Document document4 = document2;
            return document4;
        }
    }

    class RawAppProcessor
    implements XdsCommandProcessor,
    XdsQueryProcessor {
        private XmlQueryProcessor appProcessor;

        RawAppProcessor(XmlQueryProcessor xmlQueryProcessor) {
            this.appProcessor = xmlQueryProcessor;
        }

        public Document execute(Document document) {
            Publisher.this.driver.addWork(2, document);
            return NdsDtd.createStatusDocument(0, null, messageSource.getMessageString(Publisher.QUEUED_WRITEBACK));
        }

        public Document query(Document document) {
            XmlDocument xmlDocument = null;
            try {
                Publisher.this.addOperationIDs(document);
                XmlDocument xmlDocument2 = new XmlDocument(document);
                if (Publisher.this.tracer.getLevel() > 1) {
                    Publisher.this.tracer.trace(Publisher.QUERYING_PUBLISHER_SHIM, (MessageSource)messageSource);
                    Publisher.this.tracer.trace(xmlDocument2);
                }
                if ((xmlDocument = this.appProcessor.query(xmlDocument2)) != null) {
                    xmlDocument.setDocument(xmlDocument.getDocumentNS());
                }
                if (Publisher.this.tracer.getLevel() > 1) {
                    Publisher.this.tracer.trace(Publisher.PUBLISHER_SHIM_RET, (MessageSource)messageSource);
                    Publisher.this.tracer.trace(xmlDocument);
                }
                Driver.checkShimError(xmlDocument, true);
            }
            catch (VRDException vRDException) {
                Document document2 = NdsDtd.createStatusDocument(vRDException, null);
                if (vRDException.isFatal()) {
                    Publisher.this.tracer.trace(Publisher.KILL_FROM_PUBLISHER_QUERY, (MessageSource)messageSource);
                    Publisher.this.driver.killDriver();
                }
                return document2;
            }
            catch (Throwable throwable) {
                StatusLog.log(throwable);
                return NdsDtd.createStatusDocument(throwable, null);
            }
            if (xmlDocument == null) {
                return null;
            }
            return xmlDocument.getDocumentNS();
        }
    }

    class DestCommandProcessor
    implements XdsCommandProcessor {
        DestCommandProcessor() {
        }

        public Document execute(Document document) {
            Document document2 = Publisher.this.processor.process(document);
            StatusLog.log(document2);
            return document2;
        }
    }

    class SrcCommandProcessor
    implements XdsCommandProcessor {
        SrcCommandProcessor() {
        }

        public Document execute(Document document) {
            Publisher.this.driver.addWork(0, document);
            return NdsDtd.createStatusDocument(0, null, messageSource.getMessageString(Publisher.QUEUED_WRITEBACK));
        }
    }

    class PublisherAppQueryProcessor
    implements XdsQueryProcessor {
        private XmlQueryProcessor appProcessor;

        PublisherAppQueryProcessor(XmlQueryProcessor xmlQueryProcessor) {
            this.appProcessor = xmlQueryProcessor;
        }

        public Document query(Document document) {
            XmlDocument xmlDocument = null;
            try {
                RawAppProcessor rawAppProcessor = new RawAppProcessor(this.appProcessor);
                Publisher.this.addOperationIDs(document);
                RuleDynamicContext ruleDynamicContext = new RuleDynamicContext(Publisher.this, rawAppProcessor, Publisher.this.destCommandProcessor, rawAppProcessor, Publisher.this.context);
                ruleDynamicContext.forceDirect = true;
                document = Publisher.this.applyOutputTransformation(document, ruleDynamicContext);
                XmlDocument xmlDocument2 = new XmlDocument(document);
                if (Publisher.this.tracer.getLevel() > 1) {
                    Publisher.this.tracer.trace(Publisher.QUERYING_PUBLISHER_SHIM, (MessageSource)messageSource);
                    Publisher.this.tracer.trace(xmlDocument2);
                }
                xmlDocument = this.appProcessor.query(xmlDocument2);
                if (Publisher.this.tracer.getLevel() > 1) {
                    Publisher.this.tracer.trace(Publisher.PUBLISHER_SHIM_RET, (MessageSource)messageSource);
                    Publisher.this.tracer.trace(xmlDocument);
                }
                if (xmlDocument != null) {
                    xmlDocument.setDocument(Publisher.this.applyInputTransformation(xmlDocument.getDocumentNS(), new RuleDynamicContext(rawAppProcessor, Publisher.this, rawAppProcessor, Publisher.this.destCommandProcessor, Publisher.this.context)));
                }
                Driver.checkShimError(xmlDocument, true);
            }
            catch (VRDException vRDException) {
                Document document2 = NdsDtd.createStatusDocument(vRDException, null);
                if (vRDException.isFatal()) {
                    Publisher.this.tracer.trace(Publisher.KILL_FROM_PUBLISHER_QUERY, (MessageSource)messageSource);
                    Publisher.this.driver.killDriver();
                }
                return document2;
            }
            catch (Throwable throwable) {
                StatusLog.log(throwable);
                return NdsDtd.createStatusDocument(throwable, null);
            }
            if (xmlDocument == null) {
                return null;
            }
            return xmlDocument.getDocumentNS();
        }
    }
}

