/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.driver.SubscriptionShim;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.nds.dirxml.engine.Association;
import com.novell.nds.dirxml.engine.ConfigAbstraction;
import com.novell.nds.dirxml.engine.Driver;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.Entry;
import com.novell.nds.dirxml.engine.Errors;
import com.novell.nds.dirxml.engine.Events;
import com.novell.nds.dirxml.engine.KeyAccepter;
import com.novell.nds.dirxml.engine.LogSettings;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.OperationData;
import com.novell.nds.dirxml.engine.PersistentLog;
import com.novell.nds.dirxml.engine.Publisher;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.ThreadGroupVars;
import com.novell.nds.dirxml.engine.ThreadVars;
import com.novell.nds.dirxml.engine.Transformer;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.Warnings;
import com.novell.nds.dirxml.engine.WorkManager;
import com.novell.nds.dirxml.engine.XdsCommandProcessor;
import com.novell.nds.dirxml.engine.XdsQueryProcessor;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.XmlInputProcessor;
import com.novell.nds.dirxml.engine.XmlOutputProcessor;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.url.NDSURLConnection;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.xml.dom.DOMUtil;
import java.util.ArrayList;
import java.util.HashMap;
import novell.jclient.JCException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Subscriber
extends Transformer
implements XmlQueryProcessor,
XdsQueryProcessor {
    protected SubscriptionShim shim = null;
    protected XmlInputProcessor queryProcessor = null;
    protected XmlOutputProcessor outputProcessor = null;
    protected SubscriberAppQueryProcessor appQueryProcessor = new SubscriberAppQueryProcessor();
    protected XdsCommandProcessor srcCommandProcessor = new SrcCommandProcessor();
    protected XdsCommandProcessor destCommandProcessor = new DestCommandProcessor();
    protected RawNdsProcessor rawNdsProcessor = new RawNdsProcessor();
    protected RawAppProcessor rawAppProcessor = new RawAppProcessor();
    protected static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.Subscriber", Transformer.messageSource);
    protected RuleDynamicContext dynamicContext;
    protected RuleDynamicContext rawOutputDynamicContext;
    protected RuleDynamicContext rawInputDynamicContext;
    protected RuleDynamicContext reverseDynamicContext;
    protected RuleDynamicContext nullDynamicContext;
    protected static final String INIT_SUBSCRIBER = "st_isubch";
    protected static final String LOADING_RULE_PROCESSORS = "st_lrulp";
    protected static final String INIT_SUBSCRIBER_SHIM = "st_isubsh";
    protected static final String SUBSCRIBER_SHIM_INIT_RETURNED = "st_isubret";
    protected static final String SUBMITTING_DOC_TO_SUBSCRIBER = "st_subsmt";
    protected static final String SUBSCRIBER_EXECUTE_RETURNED = "st_subxret";
    protected static final String KILL_DRIVER_FROM_SUBSCRIBER = "st_subkill";
    protected static final String SUBMITTING_IQUERY_TO_SUBSCRIBER = "st_subiqry";
    protected static final String RECEIVED_SUBSCRIBER_QUERY = "st_recvsubq";
    protected static final String SUBSCRIBER_PROCESSING = "st_subproc";
    protected static final String SUBMITTING_UNKNOWN_EVENT = "st_subunkn";
    protected static final String ALREADY_ASSOCIATED_WITH = "st_ardyass";
    protected static final String SUBMITTING_OP_TO_SUBSCRIBER = "st_sopsub";
    protected static final String CONVERTING_MODIFY_TO_ADD = "st_cnvmadd";
    protected static final String QUERY_APP_FOR_MIGRATE = "st_qryapmg";
    protected static final String NO_OBJECTS_FOUND = "st_noobjfn";
    protected static final String FOUND_COUNT_OBJECTS = "st_objcntf";
    protected static final String NOT_ENOUGH_INFO_TO_MIGRATE = "st_niinmig";
    protected static final String NO_OBJECTS_MIGRATED = "st_noobjmig";
    protected static final String SYNC_MERGE = "st_syncmerge";
    protected static final String SYNC_ADD = "st_syncadd";
    protected static final String STRIPPING_OPERATION_DATA = "st_strpop";
    protected static final String RESTORE_OPERATION_DATA = "st_rstrop";

    public Subscriber(Driver driver, ConfigAbstraction configAbstraction, SubscriptionShim subscriptionShim, EngineTrace engineTrace) throws VRDException {
        super(driver, configAbstraction, 1, engineTrace);
        this.shim = subscriptionShim;
        this.init();
    }

    protected void init() throws VRDException {
        ThreadVars.put("channel", this);
        Entry entry = this.registry.getSubscriber();
        Entry entry2 = this.registry.getDriver();
        this.tracer.trace(INIT_SUBSCRIBER, (MessageSource)messageSource, this.registry.getSubscriberDN(), (Object)entry2.getDN());
        this.registry.setDriverThreadID(entry2.getEntryID(), false);
        NDSURLConnection.setThreadBaseContext(this.context);
        this.loadDriverRules();
        this.queryProcessor = new XmlInputProcessor(this.context, this.driver, this.tracer);
        this.queryProcessor.setDriverDN(entry2.getDN());
        this.queryProcessor.setQueryOnly(true);
        this.outputProcessor = new XmlOutputProcessor(this.context, this.tracer);
        this.outputProcessor.setDriverDN(entry2.getDN());
        this.tracer.trace(LOADING_RULE_PROCESSORS, (MessageSource)messageSource);
        if (entry != null) {
            this.loadChannelRules(entry, true);
        }
        this.dynamicContext = new RuleDynamicContext(this, this.appQueryProcessor, this.srcCommandProcessor, this.destCommandProcessor, this.context);
        this.rawOutputDynamicContext = new RuleDynamicContext(this.rawNdsProcessor, this.rawAppProcessor, this.rawNdsProcessor, this.rawAppProcessor, this.context);
        this.rawInputDynamicContext = new RuleDynamicContext(this.rawAppProcessor, this.rawNdsProcessor, this.rawAppProcessor, this.rawNdsProcessor, this.context);
        this.reverseDynamicContext = new RuleDynamicContext(this.appQueryProcessor, this, this.destCommandProcessor, this.srcCommandProcessor, this.context);
        this.nullDynamicContext = new RuleDynamicContext(null, null, null, null, this.context);
        this.tracer.trace(INIT_SUBSCRIBER_SHIM, (MessageSource)messageSource);
        Document document = this.registry.getInitParams("subscriber-options", "subscriber-state");
        if (this.outputMapper != null) {
            document = this.outputMapper.applyRules(document, this.nullDynamicContext);
        }
        XmlDocument xmlDocument = new XmlDocument(document);
        this.tracer.trace(xmlDocument);
        XmlDocument xmlDocument2 = this.shim.init(xmlDocument);
        if (this.tracer.getLevel() > 1) {
            this.tracer.trace(SUBSCRIBER_SHIM_INIT_RETURNED, (MessageSource)messageSource);
            this.tracer.trace(xmlDocument2);
        }
        if (xmlDocument2 != null) {
            xmlDocument2.setDocument(this.applyInputTransformation(xmlDocument2.getDocumentNS(), this.nullDynamicContext));
            this.registry.writeDriverState(xmlDocument2.getDocumentNS(), "output");
        }
        Driver.checkShimError(xmlDocument2, true);
        this.driver.setInitState(2);
        if (this.driver.isTrustedDriver() && this.shim instanceof KeyAccepter) {
            ((KeyAccepter)((Object)this.shim)).acceptKey(this.driver.getOutKey());
        }
    }

    Document execute(Document document, boolean bl, boolean bl2) throws VRDException {
        return this.execute(document, bl, bl2, false);
    }

    protected void processOperationData(Document document, HashMap hashMap) {
        boolean bl = false;
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "input");
        if (element != null) {
            Element[] elementArray = XdsUtil.getChildElementsByTagNameNS(element, "*", "*");
            int n = 0;
            while (n < elementArray.length) {
                Element element2 = elementArray[n];
                String string = element2.getAttributeNS(null, "event-id");
                Element element3 = XdsUtil.getFirstChildElementByTagNameNS(element2, null, "operation-data");
                OperationDataEntry operationDataEntry = new OperationDataEntry(string, element3);
                if (hashMap.containsKey(string)) {
                    string = string + "_opData" + n;
                    element2.setAttributeNS(null, "event-id", string);
                }
                hashMap.put(string, operationDataEntry);
                if (element3 != null) {
                    bl = true;
                    elementArray[n].removeChild(element3);
                }
                ++n;
            }
        }
        if (bl) {
            this.tracer.trace(STRIPPING_OPERATION_DATA, (MessageSource)messageSource);
        }
    }

    protected void restoreOperationData(Document document, HashMap hashMap) {
        boolean bl = false;
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "output");
        if (element != null) {
            Element[] elementArray = XdsUtil.getChildElementsByTagNameNS(element, "*", "*");
            int n = 0;
            while (n < elementArray.length) {
                Element element2 = elementArray[n];
                String string = element2.getAttributeNS(null, "event-id");
                OperationDataEntry operationDataEntry = (OperationDataEntry)hashMap.get(string);
                if (operationDataEntry != null) {
                    if (!string.equals(operationDataEntry.getEventID())) {
                        element2.setAttributeNS(null, "event-id", operationDataEntry.getEventID());
                    }
                    if (operationDataEntry.getOperationElement() != null) {
                        bl = true;
                        Element element3 = (Element)XdsUtil.cloneSubtree(document, operationDataEntry.getOperationElement());
                        elementArray[n].appendChild(element3);
                        DOMUtil.addNamespaceDecls((Node)element3);
                    }
                }
                ++n;
            }
        }
        if (bl) {
            this.tracer.trace(RESTORE_OPERATION_DATA, (MessageSource)messageSource);
        }
    }

    protected void logSubscriberEvents(Document document, Document document2, int n, int n2) {
        Element element;
        String string;
        Element element2;
        int n3;
        Element[] elementArray;
        Element element3 = XdsUtil.getFirstElementByTagNameNS(document, null, "input");
        Element element4 = XdsUtil.getFirstElementByTagNameNS(document2, null, "output");
        HashMap<String, Element> hashMap = new HashMap<String, Element>();
        int n4 = 0;
        LogSettings logSettings = PersistentLog.getChannelSettings(1);
        if (logSettings.getLevel() == 3) {
            return;
        }
        if (element4 != null) {
            elementArray = XdsUtil.getChildElementsByTagNameNS(element4, null, "status");
            n4 = elementArray.length;
            n3 = 0;
            while (n3 < elementArray.length) {
                element2 = elementArray[n3];
                string = element2.getAttributeNS(null, "event-id");
                if (string != null && string.length() != 0) {
                    element = (Element)hashMap.get(string);
                    if (element == null) {
                        hashMap.put(string, element2);
                    } else {
                        int n5 = NdsDtd.getStatusLevel(element);
                        if (NdsDtd.getStatusLevel(element2) > n5 || n5 == Integer.MAX_VALUE) {
                            hashMap.remove(string);
                            hashMap.put(string, element2);
                        }
                    }
                }
                ++n3;
            }
        }
        if (element3 != null) {
            elementArray = XdsUtil.getChildElementsByTagNameNS(element3, "*", "*");
            n3 = 0;
            while (n3 < elementArray.length) {
                element = elementArray[n3];
                String string2 = element.getNodeName();
                int n6 = Events.getEventIDFromOperation(string2, element.getAttributeNS(null, "level"));
                if (n2 == 0) {
                    string = element.getAttributeNS(null, "event-id");
                    element2 = (Element)hashMap.get(string);
                    if (element2 != null) {
                        n2 = NdsDtd.getStatusLevel(element2);
                    } else if (n4 == 1 && elementArray.length == 1) {
                        n2 = NdsDtd.getStatusLevel(XdsUtil.getFirstChildElementByTagNameNS(element4, null, "status"));
                    }
                }
                ArrayList arrayList = Events.getOperationEvents(n6, element, this.registry.getDriverDN(), 1);
                PersistentLog.logEvents(arrayList, Events.convertLevel(n2), n);
                ++n3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Document execute(Document document, boolean bl, boolean bl2, boolean bl3) throws VRDException {
        Document document2;
        block18: {
            document2 = null;
            int n = 0;
            int n2 = 0;
            try {
                block17: {
                    try {
                        if (bl) {
                            if (this.commandTransformationRule != null) {
                                this.tracer.trace("tt_acxform", (MessageSource)messageSource);
                                document = this.commandTransformationRule.applyRules(document, this.dynamicContext);
                                PersistentLog.logEvent(29, 7, document.getDocumentElement());
                            } else {
                                this.tracer.trace("tt_ncxform", (MessageSource)messageSource);
                                PersistentLog.logEvent(29, 7, messageSource.getMessageString("tt_ncxform"));
                            }
                            document = this.applyNotifyAndResetFilters(document, this.dynamicContext);
                        }
                        this.addOperationIDs(document);
                        if (bl2) {
                            document = this.applyOutputTransformation(document, this.rawOutputDynamicContext);
                        }
                        XmlDocument xmlDocument = new XmlDocument(document);
                        if (this.tracer.getLevel() > 1) {
                            this.tracer.trace(SUBMITTING_DOC_TO_SUBSCRIBER, (MessageSource)messageSource);
                            this.tracer.trace(xmlDocument);
                        }
                        HashMap hashMap = new HashMap();
                        this.processOperationData(document, hashMap);
                        XmlDocument xmlDocument2 = this.shim.execute(xmlDocument, this);
                        if (xmlDocument2 != null) {
                            this.restoreOperationData(xmlDocument2.getDocumentNS(), hashMap);
                        }
                        if (this.tracer.getLevel() > 1) {
                            this.tracer.trace(SUBSCRIBER_EXECUTE_RETURNED, (MessageSource)messageSource);
                            this.tracer.trace(xmlDocument2);
                        }
                        if (xmlDocument2 != null) {
                            document2 = xmlDocument2.getDocumentNS();
                            if (bl2) {
                                document2 = this.applyInputTransformation(document2, this.rawInputDynamicContext);
                            }
                            this.registry.writeDriverState(document2, "output");
                            Driver.checkShimError(document2, false);
                            break block17;
                        }
                        document2 = NdsDtd.createStatusDocument(0, null, "");
                    }
                    catch (VRDException vRDException) {
                        n = vRDException.getErrorCode();
                        n2 = vRDException.getSeverity();
                        document2 = NdsDtd.createStatusDocument(vRDException, null);
                        if (vRDException.isFatal()) {
                            this.tracer.trace(KILL_DRIVER_FROM_SUBSCRIBER, (MessageSource)messageSource);
                            this.driver.killDriver();
                            throw vRDException;
                        }
                        if (vRDException.isRetry()) {
                            n2 = 1;
                            if (!bl3) {
                                this.driver.setDriverRetryDelay();
                            }
                            throw vRDException;
                        }
                        Object var12_14 = null;
                        this.logSubscriberEvents(document, document2, n, n2);
                        break block18;
                    }
                    catch (Throwable throwable) {
                        n = 9010;
                        n2 = 3;
                        document2 = NdsDtd.createStatusDocument(throwable, null);
                        Object var12_15 = null;
                        this.logSubscriberEvents(document, document2, n, n2);
                    }
                }
                Object var12_13 = null;
                this.logSubscriberEvents(document, document2, n, n2);
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                this.logSubscriberEvents(document, document2, n, n2);
                throw throwable;
            }
        }
        return document2;
    }

    void checkDriverId() throws VRDException {
        Element element = NdsDtd.createDoc("input");
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(null, "query");
        element.appendChild(element2);
        element2.setAttributeNS(null, "event-id", "query-driver-ident");
        element2.setAttributeNS(null, "scope", "entry");
        Element element3 = document.createElementNS(null, "search-class");
        element2.appendChild(element3);
        element3.setAttributeNS(null, "class-name", "__driver_identification_class__");
        Element element4 = document.createElementNS(null, "read-attr");
        element2.appendChild(element4);
        try {
            XmlDocument xmlDocument = new XmlDocument(document);
            if (this.tracer.getLevel() > 1) {
                this.tracer.trace(SUBMITTING_IQUERY_TO_SUBSCRIBER, (MessageSource)messageSource);
                this.tracer.trace(xmlDocument);
            }
            XmlDocument xmlDocument2 = this.shim.execute(xmlDocument, this);
            if (this.tracer.getLevel() > 1) {
                this.tracer.trace(SUBSCRIBER_EXECUTE_RETURNED, (MessageSource)messageSource);
                this.tracer.trace(xmlDocument2);
            }
            if (xmlDocument2 != null && xmlDocument2.getDocumentNS() != null) {
                Document document2 = xmlDocument2.getDocumentNS();
                this.registry.writeDriverState(document2, "output");
                Driver.checkShimError(document2, false);
                Element[] elementArray = XdsUtil.getElementsByTagNameWithAttrValueNS(document2, null, "instance", null, "class-name", "__driver_identification_class__");
                if (elementArray == null || elementArray.length != 1) {
                    this.writeUnkownDriverId();
                    return;
                }
                Element element5 = XdsUtil.getFirstChildElementByTagNameWithAttrValueNS(elementArray[0], null, "attr", null, "attr-name", "driver-id");
                if (element5 == null || (element5 = XdsUtil.getFirstChildElementByTagNameNS(element5, null, "value")) == null) {
                    this.writeUnkownDriverId();
                    return;
                }
                Element element6 = XdsUtil.getFirstChildElementByTagNameWithAttrValueNS(elementArray[0], null, "attr", null, "attr-name", "driver-version");
                if (element6 == null || (element6 = XdsUtil.getFirstChildElementByTagNameNS(element6, null, "value")) == null) {
                    this.writeUnkownDriverId();
                    return;
                }
                Element element7 = XdsUtil.getFirstChildElementByTagNameWithAttrValueNS(elementArray[0], null, "attr", null, "attr-name", "min-activation-version");
                String string = this.registry.getDriverIdentityName();
                String string2 = XdsUtil.getNodeText(element5);
                String string3 = XdsUtil.getNodeText(element6);
                this.registry.setDriverIdentity(string2, string3);
                if (element7 != null && (element7 = XdsUtil.getFirstChildElementByTagNameNS(element7, null, "value")) != null) {
                    String string4 = XdsUtil.getNodeText(element7);
                    this.driver.writeDriverId(string2, Integer.parseInt(string4));
                } else {
                    this.driver.writeDriverId(string2, 0);
                }
                if (string == null || !string.equals(string2)) {
                    this.driver.initAppDNDelims();
                }
            }
        }
        catch (VRDException vRDException) {
            throw vRDException;
        }
        catch (Throwable throwable) {
            throw new VRDException(throwable);
        }
    }

    private void writeUnkownDriverId() {
        this.driver.writeDriverId(this.registry.getDriverObjectName(), 0);
    }

    void processWork(WorkManager.WorkEntry workEntry) throws VRDException {
        boolean bl;
        boolean bl2;
        int n = workEntry.getFlags();
        Document document = workEntry.getDocument();
        Document document2 = this.execute(document, bl2 = (n & 1) != 0, bl = (n & 2) == 0);
        if (document2 != null) {
            this.outputProcessor.process(document2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDocument query(XmlDocument xmlDocument) {
        Document document = null;
        boolean bl = this.rawInputDynamicContext.forceDirect;
        try {
            block4: {
                try {
                    this.tracer.trace(RECEIVED_SUBSCRIBER_QUERY, (MessageSource)messageSource);
                    this.tracer.trace(xmlDocument);
                    this.rawInputDynamicContext.forceDirect = true;
                    document = this.applyInputTransformation(xmlDocument.getDocumentNS(), this.rawInputDynamicContext);
                    document = this.query(document);
                    if (document == null) break block4;
                    document = this.applyOutputTransformation(document, this.rawOutputDynamicContext);
                }
                catch (Throwable throwable) {
                    document = NdsDtd.createStatusDocument(throwable, null);
                    Object var6_5 = null;
                    this.rawInputDynamicContext.forceDirect = bl;
                }
            }
            Object var6_4 = null;
            this.rawInputDynamicContext.forceDirect = bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.rawInputDynamicContext.forceDirect = bl;
            throw throwable;
        }
        XmlDocument xmlDocument2 = new XmlDocument(document);
        this.tracer.trace(xmlDocument2);
        return xmlDocument2;
    }

    public Document query(Document document) {
        Document document2 = null;
        try {
            document2 = this.queryProcessor.process(document);
        }
        catch (Throwable throwable) {
            document2 = NdsDtd.createStatusDocument(throwable, null);
        }
        return document2;
    }

    protected void processEvents(Document document) throws VRDException {
        Element element;
        LogSettings logSettings = this.registry.getLogSettings();
        LogSettings.LogTimestamp logTimestamp = LogSettings.getLogTimestamp();
        ThreadVars.put("logEventTS", logTimestamp);
        document = this.filter.filterDocument(document, 0, 2, false);
        Element element2 = XdsUtil.getFirstElementByTagNameNS(document, null, "input");
        if (element2 != null) {
            this.filter.filterByDriverRights(this.context, this.registry.getDriverDN(), element2);
        }
        this.tracer.trace(document);
        PersistentLog.logEvent(20, 7, document.getDocumentElement());
        if (this.eventTransformationRule != null) {
            this.tracer.trace("tt_aexform", (MessageSource)messageSource);
            document = this.eventTransformationRule.applyRules(document, this.dynamicContext);
            PersistentLog.logEvent(23, 7, document.getDocumentElement());
        } else {
            this.tracer.trace("tt_nexform", (MessageSource)messageSource);
            PersistentLog.logEvent(23, 7, messageSource.getMessageString("tt_nexform"));
        }
        Element element3 = XdsUtil.getFirstElementByTagNameNS(document, null, "input");
        if (element3 == null) {
            return;
        }
        Element element4 = document.createElementNS(null, "input");
        element3.getParentNode().replaceChild(element4, element3);
        while ((element = XdsUtil.getFirstChildElement(element3)) != null) {
            element4.appendChild(element);
            this.processEvent(document);
            XdsUtil.removeAllChildren(element4);
        }
        ThreadVars.remove("logEventTS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processEvent(Document document) throws VRDException {
        try {
            try {
                Document document2 = null;
                Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "input");
                Element element2 = XdsUtil.getFirstChildElement(element);
                String string = element2.getNodeName();
                String string2 = element2.getAttributeNS(null, "src-dn");
                ThreadVars.put("currentObject", string2);
                this.tracer.trace(SUBSCRIBER_PROCESSING, (MessageSource)messageSource, string, (Object)string2);
                if (string.equals("add")) {
                    document2 = this.processAdd(document);
                } else if (string.equals("modify")) {
                    document2 = this.processModify(document);
                } else if (string.equals("delete")) {
                    document2 = this.processDelete(document);
                } else if (string.equals("rename")) {
                    document2 = this.processRename(document);
                } else if (string.equals("move")) {
                    document2 = this.processMove(document);
                } else if (string.equals("sync")) {
                    document2 = this.processSync(document);
                } else if (string.equals("query")) {
                    document2 = this.processQuery(document);
                } else {
                    this.tracer.trace(SUBMITTING_UNKNOWN_EVENT, (MessageSource)messageSource);
                    document2 = this.execute(document, true, true);
                }
                this.outputProcessor.process(document2);
            }
            catch (VRDException vRDException) {
                if (vRDException.isFatal()) throw vRDException;
                if (vRDException.isRetry()) {
                    throw vRDException;
                }
                StatusLog.log(vRDException);
                Object var8_9 = null;
                ThreadVars.remove("currentObject");
                return;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            ThreadVars.remove("currentObject");
            throw throwable;
        }
        ThreadVars.remove("currentObject");
    }

    protected Document processAdd(Document document) throws VRDException {
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "add");
        String string = element.getAttributeNS(null, "class-name");
        Entry entry = XdsUtil.getSrcEntry(element);
        if (entry == null) {
            return NdsDtd.createStatusDocument(2, null, Warnings.getMessage(8029));
        }
        String string2 = XdsUtil.getAssociationValue(element);
        if (string2.length() != 0) {
            this.tracer.trace(ALREADY_ASSOCIATED_WITH, (MessageSource)messageSource, string2);
            return this.processMerge(entry, string2, string, new OperationData(element), null);
        }
        Association.addAssociation(this.context, this.registry.getDriverDN(), entry, "", 2);
        if (this.matchingRule != null) {
            this.tracer.trace("tt_amrule", (MessageSource)messageSource);
            XdsUtil.removeChildElementsByTagNameNS(element, null, "association");
            document = this.matchingRule.applyRules(document, this.dynamicContext);
            PersistentLog.logEvent(28, 7, document.getDocumentElement());
            element = XdsUtil.getFirstElementByTagNameNS(document, null, "add");
            if (element == null) {
                return NdsDtd.createStatusDocument(2, null, Warnings.getMessage(8016));
            }
            Element[] elementArray = XdsUtil.getChildElementsByTagNameNS(element, null, "association");
            if (elementArray.length > 1) {
                return NdsDtd.createStatusDocument(3, null, Errors.getMessage(9062));
            }
            if (elementArray.length == 1) {
                string2 = XdsUtil.getNodeText(elementArray[0]);
                if (Association.lookupEntry(this.context, this.registry.getDriverDN(), string2) != null) {
                    return NdsDtd.createStatusDocument(3, null, Errors.getMessage(9063));
                }
                this.tracer.trace("tt_mchfnd", (MessageSource)messageSource, string2);
                Association.addAssociation(this.context, this.registry.getDriverDN(), entry, string2, 1);
                return this.processMerge(entry, string2, string, new OperationData(element), document);
            }
            this.tracer.trace("tt_nmchfnd", (MessageSource)messageSource);
            PersistentLog.logEvent(28, 6, messageSource.getMessageString("tt_nmchfnd"));
        } else {
            this.tracer.trace("tt_nmrule", (MessageSource)messageSource);
            PersistentLog.logEvent(28, 7, messageSource.getMessageString("tt_nmrule"));
        }
        if (this.createRule != null) {
            this.tracer.trace("tt_acrule", (MessageSource)messageSource);
            document = this.createRule.applyRules(document, this.dynamicContext);
            PersistentLog.logEvent(25, 7, document.getDocumentElement());
            if (XdsUtil.getFirstElementByTagNameNS(document, null, "add") == null) {
                return NdsDtd.createStatusDocument(2, null, Warnings.getMessage(8017));
            }
        } else {
            this.tracer.trace("tt_ncrule", (MessageSource)messageSource);
            PersistentLog.logEvent(25, 7, messageSource.getMessageString("tt_ncrule"));
        }
        if (this.placementRule != null) {
            this.tracer.trace("tt_aprule", (MessageSource)messageSource);
            document = this.placementRule.applyRules(document, this.dynamicContext);
            PersistentLog.logEvent(24, 7, document.getDocumentElement());
            if (XdsUtil.getFirstElementByTagNameNS(document, null, "add") == null) {
                return NdsDtd.createStatusDocument(2, null, Warnings.getMessage(8018));
            }
        } else {
            this.tracer.trace("tt_nprule", (MessageSource)messageSource);
            PersistentLog.logEvent(24, 7, messageSource.getMessageString("tt_nprule"));
        }
        this.tracer.trace(SUBMITTING_OP_TO_SUBSCRIBER, (MessageSource)messageSource, "add");
        return this.execute(document, true, true);
    }

    protected Document processModify(Document document) throws VRDException {
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "modify");
        Entry entry = XdsUtil.getSrcEntry(element);
        String string = XdsUtil.getAssociationValue(element);
        String string2 = XdsUtil.getAssociationState(element);
        if (string.length() == 0) {
            if (entry == null) {
                return NdsDtd.createStatusDocument(2, null, Warnings.getMessage(8029));
            }
            this.tracer.trace(CONVERTING_MODIFY_TO_ADD, (MessageSource)messageSource);
            document = this.convertModifyToAdd(document, this, false, new OperationData(element));
            return this.processAdd(document);
        }
        Document document2 = this.execute(document, true, true);
        this.markAssociationProcessed(entry, string, string2);
        return document2;
    }

    protected Document processDelete(Document document) throws VRDException {
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "delete");
        if (XdsUtil.getAssociationValue(element).length() == 0) {
            return NdsDtd.createStatusDocument(2, null, Warnings.getMessage(8019));
        }
        return this.execute(document, true, true);
    }

    protected Document processRename(Document document) throws VRDException {
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "rename");
        if (XdsUtil.getAssociationValue(element).length() == 0) {
            return NdsDtd.createStatusDocument(2, null, Warnings.getMessage(8019));
        }
        return this.execute(document, true, true);
    }

    protected Document processMove(Document document) throws VRDException {
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "move");
        if (XdsUtil.getAssociationValue(element).length() == 0) {
            return NdsDtd.createStatusDocument(2, null, Warnings.getMessage(8019));
        }
        return this.execute(document, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document processSync(Document document) throws VRDException {
        Document document2;
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "sync");
        String string = element.getAttributeNS(null, "class-name");
        Entry entry = XdsUtil.getSrcEntry(element);
        String string2 = XdsUtil.getAssociationValue(element);
        String string3 = XdsUtil.getAssociationState(element);
        if (string2.length() == 0) {
            String string4 = null;
            long l = 0L;
            if (entry != null) {
                string4 = entry.getDN();
                l = 1L;
            }
            PersistentLog.logEvent(19, 6, string4, l, "Object Class", string, null, messageSource.getMessageString(SYNC_ADD), 0L, 0L, element);
            Document document3 = this.readObject(entry, null, string, this.filter.getClassAttrs(string, 0, 2, false), this, false);
            document3 = this.convertInstanceToAdd(document3, XdsUtil.getJCTimestamp(element), new OperationData(element));
            Element element2 = XdsUtil.getFirstElementByTagNameNS(document3, null, "add");
            if (element2 != null) {
                element2 = (Element)XdsUtil.cloneSubtree(document, element2);
                element.getParentNode().replaceChild(element2, element);
                DOMUtil.addNamespaceDecls((Node)element2);
                return this.processAdd(document);
            }
            return null;
        }
        String string5 = null;
        long l = 0L;
        if (entry != null) {
            string5 = entry.getDN();
            l = 1L;
        } else {
            string5 = string2;
            l = 4L;
        }
        PersistentLog.logEvent(19, 6, string5, l, "Object Class", string, string2, messageSource.getMessageString(SYNC_MERGE), 0L, 0L, element);
        try {
            document2 = this.processMerge(entry, string2, string, new OperationData(element), null);
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.markAssociationProcessed(entry, string2, string3);
            throw throwable;
        }
        this.markAssociationProcessed(entry, string2, string3);
        return document2;
    }

    protected Document processQuery(Document document) throws VRDException {
        Object object;
        this.tracer.trace(QUERY_APP_FOR_MIGRATE, (MessageSource)messageSource);
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "query");
        XdsUtil.removeChildElementsByTagNameNS(element, null, "read-attr");
        element.appendChild(document.createElementNS(null, "read-attr"));
        Document document2 = this.execute(document, false, true);
        if (document2 == null) {
            this.tracer.trace(NO_OBJECTS_FOUND, (MessageSource)messageSource);
            PersistentLog.logEvent(33, 6, messageSource.getMessageString(NO_OBJECTS_FOUND));
            return null;
        }
        NodeList nodeList = document2.getElementsByTagNameNS(null, "instance");
        int n = nodeList.getLength();
        if (n == 0) {
            this.tracer.trace(NO_OBJECTS_FOUND, (MessageSource)messageSource);
            PersistentLog.logEvent(33, 6, messageSource.getMessageString(NO_OBJECTS_FOUND));
            return null;
        }
        if (this.tracer.getLevel() > 0) {
            this.tracer.trace(FOUND_COUNT_OBJECTS, (MessageSource)messageSource, new Integer(n));
        }
        Element element2 = NdsDtd.createDoc("input");
        Document document3 = element2.getOwnerDocument();
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            object = (Element)nodeList.item(n2);
            String string = XdsUtil.getAssociationValue((Element)object);
            String string2 = object.getAttributeNS(null, "class-name");
            if ((string.length() == 0 || string2.length() == 0) && this.tracer.getLevel() > 0) {
                this.tracer.trace(NOT_ENOUGH_INFO_TO_MIGRATE, (MessageSource)messageSource, new Integer(n2));
                PersistentLog.logEvent(33, 6, messageSource.getMessageString(NOT_ENOUGH_INFO_TO_MIGRATE));
            } else {
                PersistentLog.logEvent(33, 6, string, 4L, "Object Class", string2, null, null, 0L, 0L);
                Element element3 = document3.createElementNS(null, "sync");
                element2.appendChild(element3);
                element3.setAttributeNS(null, "class-name", string2);
                Element element4 = document3.createElementNS(null, "association");
                element3.appendChild(element4);
                XdsUtil.setNodeText(element4, string);
            }
            ++n2;
        }
        if (element2.getFirstChild() == null) {
            this.tracer.trace(NO_OBJECTS_MIGRATED, (MessageSource)messageSource);
            return null;
        }
        object = (Publisher)ThreadGroupVars.get("publisher");
        return ((Publisher)object).execute(document3, this.reverseDynamicContext);
    }

    protected Document processMerge(Entry entry, String string, String string2, OperationData operationData, Document document) throws VRDException {
        this.tracer.trace("tt_merge", (MessageSource)messageSource);
        Document document2 = document;
        if (document2 != null) {
            document2 = this.convertAddToInstance(document2);
            document2 = this.filter.filterDocument(document2, 0, 0, true);
        }
        Document[] documentArray = this.createMergeDocuments(entry, this, document2, string, this.appQueryProcessor, null, string2, operationData);
        Document document3 = null;
        Document document4 = null;
        if (documentArray[0] != null) {
            this.tracer.trace("tt_updnds", (MessageSource)messageSource);
            this.tracer.trace(documentArray[0]);
            PersistentLog.logEvent(44, 6, entry.getDN(), 1L, "Object Class", string2, "publisher", string, 0L, 0L, documentArray[0].getDocumentElement());
            Publisher publisher = (Publisher)ThreadGroupVars.get("publisher");
            document4 = publisher.processCommand(documentArray[0], this.reverseDynamicContext, true);
            if (document4 != null) {
                StatusLog.log(document4);
            }
        }
        if (documentArray[1] != null) {
            this.tracer.trace("tt_updapp", (MessageSource)messageSource);
            this.tracer.trace(documentArray[1]);
            PersistentLog.logEvent(44, 6, entry.getDN(), 1L, "Object Class", string2, "subscriber", string, 0L, 0L, documentArray[1].getDocumentElement());
            document3 = this.execute(documentArray[1], true, true);
        }
        if (document3 == null) {
            document3 = NdsDtd.createStatusDocument(0, null, "");
        }
        return document3;
    }

    protected void processReset(Document document, Entry entry, RuleDynamicContext ruleDynamicContext) {
        this.tracer.trace("tt_rstnds", (MessageSource)messageSource);
        this.tracer.trace(document);
        PersistentLog.logEvent(46, 6, entry.getDN(), 1L, "publisher", null, null, null, 0L, 0L, document.getDocumentElement());
        Publisher publisher = (Publisher)ThreadGroupVars.get("publisher");
        try {
            Document document2 = publisher.processCommand(document, this.reverseDynamicContext, true);
            if (document2 != null) {
                StatusLog.log(document2);
            }
        }
        catch (VRDException vRDException) {
            StatusLog.log(vRDException);
        }
    }

    void markAssociationProcessed(Entry entry, String string, String string2) throws VRDException {
        block3: {
            if (entry != null && string.length() != 0 && !string2.equals("associated")) {
                try {
                    Association.addAssociation(this.context, this.registry.getDriverDN(), entry, string, 1);
                }
                catch (VRDException vRDException) {
                    Throwable throwable = vRDException.getCause();
                    if (throwable instanceof JCException && ((JCException)throwable).getErrorCode() == -601) break block3;
                    throw vRDException;
                }
            }
        }
    }

    protected void shutdown() {
        if (this.queryProcessor != null) {
            this.queryProcessor.shutdown();
        }
        if (this.outputProcessor != null) {
            this.outputProcessor.shutdown();
        }
        this.driver = null;
        this.shim = null;
        this.queryProcessor = null;
        this.outputProcessor = null;
        this.appQueryProcessor = null;
        NDSURLConnection.setThreadBaseContext(null);
        super.shutdown();
    }

    private static class OperationDataEntry {
        private String operationID;
        private Element operationElement;

        public OperationDataEntry(String string, Element element) {
            this.operationID = string;
            this.operationElement = element;
        }

        String getEventID() {
            return this.operationID;
        }

        Element getOperationElement() {
            return this.operationElement;
        }
    }

    class RawAppProcessor
    implements XdsCommandProcessor,
    XdsQueryProcessor {
        RawAppProcessor() {
        }

        public Document execute(Document document) {
            Document document2;
            try {
                document2 = Subscriber.this.execute(document, false, false);
            }
            catch (VRDException vRDException) {
                document2 = NdsDtd.createStatusDocument(vRDException, null);
            }
            if (document2 != null) {
                try {
                    Subscriber.this.registry.writeDriverState(document2, "output");
                    Driver.checkShimError(document2, false);
                    Subscriber.this.outputProcessor.process(document2);
                }
                catch (VRDException vRDException) {
                    StatusLog.log(vRDException);
                }
            }
            return document2;
        }

        public Document query(Document document) {
            Document document2 = null;
            try {
                document2 = Subscriber.this.execute(document, false, false);
            }
            catch (Throwable throwable) {
                document2 = NdsDtd.createStatusDocument(throwable, null);
            }
            return document2;
        }
    }

    class RawNdsProcessor
    implements XdsCommandProcessor,
    XdsQueryProcessor {
        RawNdsProcessor() {
        }

        public Document execute(Document document) {
            Document document2;
            Publisher publisher = (Publisher)ThreadGroupVars.get("publisher");
            try {
                document2 = publisher.processCommand(document, Subscriber.this.nullDynamicContext, false);
            }
            catch (VRDException vRDException) {
                document2 = NdsDtd.createStatusDocument(vRDException, null);
            }
            if (document2 != null) {
                try {
                    Subscriber.this.outputProcessor.process(document2);
                }
                catch (VRDException vRDException) {
                    StatusLog.log(vRDException);
                }
            }
            return document2;
        }

        public Document query(Document document) {
            return Subscriber.this.query(document);
        }
    }

    class DestCommandProcessor
    implements XdsCommandProcessor {
        DestCommandProcessor() {
        }

        public Document execute(Document document) {
            Document document2;
            try {
                document2 = Subscriber.this.execute(document, false, true);
            }
            catch (VRDException vRDException) {
                document2 = NdsDtd.createStatusDocument(vRDException, null);
            }
            if (document2 != null) {
                try {
                    Subscriber.this.outputProcessor.process(document2);
                }
                catch (VRDException vRDException) {
                    StatusLog.log(vRDException);
                }
            }
            return document2;
        }
    }

    class SrcCommandProcessor
    implements XdsCommandProcessor {
        SrcCommandProcessor() {
        }

        public Document execute(Document document) {
            Document document2;
            Publisher publisher = (Publisher)ThreadGroupVars.get("publisher");
            try {
                document2 = publisher.processCommand(document, Subscriber.this.nullDynamicContext, false);
            }
            catch (VRDException vRDException) {
                document2 = NdsDtd.createStatusDocument(vRDException, null);
            }
            if (document2 != null) {
                try {
                    Subscriber.this.outputProcessor.process(document2);
                }
                catch (VRDException vRDException) {
                    StatusLog.log(vRDException);
                }
            }
            return document2;
        }
    }

    class SubscriberAppQueryProcessor
    implements XdsQueryProcessor {
        SubscriberAppQueryProcessor() {
        }

        public Document query(Document document) {
            Document document2 = null;
            try {
                document2 = Subscriber.this.execute(document, false, true);
            }
            catch (Throwable throwable) {
                document2 = NdsDtd.createStatusDocument(throwable, null);
            }
            return document2;
        }
    }
}

