/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.engine.ThreadVars;
import java.util.Hashtable;

public abstract class ThreadGroupVars {
    public static final String THREAD_PROXY_GROUP = "threadProxyGroup";
    static Hashtable threadGroupTable = new Hashtable();

    protected static ThreadGroup getEffectiveThreadGroup() {
        ThreadGroup threadGroup = ThreadGroupVars.getThreadProxyGroup();
        if (threadGroup == null) {
            threadGroup = Thread.currentThread().getThreadGroup();
        }
        return threadGroup;
    }

    public static ThreadGroup getThreadProxyGroup() {
        return (ThreadGroup)ThreadVars.get(THREAD_PROXY_GROUP);
    }

    public static ThreadGroup setThreadProxyGroup(ThreadGroup threadGroup) {
        return (ThreadGroup)ThreadVars.put(THREAD_PROXY_GROUP, threadGroup);
    }

    public static synchronized Object put(Object object, Object object2) {
        return ThreadGroupVars.put(ThreadGroupVars.getEffectiveThreadGroup(), object, object2);
    }

    public static synchronized Object get(Object object) {
        return ThreadGroupVars.get(ThreadGroupVars.getEffectiveThreadGroup(), object);
    }

    public static synchronized Object put(ThreadGroup threadGroup, Object object, Object object2) {
        if (object2 == null) {
            return ThreadGroupVars.remove(threadGroup, object);
        }
        Hashtable<Object, Object> hashtable = (Hashtable<Object, Object>)threadGroupTable.get(threadGroup);
        if (hashtable == null) {
            hashtable = new Hashtable<Object, Object>();
            threadGroupTable.put(threadGroup, hashtable);
        }
        return hashtable.put(object, object2);
    }

    public static synchronized Object get(ThreadGroup threadGroup, Object object) {
        Hashtable hashtable = (Hashtable)threadGroupTable.get(threadGroup);
        Object object2 = null;
        if (hashtable != null) {
            object2 = hashtable.get(object);
        }
        if (object2 == null && (threadGroup = threadGroup.getParent()) != null) {
            object2 = ThreadGroupVars.get(threadGroup, object);
        }
        return object2;
    }

    public static synchronized Object remove(Object object) {
        return ThreadGroupVars.remove(ThreadGroupVars.getEffectiveThreadGroup(), object);
    }

    public static synchronized Object remove(ThreadGroup threadGroup, Object object) {
        Hashtable hashtable = (Hashtable)threadGroupTable.get(threadGroup);
        if (hashtable != null) {
            return hashtable.remove(object);
        }
        return null;
    }

    public static synchronized void removeAll() {
        ThreadGroupVars.removeAll(ThreadGroupVars.getEffectiveThreadGroup());
    }

    public static synchronized void removeAll(ThreadGroup threadGroup) {
        threadGroupTable.remove(threadGroup);
    }

    public static synchronized void clear() {
        threadGroupTable.clear();
    }
}

