/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.VRDException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import jdbm.btree.BTree;
import jdbm.hash.HTree;
import jdbm.helper.CachePolicy;
import jdbm.helper.Comparator;
import jdbm.helper.LongComparator;
import jdbm.helper.MRU;
import jdbm.helper.ObjectCache;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import jdbm.recman.RecordManager;
import org.w3c.dom.Document;

public class WorkManager {
    private RecordManager recman;
    private ObjectCache cache;
    private BTree workQueue;
    private HTree replicatedMoves;
    private HTree variables;
    private long workSequenceID = System.currentTimeMillis();
    private long driverEntryID;
    private String filename;
    public static final int APPLY_COMMAND_TRANSFORMATION = 1;
    public static final int RAW = 2;
    public static final String DB_NAME_PREFIX = "dx";
    public static final String WORK_QUEUE_NAME = "WORKQ";
    public static final String REPLICATED_MOVES_NAME = "REPM";
    public static final String VARIABLES_NAME = "VARS";
    public static final String VAR_LAST_DELETED = "dirxml.engine.lastdeleted";

    WorkManager(long l) throws VRDException {
        this.driverEntryID = l;
        this.filename = DB_NAME_PREFIX + String.valueOf(l);
        try {
            this.initializeDB();
        }
        catch (Throwable throwable) {
            this.handleIt(throwable);
        }
    }

    private void initializeDB() throws Throwable {
        this.recman = new RecordManager(this.filename);
        this.cache = new ObjectCache(this.recman, (CachePolicy)new MRU(100));
        try {
            this.workQueue = this.openBTree(WORK_QUEUE_NAME, (Comparator)new LongComparator());
            this.replicatedMoves = this.openHTree(REPLICATED_MOVES_NAME);
            this.variables = this.openHTree(VARIABLES_NAME);
        }
        catch (Throwable throwable) {
            this.cleanup();
            throw throwable;
        }
        this.loadLegacyQueue();
    }

    private BTree openBTree(String string, Comparator comparator) throws IOException {
        BTree bTree;
        long l = this.recman.getNamedObject(string);
        if (l != 0L) {
            bTree = BTree.load((RecordManager)this.recman, (ObjectCache)this.cache, (long)l);
        } else {
            bTree = new BTree(this.recman, this.cache, comparator);
            this.recman.setNamedObject(string, bTree.getRecid());
            this.recman.commit();
        }
        return bTree;
    }

    private HTree openHTree(String string) throws IOException {
        HTree hTree;
        long l = this.recman.getNamedObject(string);
        if (l != 0L) {
            hTree = HTree.load((RecordManager)this.recman, (ObjectCache)this.cache, (long)l);
        } else {
            hTree = new HTree(this.recman, this.cache);
            this.recman.setNamedObject(string, hTree.getRecid());
            this.recman.commit();
        }
        return hTree;
    }

    private void killDB() {
        this.cleanup();
        new File(this.filename).delete();
    }

    synchronized void addToBTree(BTree bTree, Object object, Object object2) throws VRDException {
        try {
            bTree.insert(object, object2, true);
            this.recman.commit();
        }
        catch (Throwable throwable) {
            this.handleIt(throwable);
            try {
                bTree.insert(object, object2, true);
                this.recman.commit();
            }
            catch (Throwable throwable2) {
                throw new VRDException(throwable2);
            }
        }
    }

    synchronized Object getFirstFromBTree(BTree bTree) throws VRDException {
        try {
            Tuple tuple;
            TupleBrowser tupleBrowser;
            if (bTree.size() != 0 && (tupleBrowser = bTree.browse()).getNext(tuple = new Tuple())) {
                return tuple.getValue();
            }
            return null;
        }
        catch (Throwable throwable) {
            this.handleIt(throwable);
            return null;
        }
    }

    synchronized Object getFromBTree(BTree bTree, Object object) throws VRDException {
        try {
            return bTree.find(object);
        }
        catch (Throwable throwable) {
            this.handleIt(throwable);
            return null;
        }
    }

    synchronized void removeFirstFromBTree(BTree bTree) throws VRDException {
        try {
            Tuple tuple;
            TupleBrowser tupleBrowser;
            if (bTree.size() != 0 && (tupleBrowser = this.workQueue.browse()).getNext(tuple = new Tuple())) {
                bTree.remove(tuple.getKey());
                this.recman.commit();
            }
        }
        catch (Throwable throwable) {
            this.handleIt(throwable);
        }
    }

    synchronized Object removeFromBTree(BTree bTree, Object object) throws VRDException {
        try {
            return bTree.remove(object);
        }
        catch (Throwable throwable) {
            this.handleIt(throwable);
            return null;
        }
    }

    void addWork(int n, XmlDocument xmlDocument) throws VRDException {
        this.addToBTree(this.workQueue, new Long(this.workSequenceID++), new WorkEntry(n, xmlDocument));
    }

    void addWork(int n, Document document) throws VRDException {
        this.addWork(n, new XmlDocument(document));
    }

    WorkEntry getWork() throws VRDException {
        return (WorkEntry)this.getFirstFromBTree(this.workQueue);
    }

    void removeWork() throws VRDException {
        this.removeFirstFromBTree(this.workQueue);
    }

    synchronized void cleanup() {
        try {
            if (this.recman != null) {
                this.recman.close();
            }
            this.workQueue = null;
            this.replicatedMoves = null;
            this.cache = null;
            this.recman = null;
        }
        catch (Throwable throwable) {
            StatusLog.log(new VRDException(throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadLegacyQueue() {
        RandomAccessFile randomAccessFile;
        block9: {
            File file = new File(String.valueOf(this.driverEntryID) + ".wbq");
            if (!file.canRead()) return;
            randomAccessFile = null;
            randomAccessFile = new RandomAccessFile(this.filename, "r");
            int n = (int)randomAccessFile.length();
            if (n <= 0) break block9;
            randomAccessFile.seek(0L);
            int n2 = randomAccessFile.readInt();
            randomAccessFile.seek(n2);
            while (n2 < n) {
                int n3 = randomAccessFile.readInt();
                int n4 = randomAccessFile.readInt();
                byte[] byArray = new byte[n3];
                randomAccessFile.readFully(byArray);
                this.addWork(n4, new XmlDocument(byArray));
                n2 += n3 + 8;
            }
        }
        Object var9_9 = null;
        if (randomAccessFile == null) return;
        try {
            randomAccessFile.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (Throwable throwable) {
                StatusLog.log(new VRDException(9057, throwable));
                Object var9_10 = null;
                if (randomAccessFile == null) return;
                try {
                    randomAccessFile.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (randomAccessFile == null) throw throwable;
            try {
                randomAccessFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    synchronized void addToHTree(HTree hTree, Object object, Object object2) throws VRDException {
        try {
            hTree.put(object, object2);
            this.recman.commit();
        }
        catch (Throwable throwable) {
            this.handleIt(throwable);
            try {
                hTree.put(object, object2);
                this.recman.commit();
            }
            catch (Throwable throwable2) {
                throw new VRDException(throwable2);
            }
        }
    }

    synchronized Object getFromHTree(HTree hTree, Object object) throws VRDException {
        try {
            return hTree.get(object);
        }
        catch (Throwable throwable) {
            this.handleIt(throwable);
            return null;
        }
    }

    synchronized void removeFromHTree(HTree hTree, Object object) throws VRDException {
        try {
            hTree.remove(object);
        }
        catch (Throwable throwable) {
            this.handleIt(throwable);
        }
    }

    void addReplicatedMove(long l, String string) throws VRDException {
        this.addToHTree(this.replicatedMoves, new Long(l), string);
    }

    String getReplicatedMove(long l) throws VRDException {
        return (String)this.getFromHTree(this.replicatedMoves, new Long(l));
    }

    void removeReplicatedMove(long l) throws VRDException {
        this.removeFromHTree(this.replicatedMoves, new Long(l));
    }

    void addVariable(String string, Serializable serializable) throws VRDException {
        if (serializable == null) {
            this.removeFromHTree(this.variables, string);
        } else {
            this.addToHTree(this.variables, string, serializable);
        }
    }

    Object getVariable(String string) throws VRDException {
        return this.getFromHTree(this.variables, string);
    }

    void removeVariable(String string) throws VRDException {
        this.removeFromHTree(this.variables, string);
    }

    private void handleIt(Throwable throwable) throws VRDException {
        try {
            StatusLog.log(new VRDException(throwable));
            this.killDB();
            this.initializeDB();
        }
        catch (Throwable throwable2) {
            throw new VRDException(throwable2);
        }
    }

    public static void main(String[] stringArray) {
        try {
            final WorkManager workManager = new WorkManager(0L);
            if (stringArray.length > 0) {
                if (stringArray[0].equals("1")) {
                    char c = 'a';
                    while (c <= 'z') {
                        XmlDocument xmlDocument = new XmlDocument("<" + c + "/>");
                        workManager.addWork(0, xmlDocument);
                        c = (char)(c + '\u0001');
                    }
                } else if (stringArray[0].equals("2")) {
                    WorkEntry workEntry;
                    int[] nArray = new int[]{0};
                    while ((workEntry = workManager.getWork()) != null) {
                        System.out.println(new XmlDocument(workEntry.getDocument()).getDocumentString());
                        workManager.removeWork();
                    }
                } else if (stringArray[0].equals("3")) {
                    boolean bl = false;
                    Thread thread = new Thread(){
                        boolean finished = false;

                        public void run() {
                            try {
                                while (true) {
                                    WorkEntry workEntry;
                                    if ((workEntry = workManager.getWork()) == null) {
                                        if (this.finished) break;
                                        Thread.sleep(100L);
                                        continue;
                                    }
                                    System.out.println(new XmlDocument(workEntry.getDocument()).getDocumentString());
                                    workManager.removeWork();
                                }
                                workManager.cleanup();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    };
                    thread.start();
                    char c = 'a';
                    while (c <= 'z') {
                        XmlDocument xmlDocument = new XmlDocument("<" + c + "/>");
                        workManager.addWork(0, xmlDocument);
                        c = (char)(c + '\u0001');
                    }
                    bl = true;
                    while (workManager.getWork() != null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class WorkEntry
    implements Serializable {
        int flags;
        XmlDocument doc;

        public WorkEntry() {
            this.flags = 0;
            this.doc = null;
        }

        public WorkEntry(int n, Document document) {
            this.flags = n;
            this.doc = new XmlDocument(document);
        }

        public WorkEntry(int n, XmlDocument xmlDocument) {
            this.flags = n;
            this.doc = xmlDocument;
        }

        public Document getDocument() {
            if (this.doc == null) {
                return null;
            }
            return this.doc.getDocument();
        }

        public int getFlags() {
            return this.flags;
        }
    }
}

