/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.act;

import com.novell.act.ActContext;
import com.novell.act.ActCredentialErr;
import com.novell.act.ActErr;
import com.novell.act.ActTag;
import com.novell.act.Activation;
import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.act.Credential;
import com.novell.nds.dirxml.engine.command.CommandHandler;
import com.novell.nds.dirxml.engine.command.CommandProcessor;
import com.novell.nds.dirxml.engine.command.DirXMLCommands;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dstrace.DDSTrace;
import com.novell.nds.events.EventNotification;
import com.novell.nds.events.ValueEventHandler;
import com.novell.nds.events.values.DSEValueInfo;
import com.novell.nds.events.values.DSEValueOctetList;
import com.novell.nds.events.values.DSEValueTimeStamp;
import com.novell.nds.wire.DSWire;
import com.novell.xml.util.Base64Codec;
import com.novell.xml.xpath.XPathUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import novell.jclient.JCCIstringValue;
import novell.jclient.JCContext;
import novell.jclient.JCEntryInfo;
import novell.jclient.JCEntryInfoCB;
import novell.jclient.JCEntryInfoEmptyFieldException;
import novell.jclient.JCException;
import novell.jclient.JCListFilter;
import novell.jclient.JCOctetlistValue;
import novell.jclient.JCOctetstringValue;
import novell.jclient.JCReadFilter;
import novell.jclient.JCTimestamp;
import novell.jclient.JCTimestampValue;
import novell.jclient.JCValue;
import novell.jclient.JClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DirXMLAct {
    public static final int EVAL_EXPIRED = 0;
    public static final int EVAL = 1;
    public static final int ACTIVATED = 2;
    private static final int DOMAIN_BUFFER_SIZE = 16;
    private static final long EVALUATION_PERIOD = 7776000L;
    private static int initCount = 0;
    private static DirXMLAct dirXMLAct = null;
    protected static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.act.DirXMLAct");
    protected static final String ENGINE_ACTIVATED = "act_engact";
    protected static final String ENGINE_EVAL = "act_engevl";
    protected static final String DRIVER_ACTIVATED = "act_drvact";
    protected static final String DRIVER_EVAL = "act_drvevl";
    protected static final String ENGINE_ACTIVATED_BETA = "act_engacb";
    protected static final String DRIVER_ACTIVATED_BETA = "act_drvacb";
    protected static final String ACTIVATION_DISABLED = "act_acdcec";
    protected static final String ENGINE_ACTIVATED_LTD = "act_engltd";
    protected static final String DRIVER_ACTIVATED_LTD = "act_drvltd";
    private JCContext jcContext = null;
    private long driverSetID = -1L;
    private byte[] domain = null;
    private List credentials = new LinkedList();
    private int engineUnits = 0;
    private String engineCompanyName = null;
    private Date engineExpires = null;
    private int clientDataUpdateCount = 0;
    private ActContext actContext = null;
    private EventWatcher activationWatcher = null;
    private CmdFredRequest commandHandler = null;
    private String treeName;
    private boolean limitedEngineActivation = false;
    private boolean wroteLimitedEngineFlag = false;
    protected static String platformString = "";
    private static boolean activationDisabled = false;
    private static final String GUID_ATTR = "GUID";
    private static final String ACTIVATION_DOMAIN_ATTR = "DirXML-Act1";
    private static final String ACTIVATION_TIME_ATTR = "DirXML-Act2";
    private static final String ACTIVATION_CREDENTIAL_ATTR = "DirXML-Act3";
    private static final String DRIVER_ID_ATTR = "DirXML-DriverId";
    private static final String SLASH_ROOT_NAME = "\\[Root]";
    private static final String PRODUCT_ID = "DIRXML";
    private static final String PRODUCT_ID_LTD = "DIRXMLTD";
    private static final String PRODUCT_VERSION = "2.0";
    private static final String PRODUCT_KEY_NUMBER = "1";
    private static final int MIN_ENGINE_VERSION = 2;
    private static final String TAG_FRED_REQUEST = "fred-request";
    private static final String TAG_FRED_RESPONSE = "fred-response";
    private static final String TAG_ID = "id";
    private static final String STR_ERROR_CODE = "ErrorCode";
    private static final String STR_REASON_CODE = "ReasonCode";
    private static final String MSG_DIFFERENT_TREE = "Credential is for a different tree.";
    private static final long LIMITED_ENGINE_TIMESTAMP = Integer.MAX_VALUE;
    private static final byte[] PRODUCT_ACTIVATION_CERT = new byte[]{48, -126, 3, -108, 48, -126, 2, 124, -96, 3, 2, 1, 2, 2, 49, 2, 44, 0, 0, 0, 16, 118, 34, -80, 54, -99, -115, 127, -55, -25, 94, 94, -125, 74, 26, -75, 75, -10, -93, -65, -97, -35, -27, -47, -1, 126, 107, 6, 123, 28, 28, 94, -53, 119, -71, 7, 113, 63, -4, -34, 38, 2, 1, 8, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, 73, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 19, 48, 17, 6, 3, 85, 4, 10, 19, 10, 78, 111, 118, 101, 108, 108, 44, 73, 110, 99, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 78, 111, 118, 101, 108, 108, 32, 80, 114, 111, 100, 117, 99, 116, 32, 65, 99, 116, 105, 118, 97, 116, 105, 111, 110, 32, 67, 65, 48, 30, 23, 13, 48, 49, 49, 49, 50, 57, 50, 51, 52, 56, 53, 51, 90, 23, 13, 51, 54, 48, 50, 48, 51, 50, 51, 53, 57, 48, 48, 90, 48, 67, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 19, 48, 17, 6, 3, 85, 4, 10, 19, 10, 78, 111, 118, 101, 108, 108, 44, 73, 110, 99, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 100, 105, 114, 88, 77, 76, 32, 65, 99, 116, 105, 118, 97, 116, 105, 111, 110, 32, 67, 65, 32, 49, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -60, 97, -124, 38, 93, -34, 47, -125, -118, -59, 49, 72, 79, 45, 34, -43, -112, -92, 113, -97, 66, 70, 3, -2, -2, 124, 65, 23, 26, -27, -61, 50, 56, -83, -50, 77, -84, -24, 107, -49, 81, 95, 12, -17, -55, 5, 75, -55, 86, 111, -77, 105, 18, 86, -22, 29, 39, -68, 42, -42, -66, 7, -81, -79, -79, -67, 70, 52, -3, 118, -47, 123, -5, -11, -58, 40, 29, 37, -62, -70, -121, 127, 64, -88, 6, -97, -119, -127, 61, -100, -64, -56, -46, 48, -62, 85, -85, 113, 39, 16, 11, 44, -8, 45, -24, 78, 97, 29, -111, 38, -69, 55, -70, 97, -26, -86, -103, -124, 22, 101, -67, -57, -3, -1, 30, -3, 86, 28, 46, 27, -114, 93, 93, 106, 98, -73, 43, 38, 91, 97, -103, -106, 105, 29, -90, 52, -21, 12, 63, 112, -49, -41, -104, 68, 33, 92, -50, 116, -123, 36, -29, 93, -59, 53, -61, -13, -7, 30, 110, -66, 6, 67, -76, -111, 67, -56, 71, -79, 59, 60, 113, 77, -74, -49, -69, 93, -62, -48, 6, -122, -16, 7, -20, -128, -84, -53, -72, -40, 124, 39, 108, 21, 115, 124, -27, 72, -95, 5, 49, -50, -26, 114, 46, 106, -109, 86, -43, -48, 10, 66, -10, -49, 59, -74, -56, 113, 65, 123, -89, -118, -3, -30, 33, 64, -29, -107, 51, -91, -76, 96, -88, -92, -8, 29, -74, 31, 66, 92, 127, 8, 112, -11, 28, 61, -76, 117, 2, 3, 1, 0, 1, -93, 93, 48, 91, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 42, -108, 94, 106, -53, 10, -81, 95, -76, 27, -125, -125, -2, 113, -127, -23, -14, -107, 77, 47, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 87, 81, 95, -53, -84, 63, 80, 127, 6, -30, 66, -1, -15, 29, -123, -16, 23, -98, 96, -46, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 2, -76, 48, 12, 6, 3, 85, 29, 19, 4, 5, 48, 3, 1, 1, -1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, -64, -94, -102, 70, -63, -89, 105, -111, -24, 57, -72, 59, -1, -53, -99, -38, 90, -49, -98, 5, 104, 48, 61, -23, -12, 2, 85, -55, -58, 27, 16, 99, -82, -46, 16, -92, 127, 56, 92, -66, -18, 105, 31, 113, 29, 8, -69, 2, -108, -91, -11, -24, 62, -104, 64, -5, -40, -64, -126, 105, 26, -126, -20, 34, -102, -40, 12, -92, 5, -112, -87, -102, 78, 7, 48, -107, -114, -80, -65, -5, 76, 85, -26, 102, 6, -118, 42, 72, 37, 106, -126, 16, 24, -58, 33, -16, 124, 53, 2, -63, 125, -118, -77, -12, -69, -108, 125, -9, -95, -114, -43, 29, -90, -95, -76, -97, 127, -25, -24, 93, 65, -64, -43, 121, 56, 121, -2, 52, 6, -76, -53, -110, -28, 21, 120, -54, -24, -124, -65, -16, 52, -83, -58, -32, -118, 110, 48, 50, 127, 3, 45, 74, -47, -16, -34, 121, 0, 58, -72, -25, 44, -90, -32, -9, -126, 50, 37, -37, 10, 82, 14, 33, -13, 122, -122, 119, 21, -43, -56, 48, -108, 7, 103, 111, -48, -106, 4, 24, 16, 78, 43, -98, 63, -7, 127, 36, -24, 83, -23, -8, -104, 98, -70, 11, -24, -60, -55, 65, -36, 25, 71, 125, 30, -52, -113, -62, 98, 88, -79, -4, 69, 83, -55, 39, 104, -10, -56, 108, 94, -31, 85, -35, -37, 36, -101, 117, 45, -9, 88, 40, 17, 7, -46, 70, 32, 10, -77, 41, 106, -117, -80, -20, -20, 103, 36, 104};

    /*
     * Unable to fully structure code
     */
    public static void initialize() throws Throwable {
        block7: {
            if (++DirXMLAct.initCount == 1) {
                var0 = false;
                var1_1 = false;
                DirXMLAct.detectPlatform();
                try {
                    DirXMLAct.activationDisabled = DirXMLAct.messageSource.getMessageString("act_acdcec") != "act_acdcec";
                    Activation.initialize();
                    var0 = true;
                    DirXMLCommands.initialize();
                    var1_1 = true;
                    DirXMLAct.dirXMLAct = new DirXMLAct();
                    break block7;
                }
                catch (Throwable var2_2) {
                    StatusLog.logError(9101, var2_2);
                    ** while (var1_1 || var0)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        if (var1_1) {
                            var1_1 = false;
                            DirXMLCommands.cleanup();
                        }
                        if (!var0) continue;
                        var0 = false;
                        Activation.cleanup();
                    }
                    catch (Throwable var3_3) {
                        // empty catch block
                    }
                    continue;
                }
lbl27:
                // 1 sources

                --DirXMLAct.initCount;
                throw var2_2;
            }
        }
    }

    public static void cleanup() {
        if (--initCount == 0) {
            try {
                dirXMLAct.destroy();
                dirXMLAct = null;
                DirXMLCommands.cleanup();
                Activation.cleanup();
            }
            catch (Throwable throwable) {
                StatusLog.logError(9102, throwable);
            }
        }
        if (initCount < 0) {
            initCount = 0;
        }
    }

    public static ActivationState checkEngineActivation() {
        if (dirXMLAct != null) {
            return dirXMLAct.getEngineActivationState();
        }
        return new ActivationState(0, new Date());
    }

    public static ActivationState checkDriverActivation(long l, String string, int n) {
        if (dirXMLAct != null) {
            return dirXMLAct.getDriverActivationState(l, string, n);
        }
        return new ActivationState(0, new Date());
    }

    private DirXMLAct() throws DSErr {
        try {
            this.jcContext = MiscDS.createLocalContext();
            this.driverSetID = MiscDS.getDriverSetID(this.jcContext);
            this.jcContext.setEntryID(this.driverSetID);
            this.treeName = MiscDS.getTreeName();
            this.actContext = Activation.createContext((String)PRODUCT_ID, (String)PRODUCT_VERSION, (String)PRODUCT_KEY_NUMBER, (byte[])PRODUCT_ACTIVATION_CERT);
            this.i1();
            this.getDomain();
            this.activationWatcher = new EventWatcher();
            EventNotification.registerForValueEvent((int)2, (int)5, (int)0, (ValueEventHandler)this.activationWatcher, (String)"DirXML-DriverSet", (String)ACTIVATION_CREDENTIAL_ATTR);
            EventNotification.registerForValueEvent((int)2, (int)6, (int)0, (ValueEventHandler)this.activationWatcher, (String)"DirXML-DriverSet", (String)ACTIVATION_CREDENTIAL_ATTR);
            this.initCredentials();
            this.recheckDriverTimestamps();
            this.commandHandler = new CmdFredRequest();
            DirXMLCommands.addHandler(this.commandHandler);
        }
        catch (Throwable throwable) {
            StatusLog.logError(9101, throwable);
            this.destroy();
            if (throwable instanceof DSErr) {
                throw (DSErr)throwable;
            }
            if (throwable instanceof ActErr) {
                throw new DSErr(((ActErr)throwable).getCode());
            }
            if (throwable instanceof JCException) {
                throw new DSErr(((JCException)throwable).getErrorCode());
            }
            throw new DSErr(-632);
        }
    }

    private void destroy() {
        if (this.commandHandler != null) {
            try {
                DirXMLCommands.removeHandler(this.commandHandler);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.commandHandler = null;
        }
        if (this.activationWatcher != null) {
            try {
                EventNotification.unregisterForValueEvent((int)2, (int)6, (ValueEventHandler)this.activationWatcher, (String)"DirXML-DriverSet", (String)ACTIVATION_CREDENTIAL_ATTR);
                EventNotification.unregisterForValueEvent((int)2, (int)5, (ValueEventHandler)this.activationWatcher, (String)"DirXML-DriverSet", (String)ACTIVATION_CREDENTIAL_ATTR);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.activationWatcher = null;
        }
        this.clearCredentials();
        if (this.jcContext != null) {
            this.jcContext.free();
            this.jcContext = null;
        }
        if (this.actContext != null) {
            try {
                this.actContext.destroyContext();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDomain() throws DSErr, JCException {
        JCReadFilter jCReadFilter = new JCReadFilter();
        jCReadFilter.attributeNames = new String[]{ACTIVATION_DOMAIN_ATTR};
        JCValue[] jCValueArray = null;
        try {
            jCValueArray = JClient.readEntry((JCContext)this.jcContext, (long)1L, (JCReadFilter)jCReadFilter);
        }
        catch (JCException jCException) {
            // empty catch block
        }
        if (jCValueArray == null || jCValueArray.length == 0) {
            JCOctetstringValue jCOctetstringValue;
            JCContext jCContext = new JCContext(4, "\\" + this.treeName, "00.\\+=*'");
            try {
                jCContext.resolve(2, SLASH_ROOT_NAME);
                jCReadFilter.attributeNames = new String[]{GUID_ATTR};
                jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                jCOctetstringValue = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                jCContext.free();
                throw throwable;
            }
            jCContext.free();
            this.domain = ((JCOctetstringValue)jCValueArray[0]).getOctets();
            byte[] byArray = this.o1(this.domain);
            jCOctetstringValue = new JCOctetstringValue();
            jCOctetstringValue.attributeName = ACTIVATION_DOMAIN_ATTR;
            jCOctetstringValue.operation = 2;
            jCOctetstringValue.setOctets(byArray);
            JCValue[] jCValueArray2 = new JCValue[]{jCOctetstringValue};
            JClient.modifyEntry((JCContext)this.jcContext, (JCValue[])jCValueArray2);
        } else {
            this.domain = this.o2(((JCOctetstringValue)jCValueArray[0]).getOctets());
        }
        if (this.domain.length != 16) {
            throw new DSErr(-731);
        }
    }

    private void initCredentials() {
        try {
            JCValue[] jCValueArray;
            block11: {
                this.clearCredentials();
                JCReadFilter jCReadFilter = new JCReadFilter();
                jCReadFilter.attributeNames = new String[]{ACTIVATION_CREDENTIAL_ATTR};
                jCValueArray = null;
                try {
                    jCValueArray = JClient.readEntry((JCContext)this.jcContext, (long)1L, (JCReadFilter)jCReadFilter);
                }
                catch (JCException jCException) {
                    if (jCException.getErrorCode() == -603) break block11;
                    throw jCException;
                }
            }
            if (jCValueArray != null) {
                int n = 0;
                while (n < jCValueArray.length) {
                    this.addActivationFromValue(jCValueArray[n]);
                    ++n;
                }
            }
            if (this.engineUnits > 0) {
                if (activationDisabled) {
                    DDSTrace.trace((int)217, (int)14, (String)messageSource.getMessage(ENGINE_ACTIVATED_BETA, new Object[]{this.engineCompanyName}));
                } else {
                    DDSTrace.trace((int)217, (int)10, (String)messageSource.getMessage(ENGINE_ACTIVATED, new Object[]{this.engineCompanyName}));
                    this.resetEvalTime(this.jcContext);
                }
            } else if (this.limitedEngineActivation) {
                DDSTrace.trace((int)217, (int)14, (String)messageSource.getMessage(ENGINE_ACTIVATED_LTD, new Object[]{this.engineCompanyName}));
                this.setLimitedFlag(this.jcContext);
            }
            this.updateClientData();
        }
        catch (Throwable throwable) {
            StatusLog.logError(9103, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reInitCredentials() {
        DirXMLAct dirXMLAct = this;
        synchronized (dirXMLAct) {
            this.initCredentials();
        }
        this.recheckDriverTimestamps();
    }

    private void updateClientData() {
        if (this.clientDataUpdateCount > 0) {
            int n = 0;
            Iterator iterator = this.credentials.iterator();
            while (iterator.hasNext()) {
                if (!((Credential)iterator.next()).hasClientData()) continue;
                ++n;
            }
            JCOctetlistValue[] jCOctetlistValueArray = new JCOctetlistValue[n * 2];
            iterator = this.credentials.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Credential credential = (Credential)iterator.next();
                if (!credential.hasClientData()) continue;
                jCOctetlistValueArray[n2] = new JCOctetlistValue(ACTIVATION_CREDENTIAL_ATTR, 7, 0L, new JCTimestamp(), (byte[][])new byte[][]{credential.getCredential()});
                jCOctetlistValueArray[++n2] = new JCOctetlistValue(ACTIVATION_CREDENTIAL_ATTR, 5, 0L, new JCTimestamp(), (byte[][])new byte[][]{credential.getCredential(), credential.getClientDataBytes()});
                ++n2;
                credential.destroyClientData();
            }
            try {
                JClient.modifyEntry((JCContext)this.jcContext, (JCValue[])jCOctetlistValueArray);
            }
            catch (JCException jCException) {
                StatusLog.logError(9104, jCException);
            }
            this.clientDataUpdateCount = 0;
        }
    }

    private void clearCredentials() {
        if (this.actContext != null) {
            try {
                this.actContext.clearCredentialList();
            }
            catch (ActErr actErr) {
                StatusLog.logError(9105, actErr);
            }
        }
        this.credentials.clear();
        this.engineUnits = 0;
        this.engineExpires = null;
        this.clientDataUpdateCount = 0;
        this.limitedEngineActivation = false;
        this.wroteLimitedEngineFlag = false;
    }

    private void addActivationFromValue(JCValue jCValue) throws DSErr, ActErr {
        ActTag actTag;
        if (jCValue.syntax != 13) {
            return;
        }
        JCOctetlistValue jCOctetlistValue = (JCOctetlistValue)jCValue;
        byte[][] byArray = jCOctetlistValue.getOctetstrings();
        if (byArray == null || byArray.length == 0) {
            return;
        }
        Credential credential = new Credential(byArray[0]);
        this.credentials.add(credential);
        if (byArray.length == 1) {
            credential.initClientData();
            ++this.clientDataUpdateCount;
        }
        boolean bl = false;
        try {
            credential.setCredentialHandle(this.actContext.injectActivationCredential(credential.getCredential()));
            bl = true;
        }
        catch (ActErr actErr) {
            StatusLog.logError(9106, actErr);
            if (actErr instanceof ActCredentialErr) {
                credential.setCredentialHandle(((ActCredentialErr)actErr).getCredentialHandle());
                credential.addClientData(STR_ERROR_CODE, ((ActCredentialErr)actErr).getErrorMessage());
                credential.addClientData(STR_REASON_CODE, ((ActCredentialErr)actErr).getReasonMessage());
                bl = false;
            }
            throw actErr;
        }
        if (credential.getCredentialHandle() == null) {
            return;
        }
        boolean bl2 = false;
        while ((actTag = this.actContext.getCredentialTagValue(credential.getCredentialHandle())) != null) {
            if (actTag.getType() == 1) {
                credential.addClientData(actTag.getName(), actTag.getStringValue());
            }
            if (actTag.getName().equals("ProductDomain")) {
                bl2 = true;
                credential.setDomain(actTag.getBinaryValue());
                if (!bl) continue;
                credential.setValid(credential.getDomain().length == 16 && Arrays.equals(this.domain, credential.getDomain()));
                if (credential.isValid()) continue;
                StatusLog.logError(9107);
                credential.addClientData(STR_ERROR_CODE, MSG_DIFFERENT_TREE);
                continue;
            }
            if (actTag.getName().equals("Units")) {
                int n = actTag.getStringValue().indexOf(58);
                String string = null;
                String string2 = null;
                if (n != -1) {
                    string = actTag.getStringValue().substring(0, n);
                    string2 = actTag.getStringValue().substring(n + 1);
                }
                try {
                    if (string == null) {
                        credential.setUnits(Integer.parseInt(actTag.getStringValue()));
                        continue;
                    }
                    credential.setUnits(Integer.parseInt(string) * Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    StatusLog.logError(9108, numberFormatException);
                    credential.setUnits(0);
                }
                continue;
            }
            if (actTag.getName().equals("ProductComponent")) {
                credential.addComponent(actTag.getStringValue());
                continue;
            }
            if (!actTag.getName().equals("CompanyName")) continue;
            credential.setCompanyName(actTag.getStringValue());
        }
        if (bl && !bl2) {
            credential.setValid(true);
        }
        if (credential.isValid()) {
            if (credential.checkForProduct(PRODUCT_ID, 2)) {
                if (this.engineUnits == 0) {
                    this.engineCompanyName = credential.getCompanyName();
                }
                this.engineUnits += credential.getUnits();
                this.limitedEngineActivation = false;
            } else if (credential.checkForProduct(PRODUCT_ID_LTD, 2)) {
                if (this.engineUnits == 0) {
                    this.engineCompanyName = credential.getCompanyName();
                    this.limitedEngineActivation = true;
                }
                credential.setLimitedEngine(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recheckDriverTimestamps() {
        JCContext jCContext;
        JCContext jCContext2;
        block15: {
            block13: {
                block14: {
                    jCContext2 = null;
                    jCContext = null;
                    try {
                        try {
                            jCContext2 = this.jcContext.duplicate();
                            jCContext = this.jcContext.duplicate();
                            jCContext2.setEntryID(this.driverSetID);
                            JCListFilter jCListFilter = new JCListFilter(false, true, false, false, "DirXML-Driver", "", new JCTimestamp());
                            final ArrayList arrayList = new ArrayList();
                            JClient.listToCB((JCContext)jCContext2, (JCListFilter)jCListFilter, (int)2, (JCEntryInfoCB)new JCEntryInfoCB(){

                                public int entryInfoCallback(JCContext jCContext, JCEntryInfo jCEntryInfo) {
                                    try {
                                        arrayList.add(new Long(jCEntryInfo.getEntryID()));
                                        return 0;
                                    }
                                    catch (JCEntryInfoEmptyFieldException jCEntryInfoEmptyFieldException) {
                                        return 0;
                                    }
                                }
                            });
                            if (arrayList.isEmpty()) {
                                Object var13_6 = null;
                                if (jCContext2 == null) break block13;
                                break block14;
                            }
                            int n = 0;
                            while (n < arrayList.size()) {
                                try {
                                    long l = (Long)arrayList.get(n);
                                    jCContext.setEntryID(l);
                                    JCReadFilter jCReadFilter = new JCReadFilter();
                                    jCReadFilter.attributeNames = new String[]{ACTIVATION_TIME_ATTR};
                                    JCValue[] jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                                    if (jCValueArray != null && jCValueArray.length != 0) {
                                        jCReadFilter.attributeNames[0] = ACTIVATION_DOMAIN_ATTR;
                                        jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((JCOctetstringValue)jCValueArray[0]).getOctets());
                                        int n2 = DSWire.WGetInt32((InputStream)byteArrayInputStream);
                                        jCReadFilter.attributeNames[0] = DRIVER_ID_ATTR;
                                        jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                                        this.getDriverActivationState(l, ((JCCIstringValue)jCValueArray[0]).getString(), n2 += -17958194);
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                ++n;
                            }
                            break block15;
                        }
                        catch (JCException jCException) {
                            StatusLog.logError(9109, jCException);
                            Object var13_8 = null;
                            if (jCContext2 != null) {
                                jCContext2.free();
                            }
                            if (jCContext == null) return;
                            jCContext.free();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_9 = null;
                        if (jCContext2 != null) {
                            jCContext2.free();
                        }
                        if (jCContext == null) throw throwable;
                        jCContext.free();
                        throw throwable;
                    }
                }
                jCContext2.free();
            }
            if (jCContext == null) return;
            jCContext.free();
            return;
        }
        Object var13_7 = null;
        if (jCContext2 != null) {
            jCContext2.free();
        }
        if (jCContext == null) return;
        jCContext.free();
    }

    private synchronized ActivationState getEngineActivationState() {
        int n;
        if ((this.engineUnits > 0 || this.limitedEngineActivation) && !activationDisabled) {
            n = 2;
        } else if (this.engineExpires == null) {
            ActivationState activationState = this.checkEvalTimeExpired(this.jcContext);
            n = activationState.getState();
            this.engineExpires = activationState.getExpiration();
            if (n == 1) {
                DDSTrace.trace((int)217, (int)12, (String)messageSource.getMessage(ENGINE_EVAL, new Object[]{this.engineExpires}));
            }
        } else {
            n = this.engineExpires.compareTo(new Date()) < 0 ? 0 : 1;
        }
        return new ActivationState(n, this.engineExpires);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized ActivationState getDriverActivationState(long l, String string, int n) {
        Credential credential;
        boolean bl;
        Date date;
        int n2;
        block20: {
            n2 = 0;
            date = null;
            int n3 = 0;
            String string2 = null;
            bl = false;
            Iterator iterator = this.credentials.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    if (n3 > 0 || n <= 0) {
                        if (!activationDisabled || n <= 0) break;
                        DDSTrace.trace((int)217, (int)14, (String)messageSource.getMessage(DRIVER_ACTIVATED_BETA, new Object[]{string, string2}));
                    }
                    break block20;
                }
                credential = (Credential)iterator.next();
                if (!credential.checkForProduct(string, n)) continue;
                if (n3 == 0) {
                    string2 = credential.getCompanyName();
                }
                n3 += credential.getUnits();
                if (!credential.isLimitedEngine()) continue;
                bl = true;
            }
            if (!this.limitedEngineActivation || bl) {
                n2 = 2;
                credential = null;
                try {
                    credential = this.jcContext.duplicate();
                    credential.setEntryID(l);
                    if (n > 0) {
                        DDSTrace.trace((int)217, (int)10, (String)messageSource.getMessage(DRIVER_ACTIVATED, new Object[]{string, string2}));
                    }
                    this.resetEvalTime((JCContext)credential);
                }
                catch (Throwable throwable) {
                    Object var14_12 = null;
                    if (credential == null) throw throwable;
                    credential.free();
                    throw throwable;
                }
            }
        }
        if (n2 == 2) return new ActivationState(n2, date);
        credential = null;
        try {
            try {
                if (this.limitedEngineActivation && !bl) {
                    DDSTrace.trace((int)217, (int)14, (String)messageSource.getMessage(DRIVER_ACTIVATED_LTD, new Object[]{string}));
                }
                credential = this.jcContext.duplicate();
                credential.setEntryID(l);
                ActivationState activationState = this.checkEvalTimeExpired((JCContext)credential);
                n2 = activationState.getState();
                date = activationState.getExpiration();
                if (n2 == 1) {
                    DDSTrace.trace((int)217, (int)12, (String)messageSource.getMessage(DRIVER_EVAL, new Object[]{string, activationState.getExpiration()}));
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
                DSWire.WPutInt32((OutputStream)byteArrayOutputStream, (int)(n - -17958194));
                JCOctetstringValue jCOctetstringValue = new JCOctetstringValue();
                jCOctetstringValue.attributeName = ACTIVATION_DOMAIN_ATTR;
                jCOctetstringValue.operation = 5;
                jCOctetstringValue.setOctets(byteArrayOutputStream.toByteArray());
                JCValue[] jCValueArray = new JCValue[]{jCOctetstringValue};
                try {
                    JClient.modifyEntry((JCContext)credential, (JCValue[])jCValueArray);
                }
                catch (Throwable throwable) {
                }
                Object var18_20 = null;
                if (credential == null) return new ActivationState(n2, date);
            }
            catch (Throwable throwable) {
                n2 = 0;
                date = new Date();
                Object var18_21 = null;
                if (credential == null) return new ActivationState(n2, date);
                credential.free();
                return new ActivationState(n2, date);
            }
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            if (credential == null) throw throwable;
            credential.free();
            throw throwable;
        }
        credential.free();
        return new ActivationState(n2, date);
    }

    private void resetEvalTime(JCContext jCContext) {
        try {
            JCTimestampValue jCTimestampValue = new JCTimestampValue();
            jCTimestampValue.attributeName = ACTIVATION_TIME_ATTR;
            jCTimestampValue.operation = 6;
            JCValue[] jCValueArray = new JCValue[]{jCTimestampValue};
            JClient.modifyEntry((JCContext)jCContext, (JCValue[])jCValueArray);
        }
        catch (Throwable throwable) {
            StatusLog.logError(9110, throwable);
        }
    }

    private ActivationState checkEvalTimeExpired(JCContext jCContext) {
        try {
            long l;
            JCTimestampValue jCTimestampValue;
            JCReadFilter jCReadFilter = new JCReadFilter();
            jCReadFilter.attributeNames = new String[]{ACTIVATION_TIME_ATTR};
            JCValue[] jCValueArray = null;
            while (true) {
                try {
                    jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                }
                catch (JCException jCException) {
                    if (jCException.getErrorCode() == -603) {
                        JCTimestampValue jCTimestampValue2 = new JCTimestampValue();
                        jCTimestampValue2.attributeName = ACTIVATION_TIME_ATTR;
                        jCTimestampValue2.operation = 5;
                        jCTimestampValue2.setSeconds(new Date().getTime() / 1000L + 7776000L);
                        jCTimestampValue2.setReplica(0);
                        jCTimestampValue2.setEventID((int)(jCTimestampValue2.getSeconds() - 3131963L) & 0xFFFF);
                        jCValueArray = new JCValue[]{jCTimestampValue2};
                        JClient.modifyEntry((JCContext)jCContext, (JCValue[])jCValueArray);
                    }
                    throw jCException;
                }
                jCTimestampValue = (JCTimestampValue)jCValueArray[0];
                l = jCTimestampValue.getSeconds();
                if (l != Integer.MAX_VALUE) break;
                this.resetEvalTime(jCContext);
            }
            Date date = new Date(l * 1000L);
            if (jCTimestampValue.getEventID() == ((int)(l - 3131963L) & 0xFFFF) && new Date().compareTo(date) <= 0) {
                return new ActivationState(1, date);
            }
        }
        catch (Throwable throwable) {
            StatusLog.logError(9111, throwable);
        }
        return new ActivationState(0, new Date());
    }

    private void setLimitedFlag(JCContext jCContext) {
        try {
            JCTimestampValue jCTimestampValue = new JCTimestampValue();
            jCTimestampValue.attributeName = ACTIVATION_TIME_ATTR;
            jCTimestampValue.operation = 5;
            jCTimestampValue.setSeconds(Integer.MAX_VALUE);
            jCTimestampValue.setReplica(0);
            jCTimestampValue.setEventID(13764);
            JCValue[] jCValueArray = new JCValue[]{jCTimestampValue};
            JClient.modifyEntry((JCContext)jCContext, (JCValue[])jCValueArray);
        }
        catch (JCException jCException) {
            StatusLog.logError(9104, jCException);
        }
    }

    private static void detectPlatform() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("netware") != -1) {
            platformString = "NETWARE";
        } else if (string.indexOf("windows") != -1) {
            platformString = "WIN32";
        } else if (string.indexOf("linux") != -1) {
            platformString = "LINUX";
        } else if (string.indexOf("solaris") != -1) {
            platformString = "SOLARIS";
        } else if (string.indexOf("aix") != -1) {
            platformString = "AIX";
        } else if (string.indexOf("hp") != -1 && string.indexOf("ux") != -1) {
            platformString = "HPUX";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void i1() {
        block12: {
            block11: {
                var1_1 = null;
                try {
                    try {
                        var2_2 = this.getBaseDir();
                        if (var2_2 == null) {
                            var8_4 = null;
                            if (var1_1 == null) return;
                            break block11;
                        }
                        var3_12 = new File(var2_2, "r2h409A.tmp");
                        var1_1 = new FileInputStream(var3_12);
                        var4_13 = var1_1.available();
                        var5_14 = new byte[var4_13];
                        var1_1.read(var5_14);
                        var1_1.close();
                        var5_14 = this.o2(var5_14);
                        var6_15 = new JCOctetlistValue[]{new JCOctetlistValue("DirXML-Act3", 5, 0L, new JCTimestamp(), (byte[][])new byte[][]{var5_14})};
                        JClient.modifyEntry((JCContext)this.jcContext, (JCValue[])var6_15);
                        Thread.sleep(1000L);
                        var3_12.delete();
                        break block12;
                    }
                    catch (Throwable var2_3) {
                        var8_6 = null;
                        if (var1_1 == null) return;
                        try {
                            var1_1.close();
                            return;
                        }
                        catch (IOException var9_10) {
                            return;
                        }
                    }
                }
                catch (Throwable var7_16) {
                    var8_7 = null;
                    if (var1_1 == null) throw var7_16;
                    ** try [egrp 2[TRYBLOCK] [5 : 151->158)] { 
lbl38:
                    // 1 sources

                    var1_1.close();
                    throw var7_16;
lbl40:
                    // 1 sources

                    catch (IOException var9_11) {
                        // empty catch block
                    }
                    throw var7_16;
                }
            }
            ** try [egrp 2[TRYBLOCK] [5 : 151->158)] { 
lbl45:
            // 1 sources

            var1_1.close();
            return;
lbl47:
            // 1 sources

            catch (IOException var9_8) {
                // empty catch block
            }
            return;
        }
        var8_5 = null;
        if (var1_1 == null) return;
        try {}
        catch (IOException var9_9) {}
        var1_1.close();
        return;
    }

    private File getBaseDir() {
        block12: {
            try {
                int n;
                URL uRL = this.getClass().getResource("DirXMLAct.class");
                if (uRL == null) break block12;
                String string = uRL.getFile();
                if (string.indexOf("file:") == 0) {
                    string = string.substring(0, string.indexOf(33));
                    string = string.substring(string.indexOf("file:") + 5);
                    return new File(new File(string).getParent());
                }
                int n2 = string.indexOf("ZIP");
                if (n2 != -1) {
                    string = string.substring(n2 + 3);
                } else {
                    n2 = string.indexOf("FILE");
                    if (n2 != -1) {
                        string = string.substring(n2 + 4);
                    } else {
                        return null;
                    }
                }
                int n3 = string.indexOf(47);
                if (n3 == -1) {
                    return null;
                }
                String string2 = string.substring(0, n3);
                try {
                    n = Integer.decode(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                String string3 = System.getProperty("java.class.path");
                String string4 = System.getProperty("path.separator");
                StringTokenizer stringTokenizer = new StringTokenizer(string3, string4);
                while (stringTokenizer.hasMoreTokens()) {
                    if (n == 0) {
                        return new File(new File(stringTokenizer.nextToken()).getParent());
                    }
                    stringTokenizer.nextToken();
                    --n;
                }
            }
            catch (Throwable throwable) {
                String string = throwable.toString();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private byte[] generateActivationRequest(String string) {
        this.actContext.setActivationRequestTagValue("CustomerID", string);
        this.actContext.setActivationRequestTagValue("CustomerDomainDescription", this.treeName);
        this.actContext.setActivationRequestTagValue("ProductDomain", this.domain);
        this.actContext.setActivationRequestTagValue("ProductDomainDescription", this.treeName);
        byte[] byArray = this.actContext.createActivationRequest();
        Object var5_4 = null;
        try {
            this.actContext.clearActivationRequestData();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return byArray;
        catch (ActErr actErr) {
            StatusLog.logError(9112, actErr);
            byte[] byArray2 = null;
            Object var5_5 = null;
            {
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    try {
                        this.actContext.clearActivationRequestData();
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
            }
            try {
                this.actContext.clearActivationRequestData();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return byArray2;
        }
    }

    public static Date getMaxEvaluationExpiration() {
        return new Date(System.currentTimeMillis() + 7776000000L);
    }

    private native byte[] o1(byte[] var1) throws DSErr;

    private native byte[] o2(byte[] var1) throws DSErr;

    private class CmdFredRequest
    implements CommandHandler {
        private CmdFredRequest() {
        }

        public String getCommandName() {
            return DirXMLAct.TAG_FRED_REQUEST;
        }

        public void handleCommand(Element element, String string, Element element2, DSEValueTimeStamp dSEValueTimeStamp) {
            try {
                if (dirXMLAct == null) {
                    throw new DSErr(-255);
                }
                Node node = element.getFirstChild();
                while (node != null) {
                    if (node.getNodeType() == 1 && node.getNodeName().equals(DirXMLAct.TAG_ID)) break;
                    node = node.getNextSibling();
                }
                if (node == null) {
                    throw new DSErr(-641);
                }
                String string2 = XPathUtil.getNodeValue((Node)node);
                byte[] byArray = dirXMLAct.generateActivationRequest(string2);
                if (byArray == null) {
                    throw new DSErr(-255);
                }
                Document document = element2.getOwnerDocument();
                Element element3 = document.createElementNS(null, DirXMLAct.TAG_FRED_RESPONSE);
                element2.appendChild(element3);
                element3.setAttributeNS(null, "command-id", string);
                char[] cArray = Base64Codec.encode((byte[])byArray);
                Text text = document.createTextNode(new String(cArray));
                element3.appendChild(text);
                CommandProcessor.addStatus(element2, 0, dSEValueTimeStamp, string, null);
            }
            catch (Throwable throwable) {
                CommandProcessor.addStatus(element2, 3, dSEValueTimeStamp, string, throwable.getMessage());
            }
        }
    }

    private class EventWatcher
    implements ValueEventHandler {
        private EventWatcher() {
        }

        public int handleEvent(int n, DSEValueInfo dSEValueInfo, int n2) {
            if (dSEValueInfo.getEntryID() != DirXMLAct.this.driverSetID) {
                return 0;
            }
            if (dSEValueInfo.getSyntax() != 13) {
                return 0;
            }
            DSEValueOctetList dSEValueOctetList = (DSEValueOctetList)dSEValueInfo.getValue();
            if ((n == 5 && dSEValueOctetList.getStrings().length == 1 || n == 6 && dSEValueOctetList.getStrings().length == 2) && dirXMLAct != null) {
                dirXMLAct.reInitCredentials();
            }
            return 0;
        }
    }

    public static class ActivationState {
        private int state;
        private Date expiration;

        ActivationState(int n, Date date) {
            this.state = n;
            this.expiration = date;
        }

        public int getState() {
            return this.state;
        }

        public Date getExpiration() {
            return this.expiration;
        }
    }
}

