/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.background;

import com.novell.nds.dirxml.engine.background.Task;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class Scheduler {
    private static final long MAX_WINDOW = 250L;
    private static final long MAX_THREADS = 4L;
    private static Object gate = new Object();
    private static Map tasks = null;
    private static Timer timer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(Task task, int n) {
        Object object = gate;
        synchronized (object) {
            if (timer == null) {
                timer = new Timer();
            }
            if (tasks == null) {
                tasks = new HashMap();
            }
            TaskWrapper taskWrapper = new TaskWrapper(task, n);
            tasks.put(task, taskWrapper);
            timer.schedule((TimerTask)taskWrapper, 0L, (long)(n * 1000));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancel(Task task) {
        TimerTask timerTask = null;
        Object object = gate;
        synchronized (object) {
            if (tasks != null) {
                timerTask = (TaskWrapper)tasks.remove(task);
                if (tasks.size() == 0) {
                    timer = null;
                }
            }
            if (timerTask != null) {
                timerTask.cancel();
            }
        }
    }

    private static class TaskWrapper
    extends TimerTask {
        private Task task;
        private long period;
        private long lastTime;

        TaskWrapper(Task task, int n) {
            this.task = task;
            this.period = (long)n * 1000L;
            this.lastTime = 0L;
        }

        int getPeriod() {
            return (int)(this.period / 1000L);
        }

        public void run() {
            long l = new Date().getTime();
            if (this.lastTime == 0L || l - this.lastTime > this.period + 250L) {
                // empty if block
            }
            this.task.run();
            this.lastTime = l;
        }
    }
}

