/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.cache;

import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.cache.AbortedIOException;
import com.novell.nds.dirxml.engine.cache.CheckAbort;
import com.novell.nds.dirxml.engine.cache.DSErrIOException;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CacheInputStream
extends InputStream {
    protected static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.cache.CacheInputStream");
    protected static final String WAITING_FOR_LOCKED_CACHE = "cst_cchlck";
    protected static final String WAITING_TO_PURGE_CACHE = "cst_cchprg";
    private static final String CACHE_FILE_EXTENSION = ".TAO";
    private static final long RETRY_MESSAGE_INTERVAL = 5000L;
    private long entryID;
    private byte[] currentBlock = null;
    private int currentOffset = 0;
    private long aggregateCount = 0L;
    private List blockList = null;
    private Mark mark = null;
    private CheckAbort checkAbortCallback = null;
    private EngineTrace tracer = null;

    public CacheInputStream(long l) {
        this.entryID = l;
    }

    public void setCheckAbort(CheckAbort checkAbort) {
        this.checkAbortCallback = checkAbort;
    }

    public void setTracer(EngineTrace engineTrace) {
        this.tracer = engineTrace;
    }

    public int read() throws IOException {
        if (this.ensureBytes(1) > 0) {
            ++this.aggregateCount;
            return this.currentBlock[this.currentOffset++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.ensureBytes(n2);
        if (n3 <= 0) {
            return -1;
        }
        n2 = n2 < n3 ? n2 : n3;
        System.arraycopy(this.currentBlock, this.currentOffset, byArray, n, n2);
        this.currentOffset += n2;
        this.aggregateCount += (long)n2;
        return n2;
    }

    public long skip(long l) throws IOException {
        int n;
        int n2;
        int n3;
        if (l < 0L) {
            return 0L;
        }
        long l2 = this.aggregateCount;
        int n4 = (int)(l / Integer.MAX_VALUE);
        int n5 = (int)(l % Integer.MAX_VALUE);
        int n6 = 0;
        while (n6 < n4) {
            n3 = Integer.MAX_VALUE;
            while (n3 > 0 && (n2 = this.ensureBytes(n3)) > 0) {
                if (this.checkAbort()) {
                    throw new AbortedIOException("aborted skipping " + l + " bytes");
                }
                n = n2 < n3 ? n2 : n3;
                this.aggregateCount += (long)n;
                this.currentOffset += n;
                n3 -= n;
            }
            ++n6;
        }
        n3 = n5;
        while (n3 > 0 && (n2 = this.ensureBytes(n3)) > 0) {
            if (this.checkAbort()) {
                throw new AbortedIOException("aborted skipping " + l + " bytes");
            }
            n = n2 < n3 ? n2 : n3;
            this.aggregateCount += (long)n;
            this.currentOffset += n;
            n3 -= n;
        }
        return this.aggregateCount - l2;
    }

    public long position() {
        return this.aggregateCount;
    }

    public int available() throws IOException {
        int n = 0;
        if (this.currentBlock != null) {
            n = this.currentBlock.length - this.currentOffset;
            if (this.blockList != null && !this.blockList.isEmpty()) {
                Iterator iterator = this.blockList.iterator();
                while (iterator.hasNext()) {
                    n += ((byte[])iterator.next()).length;
                }
            }
        }
        return n;
    }

    public boolean isDataAvailable() throws IOException {
        if (this.available() > 0) {
            return true;
        }
        return this.ensureBytes(1) > 0;
    }

    public void commit() throws IOException {
        block4: {
            if (this.mark != null) {
                throw new IOException("CacheInputStream.commit(): must not be called with an active mark");
            }
            if (this.currentBlock != null) {
                try {
                    this.purgeWithRetry();
                }
                catch (DSErr dSErr) {
                    if (dSErr.getCode() == -734) break block4;
                    throw new DSErrIOException(dSErr, "Purge of cache " + this.getCacheName() + " failed");
                }
            }
        }
    }

    public void close() throws IOException {
        this.commit();
        this.abort();
    }

    public void abort() throws IOException {
        this.currentBlock = null;
        this.currentOffset = 0;
        this.aggregateCount = 0L;
        if (this.blockList != null) {
            this.blockList.clear();
            this.blockList = null;
        }
        this.mark = null;
    }

    public void mark(int n) {
        if (this.blockList != null) {
            this.blockList.clear();
        }
        this.mark = new Mark(n, this.currentOffset, this.aggregateCount);
    }

    public void reset() throws IOException {
        if (this.mark == null) {
            throw new IOException("CacheInputStream: no mark has been set");
        }
        this.currentOffset = this.mark.getStartingOffset();
        this.aggregateCount = this.mark.getStartingCount();
        if (this.blockList != null && !this.blockList.isEmpty()) {
            this.currentBlock = (byte[])this.blockList.remove(0);
        }
        this.mark = null;
    }

    public boolean markSupported() {
        return true;
    }

    private boolean checkAbort() {
        return this.checkAbortCallback == null ? false : this.checkAbortCallback.abort();
    }

    private int ensureBytes(int n) throws IOException {
        int n2;
        block6: {
            int n3 = n2 = this.currentBlock == null ? 0 : this.currentBlock.length - this.currentOffset;
            if (n2 <= 0) {
                try {
                    byte[] byArray = this.mark == null && this.blockList != null && !this.blockList.isEmpty() ? (byte[])this.blockList.remove(0) : this.readWithRetry();
                    if (byArray != null) {
                        n2 = byArray.length;
                        if (this.mark != null && this.currentBlock != null) {
                            if (this.blockList == null) {
                                this.blockList = new LinkedList();
                            }
                            this.blockList.add(this.currentBlock);
                        }
                        this.currentBlock = byArray;
                        this.currentOffset = 0;
                        n2 = this.currentBlock.length;
                    }
                }
                catch (DSErr dSErr) {
                    if (dSErr.getCode() == -734) break block6;
                    throw new DSErrIOException(dSErr, "Read of cache " + this.getCacheName() + " failed");
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readWithRetry() throws IOException, DSErr {
        long l;
        long l2 = l = new Date().getTime();
        while (true) {
            try {
                return CacheInputStream.readCacheBlock(this.entryID, this.aggregateCount);
            }
            catch (DSErr dSErr) {
                if (dSErr.getCode() != -162) {
                    throw dSErr;
                }
                long l3 = new Date().getTime();
                if (l3 - l2 < 5000L) continue;
                if (this.tracer != null && this.tracer.getLevel() > 0) {
                    Object var9_5;
                    this.tracer.pushColor(14);
                    try {
                        this.tracer.trace(WAITING_FOR_LOCKED_CACHE, (MessageSource)messageSource, new Integer(this.getElapsedTime(l3, l)));
                        var9_5 = null;
                        this.tracer.popColor();
                    }
                    catch (Throwable throwable) {
                        var9_5 = null;
                        this.tracer.popColor();
                        throw throwable;
                    }
                }
                l2 = l3;
                if (!this.checkAbort()) continue;
                throw new AbortedIOException("Aborted retrying read from locked cache (elapsed time " + this.getElapsedTime(l3, l) + " seconds.");
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeWithRetry() throws DSErr, IOException {
        long l;
        long l2 = l = new Date().getTime();
        while (true) {
            try {
                CacheInputStream.purgeCacheBlock(this.entryID, this.aggregateCount);
                this.aggregateCount = 0L;
                if (this.currentOffset >= this.currentBlock.length) {
                    this.currentBlock = null;
                    this.currentOffset = 0;
                    if (this.blockList != null && !this.blockList.isEmpty()) {
                        this.currentBlock = (byte[])this.blockList.remove(0);
                    }
                }
                return;
            }
            catch (DSErr dSErr) {
                if (dSErr.getCode() != -162) {
                    throw dSErr;
                }
                long l3 = new Date().getTime();
                if (l3 - l2 < 5000L) continue;
                if (this.tracer != null && this.tracer.getLevel() > 0) {
                    Object var9_5;
                    this.tracer.pushColor(14);
                    try {
                        this.tracer.trace(WAITING_TO_PURGE_CACHE, (MessageSource)messageSource, new Integer(this.getElapsedTime(l3, l)));
                        var9_5 = null;
                        this.tracer.popColor();
                    }
                    catch (Throwable throwable) {
                        var9_5 = null;
                        this.tracer.popColor();
                        throw throwable;
                    }
                }
                l2 = l3;
                if (!this.checkAbort()) continue;
                throw new AbortedIOException("Aborted retrying purge from locked cache. elapsed time " + this.getElapsedTime(l3, l) + "seconds.");
            }
            break;
        }
    }

    private int getElapsedTime(long l, long l2) {
        return (int)((l - l2) / 1000L);
    }

    private String getCacheName() {
        return Long.toString(this.entryID) + CACHE_FILE_EXTENSION;
    }

    private static native byte[] readCacheBlock(long var0, long var2) throws DSErr;

    private static native void purgeCacheBlock(long var0, long var2) throws DSErr;

    private static class Mark {
        private int readLimit;
        private int startingOffset;
        private long startingCount;

        Mark(int n, int n2, long l) {
            this.readLimit = n;
            this.startingOffset = n2;
            this.startingCount = l;
        }

        int getReadLimit() {
            return this.readLimit;
        }

        int getStartingOffset() {
            return this.startingOffset;
        }

        long getStartingCount() {
            return this.startingCount;
        }
    }
}

