/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.classloader;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.StringTokenizer;

public class DriverClassLoader
extends URLClassLoader
implements FilenameFilter {
    private HashSet urls = new HashSet();
    private byte[] sigBuffer = new byte[4];
    private static byte[] HAHA_SIG = new byte[]{-114, -28, -74, -6};
    private File baseDir = this.getBaseDir();

    public DriverClassLoader() {
        super(new URL[0], ClassLoader.getSystemClassLoader());
        String string = System.getProperty("java.class.path");
        String string2 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                File file = new File(stringTokenizer.nextToken());
                String string3 = file.getCanonicalPath();
                URL uRL = new URL("file", "", string3);
                if (this.accept(file, string3) && this.useHaha(uRL)) {
                    uRL = new URL("vnd.nds.haha", "", string3);
                    this.addURL(uRL);
                }
                this.urls.add(uRL);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.refresh();
    }

    public synchronized void refresh() {
        String[] stringArray = this.baseDir.list(this);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                try {
                    String string = new File(this.baseDir, stringArray[n]).getCanonicalPath();
                    URL uRL = new URL("file", "", string);
                    if (this.useHaha(uRL)) {
                        uRL = new URL("vnd.nds.haha", "", string);
                    }
                    if (!this.urls.contains(uRL)) {
                        this.addURL(uRL);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++n;
            }
        }
    }

    public void setAsCurrentThreadContextClassLoader() {
        Thread.currentThread().setContextClassLoader(this);
    }

    public boolean accept(File file, String string) {
        String string2 = string.toLowerCase();
        return string2.endsWith(".jar") || string2.endsWith(".zip");
    }

    protected File getBaseDir() {
        block12: {
            try {
                int n;
                URL uRL = this.getClass().getResource("DriverClassLoader.class");
                if (uRL == null) break block12;
                String string = uRL.getFile();
                if (string.indexOf("file:") == 0) {
                    string = string.substring(0, string.indexOf(33));
                    string = string.substring(string.indexOf("file:") + 5);
                    return new File(new File(string).getParent());
                }
                int n2 = string.indexOf("ZIP");
                if (n2 != -1) {
                    string = string.substring(n2 + 3);
                } else {
                    n2 = string.indexOf("FILE");
                    if (n2 != -1) {
                        string = string.substring(n2 + 4);
                    } else {
                        return null;
                    }
                }
                int n3 = string.indexOf(47);
                if (n3 == -1) {
                    return null;
                }
                String string2 = string.substring(0, n3);
                try {
                    n = Integer.decode(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                String string3 = System.getProperty("java.class.path");
                String string4 = System.getProperty("path.separator");
                StringTokenizer stringTokenizer = new StringTokenizer(string3, string4);
                while (stringTokenizer.hasMoreTokens()) {
                    if (n == 0) {
                        return new File(new File(stringTokenizer.nextToken()).getParent());
                    }
                    stringTokenizer.nextToken();
                    --n;
                }
            }
            catch (Throwable throwable) {
                String string = throwable.toString();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean useHaha(URL uRL) {
        try {
            boolean bl;
            InputStream inputStream;
            block9: {
                boolean bl2;
                block10: {
                    boolean bl3;
                    block8: {
                        inputStream = uRL.openStream();
                        try {
                            if (inputStream.read(this.sigBuffer) != this.sigBuffer.length) {
                                bl3 = false;
                                Object var6_6 = null;
                                break block8;
                            }
                            int n = 0;
                            while (true) {
                                if (n >= HAHA_SIG.length) {
                                    bl = true;
                                    break block9;
                                }
                                if (this.sigBuffer[n] != HAHA_SIG[n]) {
                                    bl2 = false;
                                    break block10;
                                }
                                ++n;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var6_9 = null;
                            inputStream.close();
                            throw throwable;
                        }
                    }
                    inputStream.close();
                    return bl3;
                }
                Object var6_7 = null;
                inputStream.close();
                return bl2;
            }
            Object var6_8 = null;
            inputStream.close();
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

