/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.command;

import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.command.CommandHandler;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.nds.events.values.DSEValueTimeStamp;
import com.novell.xml.dom.DOMWriter;
import com.novell.xml.dom.DocumentFactory;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.parser.XMLParserFactory;
import com.novell.xml.xpath.XPathUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CommandProcessor {
    public static final String TAG_DIRXML_COMMAND = "dirxml-command";
    public static final String TAG_DIRXML_RESPONSE = "dirxml-response";
    public static final String ATTR_COMMAND_ID = "command-id";
    private static final String VAL_UTF8 = "UTF-8";
    protected static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.command.CommandProcessor");
    protected static final String PROCESSING_COMMAND_ELEMENT = "cpt_prcmde";
    protected static final String NO_DETAIL_PROVIDED = "cpt_prnod";
    protected static final String PROCESSING_SUCCESS = "cpt_prnsuc";
    protected static final String PROCESSING_WARNING = "cpt_prnsuc";
    protected static final String PROCESSING_ERROR = "cpt_prnsuc";
    protected static final String UNKNOWN_CMD_ID = "cpt_unkn";
    protected static final String MSG_BAD_DOCUMENT = "cpr_invdoc";
    protected static final String MSG_INVALID_COMMAND = "cpr_invel";
    private Map handlers = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(CommandHandler commandHandler) {
        Map map = this.handlers;
        synchronized (map) {
            this.handlers.put(commandHandler.getCommandName(), commandHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(CommandHandler commandHandler) {
        Map map = this.handlers;
        synchronized (map) {
            this.handlers.remove(commandHandler.getCommandName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] processCommand(byte[] byArray, DSEValueTimeStamp dSEValueTimeStamp) {
        Element element;
        Object object;
        Element element2 = this.constructResponse();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        XMLParser xMLParser = XMLParserFactory.newParser();
        Document document = xMLParser.parse((InputStream)byteArrayInputStream);
        if (xMLParser.anyErrors()) {
            CommandProcessor.addStatus(element2, 3, dSEValueTimeStamp, null, messageSource.getMessageString(MSG_BAD_DOCUMENT));
        } else {
            object = document.getFirstChild();
            while (object != null) {
                if (object.getNodeType() == 1 && object.getNodeName().equals(TAG_DIRXML_COMMAND)) break;
                object = object.getNextSibling();
            }
            if (object != null) {
                object = object.getFirstChild();
                while (object != null) {
                    if (object.getNodeType() == 1) {
                        CommandHandler commandHandler;
                        element = (Element)object;
                        String string = element.getAttribute(ATTR_COMMAND_ID);
                        if (string.length() <= 0) {
                            string = messageSource.getMessageString(UNKNOWN_CMD_ID);
                        }
                        Map map = this.handlers;
                        synchronized (map) {
                            commandHandler = (CommandHandler)this.handlers.get(object.getNodeName());
                        }
                        if (commandHandler != null) {
                            EngineTrace.staticTracer.trace(PROCESSING_COMMAND_ELEMENT, (MessageSource)messageSource, object.getNodeName(), (Object)string);
                            commandHandler.handleCommand(element, string, element2, dSEValueTimeStamp);
                        } else {
                            CommandProcessor.addStatus(element2, 3, dSEValueTimeStamp, string, messageSource.getMessageString(MSG_INVALID_COMMAND));
                        }
                    }
                    object = object.getNextSibling();
                }
            }
        }
        this.traceResponse(element2);
        object = new ByteArrayOutputStream(1024);
        try {
            element = new DOMWriter((Node)element2.getOwnerDocument(), (OutputStream)object, VAL_UTF8);
            element.write();
            element.flush();
        }
        catch (Throwable throwable) {
            StatusLog.logError(9114, throwable);
        }
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    public static Element addStatus(Element element, int n, DSEValueTimeStamp dSEValueTimeStamp, String string, String string2) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(null, "status");
        element.appendChild(element2);
        element2.setAttributeNS(null, "level", NdsDtd.getLevelString(n));
        if (string != null) {
            element2.setAttributeNS(null, ATTR_COMMAND_ID, string);
        }
        String string3 = dSEValueTimeStamp != null ? Long.toString(dSEValueTimeStamp.getTime().getTime() / 1000L) + '#' + dSEValueTimeStamp.getEvent() : Long.toString(new Date().getTime() / 1000L) + "#0";
        element2.setAttributeNS(null, "timestamp", string3);
        if (string2 != null) {
            element2.appendChild(document.createTextNode(string2));
        }
        return element2;
    }

    public static String getDNDelims(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("qualified-dot")) {
                return "10..+=*\\";
            }
            if (string.equalsIgnoreCase("slash")) {
                return "00.\\+=*'";
            }
            if (string.equalsIgnoreCase("qualified-slash")) {
                return "10.\\+=*'";
            }
            if (string.equalsIgnoreCase("ldap")) {
                return "10,,+=*\\\r<>#;\"";
            }
        }
        return "00..+=*\\";
    }

    private Element constructResponse() {
        Document document = DocumentFactory.newDocument();
        Element element = document.createElementNS(null, TAG_DIRXML_RESPONSE);
        document.appendChild(element);
        return element;
    }

    private void traceResponse(Node node) {
        if (EngineTrace.staticTracer.getLevel() > 0) {
            Node node2 = node;
            while (node2 != null) {
                if (node2.getNodeType() == 1 && node2.getNodeName().equals("status")) {
                    Element element = (Element)node2;
                    int n = NdsDtd.getStatusLevel(element);
                    String string = XPathUtil.getNodeValue((Node)element);
                    if (n == 0) {
                        EngineTrace.staticTracer.pushColor(10);
                        EngineTrace.staticTracer.trace("cpt_prnsuc", (MessageSource)messageSource, string.length() == 0 ? messageSource.getMessageString(NO_DETAIL_PROVIDED) : string);
                        EngineTrace.staticTracer.popColor();
                    } else if (n == 2 || n == 1) {
                        EngineTrace.staticTracer.pushColor(14);
                        EngineTrace.staticTracer.trace("cpt_prnsuc", (MessageSource)messageSource, string.length() == 0 ? messageSource.getMessageString(NO_DETAIL_PROVIDED) : string);
                        EngineTrace.staticTracer.popColor();
                    } else {
                        EngineTrace.staticTracer.pushColor(12);
                        EngineTrace.staticTracer.trace("cpt_prnsuc", (MessageSource)messageSource, string.length() == 0 ? messageSource.getMessageString(NO_DETAIL_PROVIDED) : string);
                        EngineTrace.staticTracer.popColor();
                    }
                }
                this.traceResponse(node2.getFirstChild());
                node2 = node2.getNextSibling();
            }
        }
    }
}

