/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.cache.CorruptCacheException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DDSIndirect;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEAttributeValueFactory;
import com.novell.nds.dirxml.engine.event.DSEEventInfo;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.parser.XMLParserFactory;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import novell.jclient.JClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class CacheWalker {
    static IDResolver schemaResolver = null;
    static final int COLUMN1_WIDTH = 25;
    static final byte CACHE_VERSION = 3;
    static final byte[] SIGNATURE = new byte[]{-1, 68, 88, 3};
    static final int PREFIX_SIZE = 12;
    static final boolean[] END_TRANSACTIONS = new boolean[]{true, false, false, true, true, true, true, true, true, true, true};
    static final String[] LABELS = new String[]{"Record Size", "Type", "Version", "Timestamp", "Entry ID", "Class ID", "DN", "Class name", "Association", "Event ID", "Flags", "Old DN", "Attribute", "Value", "Resync start", "Offset"};
    static final int LABEL_RECORD_SIZE = 0;
    static final int LABEL_TYPE = 1;
    static final int LABEL_VERSION = 2;
    static final int LABEL_TIMESTAMP = 3;
    static final int LABEL_ENTRY_ID = 4;
    static final int LABEL_CLASS_ID = 5;
    static final int LABEL_DN = 6;
    static final int LABEL_CLASS_NAME = 7;
    static final int LABEL_ASSOC = 8;
    static final int LABEL_EVENT_ID = 9;
    static final int LABEL_FLAGS = 10;
    static final int LABEL_OLD_DN = 11;
    static final int LABEL_ATTRIBUTE = 12;
    static final int LABEL_VALUE = 13;
    static final int LABEL_RESYNC_START = 14;
    static final int LABEL_OFFSET = 15;
    static String[] labels = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) {
        Object object;
        boolean bl = false;
        String string = null;
        String string2 = null;
        boolean bl2 = true;
        int n = -1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase("-all")) {
                bl2 = false;
            } else if (stringArray[n2].equalsIgnoreCase("-offset")) {
                ++n2;
                try {
                    n = Integer.decode(stringArray[n2]);
                }
                catch (Throwable throwable) {
                    CacheWalker.usage();
                }
            } else if (stringArray[n2].startsWith("-")) {
                CacheWalker.usage();
            } else if (string == null) {
                string = stringArray[n2];
            } else if (string2 == null) {
                string2 = stringArray[n2];
            } else {
                CacheWalker.usage();
            }
            ++n2;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        RandomAccessInputStream randomAccessInputStream = new RandomAccessInputStream(randomAccessFile);
        File file = null;
        if (string2 == null) {
            object = new File(string);
            String string3 = ((File)object).getAbsolutePath();
            int n3 = string3.lastIndexOf(File.separatorChar);
            String string4 = n3 != -1 ? string3.substring(0, n3 + 1) + "dxschema.xml" : "dxschema.xml";
            file = new File(string4);
            if (!file.exists()) {
                file = null;
            }
        } else {
            file = new File(string2);
        }
        schemaResolver = new IDResolver(file);
        DDSIndirect.setResolver(schemaResolver);
        System.out.println("Cache file:         " + new File(string).getAbsolutePath());
        System.out.println("Schema ID map file: " + (file == null ? "none" : file.getAbsolutePath()));
        if (n != -1) {
            System.out.println("Skipping signature check; starting at offset " + CacheWalker.displayInt(n));
            randomAccessInputStream.skip(n);
        } else {
            object = new byte[4];
            if (randomAccessInputStream.read((byte[])object) != 4) {
                throw new CorruptCacheException("No signature");
            }
            if (!Arrays.equals((byte[])object, SIGNATURE)) {
                throw new CorruptCacheException("Signature is incorrect");
            }
            int n4 = CacheWalker.read_uint32(randomAccessInputStream) + 12;
            int n5 = CacheWalker.read_uint32(randomAccessInputStream) + 12;
            if ((long)n4 > randomAccessFile.length()) {
                throw new CorruptCacheException("Offset to start of valid data is beyond the end-of-file");
            }
            if (n5 < n4) {
                throw new CorruptCacheException("Offset to end of valid data is before offset to start of valid data");
            }
            if ((long)n5 > randomAccessFile.length()) {
                throw new CorruptCacheException("Offset to end of valid data is beyond the end-of-file");
            }
            if ((long)n5 < randomAccessFile.length()) {
                System.out.println("Warning: Offset to end of valid data is not at end of file");
            }
            if (bl2 && n4 > 12) {
                System.out.println("Skipping " + CacheWalker.displayInt(n4) + " bytes of purged records");
                randomAccessInputStream.skip(n4 - 12);
            }
        }
        System.out.println("================================================================================\n");
        object = System.out;
        System.setOut(new PrintStream(new NullOutputStream()));
        JClient.initialize();
        bl = true;
        System.setOut((PrintStream)object);
        int n6 = -1;
        try {
            do {
                n6 = (int)randomAccessInputStream.getOffset();
                DxEventInputStream dxEventInputStream = new DxEventInputStream(randomAccessInputStream);
                CacheRecord cacheRecord = CacheRecord.construct(dxEventInputStream);
                System.out.println(CacheWalker.displayLabel(15) + CacheWalker.displayInt(n6));
                cacheRecord.dump();
                if (cacheRecord.isEndTransaction()) {
                    System.out.println("================================================================================");
                    System.out.println("=                            End of Transaction                                =");
                    System.out.println("================================================================================\n");
                    continue;
                }
                System.out.println("--------------------------------------------------------------------------------");
            } while (randomAccessInputStream.available() > 0);
        }
        catch (CorruptCacheException corruptCacheException) {
            System.err.println("Data is corrupt for event record starting at offset " + CacheWalker.displayInt(n6));
            corruptCacheException.printStackTrace();
        }
        Object var15_22 = null;
        if (!bl) return;
        try {
            JClient.cleanup();
            return;
        }
        catch (Throwable throwable) {}
        return;
        {
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Object var15_23 = null;
                if (!bl) return;
                try {
                    JClient.cleanup();
                    return;
                }
                catch (Throwable throwable2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var15_24 = null;
            if (!bl) throw throwable;
            try {
                JClient.cleanup();
                throw throwable;
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static int read_uint32(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        if (inputStream.read(byArray) < 4) {
            throw new EOFException();
        }
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    private static void usage() {
        System.err.println("Usage: java com.novell.nds.dirxml.engine.event.CacheWalker [-all] [-offset n] <input_file> [schema_map]");
        System.err.println("    -all         show all events (including those already processed)");
        System.err.println("    -offset n    Skip n bytes before beginning to interpret data as cache records");
        System.err.println("    input_file   name of the file containing the input cache file");
        System.err.println("    schema_map   name of the file containing the XML schema map (default=dxschema.xml)");
        System.exit(0);
    }

    static String displayLabel(int n) {
        if (labels == null) {
            labels = new String[LABELS.length];
            int n2 = -1;
            int n3 = 0;
            while (n3 < LABELS.length) {
                if (LABELS[n3].length() > n2) {
                    n2 = LABELS[n3].length();
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < LABELS.length) {
                CacheWalker.labels[n4] = CacheWalker.rightAlign(LABELS[n4] + ": ", n2 + 2);
                ++n4;
            }
        }
        return labels[n];
    }

    static String rightAlign(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(16);
        int n2 = n - string.length();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(' ');
            ++n3;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    static String displayInt(int n) {
        String string = CacheWalker.rightAlign("  (0x" + Integer.toHexString(n) + ")", 14);
        return CacheWalker.rightAlign(Integer.toString(n, 10), 10) + string;
    }

    static String displayTimestamp(long l) {
        String string = Long.toString(l >>> 16) + '#' + Integer.toString((int)l & 0xFFFF);
        if (l != 0L) {
            string = string + " " + new Date(l >>> 16000).toString();
        }
        return string;
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int n) throws IOException {
        }
    }

    static class RandomAccessInputStream
    extends InputStream {
        RandomAccessFile file;
        long markPos = -1L;

        RandomAccessInputStream(RandomAccessFile randomAccessFile) {
            this.file = randomAccessFile;
        }

        public int available() throws IOException {
            return (int)(this.file.length() - this.file.getFilePointer());
        }

        public void close() throws IOException {
            this.file.close();
        }

        public void mark(int n) {
            try {
                this.markPos = this.file.getFilePointer();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void reset() throws IOException {
            if (this.markPos == -1L) {
                throw new IOException("mark not set");
            }
            this.file.seek(this.markPos);
            this.markPos = -1L;
        }

        public boolean markSupported() {
            return true;
        }

        public int read() throws IOException {
            return this.file.read();
        }

        public int read(byte[] byArray) throws IOException {
            return this.file.read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.file.read(byArray, n, n2);
        }

        public long skip(long l) throws IOException {
            long l2 = this.file.getFilePointer();
            long l3 = this.file.length() - l2;
            l3 = l3 > l ? l : l3;
            this.file.seek(l2 + l3);
            return l3;
        }

        public long getOffset() throws IOException {
            return this.file.getFilePointer();
        }
    }

    static class RequestResyncRecord
    extends CacheRecord {
        int seconds;

        RequestResyncRecord(CacheRecord cacheRecord, DxEventInputStream dxEventInputStream) throws IOException {
            super(cacheRecord);
            this.seconds = dxEventInputStream.read_uint32();
        }

        void dump() {
            super.dump();
            System.out.println(CacheWalker.displayLabel(14) + new Date(this.seconds * 1000).toString());
        }
    }

    static class MigrateRecord
    extends CacheRecord {
        byte[] blob;

        MigrateRecord(CacheRecord cacheRecord, DxEventInputStream dxEventInputStream) throws IOException {
            super(cacheRecord);
            this.blob = dxEventInputStream.readOctets();
        }

        void dump() {
            super.dump();
        }
    }

    static class ValueRecord
    extends CacheRecord {
        DSEAttributeValue value;

        ValueRecord(CacheRecord cacheRecord, DxEventInputStream dxEventInputStream) throws IOException {
            super(cacheRecord);
            this.value = DSEAttributeValueFactory.createValue(dxEventInputStream);
        }

        void dump() {
            super.dump();
            if (this.value != null) {
                System.out.println(CacheWalker.displayLabel(12) + this.value.getAttrName());
                System.out.println(CacheWalker.displayLabel(13) + this.value.toString());
            }
        }
    }

    static class NewNameRecord
    extends EntryRecord {
        String oldDN;

        NewNameRecord(CacheRecord cacheRecord, DxEventInputStream dxEventInputStream) throws IOException {
            super(cacheRecord, dxEventInputStream);
            this.oldDN = dxEventInputStream.readString();
            if (dxEventInputStream.available() > 0) {
                this.flags = dxEventInputStream.read_uint8();
            }
        }

        void dump() {
            super.dump();
            if (this.oldDN != null) {
                System.out.println(CacheWalker.displayLabel(11) + this.oldDN);
            }
        }
    }

    static class EntryRecord
    extends CacheRecord {
        ObjectID objectID;
        String eventID;
        int flags = -1;

        EntryRecord(CacheRecord cacheRecord, DxEventInputStream dxEventInputStream) throws IOException {
            super(cacheRecord);
            if (this.type == 8) {
                this.eventID = dxEventInputStream.readString();
                this.objectID = new ObjectID(dxEventInputStream.readEntryID());
            } else {
                this.objectID = new ObjectID(dxEventInputStream);
                this.eventID = dxEventInputStream.readString();
            }
            if (this.type != 6 && this.type != 7 && dxEventInputStream.available() > 0) {
                this.flags = dxEventInputStream.read_uint8();
            }
        }

        void dump() {
            super.dump();
            if (this.eventID != null) {
                System.out.println(CacheWalker.displayLabel(9) + this.eventID);
            }
            if (this.objectID != null) {
                this.objectID.dump();
            }
            if (this.flags != -1) {
                System.out.println(CacheWalker.displayLabel(10) + CacheWalker.displayInt(this.flags));
            }
        }
    }

    static class IgnoreRecord
    extends CacheRecord {
        IgnoreRecord(CacheRecord cacheRecord, DxEventInputStream dxEventInputStream) throws IOException {
            super(cacheRecord);
        }
    }

    static class AssociationValue {
        String value;
        int state;

        AssociationValue(DxEventInputStream dxEventInputStream) throws IOException {
            this.state = dxEventInputStream.read_uint32();
            this.value = dxEventInputStream.readString();
        }

        void dump() {
            System.out.println(CacheWalker.displayLabel(8) + CacheWalker.displayInt(this.state) + " " + this.value);
        }
    }

    static class ObjectID {
        long entryID;
        long classID;
        String dn;
        String className;
        AssociationValue[] associations;

        ObjectID(DxEventInputStream dxEventInputStream) throws IOException {
            this.entryID = dxEventInputStream.readEntryID();
            this.classID = dxEventInputStream.readSchemaID();
            this.dn = dxEventInputStream.readString();
            try {
                this.className = schemaResolver.getLocalSchemaName(this.classID);
            }
            catch (DSErr dSErr) {
                this.className = dSErr.toString();
            }
            int n = dxEventInputStream.readUTF8Length();
            if (n > 0) {
                this.associations = new AssociationValue[n];
                int n2 = 0;
                while (n2 < n) {
                    this.associations[n2] = new AssociationValue(dxEventInputStream);
                    ++n2;
                }
            }
        }

        ObjectID(long l) {
            this.entryID = l;
            this.classID = -1L;
            this.dn = null;
            this.className = null;
            this.associations = null;
        }

        void dump() {
            System.out.println(CacheWalker.displayLabel(4) + CacheWalker.displayInt((int)this.entryID));
            System.out.println(CacheWalker.displayLabel(5) + CacheWalker.displayInt((int)this.classID));
            if (this.dn != null && this.dn.length() > 0) {
                System.out.println(CacheWalker.displayLabel(6) + this.dn);
            } else {
                System.out.println(CacheWalker.displayLabel(6) + "not known");
            }
            if (this.className != null) {
                System.out.println(CacheWalker.displayLabel(7) + this.className);
            }
            if (this.associations != null) {
                int n = 0;
                while (n < this.associations.length) {
                    this.associations[n].dump();
                    ++n;
                }
            }
        }
    }

    static class CacheRecord {
        int recordSize;
        byte[] magicMarker = new byte[DSEEventInfo.MAGIC_MARKER.length];
        int type;
        int version;
        long timestamp;

        private CacheRecord() {
        }

        protected CacheRecord(CacheRecord cacheRecord) {
            this.recordSize = cacheRecord.recordSize;
            System.arraycopy(cacheRecord.magicMarker, 0, this.magicMarker, 0, this.magicMarker.length);
            this.type = cacheRecord.type;
            this.version = cacheRecord.version;
            this.timestamp = cacheRecord.timestamp;
        }

        boolean isEndTransaction() {
            return END_TRANSACTIONS[this.type];
        }

        void dump() {
            System.out.println(CacheWalker.displayLabel(0) + CacheWalker.displayInt(this.recordSize));
            System.out.println(CacheWalker.displayLabel(1) + CacheWalker.displayInt(this.type) + " " + DSEEventInfo.TYPE_NAMES[this.type]);
            System.out.println(CacheWalker.displayLabel(2) + CacheWalker.displayInt(this.version));
            System.out.println(CacheWalker.displayLabel(3) + CacheWalker.displayTimestamp(this.timestamp));
        }

        static CacheRecord construct(DxEventInputStream dxEventInputStream) throws IOException {
            CacheRecord cacheRecord = new CacheRecord();
            dxEventInputStream.mark(Integer.MAX_VALUE);
            try {
                int n = cacheRecord.recordSize = dxEventInputStream.read_uint32();
                try {
                    dxEventInputStream.readAll(cacheRecord.magicMarker);
                }
                catch (EOFException eOFException) {
                    throw new CorruptCacheException("Magic marker not present");
                }
                if (!Arrays.equals(cacheRecord.magicMarker, DSEEventInfo.MAGIC_MARKER)) {
                    throw new CorruptCacheException("Magic marker is incorrect");
                }
                cacheRecord.type = dxEventInputStream.read_uint8();
                if (cacheRecord.type < 0 || cacheRecord.type > 10) {
                    throw new CorruptCacheException("Event type is incorrect.");
                }
                if (cacheRecord.type == 0) {
                    cacheRecord = new IgnoreRecord(cacheRecord, dxEventInputStream);
                } else {
                    if (cacheRecord.recordSize < 12 || cacheRecord.recordSize > 131072) {
                        throw new CorruptCacheException("Event size is incorrect.");
                    }
                    cacheRecord.version = dxEventInputStream.read_uint8();
                    if (cacheRecord.version > 1) {
                        throw new CorruptCacheException("Unknown event version");
                    }
                    cacheRecord.timestamp = ((long)dxEventInputStream.read_uint32() & 0xFFFFFFFFFFFFFFFFL) << 16 | (long)dxEventInputStream.read_uint16() & 0xFFFFL;
                    switch (cacheRecord.type) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 8: {
                            cacheRecord = new EntryRecord(cacheRecord, dxEventInputStream);
                            break;
                        }
                        case 6: 
                        case 7: {
                            cacheRecord = new NewNameRecord(cacheRecord, dxEventInputStream);
                            break;
                        }
                        case 1: 
                        case 2: {
                            cacheRecord = new ValueRecord(cacheRecord, dxEventInputStream);
                            break;
                        }
                        case 9: {
                            cacheRecord = new MigrateRecord(cacheRecord, dxEventInputStream);
                            break;
                        }
                        case 10: {
                            cacheRecord = new RequestResyncRecord(cacheRecord, dxEventInputStream);
                        }
                    }
                }
                dxEventInputStream.reset();
                dxEventInputStream.skip(n + 4);
                return cacheRecord;
            }
            catch (CorruptCacheException corruptCacheException) {
                dxEventInputStream.reset();
                throw corruptCacheException;
            }
            catch (IOException iOException) {
                dxEventInputStream.reset();
                CorruptCacheException corruptCacheException = new CorruptCacheException("");
                corruptCacheException.initCause(iOException);
                throw corruptCacheException;
            }
        }
    }

    static class IDResolver
    implements com.novell.nds.dirxml.engine.event.IDResolver {
        Map specialMap = new HashMap();
        Map idMap = new HashMap();

        IDResolver(File file) throws IOException {
            this.specialMap.put(new Long(-16777211L), "[Entry Rights]");
            this.specialMap.put(new Long(-16777209L), "[All Attributes Rights]");
            this.specialMap.put(new Long(-16777196L), "[Anything]");
            this.specialMap.put(new Long(-16777195L), "[Nothing]");
            if (file == null) {
                return;
            }
            XMLParser xMLParser = XMLParserFactory.newParser();
            Document document = xMLParser.parse(file);
            if (xMLParser.anyErrors()) {
                throw new IOException("Unable to parse " + file.getCanonicalPath() + ":\n" + xMLParser.getErrorMsgString());
            }
            try {
                Element element;
                NodeList nodeList = document.getElementsByTagName("class-def");
                int n = 0;
                while ((element = (Element)nodeList.item(n++)) != null) {
                    this.idMap.put(new Long(Long.parseLong(element.getAttribute("schema-id"))), element.getAttribute("name"));
                }
                nodeList = document.getElementsByTagName("attr-def");
                n = 0;
                while ((element = (Element)nodeList.item(n++)) != null) {
                    this.idMap.put(new Long(Long.parseLong(element.getAttribute("schema-id"))), element.getAttribute("name"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("NumberFormatException: Unable to parse attribute value in " + file.getCanonicalPath());
            }
        }

        public String getLocalSchemaName(long l) throws DSErr {
            return this.getLocalSchemaName(l, false);
        }

        public String getLocalSchemaName(long l, boolean bl) throws DSErr {
            String string;
            if (l == -1L) {
                return "Unknown";
            }
            Long l2 = new Long(l);
            if (bl && (string = (String)this.specialMap.get(l2)) != null) {
                return string;
            }
            string = (String)this.idMap.get(l2);
            if (string == null) {
                return CacheWalker.displayInt((int)l) + " (ID not found)";
            }
            return string;
        }

        public String getLocalEntryName(long l, int n) throws DSErr {
            throw new DSErr(-714);
        }
    }
}

