/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DDSIndirect;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEUtil;
import java.io.IOException;
import novell.jclient.JCClassnameValue;
import novell.jclient.JCValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public final class DSEClassName
extends JCClassnameValue
implements DSEAttributeValue {
    protected DSEClassName(String string) {
        this.attributeName = string;
        this.syntax = 20;
    }

    protected DSEClassName(DxEventInputStream dxEventInputStream, String string) throws IOException {
        String string2;
        this.attributeName = string;
        this.syntax = 20;
        long l = dxEventInputStream.readSchemaID();
        try {
            string2 = DDSIndirect.getLocalSchemaName(l);
        }
        catch (DSErr dSErr) {
            string2 = "Unknown";
            StatusLog.logWarning(8022, new Integer((int)l));
        }
        this.setClassname(string2);
    }

    public DSEClassName(JCClassnameValue jCClassnameValue) {
        super(jCClassnameValue.attributeName, jCClassnameValue.operation, jCClassnameValue.flags, jCClassnameValue.timestamp, jCClassnameValue.getClassname());
    }

    public String getAttrName() {
        return this.attributeName;
    }

    public void toXML(Element element) throws DOMException {
        DSEUtil.createValueElement(element, "string", this.getClassname());
    }

    public boolean equals(Element element) {
        try {
            return DSEUtil.validateString(element).equalsIgnoreCase(this.getClassname());
        }
        catch (VRDException vRDException) {
            return false;
        }
    }

    public void fromXML(Element element) throws DOMException, VRDException {
        this.setClassname(DSEUtil.validateString(element));
    }

    public void encrypt(byte[] byArray) throws VRDException {
        this.setClassname(DSEUtil.encrypt(this.getClassname(), byArray));
    }

    public void decrypt(byte[] byArray) throws VRDException {
        this.setClassname(DSEUtil.decrypt(this.getClassname(), byArray));
    }

    public int hashCode() {
        int n = 0;
        String string = this.getClassname();
        if (string != null) {
            n += string.toUpperCase().hashCode();
        }
        return n;
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean equals(DSEAttributeValue dSEAttributeValue) {
        return this.compareTo(dSEAttributeValue) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JCValue)) {
            return -1;
        }
        int n = this.syntax - ((JCValue)object).syntax;
        if (n != 0) {
            return n;
        }
        JCClassnameValue jCClassnameValue = (JCClassnameValue)object;
        return this.getClassname().compareTo(jCClassnameValue.getClassname());
    }
}

