/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEUtil;
import java.io.IOException;
import novell.jclient.JCEmailValue;
import novell.jclient.JCValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public final class DSEEMailAddress
extends JCEmailValue
implements DSEAttributeValue {
    private static final String[] strAllowed = new String[]{"eMailType", "eMailAddr"};

    protected DSEEMailAddress(String string) {
        this.attributeName = string;
        this.syntax = 14;
    }

    protected DSEEMailAddress(DxEventInputStream dxEventInputStream, String string) throws IOException {
        this.attributeName = string;
        this.syntax = 14;
        this.setType(dxEventInputStream.read_uint32());
        this.setAddress(dxEventInputStream.readString());
    }

    public DSEEMailAddress(JCEmailValue jCEmailValue) {
        super(jCEmailValue.attributeName, jCEmailValue.operation, jCEmailValue.flags, jCEmailValue.timestamp, jCEmailValue.getAddress(), jCEmailValue.getType());
    }

    public String getAttrName() {
        return this.attributeName;
    }

    public void toXML(Element element) throws DOMException {
        String[] stringArray = new String[]{"eMailType", "eMailAddr"};
        String[] stringArray2 = new String[]{Integer.toString(this.getType()), this.getAddress()};
        DSEUtil.createAggregateValueElement(element, stringArray, stringArray2);
    }

    public boolean equals(Element element) {
        try {
            String[] stringArray = new String[2];
            int[] nArray = new int[2];
            try {
                DSEUtil.validate2(element, strAllowed, nArray, stringArray);
            }
            catch (VRDException vRDException) {
                return this.getType() == 3 && this.getAddress().equals(DSEUtil.validateString(element));
            }
            return Integer.valueOf(stringArray[nArray[0]]).intValue() == this.getType() && stringArray[nArray[1]].equals(this.getAddress());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void fromXML(Element element) throws DOMException, VRDException {
        try {
            String[] stringArray = new String[2];
            int[] nArray = new int[2];
            try {
                DSEUtil.validate2(element, strAllowed, nArray, stringArray);
                this.setType(Integer.valueOf(stringArray[nArray[0]]));
                this.setAddress(stringArray[nArray[1]]);
            }
            catch (VRDException vRDException) {
                try {
                    this.setAddress(DSEUtil.validateString(element));
                    this.setType(3);
                }
                catch (VRDException vRDException2) {
                    throw vRDException;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new VRDException(numberFormatException);
        }
    }

    public void encrypt(byte[] byArray) throws VRDException {
        this.setAddress(DSEUtil.encrypt(this.getAddress(), byArray));
    }

    public void decrypt(byte[] byArray) throws VRDException {
        this.setAddress(DSEUtil.decrypt(this.getAddress(), byArray));
    }

    public int hashCode() {
        int n = 0;
        String string = this.getAddress();
        if (string != null) {
            n += string.toUpperCase().hashCode();
        }
        return n += this.getType();
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean equals(DSEAttributeValue dSEAttributeValue) {
        return this.compareTo(dSEAttributeValue) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JCValue)) {
            return -1;
        }
        int n = this.syntax - ((JCValue)object).syntax;
        if (n != 0) {
            return n;
        }
        JCEmailValue jCEmailValue = (JCEmailValue)object;
        n = this.getAddress().compareTo(jCEmailValue.getAddress());
        if (n == 0) {
            n = this.getType() - jCEmailValue.getType();
        }
        return n;
    }
}

