/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.nds.dhutil.DDSServ;
import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.engine.Association;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.Entry;
import com.novell.nds.dirxml.engine.NdsConstants;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.cache.CorruptCacheException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DDSIndirect;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEAttributeValueFactory;
import com.novell.nds.dirxml.util.XdsDN;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import novell.jclient.JCCIstringValue;
import novell.jclient.JCContext;
import novell.jclient.JCEntryInfo;
import novell.jclient.JCException;
import novell.jclient.JCPathValue;
import novell.jclient.JCTimestamp;
import novell.jclient.JCValue;
import novell.jclient.JClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public final class DSEEventInfo {
    public static final byte DXEVENT_VERSION = 1;
    public static final int EVENT_MIN_SIZE = 12;
    public static final int EVENT_MAX_SIZE = 131072;
    public static final byte[] MAGIC_MARKER = new byte[]{97, 90, 98, 89};
    public static final String BAD_SCHEMA_NAME = "Unknown";
    public static final int DXET_MIN_VALUE = 0;
    public static final int DXET_IGNORE = 0;
    public static final int DXET_ADD_VALUE = 1;
    public static final int DXET_REMOVE_VALUE = 2;
    public static final int DXET_ADD_ENTRY = 3;
    public static final int DXET_MODIFY_ENTRY = 4;
    public static final int DXET_REMOVE_ENTRY = 5;
    public static final int DXET_MOVE_SRC_ENTRY = 6;
    public static final int DXET_RENAME_ENTRY = 7;
    public static final int DXET_RESYNC_ENTRY = 8;
    public static final int DXET_MIGRATE_APP = 9;
    public static final int DXET_REQUEST_RESYNC = 10;
    public static final int DXET_MAX_VALUE = 10;
    public static final byte DXFLAG_SPECIAL_MOVE_HANDLING = 1;
    public static final String[] TYPE_NAMES = new String[]{"ignore", "add-value", "remove-value", "add-entry", "modify-entry", "remove-entry", "move-entry", "rename-entry", "resync-entry", "migrate-app", "request-resync"};
    protected int iType = 0;
    protected long timestamp = 0L;
    protected ObjectID objectID = null;
    protected String eventID = null;
    protected DSEAttributeValue attrVal = null;
    protected String oldDN = null;
    protected int seconds = 0;
    protected byte[] blob = null;
    protected byte flags = 0;
    protected JCContext context = null;
    protected String driverDN = null;
    protected DSEEventInfo endTransaction = null;
    protected boolean doRaw = false;

    protected DSEEventInfo(DxEventInputStream dxEventInputStream, int n) throws IOException {
        byte[] byArray = new byte[MAGIC_MARKER.length];
        try {
            dxEventInputStream.readAll(byArray);
        }
        catch (EOFException eOFException) {
            throw new CorruptCacheException("Magic marker not present");
        }
        if (!Arrays.equals(byArray, MAGIC_MARKER)) {
            throw new CorruptCacheException("Magic marker is incorrect");
        }
        this.iType = dxEventInputStream.read_uint8();
        if (this.iType < 0 || this.iType > 10) {
            throw new CorruptCacheException("Event type is incorrect.");
        }
        if (this.iType == 0) {
            return;
        }
        if (n < 12 || n > 131072) {
            throw new CorruptCacheException("Event size is incorrect.");
        }
        byte by = dxEventInputStream.read_uint8();
        if (by != 1) {
            throw new CorruptCacheException("Event version is incorrect.");
        }
        this.timestamp = ((long)dxEventInputStream.read_uint32() & 0xFFFFFFFFFFFFFFFFL) << 16 | (long)dxEventInputStream.read_uint16() & 0xFFFFL;
        switch (this.iType) {
            case 3: 
            case 4: 
            case 5: {
                this.objectID = new ObjectID(dxEventInputStream);
                this.eventID = dxEventInputStream.readString();
                if (dxEventInputStream.available() <= 0) break;
                this.flags = dxEventInputStream.read_uint8();
                break;
            }
            case 6: 
            case 7: {
                this.objectID = new ObjectID(dxEventInputStream);
                this.eventID = dxEventInputStream.readString();
                this.oldDN = dxEventInputStream.readString();
                if (dxEventInputStream.available() <= 0) break;
                this.flags = dxEventInputStream.read_uint8();
                break;
            }
            case 1: 
            case 2: {
                this.attrVal = DSEAttributeValueFactory.createValue(dxEventInputStream);
                break;
            }
            case 8: {
                this.eventID = dxEventInputStream.readString();
                this.objectID = new ObjectID(dxEventInputStream.readEntryID());
                if (dxEventInputStream.available() <= 0) break;
                this.flags = dxEventInputStream.read_uint8();
                break;
            }
            case 9: {
                this.blob = dxEventInputStream.readOctets();
                break;
            }
            case 10: {
                this.seconds = dxEventInputStream.read_uint32();
            }
        }
    }

    protected DSEEventInfo() {
    }

    public static DSEEventInfo construct(DxEventInputStream dxEventInputStream) throws IOException {
        dxEventInputStream.mark(Integer.MAX_VALUE);
        try {
            int n = dxEventInputStream.read_uint32();
            DSEEventInfo dSEEventInfo = new DSEEventInfo(dxEventInputStream, n);
            dxEventInputStream.reset();
            dxEventInputStream.skip(4 + n);
            return dSEEventInfo;
        }
        catch (CorruptCacheException corruptCacheException) {
            dxEventInputStream.reset();
            throw corruptCacheException;
        }
        catch (IOException iOException) {
            dxEventInputStream.reset();
            throw new CorruptCacheException(iOException.getMessage());
        }
    }

    public static DSEEventInfo constructResyncEntry(long l, String string) {
        DSEEventInfo dSEEventInfo = new DSEEventInfo();
        dSEEventInfo.iType = 8;
        dSEEventInfo.objectID = new ObjectID(l);
        dSEEventInfo.eventID = string;
        dSEEventInfo.timestamp = new Date().getTime() / 1000L;
        dSEEventInfo.timestamp <<= 16;
        return dSEEventInfo;
    }

    public static DSEEventInfo constructModifyEntry(long l, String string, long l2) {
        DSEEventInfo dSEEventInfo = new DSEEventInfo();
        dSEEventInfo.iType = 4;
        dSEEventInfo.eventID = string;
        dSEEventInfo.timestamp = l2;
        if (l2 == 0L) {
            dSEEventInfo.timestamp = new Date().getTime() / 1000L;
            dSEEventInfo.timestamp <<= 16;
        }
        dSEEventInfo.objectID = new ObjectID(l);
        return dSEEventInfo;
    }

    public static DSEEventInfo constructMoveEntry(long l, String string, String string2) {
        DSEEventInfo dSEEventInfo = new DSEEventInfo();
        dSEEventInfo.iType = 6;
        dSEEventInfo.eventID = string2;
        dSEEventInfo.timestamp = new Date().getTime() / 1000L;
        dSEEventInfo.timestamp <<= 16;
        dSEEventInfo.objectID = new ObjectID(l);
        dSEEventInfo.oldDN = string;
        return dSEEventInfo;
    }

    public static byte[] constructIgnoreHeader(long l) {
        int n = 4 + MAGIC_MARKER.length + 1;
        byte[] byArray = new byte[n];
        byArray[0] = (byte)((l -= 4L) >> 24 & 0xFFL);
        byArray[1] = (byte)(l >> 16 & 0xFFL);
        byArray[2] = (byte)(l >> 8 & 0xFFL);
        byArray[3] = (byte)(l & 0xFFL);
        System.arraycopy(MAGIC_MARKER, 0, byArray, 4, MAGIC_MARKER.length);
        byArray[4 + DSEEventInfo.MAGIC_MARKER.length] = 0;
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidEventStart(DxEventInputStream dxEventInputStream) throws IOException {
        boolean bl;
        dxEventInputStream.mark(Integer.MAX_VALUE);
        try {
            try {
                int n = dxEventInputStream.read_uint32();
                byte[] byArray = new byte[MAGIC_MARKER.length];
                try {
                    dxEventInputStream.readAll(byArray);
                }
                catch (EOFException eOFException) {
                    throw new CorruptCacheException("Magic marker not present");
                }
                if (!Arrays.equals(byArray, MAGIC_MARKER)) {
                    throw new CorruptCacheException("Magic marker is incorrect");
                }
                byte by = dxEventInputStream.read_uint8();
                if (by < 0) throw new CorruptCacheException("Event type is incorrect.");
                if (by > 10) {
                    throw new CorruptCacheException("Event type is incorrect.");
                }
                if (by != 0) {
                    if (n < 12) throw new CorruptCacheException("Event size is incorrect.");
                    if (n > 131072) {
                        throw new CorruptCacheException("Event size is incorrect.");
                    }
                }
                bl = true;
                Object var6_10 = null;
            }
            catch (CorruptCacheException corruptCacheException) {
                boolean bl2 = false;
                Object var6_11 = null;
                dxEventInputStream.reset();
                return bl2;
            }
            catch (IOException iOException) {
                boolean bl3 = false;
                Object var6_12 = null;
                dxEventInputStream.reset();
                return bl3;
            }
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            dxEventInputStream.reset();
            throw throwable;
        }
        dxEventInputStream.reset();
        return bl;
    }

    public static void validate(DxEventInputStream dxEventInputStream) throws IOException {
        dxEventInputStream.mark(Integer.MAX_VALUE);
        try {
            int n = dxEventInputStream.read_uint32();
            new DSEEventInfo(dxEventInputStream, n);
            dxEventInputStream.reset();
        }
        catch (CorruptCacheException corruptCacheException) {
            dxEventInputStream.reset();
            throw corruptCacheException;
        }
        catch (IOException iOException) {
            dxEventInputStream.reset();
            throw new CorruptCacheException(iOException.getMessage());
        }
    }

    public int getType() {
        return this.iType;
    }

    public String getTimestampString() {
        return Long.toString(this.timestamp >>> 16) + '#' + Integer.toString((int)this.timestamp & 0xFFFF);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public DSEAttributeValue getAttrValue() {
        return this.attrVal;
    }

    public ObjectID getObjectID() {
        return this.objectID;
    }

    public String getEventID() {
        return this.eventID;
    }

    public String getOldDN() {
        return this.oldDN;
    }

    public byte[] getBlob() {
        return this.blob;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public byte getFlags() {
        return this.flags;
    }

    public Element[] toXML(JCContext jCContext, String string, EngineTrace engineTrace, Element[] elementArray, DSEEventInfo dSEEventInfo) throws VRDException {
        return this.toXML(jCContext, string, engineTrace, elementArray, dSEEventInfo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Element[] toXML(JCContext jCContext, String string, EngineTrace engineTrace, Element[] elementArray, DSEEventInfo dSEEventInfo, boolean bl) throws VRDException {
        Element[] elementArray2;
        block26: {
            Element[] elementArray3;
            block25: {
                Element[] elementArray4;
                block24: {
                    Element[] elementArray5;
                    block23: {
                        Element[] elementArray6;
                        block22: {
                            Element[] elementArray7;
                            block21: {
                                Element[] elementArray8;
                                block20: {
                                    Element[] elementArray9;
                                    block19: {
                                        Element[] elementArray10;
                                        block18: {
                                            Element[] elementArray11;
                                            block17: {
                                                this.context = jCContext;
                                                this.driverDN = string;
                                                this.endTransaction = dSEEventInfo;
                                                this.doRaw = bl;
                                                this.dump(engineTrace);
                                                try {
                                                    try {
                                                        switch (this.getType()) {
                                                            case 3: {
                                                                Element[] elementArray12 = this.constructAdd(elementArray);
                                                                Object var19_9 = null;
                                                                this.context = null;
                                                                this.driverDN = null;
                                                                this.endTransaction = null;
                                                                this.doRaw = false;
                                                                return elementArray12;
                                                            }
                                                            case 4: {
                                                                elementArray11 = this.constructModify(elementArray);
                                                                break block17;
                                                            }
                                                            case 5: {
                                                                elementArray10 = this.constructDelete(elementArray);
                                                                break block18;
                                                            }
                                                            case 6: {
                                                                elementArray9 = this.constructMove(elementArray);
                                                                break block19;
                                                            }
                                                            case 7: {
                                                                elementArray8 = this.constructRename(elementArray);
                                                                break block20;
                                                            }
                                                            case 1: {
                                                                elementArray7 = this.constructAddValue(elementArray);
                                                                break block21;
                                                            }
                                                            case 2: {
                                                                elementArray6 = this.constructRemoveValue(elementArray);
                                                                break block22;
                                                            }
                                                            case 8: {
                                                                elementArray5 = this.constructSync(elementArray);
                                                                break block23;
                                                            }
                                                            case 9: {
                                                                elementArray4 = this.constructMigrateQuery(elementArray);
                                                                break block24;
                                                            }
                                                            case 10: {
                                                                elementArray3 = this.constructRequestResync(elementArray);
                                                                break block25;
                                                            }
                                                            default: {
                                                                elementArray2 = null;
                                                                break;
                                                            }
                                                        }
                                                        break block26;
                                                    }
                                                    catch (VRDException vRDException) {
                                                        if (vRDException.getErrorCode() == 9154) throw vRDException;
                                                        StatusLog.log(vRDException);
                                                        Element[] elementArray13 = null;
                                                        Object var19_20 = null;
                                                        this.context = null;
                                                        this.driverDN = null;
                                                        this.endTransaction = null;
                                                        this.doRaw = false;
                                                        return elementArray13;
                                                    }
                                                    catch (Throwable throwable) {
                                                        StatusLog.log(throwable);
                                                        Element[] elementArray14 = null;
                                                        Object var19_21 = null;
                                                        this.context = null;
                                                        this.driverDN = null;
                                                        this.endTransaction = null;
                                                        this.doRaw = false;
                                                        return elementArray14;
                                                    }
                                                }
                                                catch (Throwable throwable) {
                                                    Object var19_22 = null;
                                                    this.context = null;
                                                    this.driverDN = null;
                                                    this.endTransaction = null;
                                                    this.doRaw = false;
                                                    throw throwable;
                                                }
                                            }
                                            Object var19_10 = null;
                                            this.context = null;
                                            this.driverDN = null;
                                            this.endTransaction = null;
                                            this.doRaw = false;
                                            return elementArray11;
                                        }
                                        Object var19_11 = null;
                                        this.context = null;
                                        this.driverDN = null;
                                        this.endTransaction = null;
                                        this.doRaw = false;
                                        return elementArray10;
                                    }
                                    Object var19_12 = null;
                                    this.context = null;
                                    this.driverDN = null;
                                    this.endTransaction = null;
                                    this.doRaw = false;
                                    return elementArray9;
                                }
                                Object var19_13 = null;
                                this.context = null;
                                this.driverDN = null;
                                this.endTransaction = null;
                                this.doRaw = false;
                                return elementArray8;
                            }
                            Object var19_14 = null;
                            this.context = null;
                            this.driverDN = null;
                            this.endTransaction = null;
                            this.doRaw = false;
                            return elementArray7;
                        }
                        Object var19_15 = null;
                        this.context = null;
                        this.driverDN = null;
                        this.endTransaction = null;
                        this.doRaw = false;
                        return elementArray6;
                    }
                    Object var19_16 = null;
                    this.context = null;
                    this.driverDN = null;
                    this.endTransaction = null;
                    this.doRaw = false;
                    return elementArray5;
                }
                Object var19_17 = null;
                this.context = null;
                this.driverDN = null;
                this.endTransaction = null;
                this.doRaw = false;
                return elementArray4;
            }
            Object var19_18 = null;
            this.context = null;
            this.driverDN = null;
            this.endTransaction = null;
            this.doRaw = false;
            return elementArray3;
        }
        Object var19_19 = null;
        this.context = null;
        this.driverDN = null;
        this.endTransaction = null;
        this.doRaw = false;
        return elementArray2;
    }

    private Element[] constructAdd(Element[] elementArray) throws VRDException {
        return this.constructEventOp(elementArray, "add");
    }

    private Element[] constructModify(Element[] elementArray) throws VRDException {
        return this.constructEventOp(elementArray, "modify");
    }

    private Element[] constructDelete(Element[] elementArray) throws VRDException {
        return this.constructEventOp(elementArray, "delete");
    }

    private Element[] constructMove(Element[] elementArray) throws VRDException {
        Element[] elementArray2;
        Element[] elementArray3 = null;
        Element[] elementArray4 = null;
        if (!this.doRaw) {
            String string;
            long l = this.timestamp;
            this.timestamp = 0L;
            elementArray3 = this.constructSync(elementArray);
            this.timestamp = l;
            if (elementArray3 != null && elementArray3.length == 1 && XdsUtil.getAssociationValue(elementArray3[0]).length() == 0) {
                return elementArray3;
            }
            String string2 = new XdsDN(this.getObjectID().getDN(), NdsConstants.QSLASH_DELIMS_ARRAY).getRDN(NdsConstants.QSLASH_DELIMS_ARRAY, 1);
            if (!string2.equals(string = new XdsDN(this.getOldDN(), NdsConstants.QSLASH_DELIMS_ARRAY).getRDN(NdsConstants.QSLASH_DELIMS_ARRAY, 1))) {
                elementArray4 = this.constructRename(elementArray);
            }
        }
        if ((elementArray2 = this.constructEventOp(elementArray, "move")) != null) {
            String[] stringArray = XdsUtil.getDNForms(this.getOldDN());
            int n = 0;
            while (n < elementArray2.length) {
                elementArray2[n].setAttributeNS(null, "old-src-dn", stringArray[0]);
                elementArray2[n].setAttributeNS(null, "qualified-old-src-dn", stringArray[1]);
                ++n;
            }
            this.constructMoveParent(elementArray2);
        }
        if (!this.doRaw) {
            int n;
            int n2 = elementArray3 != null ? elementArray3.length : 0;
            int n3 = elementArray4 != null ? elementArray4.length : 0;
            int n4 = n = elementArray2 != null ? elementArray2.length : 0;
            if (n2 > 0 || n3 > 0) {
                Element[] elementArray5 = new Element[elementArray2.length + elementArray3.length + n3];
                int n5 = 0;
                if (n2 > 0) {
                    System.arraycopy(elementArray3, 0, elementArray5, n5, n2);
                    n5 += n2;
                }
                if (n3 > 0) {
                    System.arraycopy(elementArray4, 0, elementArray5, n5, n3);
                    n5 += n3;
                }
                if (n > 0) {
                    System.arraycopy(elementArray2, 0, elementArray5, n5, n);
                }
                elementArray2 = elementArray5;
            }
        }
        return elementArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void constructMoveParent(Element[] elementArray) throws VRDException {
        XdsDN xdsDN = new XdsDN(this.getObjectID().getDN(), NdsConstants.QSLASH_DELIMS_ARRAY);
        String[] stringArray = xdsDN.split(NdsConstants.QSLASH_DELIMS_ARRAY);
        String[] stringArray2 = XdsUtil.getDNForms(stringArray[0]);
        JCValue[] jCValueArray = null;
        JCContext jCContext = null;
        long l = -1L;
        try {
            jCContext = this.context.duplicate();
            jCContext.setEntryID(this.getObjectID().getEntryID());
            JCEntryInfo jCEntryInfo = JClient.getEntryInfo((JCContext)jCContext, (int)256);
            l = jCEntryInfo.getParentID();
            jCValueArray = Association.getAssociations(jCContext, this.driverDN, new Entry(l));
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (jCContext != null) {
                jCContext.free();
            }
            throw throwable;
        }
    }

    private Element[] constructRename(Element[] elementArray) throws VRDException {
        Element[] elementArray2 = this.constructEventOp(elementArray, "rename");
        String[] stringArray = XdsUtil.getDNForms(this.getOldDN());
        XdsDN xdsDN = new XdsDN(this.getObjectID().getDN(), NdsConstants.QSLASH_DELIMS_ARRAY);
        String string = xdsDN.getRDN(NdsConstants.SLASH_DELIMS_ARRAY, 1);
        String string2 = this.getRemoveOldName();
        int n = 0;
        while (n < elementArray2.length) {
            elementArray2[n].setAttributeNS(null, "old-src-dn", stringArray[0]);
            elementArray2[n].setAttributeNS(null, "qualified-old-src-dn", stringArray[1]);
            elementArray2[n].setAttributeNS(null, "remove-old-name", string2);
            Document document = elementArray2[n].getOwnerDocument();
            Element element = document.createElementNS(null, "new-name");
            elementArray2[n].appendChild(element);
            Text text = document.createTextNode(string);
            element.appendChild(text);
            ++n;
        }
        return elementArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getRemoveOldName() {
        JCContext jCContext;
        block8: {
            String string;
            block7: {
                jCContext = null;
                try {
                    try {
                        jCContext = this.context.duplicate();
                        jCContext.setEntryID(this.getObjectID().getEntryID());
                        XdsDN xdsDN = new XdsDN(this.getOldDN(), NdsConstants.QSLASH_DELIMS_ARRAY);
                        XdsDN.DNComponent dNComponent = xdsDN.getComponent(xdsDN.getComponentCount() - 1);
                        while (dNComponent != null) {
                            JCCIstringValue jCCIstringValue = new JCCIstringValue(dNComponent.getType(), 7, 0L, new JCTimestamp(), dNComponent.getValue());
                            jCCIstringValue.operation = 7;
                            if (!JClient.compareAttribute((JCContext)jCContext, (JCValue)jCCIstringValue)) {
                                string = "true";
                                Object var7_7 = null;
                                if (jCContext == null) return string;
                                break block7;
                            }
                            dNComponent = dNComponent.getNext();
                        }
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        if (jCContext == null) return "false";
                        jCContext.free();
                        return "false";
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (jCContext == null) throw throwable;
                    jCContext.free();
                    throw throwable;
                }
            }
            jCContext.free();
            return string;
        }
        Object var7_8 = null;
        if (jCContext == null) return "false";
        jCContext.free();
        return "false";
    }

    private Element[] constructSync(Element[] elementArray) throws VRDException {
        this.objectID.freshen(this.context);
        return this.constructEventOp(elementArray, "sync");
    }

    private Element[] constructAddValue(Element[] elementArray) throws VRDException {
        Element[] elementArray2 = new Element[elementArray.length];
        int n = 0;
        while (n < elementArray.length) {
            String string = elementArray[n].getNodeName();
            elementArray2[n] = string.equals("add") ? this.constructAddAttr(elementArray[n]) : (string.equals("modify") ? this.constructModifyValue(elementArray[n], "add-value") : null);
            ++n;
        }
        return elementArray2;
    }

    private Element[] constructRemoveValue(Element[] elementArray) throws VRDException {
        Element[] elementArray2 = new Element[elementArray.length];
        int n = 0;
        while (n < elementArray.length) {
            elementArray2[n] = elementArray[n].getNodeName().equals("modify") ? this.constructModifyValue(elementArray[n], "remove-value") : null;
            ++n;
        }
        return elementArray2;
    }

    private Element[] constructMigrateQuery(Element[] elementArray) throws VRDException {
        if (this.getBlob() == null) {
            return null;
        }
        XmlDocument xmlDocument = new XmlDocument(this.getBlob());
        Document document = xmlDocument.getDocumentNS();
        if (document == null) {
            throw new VRDException(9054, xmlDocument.getParserErrorMsgString());
        }
        Element element = document.getDocumentElement();
        Element element2 = null;
        if (element != null) {
            if (element.getNodeName().equals("nds")) {
                element2 = (Element)XdsUtil.getElementsByTagNameNS(element, null, "query").item(0);
            } else if (element.getNodeName().equals("query")) {
                element2 = element;
            }
        }
        if (element2 == null) {
            throw new VRDException(9042, "input", (Object)"query");
        }
        Element[] elementArray2 = new Element[elementArray.length];
        int n = 0;
        while (n < elementArray.length) {
            elementArray2[n] = (Element)XdsUtil.cloneSubtree(elementArray[n].getOwnerDocument(), element2);
            elementArray[n].appendChild(elementArray2[n]);
            ++n;
        }
        return elementArray2;
    }

    private Element[] constructRequestResync(Element[] elementArray) {
        Element[] elementArray2 = new Element[elementArray.length];
        int n = 0;
        while (n < elementArray.length) {
            Document document = elementArray[n].getOwnerDocument();
            Element element = document.createElementNS(null, "request-resync");
            elementArray[n].appendChild(element);
            element.setAttributeNS(null, "starting-time", Integer.toString(this.getSeconds()));
            ++n;
        }
        return elementArray2;
    }

    private Element[] constructEventOp(Element[] elementArray, String string) throws VRDException {
        int n;
        Element[] elementArray2;
        AssociationValue[] associationValueArray = null;
        if (this.getObjectID().getAssociations() != null && this.getObjectID().getAssociations().length > 0) {
            associationValueArray = this.getObjectID().getAssociations();
        } else if (!this.doRaw && string != "delete") {
            elementArray2 = null;
            try {
                elementArray2 = Association.getAssociations(this.context, this.driverDN, new Entry(this.getObjectID().getEntryID()));
            }
            catch (VRDException vRDException) {
                if (vRDException.getCause() != null && vRDException.getCause() instanceof JCException && ((JCException)vRDException.getCause()).getErrorCode() == -601) {
                    throw new VRDException(9154);
                }
                throw vRDException;
            }
            if (elementArray2 != null) {
                ArrayList<AssociationValue> arrayList = new ArrayList<AssociationValue>(elementArray2.length);
                int n2 = 0;
                while (n2 < elementArray2.length) {
                    JCPathValue jCPathValue = (JCPathValue)elementArray2[n2];
                    String string2 = jCPathValue.getVolumePath();
                    int n3 = jCPathValue.getNameSpace();
                    if (n3 == 0) {
                        return null;
                    }
                    arrayList.add(new AssociationValue(string2, n3));
                    ++n2;
                }
                associationValueArray = new AssociationValue[arrayList.size()];
                n = 0;
                while (n < associationValueArray.length) {
                    associationValueArray[n] = (AssociationValue)arrayList.get(n);
                    ++n;
                }
            }
        }
        elementArray2 = this.doRaw ? new Element[elementArray.length] : new Element[elementArray.length * (associationValueArray == null ? 1 : associationValueArray.length)];
        int n4 = 0;
        while (n4 < elementArray.length) {
            Document document = elementArray[n4].getOwnerDocument();
            if (associationValueArray == null) {
                elementArray2[n4] = document.createElementNS(null, string);
                elementArray[n4].appendChild(elementArray2[n4]);
            } else {
                n = 0;
                while (n < associationValueArray.length) {
                    int n5 = this.doRaw ? n4 : n4 * associationValueArray.length + n;
                    elementArray2[n5] = document.createElementNS(null, string);
                    if (associationValueArray[n].getState() == 0) {
                        return null;
                    }
                    Element element = NdsDtd.createAssociationElement(document, associationValueArray[n].getValue(), associationValueArray[n].getState());
                    elementArray2[n5].appendChild(element);
                    elementArray[n4].appendChild(elementArray2[n5]);
                    ++n;
                }
            }
            ++n4;
        }
        int n6 = -1;
        if (elementArray2.length > 1) {
            n6 = 0;
        }
        String[] stringArray = XdsUtil.getDNForms(this.getObjectID().getDN());
        int n7 = 0;
        while (n7 < elementArray2.length) {
            if (this.getObjectID().getClassName() != null) {
                elementArray2[n7].setAttributeNS(null, "class-name", this.getObjectID().getClassName());
            }
            if (this.getObjectID().getDN() != null) {
                elementArray2[n7].setAttributeNS(null, "src-dn", stringArray[0]);
                elementArray2[n7].setAttributeNS(null, "qualified-src-dn", stringArray[1]);
            }
            elementArray2[n7].setAttributeNS(null, "src-entry-id", Long.toString(this.getObjectID().getEntryID()));
            if (this.eventID != null && this.eventID.length() > 0) {
                String string3;
                if (n6 == -1) {
                    string3 = this.eventID;
                } else {
                    string3 = this.eventID + '#' + Integer.toString(n6);
                    ++n6;
                }
                elementArray2[n7].setAttributeNS(null, "event-id", string3);
            }
            elementArray2[n7].setAttributeNS(null, "timestamp", this.getTimestampString());
            ++n7;
        }
        return elementArray2;
    }

    private Element constructAddAttr(Element element) throws VRDException {
        Document document = element.getOwnerDocument();
        DSEAttributeValue dSEAttributeValue = this.getAttrValue();
        if (this.isDeferredAttr()) {
            dSEAttributeValue = this.getDeferredValue();
        }
        if (dSEAttributeValue != null) {
            Element element2 = document.createElementNS(null, "add-attr");
            element.appendChild(element2);
            element2.setAttributeNS(null, "attr-name", dSEAttributeValue.getAttrName());
            dSEAttributeValue.toXML(element2);
            Element element3 = XdsUtil.getFirstChildElementByTagNameNS(element2, null, "value");
            if (element3 != null) {
                element3.setAttributeNS(null, "timestamp", this.getTimestampString());
            }
            return element2;
        }
        return null;
    }

    private Element constructModifyValue(Element element, String string) throws VRDException {
        Document document = element.getOwnerDocument();
        Element element2 = XdsUtil.getFirstChildElementByTagNameWithAttrValueNS(element, null, "modify-attr", null, "attr-name", this.getAttrValue().getAttrName());
        if (element2 == null) {
            element2 = document.createElementNS(null, "modify-attr");
            element.appendChild(element2);
            element2.setAttributeNS(null, "attr-name", this.getAttrValue().getAttrName());
        } else if (this.isDeferredAttr()) {
            return null;
        }
        if (this.isDeferredAttr()) {
            DSEAttributeValue dSEAttributeValue;
            try {
                dSEAttributeValue = this.getDeferredValue();
            }
            catch (VRDException vRDException) {
                element.removeChild(element2);
                throw vRDException;
            }
            Element element3 = document.createElementNS(null, "remove-all-values");
            if (this.getAttrValue().getSyntax() != 9) {
                element2.appendChild(element3);
            } else if (dSEAttributeValue == null) {
                element.removeChild(element2);
            }
            if (dSEAttributeValue != null) {
                element3 = document.createElementNS(null, "add-value");
                element2.appendChild(element3);
                dSEAttributeValue.toXML(element3);
            }
            return element3;
        }
        Element element4 = document.createElementNS(null, string);
        element2.appendChild(element4);
        this.getAttrValue().toXML(element4);
        Element element5 = XdsUtil.getFirstChildElementByTagNameNS(element4, null, "value");
        if (element5 != null) {
            element5.setAttributeNS(null, "timestamp", this.getTimestampString());
        }
        return element4;
    }

    private boolean isDeferredAttr() {
        DSEAttributeValue dSEAttributeValue = this.getAttrValue();
        if (dSEAttributeValue != null) {
            int n = dSEAttributeValue.getSyntax();
            return n == 21 || n == 22 || n == 9 && dSEAttributeValue.getAttrName().equalsIgnoreCase("nspmDistributionPassword") || n == 9 && dSEAttributeValue.getAttrName().equalsIgnoreCase("SAS:Login Configuration");
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private DSEAttributeValue getDeferredValue() throws VRDException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 7[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void dump(EngineTrace engineTrace) {
        if (engineTrace != null && engineTrace.getLevel() > 3) {
            engineTrace.trace(4, this.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("type(");
        stringBuffer.append(TYPE_NAMES[this.iType]);
        stringBuffer.append(')');
        if (this.getObjectID() != null) {
            stringBuffer.append(this.getObjectID().toString());
        }
        if (this.getAttrValue() != null) {
            stringBuffer.append(this.getAttrValue().toString());
        }
        return stringBuffer.toString();
    }

    public static class AssociationValue {
        String value;
        int state;

        AssociationValue(DxEventInputStream dxEventInputStream) throws IOException {
            this.state = dxEventInputStream.read_uint32();
            this.value = dxEventInputStream.readString();
        }

        AssociationValue(String string, int n) {
            this.value = string;
            this.state = n;
        }

        public String getValue() {
            return this.value;
        }

        public int getState() {
            return this.state;
        }
    }

    public static class ObjectID {
        long entryID;
        String dn;
        long classID;
        String className;
        AssociationValue[] associations = null;

        ObjectID(DxEventInputStream dxEventInputStream) throws IOException {
            this.entryID = dxEventInputStream.readEntryID();
            this.classID = dxEventInputStream.readSchemaID();
            this.dn = dxEventInputStream.readString();
            try {
                this.className = DDSIndirect.getLocalSchemaName(this.classID);
            }
            catch (DSErr dSErr) {
                this.className = DSEEventInfo.BAD_SCHEMA_NAME;
                StatusLog.logWarning(8022, new Integer((int)this.classID));
            }
            try {
                this.dn = DDSIndirect.getLocalEntryName(this.entryID, 16);
            }
            catch (DSErr dSErr) {
                // empty catch block
            }
            int n = dxEventInputStream.readUTF8Length();
            if (n > 0) {
                this.associations = new AssociationValue[n];
                int n2 = 0;
                while (n2 < n) {
                    this.associations[n2] = new AssociationValue(dxEventInputStream);
                    ++n2;
                }
            }
        }

        ObjectID(long l) {
            this.dn = null;
            this.className = null;
            this.entryID = l;
            this.classID = -1L;
            try {
                this.dn = DDSIndirect.getLocalEntryName(l, 16);
            }
            catch (DSErr dSErr) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void freshen(JCContext jCContext) {
            JCContext jCContext2 = null;
            try {
                jCContext2 = jCContext.duplicate();
                jCContext2.setEntryID(this.entryID);
                JCEntryInfo jCEntryInfo = JClient.getEntryInfo((JCContext)jCContext2, (int)2048);
                this.className = jCEntryInfo.getBaseClass();
                this.classID = DDSServ.getLocalClassID((String)this.className);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (jCContext2 != null) {
                    jCContext2.free();
                }
                throw throwable;
            }
        }

        public long getEntryID() {
            return this.entryID;
        }

        public String getDN() {
            return this.dn;
        }

        public long getClassID() {
            return this.classID;
        }

        public String getClassName() {
            return this.className;
        }

        public AssociationValue[] getAssociations() {
            return this.associations;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append("entry-id(");
            stringBuffer.append(Long.toString(this.entryID));
            stringBuffer.append(") dn(");
            stringBuffer.append(this.dn);
            stringBuffer.append(") class-id(");
            stringBuffer.append(Long.toString(this.classID));
            stringBuffer.append(") class-name(");
            stringBuffer.append(this.className);
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }
}

