/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.io.Base64InputStream;
import com.novell.io.Base64OutputStream;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEUtil;
import java.io.IOException;
import novell.jclient.JCFaxnumberValue;
import novell.jclient.JCValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public final class DSEFAXNumber
extends JCFaxnumberValue
implements DSEAttributeValue {
    private static final String[] strAllowed = new String[]{"faxNumber", "faxBitCount", "faxParameters"};

    protected DSEFAXNumber(String string) {
        this.attributeName = string;
        this.syntax = 11;
    }

    protected DSEFAXNumber(DxEventInputStream dxEventInputStream, String string) throws IOException {
        this.attributeName = string;
        this.syntax = 11;
        this.setTelephoneNumber(dxEventInputStream.readString());
        this.setBitCount(dxEventInputStream.readUTF8Length());
        this.setBitString(dxEventInputStream.readOctets());
    }

    public DSEFAXNumber(JCFaxnumberValue jCFaxnumberValue) {
        super(jCFaxnumberValue.attributeName, jCFaxnumberValue.operation, jCFaxnumberValue.flags, jCFaxnumberValue.timestamp, jCFaxnumberValue.getTelephoneNumber(), jCFaxnumberValue.getBitCount(), jCFaxnumberValue.getBitString());
    }

    public String getAttrName() {
        return this.attributeName;
    }

    public void toXML(Element element) throws DOMException {
        String[] stringArray = new String[]{"faxNumber", "faxBitCount", "faxParameters"};
        String[] stringArray2 = new String[]{this.getTelephoneNumber(), Integer.toString(this.getBitCount()), new String(Base64OutputStream.encode((byte[])this.getBitString()))};
        DSEUtil.createAggregateValueElement(element, stringArray, stringArray2);
    }

    public boolean equals(Element element) {
        try {
            String[] stringArray = new String[3];
            int[] nArray = new int[3];
            try {
                DSEUtil.validate3(element, strAllowed, nArray, stringArray);
            }
            catch (VRDException vRDException) {
                return DSEUtil.validateString(element).equalsIgnoreCase(this.getTelephoneNumber()) && this.getBitCount() == 0;
            }
            return stringArray[nArray[0]].equals(this.getTelephoneNumber()) && Integer.valueOf(stringArray[nArray[1]]).intValue() == this.getBitCount() && stringArray[nArray[2]].equals(new String(Base64OutputStream.encode((byte[])this.getBitString())));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void fromXML(Element element) throws DOMException, VRDException {
        try {
            String[] stringArray = new String[3];
            int[] nArray = new int[3];
            try {
                DSEUtil.validate3(element, strAllowed, nArray, stringArray);
                this.setTelephoneNumber(stringArray[nArray[0]]);
                this.setBitCount(Integer.valueOf(stringArray[nArray[1]]));
                this.setBitString(Base64InputStream.decode((String)stringArray[nArray[2]]));
            }
            catch (VRDException vRDException) {
                try {
                    this.setTelephoneNumber(DSEUtil.validateString(element));
                    this.setBitCount(0);
                    this.setBitString(new byte[0]);
                }
                catch (VRDException vRDException2) {
                    throw vRDException;
                }
            }
        }
        catch (Exception exception) {
            throw new VRDException(exception);
        }
    }

    public void encrypt(byte[] byArray) throws VRDException {
        this.setTelephoneNumber(DSEUtil.encrypt(this.getTelephoneNumber(), byArray));
    }

    public void decrypt(byte[] byArray) throws VRDException {
        this.setTelephoneNumber(DSEUtil.decrypt(this.getTelephoneNumber(), byArray));
    }

    public int hashCode() {
        byte[] byArray;
        int n = 0;
        String string = this.getTelephoneNumber();
        if (string != null) {
            n += string.hashCode();
        }
        if ((byArray = this.getBitString()) != null) {
            n += DSEUtil.hashCode(byArray);
        }
        return n += this.getBitCount();
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean equals(DSEAttributeValue dSEAttributeValue) {
        return this.compareTo(dSEAttributeValue) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JCValue)) {
            return -1;
        }
        int n = this.syntax - ((JCValue)object).syntax;
        if (n != 0) {
            return n;
        }
        JCFaxnumberValue jCFaxnumberValue = (JCFaxnumberValue)object;
        n = this.getTelephoneNumber().compareTo(jCFaxnumberValue.getTelephoneNumber());
        if (n == 0) {
            n = this.getBitCount() - jCFaxnumberValue.getBitCount();
        }
        if (n == 0) {
            n = DSEUtil.compareTo(this.getBitString(), jCFaxnumberValue.getBitString());
        }
        return n;
    }
}

