/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.Driver;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DDSIndirect;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEUtil;
import java.io.IOException;
import novell.jclient.JCHoldValue;
import novell.jclient.JCValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public final class DSEHold
extends JCHoldValue
implements DSEAttributeValue {
    private static final String[] strAllowed = new String[]{"holdEntryDn", "holdAmount"};

    protected DSEHold(String string) {
        this.attributeName = string;
        this.syntax = 26;
    }

    protected DSEHold(DxEventInputStream dxEventInputStream, String string) throws IOException {
        this.attributeName = string;
        this.syntax = 26;
        long l = dxEventInputStream.readEntryID();
        String string2 = dxEventInputStream.readString();
        this.setAmount(dxEventInputStream.read_uint32());
        try {
            string2 = DDSIndirect.getLocalEntryName(l, 16);
        }
        catch (DSErr dSErr) {
            // empty catch block
        }
        this.setEntryDN(Driver.changeDNForm(string2));
    }

    public DSEHold(JCHoldValue jCHoldValue) {
        super(jCHoldValue.attributeName, jCHoldValue.operation, jCHoldValue.flags, jCHoldValue.timestamp, jCHoldValue.getAmount(), Driver.changeDNForm(jCHoldValue.getEntryDN()));
    }

    public String getAttrName() {
        return this.attributeName;
    }

    public void toXML(Element element) throws DOMException {
        String[] stringArray = new String[]{"holdEntryDn", "holdAmount"};
        String[] stringArray2 = new String[]{this.getEntryDN(), Integer.toString(this.getAmount())};
        DSEUtil.createAggregateValueElement(element, stringArray, stringArray2);
    }

    public boolean equals(Element element) {
        try {
            String[] stringArray = new String[2];
            int[] nArray = new int[2];
            DSEUtil.validate2(element, strAllowed, nArray, stringArray);
            return stringArray[nArray[0]].equals(this.getEntryDN()) && Integer.valueOf(stringArray[nArray[1]]).intValue() == this.getAmount();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void fromXML(Element element) throws DOMException, VRDException {
        try {
            String[] stringArray = new String[2];
            int[] nArray = new int[2];
            DSEUtil.validate2(element, strAllowed, nArray, stringArray);
            this.setEntryDN(stringArray[nArray[0]]);
            this.setAmount(Integer.valueOf(stringArray[nArray[1]]));
        }
        catch (NumberFormatException numberFormatException) {
            throw new VRDException(numberFormatException);
        }
    }

    public void encrypt(byte[] byArray) throws VRDException {
        this.setEntryDN(DSEUtil.encrypt(this.getEntryDN(), byArray));
    }

    public void decrypt(byte[] byArray) throws VRDException {
        this.setEntryDN(DSEUtil.decrypt(this.getEntryDN(), byArray));
    }

    public int hashCode() {
        int n = 0;
        String string = this.getEntryDN();
        if (string != null) {
            n += string.toUpperCase().hashCode();
        }
        return n += this.getAmount();
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean equals(DSEAttributeValue dSEAttributeValue) {
        return this.compareTo(dSEAttributeValue) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JCValue)) {
            return -1;
        }
        int n = this.syntax - ((JCValue)object).syntax;
        if (n != 0) {
            return n;
        }
        JCHoldValue jCHoldValue = (JCHoldValue)object;
        n = this.getEntryDN().compareTo(jCHoldValue.getEntryDN());
        if (n == 0) {
            n = this.getAmount() - jCHoldValue.getAmount();
        }
        return n;
    }
}

