/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.io.Base64InputStream;
import com.novell.io.Base64OutputStream;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEUtil;
import java.io.IOException;
import novell.jclient.JCNetaddressValue;
import novell.jclient.JCNetworkAddress;
import novell.jclient.JCValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public final class DSENetAddress
extends JCNetaddressValue
implements DSEAttributeValue {
    private static final String[] strAllowed = new String[]{"netAddrType", "netAddr"};

    protected DSENetAddress(String string) {
        this.attributeName = string;
        this.syntax = 12;
    }

    protected DSENetAddress(DxEventInputStream dxEventInputStream, String string) throws IOException {
        this.attributeName = string;
        this.syntax = 12;
        int n = dxEventInputStream.read_uint32();
        byte[] byArray = dxEventInputStream.readOctets();
        JCNetworkAddress jCNetworkAddress = new JCNetworkAddress(n, byArray);
        this.setAddress(jCNetworkAddress);
    }

    public DSENetAddress(JCNetaddressValue jCNetaddressValue) {
        super(jCNetaddressValue.attributeName, jCNetaddressValue.operation, jCNetaddressValue.flags, jCNetaddressValue.timestamp, jCNetaddressValue.getAddress());
    }

    public String getAttrName() {
        return this.attributeName;
    }

    public void toXML(Element element) throws DOMException {
        String[] stringArray = new String[]{"netAddrType", "netAddr"};
        JCNetworkAddress jCNetworkAddress = this.getAddress();
        String[] stringArray2 = new String[]{Integer.toString(jCNetworkAddress.getType()), new String(Base64OutputStream.encode((byte[])jCNetworkAddress.getAddress()))};
        DSEUtil.createAggregateValueElement(element, stringArray, stringArray2);
    }

    public boolean equals(Element element) {
        JCNetworkAddress jCNetworkAddress = this.getAddress();
        try {
            String[] stringArray = new String[2];
            int[] nArray = new int[2];
            DSEUtil.validate2(element, strAllowed, nArray, stringArray);
            return Integer.valueOf(stringArray[nArray[0]]).intValue() == jCNetworkAddress.getType() && stringArray[nArray[1]].equals(new String(Base64OutputStream.encode((byte[])jCNetworkAddress.getAddress())));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void fromXML(Element element) throws DOMException, VRDException {
        try {
            String[] stringArray = new String[2];
            int[] nArray = new int[2];
            DSEUtil.validate2(element, strAllowed, nArray, stringArray);
            try {
                this.setAddress(new JCNetworkAddress(Integer.valueOf(stringArray[nArray[0]]).intValue(), Base64InputStream.decode((String)stringArray[nArray[1]])));
            }
            catch (IOException iOException) {
                throw new VRDException(iOException);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new VRDException(numberFormatException);
        }
    }

    public void encrypt(byte[] byArray) throws VRDException {
        JCNetworkAddress jCNetworkAddress = this.getAddress();
        byte[] byArray2 = DSEUtil.encrypt(jCNetworkAddress.getAddress(), byArray);
        this.setAddress(new JCNetworkAddress(jCNetworkAddress.getType(), byArray2));
    }

    public void decrypt(byte[] byArray) throws VRDException {
        JCNetworkAddress jCNetworkAddress = this.getAddress();
        byte[] byArray2 = DSEUtil.decrypt(jCNetworkAddress.getAddress(), byArray);
        this.setAddress(new JCNetworkAddress(jCNetworkAddress.getType(), byArray2));
    }

    public int hashCode() {
        int n = 0;
        JCNetworkAddress jCNetworkAddress = this.getAddress();
        if (jCNetworkAddress != null) {
            byte[] byArray = jCNetworkAddress.getAddress();
            if (byArray != null) {
                n += DSEUtil.hashCode(byArray);
            }
            n += jCNetworkAddress.getType();
        }
        return n;
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean equals(DSEAttributeValue dSEAttributeValue) {
        return this.compareTo(dSEAttributeValue) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JCValue)) {
            return -1;
        }
        int n = this.syntax - ((JCValue)object).syntax;
        if (n != 0) {
            return n;
        }
        JCNetworkAddress jCNetworkAddress = this.getAddress();
        JCNetworkAddress jCNetworkAddress2 = ((JCNetaddressValue)object).getAddress();
        if (jCNetworkAddress == null) {
            return -1;
        }
        if (jCNetworkAddress2 == null) {
            return 1;
        }
        n = jCNetworkAddress.getType() - jCNetworkAddress2.getType();
        if (n == 0) {
            n = DSEUtil.compareTo(jCNetworkAddress.getAddress(), jCNetworkAddress2.getAddress());
        }
        return n;
    }
}

