/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.io.Base64InputStream;
import com.novell.io.Base64OutputStream;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEUtil;
import com.novell.xsl.util.Util;
import java.io.IOException;
import novell.jclient.JCOctetlistValue;
import novell.jclient.JCValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DSEOctetList
extends JCOctetlistValue
implements DSEAttributeValue {
    protected DSEOctetList(String string) {
        this.attributeName = string;
        this.syntax = 13;
    }

    protected DSEOctetList(DxEventInputStream dxEventInputStream, String string) throws IOException {
        this.attributeName = string;
        this.syntax = 13;
        int n = dxEventInputStream.readUTF8Length();
        if (n == 0) {
            this.setOctetstrings(new byte[10][]);
        } else {
            int n2 = 0;
            while (n2 < n) {
                this.addOctetstring(dxEventInputStream.readOctets());
                ++n2;
            }
        }
    }

    public DSEOctetList(JCOctetlistValue jCOctetlistValue) {
        super(jCOctetlistValue.attributeName, jCOctetlistValue.operation, jCOctetlistValue.flags, jCOctetlistValue.timestamp, jCOctetlistValue.getOctetstrings());
    }

    public String getAttrName() {
        return this.attributeName;
    }

    public void toXML(Element element) throws DOMException {
        byte[][] byArray = this.getOctetstrings();
        int n = byArray == null ? 0 : byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] == null) {
                n = n2;
            }
            ++n2;
        }
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int n3 = 0;
        while (n3 < n) {
            stringArray[n3] = "octet";
            stringArray2[n3] = new String(Base64OutputStream.encode((byte[])byArray[n3]));
            ++n3;
        }
        DSEUtil.createAggregateValueElement(element, stringArray, stringArray2);
    }

    public boolean equals(Element element) {
        try {
            NodeList nodeList = element.getElementsByTagNameNS(null, "component");
            byte[][] byArray = this.getOctetstrings();
            int n = byArray == null ? 0 : byArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (byArray[n2] == null) {
                    n = n2;
                }
                ++n2;
            }
            if (nodeList.getLength() == n) {
                int n3 = 0;
                while (n3 < n) {
                    Element element2 = (Element)nodeList.item(n3);
                    if (element2 != null) {
                        String string = element2.getAttributeNS(null, "name");
                        if (string != null && !string.equals("octet")) {
                            throw new VRDException(9000, new Object[]{element2.getNodeName(), "name", string, "string"});
                        }
                        if (!Util.getXSLStringValue((Node)element2).equals(new String(Base64OutputStream.encode((byte[])byArray[n3])))) {
                            return false;
                        }
                    }
                    ++n3;
                }
                return true;
            }
            return false;
        }
        catch (VRDException vRDException) {
            return false;
        }
    }

    public void fromXML(Element element) throws DOMException, VRDException {
        NodeList nodeList = element.getElementsByTagNameNS(null, "component");
        this.setOctetstrings(new byte[10][]);
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            String string = element2.getAttributeNS(null, "name");
            if (string != null && !string.equals("octet")) {
                throw new VRDException(9000, new Object[]{element2.getNodeName(), "name", string, "string"});
            }
            try {
                this.addOctetstring(Base64InputStream.decode((String)Util.getXSLStringValue((Node)element2)));
            }
            catch (IOException iOException) {
                throw new VRDException(iOException);
            }
            ++n;
        }
    }

    public void encrypt(byte[] byArray) throws VRDException {
        byte[][] byArray2 = this.getOctetstrings();
        int n = byArray2 == null ? 0 : byArray2.length;
        int n2 = 0;
        while (n2 < n) {
            if (byArray2[n2] == null) {
                n = n2;
            }
            ++n2;
        }
        this.setOctetstrings(new byte[10][]);
        int n3 = 0;
        while (n3 < n) {
            this.addOctetstring(DSEUtil.encrypt(byArray2[n3], byArray));
            ++n3;
        }
    }

    public void decrypt(byte[] byArray) throws VRDException {
        byte[][] byArray2 = this.getOctetstrings();
        int n = byArray2 == null ? 0 : byArray2.length;
        int n2 = 0;
        while (n2 < n) {
            if (byArray2[n2] == null) {
                n = n2;
            }
            ++n2;
        }
        this.setOctetstrings(new byte[10][]);
        int n3 = 0;
        while (n3 < n) {
            this.addOctetstring(DSEUtil.decrypt(byArray2[n3], byArray));
            ++n3;
        }
    }

    public int hashCode() {
        int n = 0;
        byte[][] byArray = this.getOctetstrings();
        if (byArray != null) {
            int n2 = 0;
            while (n2 < byArray.length && byArray[n2] != null) {
                n += DSEUtil.hashCode(byArray[n2]);
                ++n2;
            }
        }
        return n;
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean equals(DSEAttributeValue dSEAttributeValue) {
        return this.compareTo(dSEAttributeValue) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JCValue)) {
            return -1;
        }
        int n = this.syntax - ((JCValue)object).syntax;
        if (n != 0) {
            return n;
        }
        JCOctetlistValue jCOctetlistValue = (JCOctetlistValue)object;
        byte[][] byArray = this.getOctetstrings();
        byte[][] byArray2 = jCOctetlistValue.getOctetstrings();
        if (byArray == null) {
            return -1;
        }
        if (byArray2 == null) {
            return 1;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            if (byArray[n4] != null) {
                ++n2;
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < byArray2.length) {
            if (byArray2[n5] != null) {
                ++n3;
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < n2 && n6 < n3) {
            if (byArray[n6] != null && byArray2[n6] != null && (n = DSEUtil.compareTo(byArray[n6], byArray2[n6])) != 0) {
                return n;
            }
            ++n6;
        }
        return n2 - n3;
    }
}

