/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.io.Base64OutputStream;
import com.novell.nds.dhutil.DHUtil;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.cache.CorruptCacheException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DDSIndirect;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEAttributeValueXml;
import com.novell.nds.dirxml.engine.event.DSEUtil;
import java.io.IOException;
import java.util.Arrays;
import novell.jclient.JCOctetstringValue;
import novell.jclient.JCValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public final class DSEOctetString
extends JCOctetstringValue
implements DSEAttributeValueXml {
    protected boolean interpretAsXml = false;
    private static final String PRIVATE_KEY = "Private Key";
    private static final String CA_PRIVATE_KEY = "CA Private Key";

    protected DSEOctetString(String string) {
        this.attributeName = string;
        this.syntax = 9;
    }

    protected DSEOctetString(DxEventInputStream dxEventInputStream, String string) throws IOException {
        this.attributeName = string;
        this.syntax = 9;
        byte[] byArray = dxEventInputStream.readOctets();
        if (this.attributeName.equalsIgnoreCase(PRIVATE_KEY) && !DDSIndirect.isOffline()) {
            try {
                byArray = DSEUtil.s3(byArray);
            }
            catch (Throwable throwable) {
                throw new CorruptCacheException(throwable.getMessage());
            }
        }
        if (!DDSIndirect.isOffline() && !DHUtil.getNativeLoHi() && (this.attributeName.equalsIgnoreCase(PRIVATE_KEY) || this.attributeName.equalsIgnoreCase(CA_PRIVATE_KEY))) {
            this.f0(byArray);
        }
        this.setOctets(byArray);
    }

    public DSEOctetString(JCOctetstringValue jCOctetstringValue) {
        super(jCOctetstringValue.attributeName, jCOctetstringValue.operation, jCOctetstringValue.flags, jCOctetstringValue.timestamp, jCOctetstringValue.getOctets());
    }

    public void setInterpretAsXml(boolean bl) {
        this.interpretAsXml = bl;
    }

    public String getAttrName() {
        return this.attributeName;
    }

    public void toXML(Element element) throws DOMException {
        if (this.interpretAsXml) {
            DSEUtil.asXML(this.getOctets(), element, this.attributeName);
        } else {
            DSEUtil.createValueElement(element, "octet", new String(Base64OutputStream.encode((byte[])this.getOctets())));
        }
    }

    public boolean equals(Element element) {
        try {
            return Arrays.equals(this.getOctets(), DSEUtil.validateOctet(element));
        }
        catch (VRDException vRDException) {
            return false;
        }
    }

    public void fromXML(Element element) throws DOMException, VRDException {
        this.setOctets(DSEUtil.validateOctet(element));
    }

    public void encrypt(byte[] byArray) throws VRDException {
        byte[] byArray2 = this.getOctets();
        this.setOctets(DSEUtil.encrypt(byArray2, byArray));
    }

    public void decrypt(byte[] byArray) throws VRDException {
        byte[] byArray2 = DSEUtil.decrypt(this.getOctets(), byArray);
        this.setOctets(byArray2);
    }

    private void f0(byte[] byArray) {
        byte by = byArray[0];
        byArray[0] = byArray[3];
        byArray[3] = by;
        by = byArray[1];
        byArray[1] = byArray[2];
        byArray[2] = by;
        by = byArray[4];
        byArray[4] = byArray[7];
        byArray[7] = by;
        by = byArray[5];
        byArray[5] = byArray[6];
        byArray[6] = by;
    }

    public int hashCode() {
        int n = 0;
        byte[] byArray = this.getOctets();
        if (byArray != null) {
            n += DSEUtil.hashCode(byArray);
        }
        return n;
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean equals(DSEAttributeValue dSEAttributeValue) {
        return this.compareTo(dSEAttributeValue) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JCValue)) {
            return -1;
        }
        int n = this.syntax - ((JCValue)object).syntax;
        if (n != 0) {
            return n;
        }
        JCOctetstringValue jCOctetstringValue = (JCOctetstringValue)object;
        return DSEUtil.compareTo(this.getOctets(), jCOctetstringValue.getOctets());
    }
}

