/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.Driver;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DDSIndirect;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEUtil;
import java.io.IOException;
import novell.jclient.JCPathValue;
import novell.jclient.JCValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public final class DSEPath
extends JCPathValue
implements DSEAttributeValue {
    private static final String[] strAllowed = new String[]{"nameSpace", "volume", "path"};

    protected DSEPath(String string) {
        this.attributeName = string;
        this.syntax = 15;
    }

    protected DSEPath(DxEventInputStream dxEventInputStream, String string) throws IOException {
        this.attributeName = string;
        this.syntax = 15;
        long l = dxEventInputStream.readEntryID();
        String string2 = dxEventInputStream.readString();
        int n = dxEventInputStream.read_uint32();
        String string3 = dxEventInputStream.readString();
        try {
            string2 = DDSIndirect.getLocalEntryName(l, 16);
        }
        catch (DSErr dSErr) {
            // empty catch block
        }
        this.setNameSpace(n);
        this.setVolumeDN(Driver.changeDNForm(string2));
        if (string3 != null && string3.length() > 0) {
            this.setVolumePath(string3);
        }
    }

    public DSEPath(JCPathValue jCPathValue) {
        super(jCPathValue.attributeName, jCPathValue.operation, jCPathValue.flags, jCPathValue.timestamp, Driver.changeDNForm(jCPathValue.getVolumeDN()), jCPathValue.getVolumePath(), jCPathValue.getNameSpace());
    }

    public String getAttrName() {
        return this.attributeName;
    }

    public void toXML(Element element) throws DOMException {
        String[] stringArray = new String[]{"nameSpace", "volume", "path"};
        String[] stringArray2 = new String[]{Integer.toString(this.getNameSpace()), this.getVolumeDN(), this.getVolumePath()};
        DSEUtil.createAggregateValueElement(element, stringArray, stringArray2);
    }

    public boolean equals(Element element) {
        try {
            String[] stringArray = new String[3];
            int[] nArray = new int[3];
            DSEUtil.validate3(element, strAllowed, nArray, stringArray);
            return Integer.valueOf(stringArray[nArray[0]]).intValue() == this.getNameSpace() && stringArray[nArray[1]].equals(this.getVolumeDN()) && stringArray[nArray[2]].equals(this.getVolumePath());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void fromXML(Element element) throws DOMException, VRDException {
        try {
            String[] stringArray = new String[3];
            int[] nArray = new int[3];
            DSEUtil.validate3(element, strAllowed, nArray, stringArray);
            this.setNameSpace(Integer.valueOf(stringArray[nArray[0]]));
            this.setVolumeDN(stringArray[nArray[1]]);
            this.setVolumePath(stringArray[nArray[2]]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new VRDException(numberFormatException);
        }
    }

    public void encrypt(byte[] byArray) throws VRDException {
        this.setVolumeDN(DSEUtil.encrypt(this.getVolumeDN(), byArray));
        this.setVolumePath(DSEUtil.encrypt(this.getVolumePath(), byArray));
    }

    public void decrypt(byte[] byArray) throws VRDException {
        this.setVolumeDN(DSEUtil.decrypt(this.getVolumeDN(), byArray));
        this.setVolumePath(DSEUtil.decrypt(this.getVolumePath(), byArray));
    }

    public int hashCode() {
        String string;
        int n = 0;
        String string2 = this.getVolumeDN();
        if (string2 != null) {
            n += string2.toUpperCase().hashCode();
        }
        if ((string = this.getVolumePath()) != null) {
            n += string.hashCode();
        }
        return n += this.getNameSpace();
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean equals(DSEAttributeValue dSEAttributeValue) {
        return this.compareTo(dSEAttributeValue) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JCValue)) {
            return -1;
        }
        int n = this.syntax - ((JCValue)object).syntax;
        if (n != 0) {
            return n;
        }
        JCPathValue jCPathValue = (JCPathValue)object;
        n = this.getVolumeDN().compareTo(jCPathValue.getVolumeDN());
        if (n == 0) {
            n = this.getVolumePath().compareTo(jCPathValue.getVolumePath());
        }
        if (n == 0) {
            n = this.getNameSpace() - jCPathValue.getNameSpace();
        }
        return n;
    }
}

