/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEUtil;
import java.io.IOException;
import novell.jclient.JCPRstringValue;
import novell.jclient.JCValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public final class DSEPrintableString
extends JCPRstringValue
implements DSEAttributeValue {
    protected DSEPrintableString(String string) {
        this.attributeName = string;
        this.syntax = 4;
    }

    protected DSEPrintableString(DxEventInputStream dxEventInputStream, String string) throws IOException {
        this.attributeName = string;
        this.syntax = 4;
        this.setString(dxEventInputStream.readString());
    }

    public DSEPrintableString(JCPRstringValue jCPRstringValue) {
        super(jCPRstringValue.attributeName, jCPRstringValue.operation, jCPRstringValue.flags, jCPRstringValue.timestamp, jCPRstringValue.getString());
    }

    public String getAttrName() {
        return this.attributeName;
    }

    public void toXML(Element element) throws DOMException {
        DSEUtil.createValueElement(element, "string", this.getString());
    }

    public boolean equals(Element element) {
        try {
            return DSEUtil.validateString(element).equalsIgnoreCase(this.getString());
        }
        catch (VRDException vRDException) {
            return false;
        }
    }

    public void fromXML(Element element) throws DOMException, VRDException {
        this.setString(DSEUtil.validateString(element));
    }

    public void encrypt(byte[] byArray) throws VRDException {
        this.setString(DSEUtil.encrypt(this.getString(), byArray));
    }

    public void decrypt(byte[] byArray) throws VRDException {
        this.setString(DSEUtil.decrypt(this.getString(), byArray));
    }

    public int hashCode() {
        int n = 0;
        String string = this.getString();
        if (string != null) {
            n += string.toUpperCase().hashCode();
        }
        return n;
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean equals(DSEAttributeValue dSEAttributeValue) {
        return this.compareTo(dSEAttributeValue) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JCValue)) {
            return -1;
        }
        int n = this.syntax - ((JCValue)object).syntax;
        if (n != 0) {
            return n;
        }
        JCPRstringValue jCPRstringValue = (JCPRstringValue)object;
        return this.getString().compareTo(jCPRstringValue.getString());
    }
}

