/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.io.Base64OutputStream;
import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.Driver;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DDSIndirect;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEUtil;
import java.io.IOException;
import java.util.Arrays;
import novell.jclient.JCNetworkAddress;
import novell.jclient.JCReferral;
import novell.jclient.JCReplicapointerValue;
import novell.jclient.JCValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public final class DSEReplicaPointer
extends JCReplicapointerValue
implements DSEAttributeValue {
    protected DSEReplicaPointer(String string) {
        this.attributeName = string;
        this.syntax = 16;
    }

    protected DSEReplicaPointer(DxEventInputStream dxEventInputStream, String string) throws IOException {
        this.attributeName = string;
        this.syntax = 16;
        long l = dxEventInputStream.readEntryID();
        String string2 = dxEventInputStream.readString();
        this.setReplicaType(dxEventInputStream.read_uint32());
        this.setReplicaNumber(dxEventInputStream.read_uint32());
        try {
            string2 = DDSIndirect.getLocalEntryName(l, 16);
        }
        catch (DSErr dSErr) {
            // empty catch block
        }
        this.setServerDN(Driver.changeDNForm(string2));
        int n = dxEventInputStream.readUTF8Length();
        JCNetworkAddress[] jCNetworkAddressArray = new JCNetworkAddress[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dxEventInputStream.read_uint32();
            byte[] byArray = dxEventInputStream.readOctets();
            jCNetworkAddressArray[n2] = new JCNetworkAddress(n3, byArray);
            ++n2;
        }
        this.setReferral(new JCReferral(jCNetworkAddressArray));
    }

    public DSEReplicaPointer(JCReplicapointerValue jCReplicapointerValue) {
        super(jCReplicapointerValue.attributeName, jCReplicapointerValue.operation, jCReplicapointerValue.flags, jCReplicapointerValue.timestamp, Driver.changeDNForm(jCReplicapointerValue.getServerDN()), jCReplicapointerValue.getReplicaType(), jCReplicapointerValue.getReplicaNumber(), jCReplicapointerValue.getRootID(), jCReplicapointerValue.getReferral());
    }

    public String getAttrName() {
        return this.attributeName;
    }

    public void toXML(Element element) throws DOMException {
        JCNetworkAddress[] jCNetworkAddressArray = this.getReferral().getReferral();
        String[] stringArray = new String[3 + jCNetworkAddressArray.length * 2];
        stringArray[0] = "server";
        stringArray[1] = "replicaType";
        stringArray[2] = "replicaNumber";
        int n = 3;
        while (n < stringArray.length) {
            stringArray[n] = "netAddrType";
            stringArray[n + 1] = "netAddr";
            n += 2;
        }
        String[] stringArray2 = new String[stringArray.length];
        stringArray2[0] = this.getServerDN();
        stringArray2[1] = Integer.toString(this.getReplicaType());
        stringArray2[2] = Integer.toString(this.getReplicaNumber());
        int n2 = 0;
        while (n2 < jCNetworkAddressArray.length) {
            stringArray2[3 + n2 * 2] = Integer.toString(jCNetworkAddressArray[n2].getType());
            stringArray2[4 + n2 * 2] = new String(Base64OutputStream.encode((byte[])jCNetworkAddressArray[n2].getAddress()));
            ++n2;
        }
        DSEUtil.createAggregateValueElement(element, stringArray, stringArray2);
    }

    public boolean equals(Element element) {
        try {
            Element[] elementArray;
            Element element2 = XdsUtil.getFirstChildElementByTagNameWithAttrValueNS(element, null, "component", null, "name", "server");
            if (element2 == null) {
                return false;
            }
            Element element3 = XdsUtil.getFirstChildElementByTagNameWithAttrValueNS(element, null, "component", null, "name", "replicaType");
            if (element3 == null) {
                return false;
            }
            Element element4 = XdsUtil.getFirstChildElementByTagNameWithAttrValueNS(element, null, "component", null, "name", "replicaNumber");
            if (element4 == null) {
                return false;
            }
            Element[] elementArray2 = XdsUtil.getChildElementsByTagNameWithAttrValueNS(element, null, "component", null, "name", "netAddrType");
            if (elementArray2.length != (elementArray = XdsUtil.getChildElementsByTagNameWithAttrValueNS(element, null, "component", null, "name", "netAddr")).length) {
                return false;
            }
            if (this.getReplicaType() != (int)DSEUtil.validateNumber(element3)) {
                return false;
            }
            if (this.getReplicaNumber() != (int)DSEUtil.validateNumber(element4)) {
                return false;
            }
            if (!this.getServerDN().equalsIgnoreCase(DSEUtil.validateString(element2))) {
                return false;
            }
            JCNetworkAddress[] jCNetworkAddressArray = this.getReferral().getReferral();
            if (jCNetworkAddressArray.length != elementArray2.length) {
                return false;
            }
            int n = 0;
            while (n < elementArray2.length) {
                if (jCNetworkAddressArray[n].getType() != (int)DSEUtil.validateNumber(elementArray2[n])) {
                    return false;
                }
                if (!Arrays.equals(jCNetworkAddressArray[n].getAddress(), DSEUtil.validateOctet(elementArray[n]))) {
                    return false;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void fromXML(Element element) throws VRDException {
        try {
            Element[] elementArray;
            Element element2 = XdsUtil.getFirstChildElementByTagNameWithAttrValueNS(element, null, "component", null, "name", "server");
            if (element2 == null) {
                throw new VRDException(9050, new Object[]{"component", "name", "server"});
            }
            Element element3 = XdsUtil.getFirstChildElementByTagNameWithAttrValueNS(element, null, "component", null, "name", "replicaType");
            if (element3 == null) {
                throw new VRDException(9050, new Object[]{"component", "name", "replicaType"});
            }
            Element element4 = XdsUtil.getFirstChildElementByTagNameWithAttrValueNS(element, null, "component", null, "name", "replicaNumber");
            if (element4 == null) {
                throw new VRDException(9050, new Object[]{"component", "name", "replicaNumber"});
            }
            Element[] elementArray2 = XdsUtil.getChildElementsByTagNameWithAttrValueNS(element, null, "component", null, "name", "netAddrType");
            if (elementArray2.length != (elementArray = XdsUtil.getChildElementsByTagNameWithAttrValueNS(element, null, "component", null, "name", "netAddr")).length) {
                throw new VRDException(9051, "netAddrType", (Object)"netAddr");
            }
            this.setReplicaType((int)DSEUtil.validateNumber(element3));
            this.setReplicaNumber((int)DSEUtil.validateNumber(element4));
            this.setServerDN(DSEUtil.validateString(element2));
            JCNetworkAddress[] jCNetworkAddressArray = new JCNetworkAddress[elementArray2.length];
            int n = 0;
            while (n < elementArray2.length) {
                jCNetworkAddressArray[n] = new JCNetworkAddress((int)DSEUtil.validateNumber(elementArray2[n]), DSEUtil.validateOctet(elementArray[n]));
                ++n;
            }
            this.setReferral(new JCReferral(jCNetworkAddressArray));
        }
        catch (Exception exception) {
            if (exception instanceof VRDException) {
                throw (VRDException)exception;
            }
            throw new VRDException(exception);
        }
    }

    public void encrypt(byte[] byArray) throws VRDException {
    }

    public void decrypt(byte[] byArray) throws VRDException {
    }

    public int hashCode() {
        int n = 0;
        String string = this.getServerDN();
        if (string != null) {
            n += string.toUpperCase().hashCode();
        }
        n += this.getReplicaType();
        n += this.getReplicaNumber();
        JCNetworkAddress[] jCNetworkAddressArray = this.getReferral().getReferral();
        int n2 = 0;
        while (n2 < jCNetworkAddressArray.length) {
            n += jCNetworkAddressArray[n2].getType();
            n += DSEUtil.hashCode(jCNetworkAddressArray[n2].getAddress());
            ++n2;
        }
        return n;
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean equals(DSEAttributeValue dSEAttributeValue) {
        return this.compareTo(dSEAttributeValue) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JCValue)) {
            return -1;
        }
        int n = this.syntax - ((JCValue)object).syntax;
        if (n != 0) {
            return n;
        }
        JCReplicapointerValue jCReplicapointerValue = (JCReplicapointerValue)object;
        n = this.getServerDN().compareTo(jCReplicapointerValue.getServerDN());
        if (n == 0) {
            n = this.getReplicaNumber() - jCReplicapointerValue.getReplicaNumber();
        }
        if (n == 0) {
            n = this.getReplicaType() - jCReplicapointerValue.getReplicaType();
        }
        if (n == 0) {
            n = this.getRootID() - jCReplicapointerValue.getRootID();
        }
        return n;
    }
}

