/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.io.Base64OutputStream;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEAttributeValueXml;
import com.novell.nds.dirxml.engine.event.DSEUtil;
import com.novell.nds.io.NDSStreamAttributeInputStream;
import java.io.IOException;
import java.util.Arrays;
import novell.jclient.JCContext;
import novell.jclient.JCException;
import novell.jclient.JCStreamValue;
import novell.jclient.JCTimestamp;
import novell.jclient.JCValue;
import novell.jclient.JClient;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public final class DSEStream
extends JCStreamValue
implements DSEAttributeValueXml {
    protected boolean interpretAsXml = false;
    protected byte[] value = null;

    protected DSEStream(String string) {
        this.attributeName = string;
        this.syntax = 21;
    }

    protected DSEStream(DxEventInputStream dxEventInputStream, String string) throws IOException {
        this.attributeName = string;
        this.syntax = 21;
        dxEventInputStream.readOctets();
    }

    public DSEStream(JCStreamValue jCStreamValue) {
        super(jCStreamValue.attributeName, jCStreamValue.operation, jCStreamValue.flags, jCStreamValue.timestamp);
    }

    public void setInterpretAsXml(boolean bl) {
        this.interpretAsXml = bl;
    }

    public String getAttrName() {
        return this.attributeName;
    }

    public void toXML(Element element) throws DOMException {
        if (this.value == null) {
            DSEUtil.createValueElement(element, "stream", "");
        } else if (this.interpretAsXml) {
            DSEUtil.asXML(this.value, element, this.attributeName);
        } else {
            String string = new String(Base64OutputStream.encode((byte[])this.value));
            DSEUtil.createValueElement(element, "octet", string);
        }
    }

    public boolean equals(Element element) {
        try {
            return Arrays.equals(this.value == null ? new byte[]{} : this.value, DSEUtil.validateOctet(element));
        }
        catch (VRDException vRDException) {
            return false;
        }
    }

    public void fromXML(Element element) throws DOMException, VRDException {
        this.value = DSEUtil.validateOctet(element);
    }

    public void readValue(JCContext jCContext) throws JCException {
        this.value = null;
        int n = (int)NDSStreamAttributeInputStream.openStream((JCContext)jCContext, (String)this.attributeName, (int)1);
        byte[] byArray = new byte[n];
        JClient.readStream((JCContext)jCContext, (long)0L, (long)n, (byte[])byArray);
        JClient.closeStream((JCContext)jCContext);
        this.value = byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readValue(JCContext jCContext, String string) throws JCException {
        JCContext jCContext2 = null;
        try {
            jCContext2 = jCContext.duplicate();
            jCContext2.nameToID(1, string);
            this.readValue(jCContext2);
            Object var5_4 = null;
            if (jCContext2 == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (jCContext2 == null) throw throwable;
            jCContext2.free();
            throw throwable;
        }
        jCContext2.free();
    }

    public void writeValue(JCContext jCContext) throws JCException {
        JCValue[] jCValueArray = new JCValue[]{new JCStreamValue(this.attributeName, 5, 0L, new JCTimestamp())};
        JClient.modifyEntry((JCContext)jCContext, (JCValue[])jCValueArray);
        NDSStreamAttributeInputStream.openStream((JCContext)jCContext, (String)this.attributeName, (int)2);
        JClient.writeStream((JCContext)jCContext, (long)0L, (long)0L, (byte[])new byte[1]);
        if (this.value != null) {
            JClient.writeStream((JCContext)jCContext, (long)0L, (long)this.value.length, (byte[])this.value);
        }
        JClient.closeStream((JCContext)jCContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeValue(JCContext jCContext, String string) throws JCException {
        JCContext jCContext2 = null;
        try {
            jCContext2 = jCContext.duplicate();
            jCContext2.nameToID(1, string);
            this.writeValue(jCContext2);
            Object var5_4 = null;
            if (jCContext2 == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (jCContext2 == null) throw throwable;
            jCContext2.free();
            throw throwable;
        }
        jCContext2.free();
    }

    public void encrypt(byte[] byArray) throws VRDException {
        this.value = DSEUtil.encrypt(this.value, byArray);
    }

    public void decrypt(byte[] byArray) throws VRDException {
        this.value = DSEUtil.decrypt(this.value, byArray);
    }

    public int hashCode() {
        int n = 0;
        if (this.value != null) {
            n += DSEUtil.hashCode(this.value);
        }
        return n;
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean equals(DSEAttributeValue dSEAttributeValue) {
        return this.compareTo(dSEAttributeValue) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JCValue)) {
            return -1;
        }
        int n = this.syntax - ((JCValue)object).syntax;
        if (n != 0) {
            return n;
        }
        DSEStream dSEStream = (DSEStream)object;
        if (this.value != null && dSEStream.value != null) {
            return DSEUtil.compareTo(this.value, dSEStream.value);
        }
        return -1;
    }
}

